/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.util;

import com.google.common.collect.Lists;
import java.sql.SQLException;
import java.util.List;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.phoenix.expression.Determinism;
import org.apache.phoenix.expression.Expression;
import org.apache.phoenix.expression.LiteralExpression;
import org.apache.phoenix.expression.function.CurrentDateFunction;
import org.apache.phoenix.expression.function.CurrentTimeFunction;
import org.apache.phoenix.expression.function.FunctionExpression;
import org.apache.phoenix.schema.types.PDataType;

public class ExpressionUtil {
    private static final List<Class<? extends FunctionExpression>> OVERRIDE_LITERAL_FUNCTIONS = Lists.newArrayList(CurrentDateFunction.class, CurrentTimeFunction.class);

    private ExpressionUtil() {
    }

    public static boolean isConstant(Expression expression) {
        return expression.isStateless() && (expression.getDeterminism() == Determinism.ALWAYS || expression.getDeterminism() == Determinism.PER_STATEMENT || OVERRIDE_LITERAL_FUNCTIONS.contains(expression.getClass()));
    }

    public static LiteralExpression getConstantExpression(Expression expression, ImmutableBytesWritable ptr) throws SQLException {
        Object value = null;
        PDataType type = expression.getDataType();
        if (expression.evaluate(null, ptr) && ptr.getLength() != 0) {
            value = type.toObject(ptr);
        }
        return LiteralExpression.newConstant(value, type, expression.getDeterminism());
    }

    public static boolean isNull(Expression expression, ImmutableBytesWritable ptr) {
        return ExpressionUtil.isConstant(expression) && (!expression.evaluate(null, ptr) || ptr.getLength() == 0);
    }

    public static LiteralExpression getNullExpression(Expression expression) throws SQLException {
        return LiteralExpression.newConstant(null, expression.getDataType(), expression.getDeterminism());
    }
}

