/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.spark;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.phoenix.jdbc.PhoenixEmbeddedDriver;
import org.apache.phoenix.mapreduce.util.ColumnInfoToStringEncoderDecoder;
import org.apache.phoenix.mapreduce.util.PhoenixConfigurationUtil;
import org.apache.phoenix.spark.ConfigurationUtil$;
import org.apache.phoenix.util.ColumnInfo;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;

public final class ConfigurationUtil$
implements Serializable {
    public static final ConfigurationUtil$ MODULE$;

    static {
        new ConfigurationUtil$();
    }

    public Configuration getOutputConfiguration(String tableName, Seq<String> columns, Option<String> zkUrl, Option<Configuration> conf) {
        Configuration configuration;
        Option<Configuration> option = conf;
        if (option instanceof Some) {
            Some some = (Some)option;
            Configuration c = (Configuration)some.x();
            configuration = HBaseConfiguration.create(c);
        } else {
            configuration = HBaseConfiguration.create();
        }
        Configuration config = configuration;
        PhoenixConfigurationUtil.setOutputTableName(config, tableName);
        PhoenixConfigurationUtil.setPhysicalTableName(config, tableName);
        PhoenixConfigurationUtil.setUpsertColumnNames(config, (String[])Array$.MODULE$.apply(columns, ClassTag$.MODULE$.apply(String.class)));
        Option<String> option2 = zkUrl;
        if (option2 instanceof Some) {
            Some some = (Some)option2;
            String url = (String)some.x();
            this.setZookeeperURL(config, url);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            if (this.getZookeeperURL(config).isEmpty()) {
                throw new UnsupportedOperationException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"One of zkUrl or '", "' config property must be provided"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"hbase.zookeeper.quorum"})));
            }
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
        return config;
    }

    public Option<Configuration> getOutputConfiguration$default$4() {
        return None$.MODULE$;
    }

    public void setZookeeperURL(Configuration conf, String zkUrl) {
        PhoenixEmbeddedDriver.ConnectionInfo info = PhoenixEmbeddedDriver.ConnectionInfo.create(zkUrl);
        conf.set("hbase.zookeeper.quorum", info.getZookeeperQuorum());
        if (info.getPort() != null) {
            conf.setInt("hbase.zookeeper.property.clientPort", Predef$.MODULE$.Integer2int(info.getPort()));
        }
        if (info.getRootNode() != null) {
            conf.set("zookeeper.znode.parent", info.getRootNode());
        }
    }

    public void encodeColumns(Configuration conf) {
        ColumnInfoToStringEncoderDecoder.encode(conf, PhoenixConfigurationUtil.getUpsertColumnMetadataList(conf));
    }

    public List<ColumnInfo> decodeColumns(Configuration conf) {
        return JavaConversions$.MODULE$.asScalaBuffer(ColumnInfoToStringEncoderDecoder.decode(conf)).toList();
    }

    public Option<String> getZookeeperURL(Configuration conf) {
        List list;
        block4: {
            None$ none$;
            block3: {
                block2: {
                    list = (List)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Option[]{Option$.MODULE$.apply((Object)conf.get("hbase.zookeeper.quorum")), Option$.MODULE$.apply((Object)conf.get("hbase.zookeeper.property.clientPort")), Option$.MODULE$.apply((Object)conf.get("zookeeper.znode.parent"))})).flatten((Function1)new anonfun.1());
                    Nil$ nil$ = Nil$.MODULE$;
                    List list2 = list;
                    if (nil$ != null ? !nil$.equals(list2) : list2 != null) break block2;
                    none$ = None$.MODULE$;
                    break block3;
                }
                if (list == null) break block4;
                List list3 = list;
                none$ = new Some((Object)list3.mkString(":"));
            }
            return none$;
        }
        throw new MatchError((Object)list);
    }

    private Object readResolve() {
        return MODULE$;
    }

    private ConfigurationUtil$() {
        MODULE$ = this;
    }
}

