/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.schema.types;

import com.google.common.base.Preconditions;
import java.util.Random;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.phoenix.schema.SortOrder;
import org.apache.phoenix.schema.types.PDataType;
import org.apache.phoenix.schema.types.PDecimal;
import org.apache.phoenix.schema.types.PLong;
import org.apache.phoenix.schema.types.PTinyint;
import org.apache.phoenix.schema.types.PUnsignedSmallint;
import org.apache.phoenix.schema.types.PWholeNumber;

public class PUnsignedTinyint
extends PWholeNumber<Byte> {
    public static final PUnsignedTinyint INSTANCE = new PUnsignedTinyint();

    private PUnsignedTinyint() {
        super("UNSIGNED_TINYINT", 11, Byte.class, new UnsignedByteCodec(), 18);
    }

    @Override
    public Integer getScale(Object o) {
        return ZERO;
    }

    @Override
    public int compareTo(Object lhs, Object rhs, PDataType rhsType) {
        return PLong.INSTANCE.compareTo(lhs, rhs, rhsType);
    }

    @Override
    public boolean isFixedWidth() {
        return true;
    }

    @Override
    public Integer getByteSize() {
        return 1;
    }

    @Override
    public Integer getMaxLength(Object o) {
        return BYTE_PRECISION;
    }

    @Override
    public byte[] toBytes(Object object) {
        byte[] b = new byte[1];
        this.toBytes(object, b, 0);
        return b;
    }

    @Override
    public int toBytes(Object object, byte[] bytes, int offset) {
        if (object == null) {
            throw PUnsignedTinyint.newIllegalDataException(this + " may not be null");
        }
        return this.getCodec().encodeByte(((Number)object).byteValue(), bytes, offset);
    }

    @Override
    public Object toObject(String value) {
        if (value == null || value.length() == 0) {
            return null;
        }
        try {
            Byte b = Byte.parseByte(value);
            if (b < 0) {
                throw PUnsignedTinyint.newIllegalDataException("Value may not be negative(" + b + ")");
            }
            return b;
        }
        catch (NumberFormatException e) {
            throw PUnsignedTinyint.newIllegalDataException(e);
        }
    }

    @Override
    public Object toObject(Object object, PDataType actualType) {
        Byte v = (Byte)PTinyint.INSTANCE.toObject(object, actualType);
        PUnsignedTinyint.throwIfNonNegativeNumber(v);
        return v;
    }

    @Override
    public Object toObject(byte[] b, int o, int l, PDataType actualType, SortOrder sortOrder, Integer maxLength, Integer scale) {
        Byte v = (Byte)PTinyint.INSTANCE.toObject(b, o, l, actualType, sortOrder);
        PUnsignedTinyint.throwIfNonNegativeNumber(v);
        return v;
    }

    @Override
    public boolean isCoercibleTo(PDataType targetType) {
        return targetType.equals(this) || PUnsignedSmallint.INSTANCE.isCoercibleTo(targetType) || PTinyint.INSTANCE.isCoercibleTo(targetType);
    }

    @Override
    public boolean isCoercibleTo(PDataType targetType, Object value) {
        return super.isCoercibleTo(targetType, value) || PTinyint.INSTANCE.isCoercibleTo(targetType, value);
    }

    @Override
    public boolean isComparableTo(PDataType targetType) {
        return PDecimal.INSTANCE.isComparableTo(targetType);
    }

    @Override
    public int getResultSetSqlType() {
        return PTinyint.INSTANCE.getResultSetSqlType();
    }

    @Override
    public Object getSampleValue(Integer maxLength, Integer arrayLength) {
        return Integer.valueOf(((Random)RANDOM.get()).nextInt(127)).byteValue();
    }

    static class UnsignedByteCodec
    extends PTinyint.ByteCodec {
        UnsignedByteCodec() {
        }

        @Override
        public byte decodeByte(byte[] b, int o, SortOrder sortOrder) {
            Preconditions.checkNotNull(sortOrder);
            PDataType.checkForSufficientLength(b, o, 1);
            byte v = b[o];
            if (sortOrder == SortOrder.DESC) {
                v = SortOrder.invert(v);
            }
            if (v < 0) {
                throw PDataType.newIllegalDataException();
            }
            return v;
        }

        @Override
        public int encodeByte(byte v, byte[] b, int o) {
            if (v < 0) {
                throw PDataType.newIllegalDataException();
            }
            Bytes.putByte(b, o, v);
            return 1;
        }
    }
}

