/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.schema.types;

import com.google.common.base.Preconditions;
import com.google.common.primitives.Doubles;
import com.google.common.primitives.Longs;
import java.math.BigDecimal;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Order;
import org.apache.phoenix.schema.SortOrder;
import org.apache.phoenix.schema.types.PDataType;
import org.apache.phoenix.schema.types.PDecimal;
import org.apache.phoenix.schema.types.PDouble;
import org.apache.phoenix.schema.types.PFloat;
import org.apache.phoenix.schema.types.PLong;
import org.apache.phoenix.schema.types.PTimestamp;
import org.apache.phoenix.schema.types.PUnsignedDouble;
import org.apache.phoenix.schema.types.PUnsignedFloat;
import org.apache.phoenix.schema.types.PWholeNumber;

public class PUnsignedLong
extends PWholeNumber<Long> {
    public static final PUnsignedLong INSTANCE = new PUnsignedLong();

    private PUnsignedLong() {
        super("UNSIGNED_LONG", 10, Long.class, new UnsignedLongCodec(), 15);
    }

    @Override
    public boolean isOrderPreserving() {
        return true;
    }

    @Override
    public Order getOrder() {
        return Order.ASCENDING;
    }

    @Override
    public boolean isSkippable() {
        return true;
    }

    @Override
    public Integer getScale(Object o) {
        return ZERO;
    }

    @Override
    public byte[] toBytes(Object object) {
        byte[] b = new byte[8];
        this.toBytes(object, b, 0);
        return b;
    }

    @Override
    public int toBytes(Object object, byte[] b, int o) {
        if (object == null) {
            throw PUnsignedLong.newIllegalDataException(this + " may not be null");
        }
        return this.getCodec().encodeLong(((Number)object).longValue(), b, o);
    }

    @Override
    public Object toObject(Object object, PDataType actualType) {
        Long v = (Long)PLong.INSTANCE.toObject(object, actualType);
        PUnsignedLong.throwIfNonNegativeNumber(v);
        return v;
    }

    @Override
    public Object toObject(byte[] b, int o, int l, PDataType actualType, SortOrder sortOrder, Integer maxLength, Integer scale) {
        Long v = (Long)PLong.INSTANCE.toObject(b, o, l, actualType, sortOrder);
        PUnsignedLong.throwIfNonNegativeNumber(v);
        return v;
    }

    @Override
    public boolean isCastableTo(PDataType targetType) {
        return super.isCastableTo(targetType) || targetType.isCoercibleTo(PTimestamp.INSTANCE);
    }

    @Override
    public boolean isCoercibleTo(PDataType targetType) {
        return targetType == this || targetType == PUnsignedDouble.INSTANCE || PLong.INSTANCE.isCoercibleTo(targetType);
    }

    @Override
    public boolean isCoercibleTo(PDataType targetType, Object value) {
        return super.isCoercibleTo(targetType, value) || PLong.INSTANCE.isCoercibleTo(targetType, value);
    }

    @Override
    public boolean isFixedWidth() {
        return true;
    }

    @Override
    public Integer getByteSize() {
        return 8;
    }

    @Override
    public int compareTo(Object lhs, Object rhs, PDataType rhsType) {
        if (rhsType == PDecimal.INSTANCE) {
            return -((BigDecimal)rhs).compareTo(BigDecimal.valueOf(((Number)lhs).longValue()));
        }
        if (PUnsignedLong.equalsAny(rhsType, PDouble.INSTANCE, PFloat.INSTANCE, PUnsignedDouble.INSTANCE, PUnsignedFloat.INSTANCE)) {
            return Doubles.compare(((Number)lhs).doubleValue(), ((Number)rhs).doubleValue());
        }
        return Longs.compare(((Number)lhs).longValue(), ((Number)rhs).longValue());
    }

    @Override
    public boolean isComparableTo(PDataType targetType) {
        return PDecimal.INSTANCE.isComparableTo(targetType);
    }

    @Override
    public Object toObject(String value) {
        if (value == null || value.length() == 0) {
            return null;
        }
        try {
            Long l = Long.parseLong(value);
            if (l < 0L) {
                throw PUnsignedLong.newIllegalDataException("Value may not be negative(" + l + ")");
            }
            return l;
        }
        catch (NumberFormatException e) {
            throw PUnsignedLong.newIllegalDataException(e);
        }
    }

    @Override
    public int getResultSetSqlType() {
        return PLong.INSTANCE.getResultSetSqlType();
    }

    @Override
    public Object getSampleValue(Integer maxLength, Integer arrayLength) {
        return Math.abs((Long)PLong.INSTANCE.getSampleValue(maxLength, arrayLength));
    }

    static class UnsignedLongCodec
    extends PLong.LongCodec {
        UnsignedLongCodec() {
        }

        @Override
        public long decodeLong(byte[] b, int o, SortOrder sortOrder) {
            Preconditions.checkNotNull(sortOrder);
            PDataType.checkForSufficientLength(b, o, 8);
            long v = 0L;
            if (sortOrder == SortOrder.ASC) {
                for (int i = o; i < o + 8; ++i) {
                    v <<= 8;
                    v ^= (long)(b[i] & 0xFF);
                }
            } else {
                for (int i = o; i < o + 8; ++i) {
                    v <<= 8;
                    v ^= (long)(b[i] & 0xFF ^ 0xFF);
                }
            }
            if (v < 0L) {
                throw PDataType.newIllegalDataException();
            }
            return v;
        }

        @Override
        public int encodeLong(long v, byte[] b, int o) {
            PDataType.checkForSufficientLength(b, o, 8);
            if (v < 0L) {
                throw PDataType.newIllegalDataException();
            }
            Bytes.putLong(b, o, v);
            return 8;
        }
    }
}

