/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.schema.types;

import com.google.common.base.Preconditions;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Order;
import org.apache.phoenix.schema.SortOrder;
import org.apache.phoenix.schema.types.PDataType;
import org.apache.phoenix.schema.types.PDecimal;
import org.apache.phoenix.schema.types.PInteger;
import org.apache.phoenix.schema.types.PLong;
import org.apache.phoenix.schema.types.PUnsignedFloat;
import org.apache.phoenix.schema.types.PUnsignedLong;
import org.apache.phoenix.schema.types.PWholeNumber;

public class PUnsignedInt
extends PWholeNumber<Integer> {
    public static final PUnsignedInt INSTANCE = new PUnsignedInt();

    private PUnsignedInt() {
        super("UNSIGNED_INT", 9, Integer.class, new UnsignedIntCodec(), 16);
    }

    @Override
    public boolean isOrderPreserving() {
        return true;
    }

    @Override
    public Order getOrder() {
        return Order.ASCENDING;
    }

    @Override
    public boolean isSkippable() {
        return true;
    }

    @Override
    public Integer getScale(Object o) {
        return ZERO;
    }

    @Override
    public byte[] toBytes(Object object) {
        byte[] b = new byte[4];
        this.toBytes(object, b, 0);
        return b;
    }

    @Override
    public int toBytes(Object object, byte[] b, int o) {
        if (object == null) {
            throw PUnsignedInt.newIllegalDataException(this + " may not be null");
        }
        return this.getCodec().encodeInt(((Number)object).intValue(), b, o);
    }

    @Override
    public Object toObject(Object object, PDataType actualType) {
        Integer v = (Integer)PInteger.INSTANCE.toObject(object, actualType);
        PUnsignedInt.throwIfNonNegativeNumber(v);
        return v;
    }

    @Override
    public Object toObject(byte[] b, int o, int l, PDataType actualType, SortOrder sortOrder, Integer maxLength, Integer scale) {
        Integer v = (Integer)PInteger.INSTANCE.toObject(b, o, l, actualType, sortOrder);
        PUnsignedInt.throwIfNonNegativeNumber(v);
        return v;
    }

    @Override
    public boolean isCoercibleTo(PDataType targetType) {
        return targetType.equals(this) || targetType.equals(PUnsignedFloat.INSTANCE) || PUnsignedLong.INSTANCE.isCoercibleTo(targetType) || PInteger.INSTANCE.isCoercibleTo(targetType);
    }

    @Override
    public boolean isCoercibleTo(PDataType targetType, Object value) {
        return super.isCoercibleTo(targetType, value) || PInteger.INSTANCE.isCoercibleTo(targetType, value);
    }

    @Override
    public boolean isFixedWidth() {
        return true;
    }

    @Override
    public Integer getByteSize() {
        return 4;
    }

    @Override
    public int compareTo(Object lhs, Object rhs, PDataType rhsType) {
        return PLong.INSTANCE.compareTo(lhs, rhs, rhsType);
    }

    @Override
    public boolean isComparableTo(PDataType targetType) {
        return PDecimal.INSTANCE.isComparableTo(targetType);
    }

    @Override
    public Object toObject(String value) {
        if (value == null || value.length() == 0) {
            return null;
        }
        try {
            Integer i = Integer.parseInt(value);
            if (i < 0) {
                throw PUnsignedInt.newIllegalDataException("Value may not be negative(" + i + ")");
            }
            return i;
        }
        catch (NumberFormatException e) {
            throw PUnsignedInt.newIllegalDataException(e);
        }
    }

    @Override
    public int getResultSetSqlType() {
        return PInteger.INSTANCE.getResultSetSqlType();
    }

    @Override
    public Object getSampleValue(Integer maxLength, Integer arrayLength) {
        return Math.abs((Integer)PInteger.INSTANCE.getSampleValue(maxLength, arrayLength));
    }

    static class UnsignedIntCodec
    extends PInteger.IntCodec {
        UnsignedIntCodec() {
        }

        @Override
        public int decodeInt(byte[] b, int o, SortOrder sortOrder) {
            int v;
            Preconditions.checkNotNull(sortOrder);
            PDataType.checkForSufficientLength(b, o, 4);
            if (sortOrder == SortOrder.DESC) {
                b = SortOrder.invert(b, o, new byte[4], 0, 4);
            }
            if ((v = Bytes.toInt(b, o)) < 0) {
                throw PDataType.newIllegalDataException();
            }
            return v;
        }

        @Override
        public int encodeInt(int v, byte[] b, int o) {
            PDataType.checkForSufficientLength(b, o, 4);
            if (v < 0) {
                throw PDataType.newIllegalDataException();
            }
            Bytes.putInt(b, o, v);
            return 4;
        }
    }
}

