/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.schema.types;

import com.google.common.base.Preconditions;
import com.google.common.primitives.Doubles;
import java.math.BigDecimal;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.phoenix.schema.SortOrder;
import org.apache.phoenix.schema.types.PDataType;
import org.apache.phoenix.schema.types.PDecimal;
import org.apache.phoenix.schema.types.PDouble;
import org.apache.phoenix.schema.types.PRealNumber;

public class PUnsignedDouble
extends PRealNumber<PDouble> {
    public static final PUnsignedDouble INSTANCE = new PUnsignedDouble();

    private PUnsignedDouble() {
        super("UNSIGNED_DOUBLE", 15, Double.class, new UnsignedDoubleCodec(), 20);
    }

    @Override
    public int compareTo(Object lhs, Object rhs, PDataType rhsType) {
        if (rhsType == PDecimal.INSTANCE) {
            return -((BigDecimal)rhs).compareTo(BigDecimal.valueOf(((Number)lhs).doubleValue()));
        }
        return Doubles.compare(((Number)lhs).doubleValue(), ((Number)rhs).doubleValue());
    }

    @Override
    public boolean isFixedWidth() {
        return true;
    }

    @Override
    public Integer getByteSize() {
        return 8;
    }

    @Override
    public Integer getScale(Object o) {
        return PDouble.INSTANCE.getScale(o);
    }

    @Override
    public Integer getMaxLength(Object o) {
        return PDouble.INSTANCE.getMaxLength(o);
    }

    @Override
    public byte[] toBytes(Object object) {
        byte[] b = new byte[8];
        this.toBytes(object, b, 0);
        return b;
    }

    @Override
    public int toBytes(Object object, byte[] bytes, int offset) {
        if (object == null) {
            throw PUnsignedDouble.newIllegalDataException(this + " may not be null");
        }
        return this.getCodec().encodeDouble(((Number)object).doubleValue(), bytes, offset);
    }

    @Override
    public Object toObject(String value) {
        if (value == null || value.length() == 0) {
            return null;
        }
        try {
            Double d = Double.parseDouble(value);
            if (d < 0.0) {
                throw PUnsignedDouble.newIllegalDataException("Value may not be negative(" + d + ")");
            }
            return d;
        }
        catch (NumberFormatException e) {
            throw PUnsignedDouble.newIllegalDataException(e);
        }
    }

    @Override
    public Object toObject(Object object, PDataType actualType) {
        Double v = (Double)PDouble.INSTANCE.toObject(object, actualType);
        PUnsignedDouble.throwIfNonNegativeNumber(v);
        return v;
    }

    @Override
    public Object toObject(byte[] b, int o, int l, PDataType actualType, SortOrder sortOrder, Integer maxLength, Integer scale) {
        Double v = (Double)PDouble.INSTANCE.toObject(b, o, l, actualType, sortOrder);
        PUnsignedDouble.throwIfNonNegativeNumber(v);
        return v;
    }

    @Override
    public boolean isCoercibleTo(PDataType targetType, Object value) {
        return super.isCoercibleTo(targetType, value) || PDouble.INSTANCE.isCoercibleTo(targetType, value);
    }

    @Override
    public boolean isCoercibleTo(PDataType targetType) {
        return this.equals(targetType) || PDouble.INSTANCE.isCoercibleTo(targetType);
    }

    @Override
    public int getResultSetSqlType() {
        return PDouble.INSTANCE.getResultSetSqlType();
    }

    @Override
    public Object getSampleValue(Integer maxLength, Integer arrayLength) {
        return Math.abs((Double)PDouble.INSTANCE.getSampleValue(maxLength, arrayLength));
    }

    static class UnsignedDoubleCodec
    extends PDouble.DoubleCodec {
        UnsignedDoubleCodec() {
        }

        @Override
        public int encodeDouble(double v, byte[] b, int o) {
            PDataType.checkForSufficientLength(b, o, 8);
            if (v < 0.0) {
                throw PDataType.newIllegalDataException();
            }
            Bytes.putDouble(b, o, v);
            return 8;
        }

        @Override
        public double decodeDouble(byte[] b, int o, SortOrder sortOrder) {
            double v;
            Preconditions.checkNotNull(sortOrder);
            PDataType.checkForSufficientLength(b, o, 8);
            if (sortOrder == SortOrder.DESC) {
                b = SortOrder.invert(b, o, new byte[8], 0, 8);
            }
            if ((v = Bytes.toDouble(b, o)) < 0.0) {
                throw PDataType.newIllegalDataException();
            }
            return v;
        }
    }
}

