/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.schema.types;

import com.google.common.base.Preconditions;
import com.google.common.primitives.Doubles;
import com.google.common.primitives.Longs;
import java.math.BigDecimal;
import java.util.Date;
import java.util.Random;
import org.apache.phoenix.schema.SortOrder;
import org.apache.phoenix.schema.types.PBinary;
import org.apache.phoenix.schema.types.PDataType;
import org.apache.phoenix.schema.types.PDate;
import org.apache.phoenix.schema.types.PDecimal;
import org.apache.phoenix.schema.types.PDouble;
import org.apache.phoenix.schema.types.PFloat;
import org.apache.phoenix.schema.types.PInteger;
import org.apache.phoenix.schema.types.PSmallint;
import org.apache.phoenix.schema.types.PTime;
import org.apache.phoenix.schema.types.PTimestamp;
import org.apache.phoenix.schema.types.PTinyint;
import org.apache.phoenix.schema.types.PUnsignedDate;
import org.apache.phoenix.schema.types.PUnsignedDouble;
import org.apache.phoenix.schema.types.PUnsignedFloat;
import org.apache.phoenix.schema.types.PUnsignedInt;
import org.apache.phoenix.schema.types.PUnsignedLong;
import org.apache.phoenix.schema.types.PUnsignedSmallint;
import org.apache.phoenix.schema.types.PUnsignedTime;
import org.apache.phoenix.schema.types.PUnsignedTinyint;
import org.apache.phoenix.schema.types.PVarbinary;
import org.apache.phoenix.schema.types.PWholeNumber;
import org.apache.phoenix.schema.types.PhoenixArray;

public class PLong
extends PWholeNumber<Long> {
    public static final PLong INSTANCE = new PLong();

    private PLong() {
        super("BIGINT", -5, Long.class, new LongCodec(), 2);
    }

    @Override
    public Integer getScale(Object o) {
        return ZERO;
    }

    @Override
    public byte[] toBytes(Object object) {
        byte[] b = new byte[8];
        this.toBytes(object, b, 0);
        return b;
    }

    @Override
    public int toBytes(Object object, byte[] b, int o) {
        if (object == null) {
            throw PLong.newIllegalDataException(this + " may not be null");
        }
        return this.getCodec().encodeLong(((Number)object).longValue(), b, o);
    }

    @Override
    public Object toObject(Object object, PDataType actualType) {
        if (object == null) {
            return null;
        }
        if (PLong.equalsAny(actualType, INSTANCE, PUnsignedLong.INSTANCE)) {
            return object;
        }
        if (PLong.equalsAny(actualType, PUnsignedInt.INSTANCE, PInteger.INSTANCE)) {
            long s = ((Integer)object).intValue();
            return s;
        }
        if (PLong.equalsAny(actualType, PTinyint.INSTANCE, PUnsignedTinyint.INSTANCE)) {
            long s = ((Byte)object).byteValue();
            return s;
        }
        if (PLong.equalsAny(actualType, PSmallint.INSTANCE, PUnsignedSmallint.INSTANCE)) {
            long s = ((Short)object).shortValue();
            return s;
        }
        if (PLong.equalsAny(actualType, PFloat.INSTANCE, PUnsignedFloat.INSTANCE)) {
            Float f = (Float)object;
            if (f.floatValue() > 9.223372E18f || f.floatValue() < -9.223372E18f) {
                throw PLong.newIllegalDataException(actualType + " value " + f + " cannot be cast to Long without changing its value");
            }
            long s = f.longValue();
            return s;
        }
        if (PLong.equalsAny(actualType, PDouble.INSTANCE, PUnsignedDouble.INSTANCE)) {
            Double de = (Double)object;
            if (de > 9.223372036854776E18 || de < -9.223372036854776E18) {
                throw PLong.newIllegalDataException(actualType + " value " + de + " cannot be cast to Long without changing its value");
            }
            long s = de.longValue();
            return s;
        }
        if (actualType == PDecimal.INSTANCE) {
            BigDecimal d = (BigDecimal)object;
            return d.longValueExact();
        }
        if (PLong.equalsAny(actualType, PDate.INSTANCE, PUnsignedDate.INSTANCE, PTime.INSTANCE, PUnsignedTime.INSTANCE)) {
            Date date = (Date)object;
            return date.getTime();
        }
        return PLong.throwConstraintViolationException(actualType, this);
    }

    @Override
    public Long toObject(byte[] b, int o, int l, PDataType actualType, SortOrder sortOrder, Integer maxLength, Integer scale) {
        if (l == 0) {
            return null;
        }
        if (PLong.equalsAny(actualType, INSTANCE, PUnsignedLong.INSTANCE, PInteger.INSTANCE, PUnsignedInt.INSTANCE, PSmallint.INSTANCE, PUnsignedSmallint.INSTANCE, PTinyint.INSTANCE, PUnsignedTinyint.INSTANCE, PFloat.INSTANCE, PUnsignedFloat.INSTANCE, PDouble.INSTANCE, PUnsignedDouble.INSTANCE, PDate.INSTANCE, PUnsignedDate.INSTANCE, PTime.INSTANCE, PUnsignedTime.INSTANCE)) {
            return actualType.getCodec().decodeLong(b, o, sortOrder);
        }
        if (actualType == PDecimal.INSTANCE) {
            BigDecimal bd = (BigDecimal)actualType.toObject(b, o, l, actualType, sortOrder);
            return bd.longValueExact();
        }
        PLong.throwConstraintViolationException(actualType, this);
        return null;
    }

    @Override
    public boolean isCoercibleTo(PDataType targetType) {
        return PLong.equalsAny(targetType, this, PDecimal.INSTANCE, PVarbinary.INSTANCE, PBinary.INSTANCE, PDouble.INSTANCE);
    }

    @Override
    public boolean isComparableTo(PDataType targetType) {
        return PDecimal.INSTANCE.isComparableTo(targetType);
    }

    @Override
    public boolean isCoercibleTo(PDataType targetType, Object value) {
        if (value != null) {
            if (PLong.equalsAny(targetType, PUnsignedDouble.INSTANCE, PUnsignedFloat.INSTANCE, PUnsignedLong.INSTANCE)) {
                long l = (Long)value;
                return l >= 0L;
            }
            if (targetType.equals(PUnsignedInt.INSTANCE)) {
                long l = (Long)value;
                return l >= 0L && l <= Integer.MAX_VALUE;
            }
            if (targetType.equals(PInteger.INSTANCE)) {
                long l = (Long)value;
                return l >= Integer.MIN_VALUE && l <= Integer.MAX_VALUE;
            }
            if (targetType.equals(PUnsignedSmallint.INSTANCE)) {
                long l = (Long)value;
                return l >= 0L && l <= 32767L;
            }
            if (targetType.equals(PSmallint.INSTANCE)) {
                long l = (Long)value;
                return l >= -32768L && l <= 32767L;
            }
            if (targetType.equals(PTinyint.INSTANCE)) {
                long l = (Long)value;
                return l >= -128L && l <= 127L;
            }
            if (targetType.equals(PUnsignedTinyint.INSTANCE)) {
                long l = (Long)value;
                return l >= 0L && l <= 127L;
            }
        }
        return super.isCoercibleTo(targetType, value);
    }

    @Override
    public boolean isCastableTo(PDataType targetType) {
        return super.isCastableTo(targetType) || targetType.isCoercibleTo(PTimestamp.INSTANCE);
    }

    @Override
    public boolean isFixedWidth() {
        return true;
    }

    @Override
    public Integer getByteSize() {
        return 8;
    }

    @Override
    public Integer getMaxLength(Object o) {
        return LONG_PRECISION;
    }

    @Override
    public int compareTo(Object lhs, Object rhs, PDataType rhsType) {
        if (rhsType == PDecimal.INSTANCE) {
            return -((BigDecimal)rhs).compareTo(BigDecimal.valueOf(((Number)lhs).longValue()));
        }
        if (PLong.equalsAny(rhsType, PDouble.INSTANCE, PFloat.INSTANCE, PUnsignedDouble.INSTANCE, PUnsignedFloat.INSTANCE)) {
            return Doubles.compare(((Number)lhs).doubleValue(), ((Number)rhs).doubleValue());
        }
        return Longs.compare(((Number)lhs).longValue(), ((Number)rhs).longValue());
    }

    @Override
    public Object toObject(String value) {
        if (value == null || value.length() == 0) {
            return null;
        }
        try {
            return Long.parseLong(value);
        }
        catch (NumberFormatException e) {
            throw PLong.newIllegalDataException(e);
        }
    }

    @Override
    public Object getSampleValue(Integer maxLength, Integer arrayLength) {
        return ((Random)RANDOM.get()).nextLong();
    }

    static class LongCodec
    extends PDataType.BaseCodec {
        LongCodec() {
        }

        @Override
        public float decodeFloat(byte[] b, int o, SortOrder sortOrder) {
            return this.decodeLong(b, o, sortOrder);
        }

        @Override
        public double decodeDouble(byte[] b, int o, SortOrder sortOrder) {
            return this.decodeLong(b, o, sortOrder);
        }

        @Override
        public long decodeLong(byte[] bytes, int o, SortOrder sortOrder) {
            long v;
            Preconditions.checkNotNull(sortOrder);
            PDataType.checkForSufficientLength(bytes, o, 8);
            byte b = bytes[o];
            if (sortOrder == SortOrder.ASC) {
                v = b ^ 0x80;
                for (int i = 1; i < 8; ++i) {
                    b = bytes[o + i];
                    v = (v << 8) + (long)(b & 0xFF);
                }
            } else {
                b = (byte)(b ^ 0xFF);
                v = b ^ 0x80;
                for (int i = 1; i < 8; ++i) {
                    b = bytes[o + i];
                    b = (byte)(b ^ 0xFF);
                    v = (v << 8) + (long)(b & 0xFF);
                }
            }
            return v;
        }

        @Override
        public int decodeInt(byte[] b, int o, SortOrder sortOrder) {
            long v = this.decodeLong(b, o, sortOrder);
            if (v < Integer.MIN_VALUE || v > Integer.MAX_VALUE) {
                throw PDataType.newIllegalDataException("Value " + v + " cannot be cast to Integer without changing its value");
            }
            return (int)v;
        }

        @Override
        public int encodeFloat(float v, byte[] b, int o) {
            if (v < -9.223372E18f || v > 9.223372E18f) {
                throw PDataType.newIllegalDataException("Value " + v + " cannot be encoded as an Long without changing its value");
            }
            return this.encodeLong((long)v, b, o);
        }

        @Override
        public int encodeDouble(double v, byte[] b, int o) {
            if (v < -9.223372036854776E18 || v > 9.223372036854776E18) {
                throw PDataType.newIllegalDataException("Value " + v + " cannot be encoded as an Long without changing its value");
            }
            return this.encodeLong((long)v, b, o);
        }

        @Override
        public int encodeLong(long v, byte[] b, int o) {
            PDataType.checkForSufficientLength(b, o, 8);
            b[o + 0] = (byte)(v >> 56 ^ 0x80L);
            b[o + 1] = (byte)(v >> 48);
            b[o + 2] = (byte)(v >> 40);
            b[o + 3] = (byte)(v >> 32);
            b[o + 4] = (byte)(v >> 24);
            b[o + 5] = (byte)(v >> 16);
            b[o + 6] = (byte)(v >> 8);
            b[o + 7] = (byte)v;
            return 8;
        }

        @Override
        public byte decodeByte(byte[] b, int o, SortOrder sortOrder) {
            long v = this.decodeLong(b, o, sortOrder);
            if (v < -128L || v > 127L) {
                throw PDataType.newIllegalDataException("Value " + v + " cannot be cast to Byte without changing its value");
            }
            return (byte)v;
        }

        @Override
        public short decodeShort(byte[] b, int o, SortOrder sortOrder) {
            long v = this.decodeLong(b, o, sortOrder);
            if (v < -32768L || v > 32767L) {
                throw PDataType.newIllegalDataException("Value " + v + " cannot be cast to Short without changing its value");
            }
            return (short)v;
        }

        @Override
        public int encodeByte(byte v, byte[] b, int o) {
            return this.encodeLong(v, b, o);
        }

        @Override
        public int encodeShort(short v, byte[] b, int o) {
            return this.encodeLong(v, b, o);
        }

        @Override
        public PDataType.PhoenixArrayFactory getPhoenixArrayFactory() {
            return new PDataType.PhoenixArrayFactory(){

                @Override
                public PhoenixArray newArray(PDataType type, Object[] elements) {
                    return new PhoenixArray.PrimitiveLongPhoenixArray(type, elements);
                }
            };
        }
    }
}

