/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.schema.types;

import com.google.common.base.Preconditions;
import java.math.BigDecimal;
import java.util.Random;
import org.apache.phoenix.schema.SortOrder;
import org.apache.phoenix.schema.types.PDataType;
import org.apache.phoenix.schema.types.PDecimal;
import org.apache.phoenix.schema.types.PDouble;
import org.apache.phoenix.schema.types.PFloat;
import org.apache.phoenix.schema.types.PLong;
import org.apache.phoenix.schema.types.PSmallint;
import org.apache.phoenix.schema.types.PTinyint;
import org.apache.phoenix.schema.types.PUnsignedDouble;
import org.apache.phoenix.schema.types.PUnsignedFloat;
import org.apache.phoenix.schema.types.PUnsignedInt;
import org.apache.phoenix.schema.types.PUnsignedLong;
import org.apache.phoenix.schema.types.PUnsignedSmallint;
import org.apache.phoenix.schema.types.PUnsignedTinyint;
import org.apache.phoenix.schema.types.PWholeNumber;
import org.apache.phoenix.schema.types.PhoenixArray;

public class PInteger
extends PWholeNumber<Integer> {
    public static final PInteger INSTANCE = new PInteger();

    private PInteger() {
        super("INTEGER", 4, Integer.class, new IntCodec(), 3);
    }

    @Override
    public Integer getScale(Object o) {
        return ZERO;
    }

    @Override
    public byte[] toBytes(Object object) {
        byte[] b = new byte[4];
        this.toBytes(object, b, 0);
        return b;
    }

    @Override
    public int toBytes(Object object, byte[] b, int o) {
        if (object == null) {
            throw PInteger.newIllegalDataException(this + " may not be null");
        }
        return this.getCodec().encodeInt(((Number)object).intValue(), b, o);
    }

    @Override
    public Object toObject(Object object, PDataType actualType) {
        Object o = PLong.INSTANCE.toObject(object, actualType);
        if (!(o instanceof Long) || o == null) {
            return o;
        }
        long l = (Long)o;
        if (l < Integer.MIN_VALUE || l > Integer.MAX_VALUE) {
            throw PInteger.newIllegalDataException(actualType + " value " + l + " cannot be cast to Integer without changing its value");
        }
        int v = (int)l;
        return v;
    }

    @Override
    public Integer toObject(byte[] b, int o, int l, PDataType actualType, SortOrder sortOrder, Integer maxLength, Integer scale) {
        if (l == 0) {
            return null;
        }
        if (PInteger.equalsAny(actualType, PLong.INSTANCE, PUnsignedLong.INSTANCE, INSTANCE, PUnsignedInt.INSTANCE, PSmallint.INSTANCE, PUnsignedSmallint.INSTANCE, PTinyint.INSTANCE, PUnsignedTinyint.INSTANCE, PFloat.INSTANCE, PUnsignedFloat.INSTANCE, PDouble.INSTANCE, PUnsignedDouble.INSTANCE)) {
            return actualType.getCodec().decodeInt(b, o, sortOrder);
        }
        if (actualType == PDecimal.INSTANCE) {
            BigDecimal bd = (BigDecimal)actualType.toObject(b, o, l, actualType, sortOrder);
            return bd.intValueExact();
        }
        PInteger.throwConstraintViolationException(actualType, this);
        return null;
    }

    @Override
    public boolean isCoercibleTo(PDataType targetType, Object value) {
        if (value != null) {
            if (PInteger.equalsAny(targetType, PUnsignedDouble.INSTANCE, PUnsignedFloat.INSTANCE, PUnsignedLong.INSTANCE, PUnsignedInt.INSTANCE)) {
                int i = (Integer)value;
                return i >= 0;
            }
            if (targetType.equals(PUnsignedSmallint.INSTANCE)) {
                int i = (Integer)value;
                return i >= 0 && i <= Short.MAX_VALUE;
            }
            if (targetType.equals(PSmallint.INSTANCE)) {
                int i = (Integer)value;
                return i >= Short.MIN_VALUE && i <= Short.MAX_VALUE;
            }
            if (targetType.equals(PTinyint.INSTANCE)) {
                int i = (Integer)value;
                return i >= -128 && i <= 127;
            }
            if (targetType.equals(PUnsignedTinyint.INSTANCE)) {
                int i = (Integer)value;
                return i >= 0 && i <= 127;
            }
        }
        return super.isCoercibleTo(targetType, value);
    }

    @Override
    public boolean isCoercibleTo(PDataType targetType) {
        return PInteger.equalsAny(targetType, this, PFloat.INSTANCE) || PLong.INSTANCE.isCoercibleTo(targetType);
    }

    @Override
    public boolean isFixedWidth() {
        return true;
    }

    @Override
    public Integer getByteSize() {
        return 4;
    }

    @Override
    public Integer getMaxLength(Object o) {
        return INT_PRECISION;
    }

    @Override
    public int compareTo(Object lhs, Object rhs, PDataType rhsType) {
        return PLong.INSTANCE.compareTo(lhs, rhs, rhsType);
    }

    @Override
    public boolean isComparableTo(PDataType targetType) {
        return PDecimal.INSTANCE.isComparableTo(targetType);
    }

    @Override
    public Object toObject(String value) {
        if (value == null || value.length() == 0) {
            return null;
        }
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            throw PInteger.newIllegalDataException(e);
        }
    }

    @Override
    public Object getSampleValue(Integer maxLength, Integer arrayLength) {
        return ((Random)RANDOM.get()).nextInt();
    }

    static class IntCodec
    extends PDataType.BaseCodec {
        IntCodec() {
        }

        @Override
        public long decodeLong(byte[] b, int o, SortOrder sortOrder) {
            return this.decodeInt(b, o, sortOrder);
        }

        @Override
        public float decodeFloat(byte[] b, int o, SortOrder sortOrder) {
            return this.decodeInt(b, o, sortOrder);
        }

        @Override
        public double decodeDouble(byte[] b, int o, SortOrder sortOrder) {
            return this.decodeInt(b, o, sortOrder);
        }

        @Override
        public int decodeInt(byte[] bytes, int o, SortOrder sortOrder) {
            int v;
            Preconditions.checkNotNull(sortOrder);
            PDataType.checkForSufficientLength(bytes, o, 4);
            if (sortOrder == SortOrder.ASC) {
                v = bytes[o] ^ 0x80;
                for (int i = 1; i < 4; ++i) {
                    v = (v << 8) + (bytes[o + i] & 0xFF);
                }
            } else {
                v = bytes[o] ^ 0xFF ^ 0x80;
                for (int i = 1; i < 4; ++i) {
                    v = (v << 8) + ((bytes[o + i] ^ 0xFF) & 0xFF);
                }
            }
            return v;
        }

        @Override
        public int encodeInt(int v, byte[] b, int o) {
            PDataType.checkForSufficientLength(b, o, 4);
            b[o + 0] = (byte)(v >> 24 ^ 0x80);
            b[o + 1] = (byte)(v >> 16);
            b[o + 2] = (byte)(v >> 8);
            b[o + 3] = (byte)v;
            return 4;
        }

        @Override
        public int encodeFloat(float v, byte[] b, int o) {
            if (v < -2.1474836E9f || v > 2.1474836E9f) {
                throw PDataType.newIllegalDataException("Value " + v + " cannot be encoded as an Integer without changing its value");
            }
            return this.encodeInt((int)v, b, o);
        }

        @Override
        public int encodeDouble(double v, byte[] b, int o) {
            if (v < -2.147483648E9 || v > 2.147483647E9) {
                throw PDataType.newIllegalDataException("Value " + v + " cannot be encoded as an Integer without changing its value");
            }
            return this.encodeInt((int)v, b, o);
        }

        @Override
        public int encodeLong(long v, byte[] b, int o) {
            if (v < Integer.MIN_VALUE || v > Integer.MAX_VALUE) {
                throw PDataType.newIllegalDataException("Value " + v + " cannot be encoded as an Integer without changing its value");
            }
            return this.encodeInt((int)v, b, o);
        }

        @Override
        public byte decodeByte(byte[] b, int o, SortOrder sortOrder) {
            int v = this.decodeInt(b, o, sortOrder);
            if (v < -128 || v > 127) {
                throw PDataType.newIllegalDataException("Value " + v + " cannot be cast to Byte without changing its value");
            }
            return (byte)v;
        }

        @Override
        public short decodeShort(byte[] b, int o, SortOrder sortOrder) {
            int v = this.decodeInt(b, o, sortOrder);
            if (v < Short.MIN_VALUE || v > Short.MAX_VALUE) {
                throw PDataType.newIllegalDataException("Value " + v + " cannot be cast to Short without changing its value");
            }
            return (short)v;
        }

        @Override
        public int encodeByte(byte v, byte[] b, int o) {
            return this.encodeInt(v, b, o);
        }

        @Override
        public int encodeShort(short v, byte[] b, int o) {
            return this.encodeInt(v, b, o);
        }

        @Override
        public PDataType.PhoenixArrayFactory getPhoenixArrayFactory() {
            return new PDataType.PhoenixArrayFactory(){

                @Override
                public PhoenixArray newArray(PDataType type, Object[] elements) {
                    return new PhoenixArray.PrimitiveIntPhoenixArray(type, elements);
                }
            };
        }
    }
}

