/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.schema.types;

import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.apache.phoenix.schema.types.PBinary;
import org.apache.phoenix.schema.types.PBinaryArray;
import org.apache.phoenix.schema.types.PBoolean;
import org.apache.phoenix.schema.types.PBooleanArray;
import org.apache.phoenix.schema.types.PChar;
import org.apache.phoenix.schema.types.PCharArray;
import org.apache.phoenix.schema.types.PDataType;
import org.apache.phoenix.schema.types.PDate;
import org.apache.phoenix.schema.types.PDateArray;
import org.apache.phoenix.schema.types.PDecimal;
import org.apache.phoenix.schema.types.PDecimalArray;
import org.apache.phoenix.schema.types.PDouble;
import org.apache.phoenix.schema.types.PDoubleArray;
import org.apache.phoenix.schema.types.PFloat;
import org.apache.phoenix.schema.types.PFloatArray;
import org.apache.phoenix.schema.types.PInteger;
import org.apache.phoenix.schema.types.PIntegerArray;
import org.apache.phoenix.schema.types.PLong;
import org.apache.phoenix.schema.types.PLongArray;
import org.apache.phoenix.schema.types.PSmallint;
import org.apache.phoenix.schema.types.PSmallintArray;
import org.apache.phoenix.schema.types.PTime;
import org.apache.phoenix.schema.types.PTimeArray;
import org.apache.phoenix.schema.types.PTimestamp;
import org.apache.phoenix.schema.types.PTimestampArray;
import org.apache.phoenix.schema.types.PTinyint;
import org.apache.phoenix.schema.types.PTinyintArray;
import org.apache.phoenix.schema.types.PUnsignedDate;
import org.apache.phoenix.schema.types.PUnsignedDateArray;
import org.apache.phoenix.schema.types.PUnsignedDouble;
import org.apache.phoenix.schema.types.PUnsignedDoubleArray;
import org.apache.phoenix.schema.types.PUnsignedFloat;
import org.apache.phoenix.schema.types.PUnsignedFloatArray;
import org.apache.phoenix.schema.types.PUnsignedInt;
import org.apache.phoenix.schema.types.PUnsignedIntArray;
import org.apache.phoenix.schema.types.PUnsignedLong;
import org.apache.phoenix.schema.types.PUnsignedLongArray;
import org.apache.phoenix.schema.types.PUnsignedSmallint;
import org.apache.phoenix.schema.types.PUnsignedSmallintArray;
import org.apache.phoenix.schema.types.PUnsignedTime;
import org.apache.phoenix.schema.types.PUnsignedTimeArray;
import org.apache.phoenix.schema.types.PUnsignedTimestamp;
import org.apache.phoenix.schema.types.PUnsignedTimestampArray;
import org.apache.phoenix.schema.types.PUnsignedTinyint;
import org.apache.phoenix.schema.types.PUnsignedTinyintArray;
import org.apache.phoenix.schema.types.PVarbinary;
import org.apache.phoenix.schema.types.PVarbinaryArray;
import org.apache.phoenix.schema.types.PVarchar;
import org.apache.phoenix.schema.types.PVarcharArray;

public class PDataTypeFactory {
    private static PDataTypeFactory INSTANCE;
    private final PDataType[] orderedTypes;
    private final SortedSet<PDataType> types = new TreeSet<PDataType>(new Comparator<PDataType>(){

        @Override
        public int compare(PDataType o1, PDataType o2) {
            return Integer.compare(o1.ordinal(), o2.ordinal());
        }
    });
    private final Map<Class<? extends PDataType>, PDataType> classToInstance;

    public static PDataTypeFactory getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new PDataTypeFactory();
        }
        return INSTANCE;
    }

    private PDataTypeFactory() {
        this.types.add(PBinary.INSTANCE);
        this.types.add(PBinaryArray.INSTANCE);
        this.types.add(PChar.INSTANCE);
        this.types.add(PCharArray.INSTANCE);
        this.types.add(PDecimal.INSTANCE);
        this.types.add(PDecimalArray.INSTANCE);
        this.types.add(PBoolean.INSTANCE);
        this.types.add(PBooleanArray.INSTANCE);
        this.types.add(PDate.INSTANCE);
        this.types.add(PDateArray.INSTANCE);
        this.types.add(PDouble.INSTANCE);
        this.types.add(PDoubleArray.INSTANCE);
        this.types.add(PFloat.INSTANCE);
        this.types.add(PFloatArray.INSTANCE);
        this.types.add(PInteger.INSTANCE);
        this.types.add(PIntegerArray.INSTANCE);
        this.types.add(PLong.INSTANCE);
        this.types.add(PLongArray.INSTANCE);
        this.types.add(PTime.INSTANCE);
        this.types.add(PTimeArray.INSTANCE);
        this.types.add(PTimestamp.INSTANCE);
        this.types.add(PTimestampArray.INSTANCE);
        this.types.add(PSmallint.INSTANCE);
        this.types.add(PSmallintArray.INSTANCE);
        this.types.add(PTinyint.INSTANCE);
        this.types.add(PTinyintArray.INSTANCE);
        this.types.add(PUnsignedDate.INSTANCE);
        this.types.add(PUnsignedDateArray.INSTANCE);
        this.types.add(PUnsignedDouble.INSTANCE);
        this.types.add(PUnsignedDoubleArray.INSTANCE);
        this.types.add(PUnsignedFloat.INSTANCE);
        this.types.add(PUnsignedFloatArray.INSTANCE);
        this.types.add(PUnsignedInt.INSTANCE);
        this.types.add(PUnsignedIntArray.INSTANCE);
        this.types.add(PUnsignedLong.INSTANCE);
        this.types.add(PUnsignedLongArray.INSTANCE);
        this.types.add(PUnsignedSmallint.INSTANCE);
        this.types.add(PUnsignedSmallintArray.INSTANCE);
        this.types.add(PUnsignedTime.INSTANCE);
        this.types.add(PUnsignedTimeArray.INSTANCE);
        this.types.add(PUnsignedTimestamp.INSTANCE);
        this.types.add(PUnsignedTimestampArray.INSTANCE);
        this.types.add(PUnsignedTinyint.INSTANCE);
        this.types.add(PUnsignedTinyintArray.INSTANCE);
        this.types.add(PVarbinary.INSTANCE);
        this.types.add(PVarbinaryArray.INSTANCE);
        this.types.add(PVarchar.INSTANCE);
        this.types.add(PVarcharArray.INSTANCE);
        this.classToInstance = new HashMap<Class<? extends PDataType>, PDataType>(this.types.size());
        for (PDataType t : this.types) {
            this.classToInstance.put(t.getClass(), t);
        }
        this.orderedTypes = this.types.toArray(new PDataType[this.types.size()]);
    }

    public Set<PDataType> getTypes() {
        return this.types;
    }

    public PDataType[] getOrderedTypes() {
        return this.orderedTypes;
    }

    public PDataType instanceFromClass(Class<? extends PDataType> clazz) {
        return this.classToInstance.get(clazz);
    }
}

