/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.schema.stats;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.KeyValueUtil;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessorEnvironment;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.regionserver.InternalScanner;
import org.apache.hadoop.hbase.regionserver.Region;
import org.apache.hadoop.hbase.regionserver.Store;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.phoenix.hbase.index.util.ImmutableBytesPtr;
import org.apache.phoenix.schema.SortOrder;
import org.apache.phoenix.schema.stats.GuidePostsInfo;
import org.apache.phoenix.schema.stats.StatisticsScanner;
import org.apache.phoenix.schema.stats.StatisticsUtil;
import org.apache.phoenix.schema.stats.StatisticsWriter;
import org.apache.phoenix.schema.types.PInteger;
import org.apache.phoenix.schema.types.PLong;
import org.apache.phoenix.util.ByteUtil;
import org.apache.phoenix.util.TimeKeeper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StatisticsCollector {
    private static final Logger logger = LoggerFactory.getLogger(StatisticsCollector.class);
    public static final long NO_TIMESTAMP = -1L;
    private long guidepostDepth;
    private long maxTimeStamp = 0L;
    private Map<ImmutableBytesPtr, Pair<Long, GuidePostsInfo>> guidePostsMap = Maps.newHashMap();
    protected StatisticsWriter statsTable;
    private Pair<Long, GuidePostsInfo> cachedGps = null;
    private byte[] minKey;
    private int minKeyOffset;
    private int minKeyLength;

    public StatisticsCollector(RegionCoprocessorEnvironment env, String tableName, long clientTimeStamp) throws IOException {
        this(env, tableName, clientTimeStamp, null, null, null);
    }

    public StatisticsCollector(RegionCoprocessorEnvironment env, String tableName, long clientTimeStamp, byte[] gp_width_bytes, byte[] gp_per_region_bytes) throws IOException {
        this(env, tableName, clientTimeStamp, null, gp_width_bytes, gp_per_region_bytes);
    }

    public StatisticsCollector(RegionCoprocessorEnvironment env, String tableName, long clientTimeStamp, byte[] family) throws IOException {
        this(env, tableName, clientTimeStamp, family, null, null);
    }

    public StatisticsCollector(RegionCoprocessorEnvironment env, String tableName, long clientTimeStamp, byte[] family, byte[] gp_width_bytes, byte[] gp_per_region_bytes) throws IOException {
        Configuration config = env.getConfiguration();
        int guidepostPerRegion = gp_per_region_bytes == null ? config.getInt("phoenix.stats.guidepost.per.region", 0) : PInteger.INSTANCE.getCodec().decodeInt(gp_per_region_bytes, 0, SortOrder.getDefault());
        long guidepostWidth = gp_width_bytes == null ? config.getLong("phoenix.stats.guidepost.width", 314572800L) : (long)PLong.INSTANCE.getCodec().decodeInt(gp_width_bytes, 0, SortOrder.getDefault());
        this.guidepostDepth = StatisticsUtil.getGuidePostDepth(guidepostPerRegion, guidepostWidth, env.getRegion().getTableDesc());
        this.statsTable = StatisticsWriter.newWriter(env, tableName, clientTimeStamp);
        if (family != null) {
            ImmutableBytesPtr cfKey = new ImmutableBytesPtr(family);
            this.cachedGps = new Pair<Long, GuidePostsInfo>(0L, new GuidePostsInfo(0L, Collections.emptyList(), 0L));
            this.guidePostsMap.put(cfKey, this.cachedGps);
        }
    }

    public long getMaxTimeStamp() {
        return this.maxTimeStamp;
    }

    public void close() throws IOException {
        this.statsTable.close();
    }

    public void updateStatistic(Region region) {
        try {
            ArrayList<Mutation> mutations = new ArrayList<Mutation>();
            this.writeStatsToStatsTable(region, true, mutations, TimeKeeper.SYSTEM.getCurrentTime());
            if (logger.isDebugEnabled()) {
                logger.debug("Committing new stats for the region " + region.getRegionInfo());
            }
            this.commitStats(mutations);
        }
        catch (IOException e) {
            logger.error("Unable to commit new stats", e);
        }
        finally {
            this.clear();
        }
    }

    private void writeStatsToStatsTable(Region region, boolean delete, List<Mutation> mutations, long currentTime) throws IOException {
        try {
            for (ImmutableBytesPtr fam : this.guidePostsMap.keySet()) {
                if (delete) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("Deleting the stats for the region " + region.getRegionInfo());
                    }
                    this.statsTable.deleteStats(region.getRegionInfo().getRegionName(), this, fam, mutations);
                }
                if (logger.isDebugEnabled()) {
                    logger.debug("Adding new stats for the region " + region.getRegionInfo());
                }
                this.statsTable.addStats(region.getRegionInfo().getRegionName(), this, fam, mutations);
            }
            this.clearMinKeys();
        }
        catch (IOException e) {
            logger.error("Failed to update statistics table!", e);
            throw e;
        }
    }

    private void commitStats(List<Mutation> mutations) throws IOException {
        this.statsTable.commitStats(mutations);
    }

    public void collectStatistics(List<Cell> results) {
        HashMap<ImmutableBytesPtr, Boolean> famMap = Maps.newHashMap();
        ArrayList<GuidePostsInfo> rowTracker = null;
        if (this.cachedGps == null) {
            rowTracker = new ArrayList<GuidePostsInfo>();
        }
        if (this.minKey == null && !results.isEmpty()) {
            Cell minCell = results.get(0);
            this.minKey = minCell.getRowArray();
            this.minKeyOffset = minCell.getRowOffset();
            this.minKeyLength = minCell.getRowLength();
        }
        for (Cell cell : results) {
            Pair<Long, GuidePostsInfo> gps;
            KeyValue kv = KeyValueUtil.ensureKeyValue(cell);
            this.maxTimeStamp = Math.max(this.maxTimeStamp, kv.getTimestamp());
            if (this.cachedGps == null) {
                ImmutableBytesPtr cfKey = new ImmutableBytesPtr(kv.getFamilyArray(), kv.getFamilyOffset(), kv.getFamilyLength());
                gps = this.guidePostsMap.get(cfKey);
                if (gps == null) {
                    gps = new Pair<Long, GuidePostsInfo>(0L, new GuidePostsInfo(0L, Collections.emptyList(), 0L));
                    this.guidePostsMap.put(cfKey, gps);
                }
                if (famMap.get(cfKey) == null) {
                    famMap.put(cfKey, true);
                    rowTracker.add(gps.getSecond());
                }
            } else {
                gps = this.cachedGps;
            }
            int kvLength = kv.getLength();
            long byteCount = gps.getFirst() + (long)kvLength;
            gps.setFirst(byteCount);
            if (byteCount < this.guidepostDepth) continue;
            byte[] row = ByteUtil.copyKeyBytesIfNecessary(new ImmutableBytesWritable(kv.getRowArray(), kv.getRowOffset(), kv.getRowLength()));
            if (!gps.getSecond().addGuidePost(row, byteCount)) continue;
            gps.setFirst(0L);
        }
        if (this.cachedGps == null) {
            for (GuidePostsInfo s : rowTracker) {
                s.incrementRowCount();
            }
        } else {
            this.cachedGps.getSecond().incrementRowCount();
        }
    }

    public InternalScanner createCompactionScanner(Region region, Store store, InternalScanner s) throws IOException {
        if (logger.isDebugEnabled()) {
            logger.debug("Compaction scanner created for stats");
        }
        ImmutableBytesPtr cfKey = new ImmutableBytesPtr(store.getFamily().getName());
        return this.getInternalScanner(region, store, s, cfKey);
    }

    public void splitStats(Region parent, Region left, Region right) {
        try {
            if (logger.isDebugEnabled()) {
                logger.debug("Collecting stats for split of " + parent.getRegionInfo() + " into " + left.getRegionInfo() + " and " + right.getRegionInfo());
            }
            ArrayList<Mutation> mutations = Lists.newArrayListWithExpectedSize(3);
            for (byte[] fam : parent.getTableDesc().getFamiliesKeys()) {
                this.statsTable.splitStats(parent, left, right, this, new ImmutableBytesPtr(fam), mutations);
            }
            if (logger.isDebugEnabled()) {
                logger.debug("Committing stats for the daughter regions as part of split " + parent.getRegionInfo());
            }
            this.commitStats(mutations);
        }
        catch (IOException e) {
            logger.error("Error while capturing stats after split of region " + parent.getRegionInfo().getRegionNameAsString(), e);
        }
    }

    protected InternalScanner getInternalScanner(Region region, Store store, InternalScanner internalScan, ImmutableBytesPtr family) {
        return new StatisticsScanner(this, this.statsTable, region, internalScan, family);
    }

    public void clear() {
        this.guidePostsMap.clear();
        this.maxTimeStamp = 0L;
        this.clearMinKeys();
    }

    private void clearMinKeys() {
        this.minKey = null;
        this.minKeyLength = 0;
        this.minKeyOffset = 0;
    }

    public void addGuidePost(ImmutableBytesPtr cfKey, GuidePostsInfo info, long byteSize, long timestamp, byte[] minKey) {
        Pair<Long, GuidePostsInfo> newInfo = new Pair<Long, GuidePostsInfo>(byteSize, info);
        Pair<Long, GuidePostsInfo> oldInfo = this.guidePostsMap.put(cfKey, newInfo);
        if (oldInfo != null) {
            info.combine(oldInfo.getSecond());
            newInfo.setFirst(oldInfo.getFirst() + newInfo.getFirst());
        }
        this.maxTimeStamp = Math.max(this.maxTimeStamp, timestamp);
        this.minKey = minKey;
        this.minKeyOffset = 0;
        this.minKeyLength = this.minKey.length;
    }

    public GuidePostsInfo getGuidePosts(ImmutableBytesPtr fam) {
        Pair<Long, GuidePostsInfo> pair = this.guidePostsMap.get(fam);
        if (pair != null) {
            return pair.getSecond();
        }
        return null;
    }

    public void getMinKey(ImmutableBytesWritable ptr) {
        if (this.minKey != null) {
            ptr.set(this.minKey, this.minKeyOffset, this.minKeyLength);
        } else {
            ptr.set(HConstants.EMPTY_BYTE_ARRAY);
        }
    }
}

