/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.schema;

import java.sql.SQLException;
import org.apache.phoenix.exception.SQLExceptionCode;
import org.apache.phoenix.exception.SQLExceptionInfo;
import org.apache.phoenix.schema.PTableType;

public enum TableProperty {
    IMMUTABLE_ROWS("IMMUTABLE_ROWS", true, true),
    MULTI_TENANT("MULTI_TENANT", true, false),
    DISABLE_WAL("DISABLE_WAL", true, false),
    SALT_BUCKETS("SALT_BUCKETS", SQLExceptionCode.COLUMN_FAMILY_NOT_ALLOWED_TABLE_PROPERTY, false, SQLExceptionCode.SALT_ONLY_ON_CREATE_TABLE, false),
    DEFAULT_COLUMN_FAMILY("DEFAULT_COLUMN_FAMILY", SQLExceptionCode.COLUMN_FAMILY_NOT_ALLOWED_TABLE_PROPERTY, false, SQLExceptionCode.DEFAULT_COLUMN_FAMILY_ONLY_ON_CREATE_TABLE, false),
    TTL("TTL", SQLExceptionCode.COLUMN_FAMILY_NOT_ALLOWED_FOR_TTL, true, SQLExceptionCode.CANNOT_ALTER_PROPERTY, false),
    STORE_NULLS("STORE_NULLS", SQLExceptionCode.COLUMN_FAMILY_NOT_ALLOWED_TABLE_PROPERTY, true, false);

    private final String propertyName;
    private final SQLExceptionCode colFamSpecifiedException;
    private final boolean isMutable;
    private final SQLExceptionCode mutatingImmutablePropException;
    private final boolean isValidOnView;

    private TableProperty(String propertyName, boolean isMutable, boolean isValidOnView) {
        this(propertyName, SQLExceptionCode.COLUMN_FAMILY_NOT_ALLOWED_TABLE_PROPERTY, isMutable, SQLExceptionCode.CANNOT_ALTER_PROPERTY, isValidOnView);
    }

    private TableProperty(String propertyName, SQLExceptionCode colFamilySpecifiedException, boolean isMutable, boolean isValidOnView) {
        this(propertyName, colFamilySpecifiedException, isMutable, SQLExceptionCode.CANNOT_ALTER_PROPERTY, isValidOnView);
    }

    private TableProperty(String propertyName, boolean isMutable, boolean isValidOnView, SQLExceptionCode isMutatingException) {
        this(propertyName, SQLExceptionCode.COLUMN_FAMILY_NOT_ALLOWED_TABLE_PROPERTY, isMutable, isMutatingException, isValidOnView);
    }

    private TableProperty(String propertyName, SQLExceptionCode colFamSpecifiedException, boolean isMutable, SQLExceptionCode mutatingException, boolean isValidOnView) {
        this.propertyName = propertyName;
        this.colFamSpecifiedException = colFamSpecifiedException;
        this.isMutable = isMutable;
        this.mutatingImmutablePropException = mutatingException;
        this.isValidOnView = isValidOnView;
    }

    public static boolean isPhoenixTableProperty(String property) {
        try {
            TableProperty.valueOf(property);
        }
        catch (IllegalArgumentException e) {
            return false;
        }
        return true;
    }

    public void validate(boolean isMutating, boolean isQualified, PTableType tableType) throws SQLException {
        this.checkForColumnFamily(isQualified);
        this.checkForMutability(isMutating);
        this.checkIfApplicableForView(tableType);
    }

    private void checkForColumnFamily(boolean isQualified) throws SQLException {
        if (isQualified) {
            throw new SQLExceptionInfo.Builder(this.colFamSpecifiedException).setMessage(". Property: " + this.propertyName).build().buildException();
        }
    }

    private void checkForMutability(boolean isMutating) throws SQLException {
        if (isMutating && !this.isMutable) {
            throw new SQLExceptionInfo.Builder(this.mutatingImmutablePropException).setMessage(". Property: " + this.propertyName).build().buildException();
        }
    }

    private void checkIfApplicableForView(PTableType tableType) throws SQLException {
        if (tableType == PTableType.VIEW && !this.isValidOnView) {
            throw new SQLExceptionInfo.Builder(SQLExceptionCode.VIEW_WITH_PROPERTIES).setMessage("Property: " + this.propertyName).build().buildException();
        }
    }
}

