/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.schema;

import com.google.common.base.Preconditions;
import org.apache.phoenix.schema.PName;

public class PTableKey {
    private final PName tenantId;
    private final String name;

    public PTableKey(PName tenantId, String name) {
        Preconditions.checkNotNull(name);
        this.tenantId = tenantId;
        this.name = name;
    }

    public PName getTenantId() {
        return this.tenantId;
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.name + (this.tenantId == null ? "" : " for " + this.tenantId.getString());
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.tenantId == null ? 0 : this.tenantId.hashCode());
        result = 31 * result + this.name.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PTableKey other = (PTableKey)obj;
        if (!this.name.equals(other.name)) {
            return false;
        }
        return !(this.tenantId == null ? other.tenantId != null : !this.tenantId.equals(other.tenantId));
    }
}

