/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.query;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.client.Consistency;
import org.apache.hadoop.hbase.ipc.controller.ClientRpcControllerFactory;
import org.apache.phoenix.query.HBaseFactoryProvider;
import org.apache.phoenix.schema.SaltingUtil;
import org.apache.phoenix.trace.util.Tracing;
import org.apache.phoenix.util.ReadOnlyProps;

public class QueryServicesOptions {
    public static final int DEFAULT_KEEP_ALIVE_MS = 60000;
    public static final int DEFAULT_THREAD_POOL_SIZE = 128;
    public static final int DEFAULT_QUEUE_SIZE = 5000;
    public static final int DEFAULT_THREAD_TIMEOUT_MS = 600000;
    public static final int DEFAULT_SPOOL_THRESHOLD_BYTES = 0x1400000;
    public static final String DEFAULT_SPOOL_DIRECTORY = "/tmp";
    public static final int DEFAULT_MAX_MEMORY_PERC = 15;
    public static final int DEFAULT_MAX_MEMORY_WAIT_MS = 10000;
    public static final int DEFAULT_MAX_TENANT_MEMORY_PERC = 100;
    public static final long DEFAULT_MAX_SERVER_CACHE_SIZE = 0x6400000L;
    public static final int DEFAULT_TARGET_QUERY_CONCURRENCY = 32;
    public static final int DEFAULT_MAX_QUERY_CONCURRENCY = 64;
    public static final String DEFAULT_DATE_FORMAT = "yyyy-MM-dd HH:mm:ss.SSS";
    public static final String DEFAULT_DATE_FORMAT_TIMEZONE = "GMT";
    public static final boolean DEFAULT_CALL_QUEUE_ROUND_ROBIN = true;
    public static final int DEFAULT_MAX_MUTATION_SIZE = 500000;
    public static final boolean DEFAULT_USE_INDEXES = true;
    public static final boolean DEFAULT_IMMUTABLE_ROWS = false;
    public static final boolean DEFAULT_DROP_METADATA = true;
    public static final int DEFAULT_MUTATE_BATCH_SIZE = 1000;
    public static final int DEFAULT_MAX_SERVER_CACHE_TIME_TO_LIVE_MS = 30000;
    public static final int DEFAULT_SCAN_CACHE_SIZE = 1000;
    public static final int DEFAULT_MAX_INTRA_REGION_PARALLELIZATION = 64;
    public static final int DEFAULT_DISTINCT_VALUE_COMPRESS_THRESHOLD = 0x100000;
    public static final int DEFAULT_INDEX_MUTATE_BATCH_SIZE_THRESHOLD = 5;
    public static final long DEFAULT_MAX_SPOOL_TO_DISK_BYTES = 1024000000L;
    public static final long DEFAULT_SCAN_RESULT_CHUNK_SIZE = 2999L;
    public static boolean DEFAULT_GROUPBY_SPILLABLE = true;
    public static final int DEFAULT_GROUPBY_SPILL_FILES = 2;
    public static final long DEFAULT_GROUPBY_MAX_CACHE_MAX = 0x6400000L;
    public static final long DEFAULT_SEQUENCE_CACHE_SIZE = 100L;
    public static final int DEFAULT_INDEX_MAX_FILESIZE_PERC = 50;
    public static final long DEFAULT_MAX_SERVER_METADATA_CACHE_TIME_TO_LIVE_MS = 1800000L;
    public static final long DEFAULT_MAX_SERVER_METADATA_CACHE_SIZE = 0x1400000L;
    public static final long DEFAULT_MAX_CLIENT_METADATA_CACHE_SIZE = 0xA00000L;
    public static final int DEFAULT_GROUPBY_ESTIMATED_DISTINCT_VALUES = 1000;
    public static final int DEFAULT_CLOCK_SKEW_INTERVAL = 2000;
    public static final boolean DEFAULT_INDEX_FAILURE_HANDLING_REBUILD = true;
    public static final long DEFAULT_INDEX_FAILURE_HANDLING_REBUILD_INTERVAL = 10000L;
    public static final long DEFAULT_INDEX_FAILURE_HANDLING_REBUILD_OVERLAP_TIME = 300000L;
    public static final int DEFAULT_INDEX_PRIORITY = 1000;
    public static final int DEFAULT_METADATA_PRIORITY = 2000;
    public static final boolean DEFAULT_ALLOW_LOCAL_INDEX = true;
    public static final int DEFAULT_INDEX_HANDLER_COUNT = 30;
    public static final int DEFAULT_METADATA_HANDLER_COUNT = 30;
    public static final int DEFAULT_TRACING_PAGE_SIZE = 100;
    public static final String DEFAULT_TRACING_STATS_TABLE_NAME = "SYSTEM.TRACING_STATS";
    public static final String DEFAULT_TRACING_FREQ = Tracing.Frequency.NEVER.getKey();
    public static final double DEFAULT_TRACING_PROBABILITY_THRESHOLD = 0.05;
    public static final int DEFAULT_STATS_UPDATE_FREQ_MS = 900000;
    public static final int DEFAULT_STATS_GUIDEPOST_PER_REGION = 0;
    public static final long DEFAULT_STATS_GUIDEPOST_WIDTH_BYTES = 314572800L;
    public static final boolean DEFAULT_STATS_USE_CURRENT_TIME = true;
    public static final boolean DEFAULT_USE_REVERSE_SCAN = true;
    public static final int DEFAULT_SEQUENCE_TABLE_SALT_BUCKETS = SaltingUtil.MAX_BUCKET_NUM;
    public static final int DEFAULT_COPROCESSOR_PRIORITY = 0x2FFFFFFE;
    public static final boolean DEFAULT_EXPLAIN_CHUNK_COUNT = true;
    public static final boolean DEFAULT_ALLOW_ONLINE_TABLE_SCHEMA_UPDATE = true;
    public static final int DEFAULT_RETRIES_FOR_SCHEMA_UPDATE_CHECK = 10;
    public static final long DEFAULT_DELAY_FOR_SCHEMA_UPDATE_CHECK = 5000L;
    public static final boolean DEFAULT_KEEP_DELETED_CELLS = false;
    public static final boolean DEFAULT_STORE_NULLS = false;
    public static final boolean DEFAULT_AUTO_COMMIT = false;
    public static final boolean DEFAULT_IS_METRICS_ENABLED = true;
    private static final String DEFAULT_CLIENT_RPC_CONTROLLER_FACTORY = ClientRpcControllerFactory.class.getName();
    public static final String DEFAULT_CONSISTENCY_LEVEL = Consistency.STRONG.toString();
    public static final boolean DEFAULT_USE_BYTE_BASED_REGEX = false;
    public static final boolean DEFAULT_FORCE_ROW_KEY_ORDER = false;
    public static final boolean DEFAULT_ALLOW_USER_DEFINED_FUNCTIONS = false;
    public static final String DEFAULT_QUERY_SERVER_SERIALIZATION = "PROTOBUF";
    public static final int DEFAULT_QUERY_SERVER_HTTP_PORT = 8765;
    public static final Set<String> DEFAULT_QUERY_SERVER_SKIP_WORDS = new HashSet<String>(){
        {
            this.add("secret");
            this.add("passwd");
            this.add("password");
            this.add("credential");
        }
    };
    private final Configuration config;

    private QueryServicesOptions(Configuration config) {
        this.config = config;
    }

    public ReadOnlyProps getProps(ReadOnlyProps defaultProps) {
        return new ReadOnlyProps(defaultProps, this.config.iterator());
    }

    public QueryServicesOptions setAll(ReadOnlyProps props) {
        for (Map.Entry<String, String> entry : props) {
            this.config.set(entry.getKey(), entry.getValue());
        }
        return this;
    }

    public static QueryServicesOptions withDefaults() {
        Configuration config = HBaseFactoryProvider.getConfigurationFactory().getConfiguration();
        QueryServicesOptions options = new QueryServicesOptions(config).setIfUnset("phoenix.stats.useCurrentTime", true).setIfUnset("phoenix.query.keepAliveMs", 60000).setIfUnset("phoenix.query.threadPoolSize", 128).setIfUnset("phoenix.query.queueSize", 5000).setIfUnset("phoenix.query.timeoutMs", 600000).setIfUnset("phoenix.query.spoolThresholdBytes", 0x1400000).setIfUnset("phoenix.spool.directory", DEFAULT_SPOOL_DIRECTORY).setIfUnset("phoenix.query.maxGlobalMemoryPercentage", 15).setIfUnset("phoenix.query.maxGlobalMemoryWaitMs", 10000).setIfUnset("phoenix.query.maxTenantMemoryPercentage", 100).setIfUnset("phoenix.query.maxServerCacheBytes", 0x6400000L).setIfUnset("hbase.client.scanner.caching", 1000).setIfUnset("phoenix.query.dateFormat", DEFAULT_DATE_FORMAT).setIfUnset("phoenix.query.dateFormatTimeZone", DEFAULT_DATE_FORMAT_TIMEZONE).setIfUnset("phoenix.stats.updateFrequency", 900000).setIfUnset("ipc.server.callqueue.roundrobin", true).setIfUnset("phoenix.mutate.maxSize", 500000).setIfUnset("phoenix.query.rowKeyOrderSaltedTable", false).setIfUnset("phoenix.query.useIndexes", true).setIfUnset("phoenix.mutate.immutableRows", false).setIfUnset("phoenix.index.mutableBatchSizeThreshold", 5).setIfUnset("phoenix.query.maxSpoolToDiskBytes", 1024000000L).setIfUnset("phoenix.schema.dropMetaData", true).setIfUnset("phoenix.groupby.spillable", DEFAULT_GROUPBY_SPILLABLE).setIfUnset("phoenix.groupby.maxCacheSize", 0x6400000L).setIfUnset("phoenix.groupby.spillFiles", 2).setIfUnset("phoenix.sequence.cacheSize", 100L).setIfUnset("phoenix.query.scanResultChunkSize", 2999L).setIfUnset("hbase.online.schema.update.enable", true).setIfUnset("phoenix.schema.change.retries", 10).setIfUnset("phoenix.schema.change.delay", 5000L).setIfUnset("phoenix.query.metrics.enabled", true).setIfUnset("hbase.rpc.controllerfactory.class", DEFAULT_CLIENT_RPC_CONTROLLER_FACTORY).setIfUnset("phoenix.regex.byteBased", false).setIfUnset("phoenix.query.force.rowkeyorder", false);
        int scanCaching = config.getInt("hbase.client.scanner.caching", 0);
        if (scanCaching == 1) {
            config.setInt("hbase.client.scanner.caching", 1000);
        } else if (scanCaching <= 0) {
            config.setInt("hbase.client.scanner.caching", 1);
        }
        return options;
    }

    public Configuration getConfiguration() {
        return this.config;
    }

    private QueryServicesOptions setIfUnset(String name, int value) {
        this.config.setIfUnset(name, Integer.toString(value));
        return this;
    }

    private QueryServicesOptions setIfUnset(String name, boolean value) {
        this.config.setIfUnset(name, Boolean.toString(value));
        return this;
    }

    private QueryServicesOptions setIfUnset(String name, long value) {
        this.config.setIfUnset(name, Long.toString(value));
        return this;
    }

    private QueryServicesOptions setIfUnset(String name, String value) {
        this.config.setIfUnset(name, value);
        return this;
    }

    public QueryServicesOptions setKeepAliveMs(int keepAliveMs) {
        return this.set("phoenix.query.keepAliveMs", keepAliveMs);
    }

    public QueryServicesOptions setThreadPoolSize(int threadPoolSize) {
        return this.set("phoenix.query.threadPoolSize", threadPoolSize);
    }

    public QueryServicesOptions setQueueSize(int queueSize) {
        this.config.setInt("phoenix.query.queueSize", queueSize);
        return this;
    }

    public QueryServicesOptions setThreadTimeoutMs(int threadTimeoutMs) {
        return this.set("phoenix.query.timeoutMs", threadTimeoutMs);
    }

    public QueryServicesOptions setSpoolThresholdBytes(int spoolThresholdBytes) {
        return this.set("phoenix.query.spoolThresholdBytes", spoolThresholdBytes);
    }

    public QueryServicesOptions setSpoolDirectory(String spoolDirectory) {
        return this.set("phoenix.spool.directory", spoolDirectory);
    }

    public QueryServicesOptions setMaxMemoryPerc(int maxMemoryPerc) {
        return this.set("phoenix.query.maxGlobalMemoryPercentage", maxMemoryPerc);
    }

    public QueryServicesOptions setMaxMemoryWaitMs(int maxMemoryWaitMs) {
        return this.set("phoenix.query.maxGlobalMemoryWaitMs", maxMemoryWaitMs);
    }

    public QueryServicesOptions setMaxTenantMemoryPerc(int maxTenantMemoryPerc) {
        return this.set("phoenix.query.maxTenantMemoryPercentage", maxTenantMemoryPerc);
    }

    public QueryServicesOptions setMaxServerCacheSize(long maxServerCacheSize) {
        return this.set("phoenix.query.maxServerCacheBytes", maxServerCacheSize);
    }

    public QueryServicesOptions setMaxServerMetaDataCacheSize(long maxMetaDataCacheSize) {
        return this.set("phoenix.coprocessor.maxMetaDataCacheSize", maxMetaDataCacheSize);
    }

    public QueryServicesOptions setMaxClientMetaDataCacheSize(long maxMetaDataCacheSize) {
        return this.set("phoenix.client.maxMetaDataCacheSize", maxMetaDataCacheSize);
    }

    public QueryServicesOptions setScanFetchSize(int scanFetchSize) {
        return this.set("hbase.client.scanner.caching", scanFetchSize);
    }

    public QueryServicesOptions setDateFormat(String dateFormat) {
        return this.set("phoenix.query.dateFormat", dateFormat);
    }

    public QueryServicesOptions setCallQueueRoundRobin(boolean isRoundRobin) {
        return this.set("CALL_QUEUE_PRODUCER", isRoundRobin);
    }

    public QueryServicesOptions setMaxMutateSize(int maxMutateSize) {
        return this.set("phoenix.mutate.maxSize", maxMutateSize);
    }

    public QueryServicesOptions setMutateBatchSize(int mutateBatchSize) {
        return this.set("phoenix.mutate.batchSize", mutateBatchSize);
    }

    public QueryServicesOptions setDropMetaData(boolean dropMetadata) {
        return this.set("phoenix.schema.dropMetaData", dropMetadata);
    }

    public QueryServicesOptions setGroupBySpill(boolean enabled) {
        return this.set("phoenix.groupby.spillable", enabled);
    }

    public QueryServicesOptions setGroupBySpillMaxCacheSize(long size) {
        return this.set("phoenix.groupby.maxCacheSize", size);
    }

    public QueryServicesOptions setGroupBySpillNumSpillFiles(long num) {
        return this.set("phoenix.groupby.spillFiles", num);
    }

    private QueryServicesOptions set(String name, boolean value) {
        this.config.set(name, Boolean.toString(value));
        return this;
    }

    private QueryServicesOptions set(String name, int value) {
        this.config.set(name, Integer.toString(value));
        return this;
    }

    private QueryServicesOptions set(String name, String value) {
        this.config.set(name, value);
        return this;
    }

    private QueryServicesOptions set(String name, long value) {
        this.config.set(name, Long.toString(value));
        return this;
    }

    public int getKeepAliveMs() {
        return this.config.getInt("phoenix.query.keepAliveMs", 60000);
    }

    public int getThreadPoolSize() {
        return this.config.getInt("phoenix.query.threadPoolSize", 128);
    }

    public int getQueueSize() {
        return this.config.getInt("phoenix.query.queueSize", 5000);
    }

    public int getMaxMemoryPerc() {
        return this.config.getInt("phoenix.query.maxGlobalMemoryPercentage", 15);
    }

    public int getMaxMemoryWaitMs() {
        return this.config.getInt("phoenix.query.maxGlobalMemoryWaitMs", 10000);
    }

    public int getMaxMutateSize() {
        return this.config.getInt("phoenix.mutate.maxSize", 500000);
    }

    public int getMutateBatchSize() {
        return this.config.getInt("phoenix.mutate.batchSize", 1000);
    }

    public boolean isUseIndexes() {
        return this.config.getBoolean("phoenix.query.useIndexes", true);
    }

    public boolean isImmutableRows() {
        return this.config.getBoolean("phoenix.mutate.immutableRows", false);
    }

    public boolean isDropMetaData() {
        return this.config.getBoolean("phoenix.schema.dropMetaData", true);
    }

    public boolean isSpillableGroupByEnabled() {
        return this.config.getBoolean("phoenix.groupby.spillable", DEFAULT_GROUPBY_SPILLABLE);
    }

    public long getSpillableGroupByMaxCacheSize() {
        return this.config.getLong("phoenix.groupby.maxCacheSize", 0x6400000L);
    }

    public int getSpillableGroupByNumSpillFiles() {
        return this.config.getInt("phoenix.groupby.spillFiles", 2);
    }

    public boolean isMetricsEnabled() {
        return this.config.getBoolean("phoenix.query.metrics.enabled", true);
    }

    public boolean isUseByteBasedRegex() {
        return this.config.getBoolean("phoenix.regex.byteBased", false);
    }

    public int getScanCacheSize() {
        return this.config.getInt("hbase.client.scanner.caching", 1000);
    }

    public QueryServicesOptions setMaxServerCacheTTLMs(int ttl) {
        return this.set("phoenix.coprocessor.maxServerCacheTimeToLiveMs", ttl);
    }

    public QueryServicesOptions setMasterInfoPort(int port) {
        return this.set("hbase.master.info.port", port);
    }

    public QueryServicesOptions setRegionServerInfoPort(int port) {
        return this.set("hbase.regionserver.info.port", port);
    }

    public QueryServicesOptions setRegionServerLeasePeriodMs(int period) {
        return this.set("hbase.regionserver.lease.period", period);
    }

    public QueryServicesOptions setRpcTimeoutMs(int timeout) {
        return this.set("hbase.rpc.timeout", timeout);
    }

    public QueryServicesOptions setUseIndexes(boolean useIndexes) {
        return this.set("phoenix.query.useIndexes", useIndexes);
    }

    public QueryServicesOptions setImmutableRows(boolean isImmutableRows) {
        return this.set("phoenix.mutate.immutableRows", isImmutableRows);
    }

    public QueryServicesOptions setWALEditCodec(String walEditCodec) {
        return this.set("hbase.regionserver.wal.codec", walEditCodec);
    }

    public QueryServicesOptions setStatsHistogramDepthBytes(long byteDepth) {
        return this.set("phoenix.stats.guidepost.width", byteDepth);
    }

    public QueryServicesOptions setStatsUpdateFrequencyMs(int frequencyMs) {
        return this.set("phoenix.stats.updateFrequency", frequencyMs);
    }

    public QueryServicesOptions setMinStatsUpdateFrequencyMs(int frequencyMs) {
        return this.set("phoenix.stats.minUpdateFrequency", frequencyMs);
    }

    public QueryServicesOptions setSequenceSaltBuckets(int saltBuckets) {
        this.config.setInt("phoenix.sequence.saltBuckets", saltBuckets);
        return this;
    }

    public QueryServicesOptions setExplainChunkCount(boolean showChunkCount) {
        this.config.setBoolean("phoenix.explain.displayChunkCount", showChunkCount);
        return this;
    }

    public QueryServicesOptions setAllowOnlineSchemaUpdate(boolean allow) {
        this.config.setBoolean("hbase.online.schema.update.enable", allow);
        return this;
    }

    public QueryServicesOptions setNumRetriesForSchemaChangeCheck(int numRetries) {
        this.config.setInt("phoenix.schema.change.retries", numRetries);
        return this;
    }

    public QueryServicesOptions setDelayInMillisForSchemaChangeCheck(long delayInMillis) {
        this.config.setLong("phoenix.schema.change.delay", delayInMillis);
        return this;
    }

    public QueryServicesOptions setMetricsEnabled(boolean flag) {
        this.config.setBoolean("phoenix.query.metrics.enabled", flag);
        return this;
    }

    public QueryServicesOptions setUseByteBasedRegex(boolean flag) {
        this.config.setBoolean("phoenix.regex.byteBased", flag);
        return this;
    }

    public QueryServicesOptions setForceRowKeyOrder(boolean forceRowKeyOrder) {
        this.config.setBoolean("phoenix.query.force.rowkeyorder", forceRowKeyOrder);
        return this;
    }
}

