/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.query;

import com.google.common.base.Function;
import com.google.common.collect.ComparisonChain;
import com.google.common.collect.Lists;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableUtils;
import org.apache.phoenix.query.QueryConstants;
import org.apache.phoenix.schema.SortOrder;
import org.apache.phoenix.util.ByteUtil;

public class KeyRange
implements Writable {
    private static final byte[] DEGENERATE_KEY = new byte[]{1};
    public static final byte[] UNBOUND = new byte[0];
    public static final KeyRange IS_NULL_RANGE = new KeyRange(ByteUtil.EMPTY_BYTE_ARRAY, true, ByteUtil.EMPTY_BYTE_ARRAY, true);
    public static final KeyRange IS_NOT_NULL_RANGE = new KeyRange(ByteUtil.nextKey(QueryConstants.SEPARATOR_BYTE_ARRAY), true, UNBOUND, false);
    public static final KeyRange EMPTY_RANGE = new KeyRange(DEGENERATE_KEY, false, DEGENERATE_KEY, false);
    public static final KeyRange EVERYTHING_RANGE = new KeyRange(UNBOUND, false, UNBOUND, false);
    public static final Function<byte[], KeyRange> POINT = new Function<byte[], KeyRange>(){

        @Override
        public KeyRange apply(byte[] input) {
            return new KeyRange(input, true, input, true);
        }
    };
    public static final Comparator<KeyRange> COMPARATOR = new Comparator<KeyRange>(){

        @Override
        public int compare(KeyRange o1, KeyRange o2) {
            return ComparisonChain.start().compareFalseFirst(o2.lowerUnbound(), o1.lowerUnbound()).compare(o1.getLowerRange(), o2.getLowerRange(), Bytes.BYTES_COMPARATOR).compareFalseFirst(o2.isLowerInclusive(), o1.isLowerInclusive()).compareFalseFirst(o1.upperUnbound(), o2.upperUnbound()).compare(o1.getUpperRange(), o2.getUpperRange(), Bytes.BYTES_COMPARATOR).compareFalseFirst(o2.isUpperInclusive(), o1.isUpperInclusive()).result();
        }
    };
    private byte[] lowerRange;
    private boolean lowerInclusive;
    private byte[] upperRange;
    private boolean upperInclusive;
    private boolean isSingleKey;

    public static KeyRange getKeyRange(byte[] point) {
        return KeyRange.getKeyRange(point, true, point, true);
    }

    public static KeyRange getKeyRange(byte[] lowerRange, byte[] upperRange) {
        return KeyRange.getKeyRange(lowerRange, true, upperRange, false);
    }

    public static KeyRange getKeyRange(byte[] lowerRange, boolean lowerInclusive, byte[] upperRange, boolean upperInclusive) {
        int cmp;
        if (lowerRange == null || upperRange == null) {
            return EMPTY_RANGE;
        }
        if (lowerRange.length == 0 && upperRange.length == 0 && lowerInclusive && upperInclusive) {
            return IS_NULL_RANGE;
        }
        boolean unboundLower = false;
        boolean unboundUpper = false;
        if (lowerRange.length == 0) {
            lowerRange = UNBOUND;
            lowerInclusive = false;
            unboundLower = true;
        }
        if (upperRange.length == 0) {
            upperRange = UNBOUND;
            upperInclusive = false;
            unboundUpper = true;
        }
        if (unboundLower && unboundUpper) {
            return EVERYTHING_RANGE;
        }
        if (!(unboundLower || unboundUpper || (cmp = Bytes.compareTo(lowerRange, upperRange)) <= 0 && (cmp != 0 || lowerInclusive && upperInclusive))) {
            return EMPTY_RANGE;
        }
        return new KeyRange(lowerRange, unboundLower ? false : lowerInclusive, upperRange, unboundUpper ? false : upperInclusive);
    }

    public KeyRange() {
        this.lowerRange = DEGENERATE_KEY;
        this.lowerInclusive = false;
        this.upperRange = DEGENERATE_KEY;
        this.upperInclusive = false;
        this.isSingleKey = false;
    }

    private KeyRange(byte[] lowerRange, boolean lowerInclusive, byte[] upperRange, boolean upperInclusive) {
        this.lowerRange = lowerRange;
        this.lowerInclusive = lowerInclusive;
        this.upperRange = upperRange;
        this.upperInclusive = upperInclusive;
        this.init();
    }

    private void init() {
        this.isSingleKey = this.lowerRange != UNBOUND && this.upperRange != UNBOUND && this.lowerInclusive && this.upperInclusive && Bytes.compareTo(this.lowerRange, this.upperRange) == 0;
    }

    public byte[] getRange(Bound bound) {
        return bound == Bound.LOWER ? this.getLowerRange() : this.getUpperRange();
    }

    public boolean isInclusive(Bound bound) {
        return bound == Bound.LOWER ? this.isLowerInclusive() : this.isUpperInclusive();
    }

    public boolean isUnbound(Bound bound) {
        return bound == Bound.LOWER ? this.lowerUnbound() : this.upperUnbound();
    }

    public boolean isSingleKey() {
        return this.isSingleKey;
    }

    public int compareLowerToUpperBound(ImmutableBytesWritable ptr, boolean isInclusive) {
        return this.compareLowerToUpperBound(ptr.get(), ptr.getOffset(), ptr.getLength(), isInclusive);
    }

    public int compareLowerToUpperBound(ImmutableBytesWritable ptr) {
        return this.compareLowerToUpperBound(ptr, true);
    }

    public int compareUpperToLowerBound(ImmutableBytesWritable ptr, boolean isInclusive) {
        return this.compareUpperToLowerBound(ptr.get(), ptr.getOffset(), ptr.getLength(), isInclusive);
    }

    public int compareUpperToLowerBound(ImmutableBytesWritable ptr) {
        return this.compareUpperToLowerBound(ptr, true);
    }

    public int compareLowerToUpperBound(byte[] b, int o, int l) {
        return this.compareLowerToUpperBound(b, o, l, true);
    }

    public int compareLowerToUpperBound(byte[] b) {
        return this.compareLowerToUpperBound(b, 0, b.length);
    }

    public int compareLowerToUpperBound(byte[] b, int o, int l, boolean isInclusive) {
        if (this.lowerUnbound() || b == UNBOUND) {
            return -1;
        }
        int cmp = Bytes.compareTo(this.lowerRange, 0, this.lowerRange.length, b, o, l);
        if (cmp > 0) {
            return 1;
        }
        if (cmp < 0) {
            return -1;
        }
        if (this.lowerInclusive && isInclusive) {
            return 0;
        }
        return 1;
    }

    public int compareUpperToLowerBound(byte[] b) {
        return this.compareUpperToLowerBound(b, 0, b.length);
    }

    public int compareUpperToLowerBound(byte[] b, int o, int l) {
        return this.compareUpperToLowerBound(b, o, l, true);
    }

    public int compareUpperToLowerBound(byte[] b, int o, int l, boolean isInclusive) {
        if (this.upperUnbound() || b == UNBOUND) {
            return 1;
        }
        int cmp = Bytes.compareTo(this.upperRange, 0, this.upperRange.length, b, o, l);
        if (cmp > 0) {
            return 1;
        }
        if (cmp < 0) {
            return -1;
        }
        if (this.upperInclusive && isInclusive) {
            return 0;
        }
        return -1;
    }

    public byte[] getLowerRange() {
        return this.lowerRange;
    }

    public boolean isLowerInclusive() {
        return this.lowerInclusive;
    }

    public byte[] getUpperRange() {
        return this.upperRange;
    }

    public boolean isUpperInclusive() {
        return this.upperInclusive;
    }

    public boolean isUnbound() {
        return this.lowerUnbound() || this.upperUnbound();
    }

    public boolean upperUnbound() {
        return this.upperRange == UNBOUND;
    }

    public boolean lowerUnbound() {
        return this.lowerRange == UNBOUND;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Arrays.hashCode(this.lowerRange);
        if (this.lowerRange != null) {
            result = 31 * result + (this.lowerInclusive ? 1231 : 1237);
        }
        result = 31 * result + Arrays.hashCode(this.upperRange);
        if (this.upperRange != null) {
            result = 31 * result + (this.upperInclusive ? 1231 : 1237);
        }
        return result;
    }

    public String toString() {
        if (this.isSingleKey()) {
            return Bytes.toStringBinary(this.lowerRange);
        }
        return (this.lowerInclusive ? "[" : "(") + (this.lowerUnbound() ? "*" : Bytes.toStringBinary(this.lowerRange)) + " - " + (this.upperUnbound() ? "*" : Bytes.toStringBinary(this.upperRange)) + (this.upperInclusive ? "]" : ")");
    }

    public boolean equals(Object o) {
        if (!(o instanceof KeyRange)) {
            return false;
        }
        KeyRange that = (KeyRange)o;
        return Bytes.compareTo(this.lowerRange, that.lowerRange) == 0 && this.lowerInclusive == that.lowerInclusive && Bytes.compareTo(this.upperRange, that.upperRange) == 0 && this.upperInclusive == that.upperInclusive;
    }

    public KeyRange intersect(KeyRange range) {
        boolean newUpperInclusive;
        byte[] newUpperRange;
        int cmp;
        boolean newLowerInclusive;
        byte[] newLowerRange;
        if (this == IS_NULL_RANGE) {
            if (range == IS_NULL_RANGE) {
                return IS_NULL_RANGE;
            }
            return EMPTY_RANGE;
        }
        if (this.lowerUnbound()) {
            newLowerRange = range.lowerRange;
            newLowerInclusive = range.lowerInclusive;
        } else if (range.lowerUnbound()) {
            newLowerRange = this.lowerRange;
            newLowerInclusive = this.lowerInclusive;
        } else {
            cmp = Bytes.compareTo(this.lowerRange, range.lowerRange);
            if (cmp != 0 || this.lowerInclusive == range.lowerInclusive) {
                if (cmp <= 0) {
                    newLowerRange = range.lowerRange;
                    newLowerInclusive = range.lowerInclusive;
                } else {
                    newLowerRange = this.lowerRange;
                    newLowerInclusive = this.lowerInclusive;
                }
            } else {
                newLowerRange = range.lowerRange;
                newLowerInclusive = false;
            }
        }
        if (this.upperUnbound()) {
            newUpperRange = range.upperRange;
            newUpperInclusive = range.upperInclusive;
        } else if (range.upperUnbound()) {
            newUpperRange = this.upperRange;
            newUpperInclusive = this.upperInclusive;
        } else {
            cmp = Bytes.compareTo(this.upperRange, range.upperRange);
            if (cmp != 0 || this.upperInclusive == range.upperInclusive) {
                if (cmp >= 0) {
                    newUpperRange = range.upperRange;
                    newUpperInclusive = range.upperInclusive;
                } else {
                    newUpperRange = this.upperRange;
                    newUpperInclusive = this.upperInclusive;
                }
            } else {
                newUpperRange = range.upperRange;
                newUpperInclusive = false;
            }
        }
        if (newLowerRange == this.lowerRange && newLowerInclusive == this.lowerInclusive && newUpperRange == this.upperRange && newUpperInclusive == this.upperInclusive) {
            return this;
        }
        return KeyRange.getKeyRange(newLowerRange, newLowerInclusive, newUpperRange, newUpperInclusive);
    }

    public static boolean isDegenerate(byte[] lowerRange, byte[] upperRange) {
        return lowerRange == EMPTY_RANGE.getLowerRange() && upperRange == EMPTY_RANGE.getUpperRange();
    }

    public KeyRange appendSeparator() {
        byte[] lowerBound = this.getLowerRange();
        byte[] upperBound = this.getUpperRange();
        if (lowerBound != UNBOUND) {
            lowerBound = ByteUtil.concat(lowerBound, new byte[][]{QueryConstants.SEPARATOR_BYTE_ARRAY});
        }
        if (upperBound != UNBOUND) {
            upperBound = ByteUtil.concat(upperBound, new byte[][]{QueryConstants.SEPARATOR_BYTE_ARRAY});
        }
        return KeyRange.getKeyRange(lowerBound, this.lowerInclusive, upperBound, this.upperInclusive);
    }

    @NonNull
    public static List<KeyRange> coalesce(List<KeyRange> keyRanges) {
        ArrayList<KeyRange> tmp = new ArrayList<KeyRange>();
        for (KeyRange keyRange : keyRanges) {
            if (EMPTY_RANGE == keyRange) continue;
            if (EVERYTHING_RANGE == keyRange) {
                tmp.clear();
                tmp.add(keyRange);
                break;
            }
            tmp.add(keyRange);
        }
        if (tmp.size() == 1) {
            return tmp;
        }
        if (tmp.size() == 0) {
            return Collections.singletonList(EMPTY_RANGE);
        }
        Collections.sort(tmp, COMPARATOR);
        ArrayList<KeyRange> tmp2 = new ArrayList<KeyRange>();
        KeyRange range = (KeyRange)tmp.get(0);
        for (int i = 1; i < tmp.size(); ++i) {
            KeyRange otherRange = (KeyRange)tmp.get(i);
            KeyRange intersect = range.intersect(otherRange);
            if (EMPTY_RANGE == intersect) {
                tmp2.add(range);
                range = otherRange;
                continue;
            }
            range = range.union(otherRange);
        }
        tmp2.add(range);
        ArrayList<KeyRange> tmp3 = new ArrayList<KeyRange>();
        range = (KeyRange)tmp2.get(0);
        for (int i = 1; i < tmp2.size(); ++i) {
            KeyRange otherRange = (KeyRange)tmp2.get(i);
            assert (!range.upperUnbound());
            assert (!otherRange.lowerUnbound());
            if (range.isUpperInclusive() != otherRange.isLowerInclusive() && Bytes.equals(range.getUpperRange(), otherRange.getLowerRange())) {
                range = KeyRange.getKeyRange(range.getLowerRange(), range.isLowerInclusive(), otherRange.getUpperRange(), otherRange.isUpperInclusive());
                continue;
            }
            tmp3.add(range);
            range = otherRange;
        }
        tmp3.add(range);
        return tmp3;
    }

    public KeyRange union(KeyRange other) {
        boolean newUpperInclusive;
        byte[] newUpper;
        boolean newLowerInclusive;
        byte[] newLower;
        if (EMPTY_RANGE == other) {
            return this;
        }
        if (EMPTY_RANGE == this) {
            return other;
        }
        if (this.lowerUnbound() || other.lowerUnbound()) {
            newLower = UNBOUND;
            newLowerInclusive = false;
        } else {
            int lowerCmp = Bytes.compareTo(this.lowerRange, other.lowerRange);
            if (lowerCmp < 0) {
                newLower = this.lowerRange;
                newLowerInclusive = this.lowerInclusive;
            } else if (lowerCmp == 0) {
                newLower = this.lowerRange;
                newLowerInclusive = this.lowerInclusive || other.lowerInclusive;
            } else {
                newLower = other.lowerRange;
                newLowerInclusive = other.lowerInclusive;
            }
        }
        if (this.upperUnbound() || other.upperUnbound()) {
            newUpper = UNBOUND;
            newUpperInclusive = false;
        } else {
            int upperCmp = Bytes.compareTo(this.upperRange, other.upperRange);
            if (upperCmp > 0) {
                newUpper = this.upperRange;
                newUpperInclusive = this.upperInclusive;
            } else if (upperCmp == 0) {
                newUpper = this.upperRange;
                newUpperInclusive = this.upperInclusive || other.upperInclusive;
            } else {
                newUpper = other.upperRange;
                newUpperInclusive = other.upperInclusive;
            }
        }
        return KeyRange.getKeyRange(newLower, newLowerInclusive, newUpper, newUpperInclusive);
    }

    public static List<KeyRange> of(List<byte[]> keys) {
        return Lists.transform(keys, POINT);
    }

    public static List<KeyRange> intersect(List<KeyRange> keyRanges, List<KeyRange> keyRanges2) {
        ArrayList<KeyRange> tmp = new ArrayList<KeyRange>();
        for (KeyRange r1 : keyRanges) {
            for (KeyRange r2 : keyRanges2) {
                KeyRange r = r1.intersect(r2);
                if (EMPTY_RANGE == r) continue;
                tmp.add(r);
            }
        }
        if (tmp.size() == 0) {
            return Collections.singletonList(EMPTY_RANGE);
        }
        Collections.sort(tmp, COMPARATOR);
        ArrayList<KeyRange> tmp2 = new ArrayList<KeyRange>();
        KeyRange r = (KeyRange)tmp.get(0);
        for (int i = 1; i < tmp.size(); ++i) {
            if (EMPTY_RANGE == r.intersect((KeyRange)tmp.get(i))) {
                tmp2.add(r);
                r = (KeyRange)tmp.get(i);
                continue;
            }
            r = r.intersect((KeyRange)tmp.get(i));
        }
        tmp2.add(r);
        return tmp2;
    }

    public KeyRange invert() {
        byte[] upper;
        byte[] lower = this.getLowerRange();
        if (!this.lowerUnbound()) {
            lower = SortOrder.invert(lower, 0, lower.length);
        }
        if (this.isSingleKey()) {
            upper = lower;
        } else {
            upper = this.getUpperRange();
            if (!this.upperUnbound()) {
                upper = SortOrder.invert(upper, 0, upper.length);
            }
        }
        return KeyRange.getKeyRange(lower, this.isLowerInclusive(), upper, this.isUpperInclusive());
    }

    @Override
    public void readFields(DataInput in) throws IOException {
        int len = WritableUtils.readVInt(in);
        if (len == 0) {
            this.lowerRange = UNBOUND;
            this.lowerInclusive = false;
        } else if (len < 0) {
            this.lowerInclusive = false;
            this.lowerRange = new byte[-len - 1];
            in.readFully(this.lowerRange);
        } else {
            this.lowerInclusive = true;
            this.lowerRange = new byte[len - 1];
            in.readFully(this.lowerRange);
        }
        len = WritableUtils.readVInt(in);
        if (len == 0) {
            this.upperRange = UNBOUND;
            this.upperInclusive = false;
        } else if (len < 0) {
            this.upperInclusive = false;
            this.upperRange = new byte[-len - 1];
            in.readFully(this.upperRange);
        } else {
            this.upperInclusive = true;
            this.upperRange = new byte[len - 1];
            in.readFully(this.upperRange);
        }
        this.init();
    }

    private void writeBound(Bound bound, DataOutput out) throws IOException {
        if (this.isUnbound(bound)) {
            WritableUtils.writeVInt(out, 0);
            return;
        }
        byte[] range = this.getRange(bound);
        if (this.isInclusive(bound)) {
            WritableUtils.writeVInt(out, range.length + 1);
        } else {
            WritableUtils.writeVInt(out, -(range.length + 1));
        }
        out.write(range);
    }

    @Override
    public void write(DataOutput out) throws IOException {
        this.writeBound(Bound.LOWER, out);
        this.writeBound(Bound.UPPER, out);
    }

    public KeyRange prependRange(byte[] bytes, int offset, int length) {
        if (length == 0 || this == EVERYTHING_RANGE) {
            return this;
        }
        byte[] lowerRange = this.getLowerRange();
        if (!this.lowerUnbound()) {
            byte[] newLowerRange = new byte[length + lowerRange.length];
            System.arraycopy(bytes, offset, newLowerRange, 0, length);
            System.arraycopy(lowerRange, 0, newLowerRange, length, lowerRange.length);
            lowerRange = newLowerRange;
        }
        byte[] upperRange = this.getUpperRange();
        if (!this.upperUnbound()) {
            byte[] newUpperRange = new byte[length + upperRange.length];
            System.arraycopy(bytes, offset, newUpperRange, 0, length);
            System.arraycopy(upperRange, 0, newUpperRange, length, upperRange.length);
            upperRange = newUpperRange;
        }
        return KeyRange.getKeyRange(lowerRange, this.lowerInclusive, upperRange, this.upperInclusive);
    }

    public static enum Bound {
        LOWER,
        UPPER;

    }
}

