/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.query;

import com.google.common.base.Throwables;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.annotation.concurrent.GuardedBy;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.TableExistsException;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Append;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.apache.hadoop.hbase.client.HConnection;
import org.apache.hadoop.hbase.client.HTableInterface;
import org.apache.hadoop.hbase.client.Increment;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.coprocessor.Batch;
import org.apache.hadoop.hbase.coprocessor.MultiRowMutationEndpoint;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.ipc.BlockingRpcCallback;
import org.apache.hadoop.hbase.ipc.ServerRpcController;
import org.apache.hadoop.hbase.protobuf.generated.ClientProtos;
import org.apache.hadoop.hbase.regionserver.IndexHalfStoreFileReaderGenerator;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.hbase.util.ByteStringer;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.hadoop.hbase.util.VersionInfo;
import org.apache.hadoop.hbase.zookeeper.ZKConfig;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.phoenix.compile.MutationPlan;
import org.apache.phoenix.coprocessor.GroupedAggregateRegionObserver;
import org.apache.phoenix.coprocessor.MetaDataEndpointImpl;
import org.apache.phoenix.coprocessor.MetaDataProtocol;
import org.apache.phoenix.coprocessor.MetaDataRegionObserver;
import org.apache.phoenix.coprocessor.ScanRegionObserver;
import org.apache.phoenix.coprocessor.SequenceRegionObserver;
import org.apache.phoenix.coprocessor.ServerCachingEndpointImpl;
import org.apache.phoenix.coprocessor.UngroupedAggregateRegionObserver;
import org.apache.phoenix.coprocessor.generated.MetaDataProtos;
import org.apache.phoenix.exception.PhoenixIOException;
import org.apache.phoenix.exception.SQLExceptionCode;
import org.apache.phoenix.exception.SQLExceptionInfo;
import org.apache.phoenix.execute.MutationState;
import org.apache.phoenix.hbase.index.IndexRegionSplitPolicy;
import org.apache.phoenix.hbase.index.Indexer;
import org.apache.phoenix.hbase.index.util.ImmutableBytesPtr;
import org.apache.phoenix.hbase.index.util.KeyValueBuilder;
import org.apache.phoenix.index.PhoenixIndexBuilder;
import org.apache.phoenix.index.PhoenixIndexCodec;
import org.apache.phoenix.jdbc.PhoenixConnection;
import org.apache.phoenix.jdbc.PhoenixDatabaseMetaData;
import org.apache.phoenix.jdbc.PhoenixEmbeddedDriver;
import org.apache.phoenix.parse.PFunction;
import org.apache.phoenix.protobuf.ProtobufUtil;
import org.apache.phoenix.query.ChildQueryServices;
import org.apache.phoenix.query.ConnectionQueryServices;
import org.apache.phoenix.query.DelegateQueryServices;
import org.apache.phoenix.query.HBaseFactoryProvider;
import org.apache.phoenix.query.QueryConstants;
import org.apache.phoenix.query.QueryServices;
import org.apache.phoenix.query.QueryServicesOptions;
import org.apache.phoenix.schema.ColumnFamilyNotFoundException;
import org.apache.phoenix.schema.EmptySequenceCacheException;
import org.apache.phoenix.schema.FunctionNotFoundException;
import org.apache.phoenix.schema.MetaDataSplitPolicy;
import org.apache.phoenix.schema.NewerTableAlreadyExistsException;
import org.apache.phoenix.schema.PColumn;
import org.apache.phoenix.schema.PColumnFamily;
import org.apache.phoenix.schema.PMetaData;
import org.apache.phoenix.schema.PMetaDataImpl;
import org.apache.phoenix.schema.PName;
import org.apache.phoenix.schema.PNameFactory;
import org.apache.phoenix.schema.PTable;
import org.apache.phoenix.schema.PTableKey;
import org.apache.phoenix.schema.PTableType;
import org.apache.phoenix.schema.ReadOnlyTableException;
import org.apache.phoenix.schema.SaltingUtil;
import org.apache.phoenix.schema.Sequence;
import org.apache.phoenix.schema.SequenceKey;
import org.apache.phoenix.schema.TableAlreadyExistsException;
import org.apache.phoenix.schema.TableNotFoundException;
import org.apache.phoenix.schema.TableProperty;
import org.apache.phoenix.schema.stats.PTableStats;
import org.apache.phoenix.schema.stats.StatisticsUtil;
import org.apache.phoenix.schema.types.PBoolean;
import org.apache.phoenix.schema.types.PDataType;
import org.apache.phoenix.schema.types.PLong;
import org.apache.phoenix.schema.types.PUnsignedTinyint;
import org.apache.phoenix.util.ByteUtil;
import org.apache.phoenix.util.Closeables;
import org.apache.phoenix.util.ConfigUtil;
import org.apache.phoenix.util.JDBCUtil;
import org.apache.phoenix.util.MetaDataUtil;
import org.apache.phoenix.util.PhoenixContextExecutor;
import org.apache.phoenix.util.PhoenixStopWatch;
import org.apache.phoenix.util.PropertiesUtil;
import org.apache.phoenix.util.ReadOnlyProps;
import org.apache.phoenix.util.SchemaUtil;
import org.apache.phoenix.util.ServerUtil;
import org.apache.phoenix.util.UpgradeUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectionQueryServicesImpl
extends DelegateQueryServices
implements ConnectionQueryServices {
    private static final Logger logger = LoggerFactory.getLogger(ConnectionQueryServicesImpl.class);
    private static final int INITIAL_CHILD_SERVICES_CAPACITY = 100;
    private static final int DEFAULT_OUT_OF_ORDER_MUTATIONS_WAIT_TIME_MS = 1000;
    private static final int MAX_TABLE_STATS_CACHE_ENTRIES = 512;
    protected final Configuration config;
    private final ReadOnlyProps props;
    private final String userName;
    private final ConcurrentHashMap<ImmutableBytesWritable, ConnectionQueryServices> childServices;
    private final Cache<ImmutableBytesPtr, PTableStats> tableStatsCache;
    private volatile PMetaData latestMetaData;
    private final Object latestMetaDataLock = new Object();
    private int lowestClusterHBaseVersion = Integer.MAX_VALUE;
    private boolean hasInvalidIndexConfiguration = false;
    @GuardedBy(value="connectionCountLock")
    private int connectionCount = 0;
    private final Object connectionCountLock = new Object();
    private HConnection connection;
    private volatile boolean initialized;
    private volatile int nSequenceSaltBuckets;
    private volatile boolean closed;
    private volatile SQLException initializationException;
    private volatile ConcurrentMap<SequenceKey, Sequence> sequenceMap = Maps.newConcurrentMap();
    private KeyValueBuilder kvBuilder;
    private final Map<ConnectionQueryServices.Feature, FeatureSupported> featureMap = ImmutableMap.of(ConnectionQueryServices.Feature.LOCAL_INDEX, new FeatureSupported(){

        @Override
        public boolean isSupported(ConnectionQueryServices services) {
            int hbaseVersion = services.getLowestClusterHBaseVersion();
            return hbaseVersion < PhoenixDatabaseMetaData.MIN_LOCAL_SI_VERSION_DISALLOW || hbaseVersion > PhoenixDatabaseMetaData.MAX_LOCAL_SI_VERSION_DISALLOW;
        }
    });
    private static final String TRUE_BYTES_AS_STRING = Bytes.toString(PDataType.TRUE_BYTES);

    private PMetaData newEmptyMetaData() {
        long maxSizeBytes = this.props.getLong("phoenix.client.maxMetaDataCacheSize", 0xA00000L);
        return new PMetaDataImpl(100, maxSizeBytes);
    }

    public ConnectionQueryServicesImpl(QueryServices services, PhoenixEmbeddedDriver.ConnectionInfo connectionInfo, Properties info) {
        super(services);
        Configuration config = HBaseFactoryProvider.getConfigurationFactory().getConfiguration();
        for (Map.Entry entry : services.getProps()) {
            config.set(entry.getKey(), entry.getValue());
        }
        if (info != null) {
            for (Object key : info.keySet()) {
                config.set((String)key, info.getProperty((String)key));
            }
        }
        for (Map.Entry entry : connectionInfo.asProps()) {
            config.set((String)entry.getKey(), (String)entry.getValue());
        }
        this.config = HBaseFactoryProvider.getConfigurationFactory().getConfiguration(config);
        ConfigUtil.setReplicationConfigIfAbsent(this.config);
        this.props = new ReadOnlyProps(this.config.iterator());
        this.userName = connectionInfo.getPrincipal();
        this.latestMetaData = this.newEmptyMetaData();
        this.childServices = new ConcurrentHashMap(100);
        String hbaseVersion = VersionInfo.getVersion();
        this.kvBuilder = KeyValueBuilder.get(hbaseVersion);
        long halfStatsUpdateFreq = config.getLong("phoenix.stats.updateFrequency", 900000L) / 2L;
        this.tableStatsCache = CacheBuilder.newBuilder().maximumSize(512L).expireAfterWrite(halfStatsUpdateFreq, TimeUnit.MILLISECONDS).build();
    }

    private void openConnection() throws SQLException {
        try {
            String clientKeytab = this.getProps().get("hbase.myclient.keytab");
            String clientPrincipal = this.getProps().get("hbase.myclient.principal");
            if (clientKeytab != null && clientPrincipal != null) {
                logger.info("Trying to connect to a secure cluster with keytab:" + clientKeytab);
                UserGroupInformation.setConfiguration(this.config);
                User.login(this.config, "hbase.myclient.keytab", "hbase.myclient.principal", null);
                logger.info("Successfull login to secure cluster!!");
            }
            this.connection = HBaseFactoryProvider.getHConnectionFactory().createConnection(this.config);
        }
        catch (IOException e) {
            throw new SQLExceptionInfo.Builder(SQLExceptionCode.CANNOT_ESTABLISH_CONNECTION).setRootCause(e).build().buildException();
        }
        if (this.connection.isClosed()) {
            throw new SQLExceptionInfo.Builder(SQLExceptionCode.CANNOT_ESTABLISH_CONNECTION).build().buildException();
        }
    }

    @Override
    public HTableInterface getTable(byte[] tableName) throws SQLException {
        try {
            return HBaseFactoryProvider.getHTableFactory().getTable(tableName, this.connection, null);
        }
        catch (org.apache.hadoop.hbase.TableNotFoundException e) {
            byte[][] schemaAndTableName = new byte[2][];
            SchemaUtil.getVarChars(tableName, schemaAndTableName);
            throw new TableNotFoundException(Bytes.toString(schemaAndTableName[0]), Bytes.toString(schemaAndTableName[1]));
        }
        catch (IOException e) {
            throw new SQLException(e);
        }
    }

    @Override
    public HTableDescriptor getTableDescriptor(byte[] tableName) throws SQLException {
        HTableInterface htable = this.getTable(tableName);
        try {
            HTableDescriptor hTableDescriptor = htable.getTableDescriptor();
            return hTableDescriptor;
        }
        catch (IOException e) {
            if (e instanceof org.apache.hadoop.hbase.TableNotFoundException || e.getCause() instanceof org.apache.hadoop.hbase.TableNotFoundException) {
                byte[][] schemaAndTableName = new byte[2][];
                SchemaUtil.getVarChars(tableName, schemaAndTableName);
                throw new TableNotFoundException(Bytes.toString(schemaAndTableName[0]), Bytes.toString(schemaAndTableName[1]));
            }
            throw new RuntimeException(e);
        }
        finally {
            Closeables.closeQuietly(htable);
        }
    }

    @Override
    public ReadOnlyProps getProps() {
        return this.props;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public void close() throws SQLException {
        block68: {
            if (this.closed) {
                return;
            }
            ConnectionQueryServicesImpl connectionQueryServicesImpl = this;
            // MONITORENTER : connectionQueryServicesImpl
            if (this.closed) {
                // MONITOREXIT : connectionQueryServicesImpl
                return;
            }
            this.closed = true;
            SQLException sqlE = null;
            try {
                if (this.connection == null) return;
                this.returnAllSequences(this.sequenceMap);
                return;
            }
            catch (SQLException e) {
                sqlE = e;
            }
            finally {
                try {
                    this.childServices.clear();
                    Object e = this.latestMetaDataLock;
                }
                catch (IOException e) {
                    if (sqlE == null) {
                        sqlE = ServerUtil.parseServerException(e);
                    }
                    sqlE.setNextException(ServerUtil.parseServerException(e));
                }
                finally {
                    try {
                        this.tableStatsCache.invalidateAll();
                        super.close();
                    }
                    catch (SQLException e) {
                        if (sqlE == null) {
                            sqlE = e;
                        }
                        sqlE.setNextException(e);
                    }
                    finally {
                        if (sqlE == null) break block68;
                        throw sqlE;
                    }
                }
            }
        }
        // MONITOREXIT : connectionQueryServicesImpl
    }

    protected ConnectionQueryServices newChildQueryService() {
        return new ChildQueryServices(this);
    }

    @Override
    public ConnectionQueryServices getChildQueryServices(ImmutableBytesWritable tenantId) {
        ConnectionQueryServices childQueryService = this.childServices.get(tenantId);
        if (childQueryService == null) {
            childQueryService = this.newChildQueryService();
            ConnectionQueryServices prevQueryService = this.childServices.putIfAbsent(tenantId, childQueryService);
            return prevQueryService == null ? childQueryService : prevQueryService;
        }
        return childQueryService;
    }

    @Override
    public void clearTableRegionCache(byte[] tableName) throws SQLException {
        this.connection.clearRegionCache(TableName.valueOf(tableName));
    }

    @Override
    public List<HRegionLocation> getAllTableRegions(byte[] tableName) throws SQLException {
        int retryCount = 0;
        int maxRetryCount = 1;
        boolean reload = false;
        while (true) {
            try {
                HRegionLocation regionLocation;
                ArrayList<HRegionLocation> locations = Lists.newArrayList();
                byte[] currentKey = HConstants.EMPTY_START_ROW;
                do {
                    regionLocation = this.connection.getRegionLocation(TableName.valueOf(tableName), currentKey, reload);
                    locations.add(regionLocation);
                } while (!Bytes.equals(currentKey = regionLocation.getRegionInfo().getEndKey(), HConstants.EMPTY_END_ROW));
                return locations;
            }
            catch (org.apache.hadoop.hbase.TableNotFoundException e) {
                String fullName = Bytes.toString(tableName);
                throw new TableNotFoundException(SchemaUtil.getSchemaNameFromFullName(fullName), SchemaUtil.getTableNameFromFullName(fullName));
            }
            catch (IOException e) {
                if (retryCount++ < maxRetryCount) {
                    reload = true;
                    continue;
                }
                throw new SQLExceptionInfo.Builder(SQLExceptionCode.GET_TABLE_REGIONS_FAIL).setRootCause(e).build().buildException();
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PMetaData addTable(PTable table) throws SQLException {
        Object object = this.latestMetaDataLock;
        synchronized (object) {
            try {
                this.throwConnectionClosedIfNullMetaData();
                PTable existingTable = this.latestMetaData.getTable(new PTableKey(table.getTenantId(), table.getName().getString()));
                if (existingTable.getTimeStamp() >= table.getTimeStamp()) {
                    return this.latestMetaData;
                }
            }
            catch (TableNotFoundException tableNotFoundException) {
                // empty catch block
            }
            this.latestMetaData = this.latestMetaData.addTable(table);
            this.latestMetaDataLock.notifyAll();
            return this.latestMetaData;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PMetaData metaDataMutated(PName tenantId, String tableName, long tableSeqNum, Mutator mutator) throws SQLException {
        Object object = this.latestMetaDataLock;
        synchronized (object) {
            this.throwConnectionClosedIfNullMetaData();
            PMetaData metaData = this.latestMetaData;
            long endTime = System.currentTimeMillis() + 1000L;
            try {
                while (true) {
                    long waitTime;
                    block11: {
                        try {
                            PTable table = metaData.getTable(new PTableKey(tenantId, tableName));
                            if (table.getSequenceNumber() + 1L == tableSeqNum) {
                                metaData = mutator.mutate(metaData);
                                break;
                            }
                            if (table.getSequenceNumber() < tableSeqNum) break block11;
                            logger.warn("Attempt to cache older version of " + tableName + ": current= " + table.getSequenceNumber() + ", new=" + tableSeqNum);
                            break;
                        }
                        catch (TableNotFoundException tableNotFoundException) {
                            // empty catch block
                        }
                    }
                    if ((waitTime = endTime - System.currentTimeMillis()) <= 0L) {
                        logger.warn("Unable to update meta data repo within 1 seconds for " + tableName);
                        metaData = metaData.removeTable(tenantId, tableName, null, Long.MAX_VALUE);
                        break;
                    }
                    this.latestMetaDataLock.wait(waitTime);
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new SQLExceptionInfo.Builder(SQLExceptionCode.INTERRUPTED_EXCEPTION).setRootCause(e).build().buildException();
            }
            this.latestMetaData = metaData;
            this.latestMetaDataLock.notifyAll();
            return metaData;
        }
    }

    @Override
    public PMetaData addColumn(final PName tenantId, final String tableName, final List<PColumn> columns, final long tableTimeStamp, final long tableSeqNum, final boolean isImmutableRows, final boolean isWalDisabled, final boolean isMultitenant, final boolean storeNulls) throws SQLException {
        return this.metaDataMutated(tenantId, tableName, tableSeqNum, new Mutator(){

            @Override
            public PMetaData mutate(PMetaData metaData) throws SQLException {
                try {
                    return metaData.addColumn(tenantId, tableName, columns, tableTimeStamp, tableSeqNum, isImmutableRows, isWalDisabled, isMultitenant, storeNulls);
                }
                catch (TableNotFoundException e) {
                    return metaData;
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PMetaData removeTable(PName tenantId, String tableName, String parentTableName, long tableTimeStamp) throws SQLException {
        Object object = this.latestMetaDataLock;
        synchronized (object) {
            this.throwConnectionClosedIfNullMetaData();
            this.latestMetaData = this.latestMetaData.removeTable(tenantId, tableName, parentTableName, tableTimeStamp);
            this.latestMetaDataLock.notifyAll();
            return this.latestMetaData;
        }
    }

    @Override
    public PMetaData removeColumn(final PName tenantId, final String tableName, final List<PColumn> columnsToRemove, final long tableTimeStamp, final long tableSeqNum) throws SQLException {
        return this.metaDataMutated(tenantId, tableName, tableSeqNum, new Mutator(){

            @Override
            public PMetaData mutate(PMetaData metaData) throws SQLException {
                try {
                    return metaData.removeColumn(tenantId, tableName, columnsToRemove, tableTimeStamp, tableSeqNum);
                }
                catch (TableNotFoundException e) {
                    return metaData;
                }
            }
        });
    }

    @Override
    public PhoenixConnection connect(String url, Properties info) throws SQLException {
        this.checkClosed();
        PMetaData metadata = this.latestMetaData;
        if (metadata == null) {
            this.throwConnectionClosedException();
        }
        return new PhoenixConnection(this, url, info, metadata);
    }

    private HColumnDescriptor generateColumnFamilyDescriptor(Pair<byte[], Map<String, Object>> family, PTableType tableType) throws SQLException {
        HColumnDescriptor columnDesc = new HColumnDescriptor(family.getFirst());
        if (tableType != PTableType.VIEW) {
            if (this.props.get("phoenix.table.default.keep.deleted.cells") != null) {
                columnDesc.setKeepDeletedCells(this.props.getBoolean("phoenix.table.default.keep.deleted.cells", false));
            }
            columnDesc.setDataBlockEncoding(SchemaUtil.DEFAULT_DATA_BLOCK_ENCODING);
            for (Map.Entry<String, Object> entry : family.getSecond().entrySet()) {
                String key = entry.getKey();
                Object value = entry.getValue();
                columnDesc.setValue(key, value == null ? null : value.toString());
            }
        }
        return columnDesc;
    }

    private void modifyColumnFamilyDescriptor(HColumnDescriptor hcd, Pair<byte[], Map<String, Object>> family) throws SQLException {
        if (!Bytes.equals(hcd.getName(), family.getFirst())) {
            throw new IllegalArgumentException("Column family names don't match. Column descriptor family name: " + hcd.getNameAsString() + ", Family name: " + Bytes.toString(family.getFirst()));
        }
        this.modifyColumnFamilyDescriptor(hcd, family.getSecond());
    }

    private void modifyColumnFamilyDescriptor(HColumnDescriptor hcd, Map<String, Object> props) throws SQLException {
        for (Map.Entry<String, Object> entry : props.entrySet()) {
            String propName = entry.getKey();
            Object value = entry.getValue();
            hcd.setValue(propName, value == null ? null : value.toString());
        }
    }

    private HTableDescriptor generateTableDescriptor(byte[] tableName, HTableDescriptor existingDesc, PTableType tableType, Map<String, Object> tableProps, List<Pair<byte[], Map<String, Object>>> families, byte[][] splits) throws SQLException {
        String defaultFamilyName = (String)tableProps.remove("DEFAULT_COLUMN_FAMILY");
        HTableDescriptor tableDescriptor = existingDesc != null ? new HTableDescriptor(existingDesc) : new HTableDescriptor(TableName.valueOf(tableName));
        for (Map.Entry<String, Object> entry : tableProps.entrySet()) {
            String key = entry.getKey();
            Object value = entry.getValue();
            tableDescriptor.setValue(key, value == null ? null : value.toString());
        }
        if (families.isEmpty()) {
            if (tableType != PTableType.VIEW) {
                byte[] defaultFamilyByes = defaultFamilyName == null ? QueryConstants.DEFAULT_COLUMN_FAMILY_BYTES : Bytes.toBytes(defaultFamilyName);
                HColumnDescriptor hColumnDescriptor = this.generateColumnFamilyDescriptor(new Pair<byte[], Map<String, Object>>(defaultFamilyByes, Collections.emptyMap()), tableType);
                tableDescriptor.addFamily(hColumnDescriptor);
            }
        } else {
            for (Pair pair : families) {
                byte[] familyByte = (byte[])pair.getFirst();
                if (tableDescriptor.getFamily(familyByte) == null) {
                    if (tableType == PTableType.VIEW) {
                        String fullTableName = Bytes.toString(tableName);
                        throw new ReadOnlyTableException("The HBase column families for a read-only table must already exist", SchemaUtil.getSchemaNameFromFullName(fullTableName), SchemaUtil.getTableNameFromFullName(fullTableName), Bytes.toString(familyByte));
                    }
                    HColumnDescriptor columnDescriptor = this.generateColumnFamilyDescriptor(pair, tableType);
                    tableDescriptor.addFamily(columnDescriptor);
                    continue;
                }
                if (tableType == PTableType.VIEW) continue;
                this.modifyColumnFamilyDescriptor(tableDescriptor.getFamily(familyByte), pair);
            }
        }
        this.addCoprocessors(tableName, tableDescriptor, tableType);
        return tableDescriptor;
    }

    private void addCoprocessors(byte[] tableName, HTableDescriptor descriptor, PTableType tableType) throws SQLException {
        int priority = this.props.getInt("phoenix.coprocessor.priority", 0x2FFFFFFE);
        try {
            if (!descriptor.hasCoprocessor(ScanRegionObserver.class.getName())) {
                descriptor.addCoprocessor(ScanRegionObserver.class.getName(), null, priority, null);
            }
            if (!descriptor.hasCoprocessor(UngroupedAggregateRegionObserver.class.getName())) {
                descriptor.addCoprocessor(UngroupedAggregateRegionObserver.class.getName(), null, priority, null);
            }
            if (!descriptor.hasCoprocessor(GroupedAggregateRegionObserver.class.getName())) {
                descriptor.addCoprocessor(GroupedAggregateRegionObserver.class.getName(), null, priority, null);
            }
            if (!descriptor.hasCoprocessor(ServerCachingEndpointImpl.class.getName())) {
                descriptor.addCoprocessor(ServerCachingEndpointImpl.class.getName(), null, priority, null);
            }
            if (!(tableType == PTableType.INDEX || tableType == PTableType.VIEW || SchemaUtil.isMetaTable(tableName) || SchemaUtil.isStatsTable(tableName) || descriptor.hasCoprocessor(Indexer.class.getName()))) {
                HashMap<String, String> opts = Maps.newHashMapWithExpectedSize(1);
                opts.put("org.apache.hadoop.hbase.index.codec.class", PhoenixIndexCodec.class.getName());
                Indexer.enableIndexing(descriptor, PhoenixIndexBuilder.class, opts, priority);
            }
            if (SchemaUtil.isStatsTable(tableName) && !descriptor.hasCoprocessor(MultiRowMutationEndpoint.class.getName())) {
                descriptor.addCoprocessor(MultiRowMutationEndpoint.class.getName(), null, priority, null);
            }
            Set<byte[]> familiesKeys = descriptor.getFamiliesKeys();
            for (byte[] family : familiesKeys) {
                if (!Bytes.toString(family).startsWith("L#") || descriptor.hasCoprocessor(IndexHalfStoreFileReaderGenerator.class.getName())) continue;
                descriptor.addCoprocessor(IndexHalfStoreFileReaderGenerator.class.getName(), null, priority, null);
                break;
            }
            if (SchemaUtil.isMetaTable(tableName) || SchemaUtil.isFunctionTable(tableName)) {
                if (!descriptor.hasCoprocessor(MetaDataEndpointImpl.class.getName())) {
                    descriptor.addCoprocessor(MetaDataEndpointImpl.class.getName(), null, priority, null);
                }
                if (SchemaUtil.isMetaTable(tableName) && !descriptor.hasCoprocessor(MetaDataRegionObserver.class.getName())) {
                    descriptor.addCoprocessor(MetaDataRegionObserver.class.getName(), null, priority + 1, null);
                }
            } else if (SchemaUtil.isSequenceTable(tableName) && !descriptor.hasCoprocessor(SequenceRegionObserver.class.getName())) {
                descriptor.addCoprocessor(SequenceRegionObserver.class.getName(), null, priority, null);
            }
        }
        catch (IOException e) {
            throw ServerUtil.parseServerException(e);
        }
    }

    private void pollForUpdatedTableDescriptor(final HBaseAdmin admin, final HTableDescriptor newTableDescriptor, final byte[] tableName) throws InterruptedException, TimeoutException {
        this.checkAndRetry(new RetriableOperation(){

            @Override
            public String getOperatioName() {
                return "UpdateOrNewTableDescriptor";
            }

            @Override
            public boolean checkForCompletion() throws TimeoutException, IOException {
                HTableDescriptor tableDesc = admin.getTableDescriptor(tableName);
                return newTableDescriptor.equals(tableDesc);
            }
        });
    }

    private void checkAndRetry(RetriableOperation op) throws InterruptedException, TimeoutException {
        int maxRetries = this.props.getInt("phoenix.schema.change.retries", 10);
        long sleepInterval = this.props.getLong("phoenix.schema.change.delay", 5000L);
        boolean success = false;
        int numTries = 1;
        PhoenixStopWatch watch = new PhoenixStopWatch();
        watch.start();
        do {
            block5: {
                try {
                    success = op.checkForCompletion();
                }
                catch (Exception ex) {
                    if (numTries != 1 && numTries != maxRetries) break block5;
                    watch.stop();
                    TimeoutException toThrow = new TimeoutException("Operation " + op.getOperatioName() + " didn't complete because of exception. Time elapsed: " + watch.elapsedMillis());
                    toThrow.initCause(ex);
                    throw toThrow;
                }
            }
            Thread.sleep(sleepInterval);
        } while (++numTries < maxRetries && !success);
        watch.stop();
        if (!success) {
            throw new TimeoutException("Operation  " + op.getOperatioName() + " didn't complete within " + watch.elapsedMillis() + " ms " + (numTries > 1 ? "after trying " + numTries + (numTries > 1 ? "times." : "time.") : ""));
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Operation " + op.getOperatioName() + " completed within " + watch.elapsedMillis() + "ms " + (numTries > 1 ? "after trying " + numTries + (numTries > 1 ? "times." : "time.") : ""));
        }
    }

    private boolean allowOnlineTableSchemaUpdate() {
        return this.props.getBoolean("hbase.online.schema.update.enable", true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private HTableDescriptor ensureTableCreated(byte[] tableName, PTableType tableType, Map<String, Object> props, List<Pair<byte[], Map<String, Object>>> families, byte[][] splits, boolean modifyExistingMetaData) throws SQLException {
        HBaseAdmin admin = null;
        SQLException sqlE = null;
        HTableDescriptor existingDesc = null;
        boolean isMetaTable = SchemaUtil.isMetaTable(tableName);
        boolean tableExist = true;
        try {
            Object object;
            block63: {
                String quorum = ZKConfig.getZKQuorumServersString(this.config);
                String znode = this.config.get("zookeeper.znode.parent");
                logger.debug("Found quorum: " + quorum + ":" + znode);
                admin = new HBaseAdmin(this.config);
                try {
                    existingDesc = admin.getTableDescriptor(tableName);
                }
                catch (org.apache.hadoop.hbase.TableNotFoundException e) {
                    tableExist = false;
                    if (tableType != PTableType.VIEW) break block63;
                    String fullTableName = Bytes.toString(tableName);
                    throw new ReadOnlyTableException("An HBase table for a VIEW must already exist", SchemaUtil.getSchemaNameFromFullName(fullTableName), SchemaUtil.getTableNameFromFullName(fullTableName));
                }
            }
            HTableDescriptor newDesc = this.generateTableDescriptor(tableName, existingDesc, tableType, props, families, splits);
            if (!tableExist) {
                if (isMetaTable) {
                    newDesc.remove("SPLIT_POLICY");
                }
                try {
                    if (splits == null) {
                        admin.createTable(newDesc);
                    } else {
                        admin.createTable(newDesc, splits);
                    }
                }
                catch (TableExistsException e) {
                    HTableDescriptor hTableDescriptor = null;
                    try {
                        if (admin == null) return hTableDescriptor;
                        admin.close();
                        return hTableDescriptor;
                    }
                    catch (IOException e2) {
                        if (sqlE == null) {
                            sqlE = ServerUtil.parseServerException(e2);
                        }
                        sqlE.setNextException(ServerUtil.parseServerException(e2));
                    }
                    finally {
                        if (sqlE == null) return hTableDescriptor;
                        throw sqlE;
                    }
                }
                if (isMetaTable) {
                    this.checkClientServerCompatibility();
                    newDesc.setValue("SPLIT_POLICY", MetaDataSplitPolicy.class.getName());
                    if (this.allowOnlineTableSchemaUpdate()) {
                        admin.modifyTable(tableName, newDesc);
                    } else {
                        admin.disableTable(tableName);
                        admin.modifyTable(tableName, newDesc);
                        admin.enableTable(tableName);
                    }
                }
                HTableDescriptor hTableDescriptor = null;
                return hTableDescriptor;
            }
            if (isMetaTable) {
                this.checkClientServerCompatibility();
            }
            for (Pair<byte[], Map<String, Object>> family : families) {
                if (!Bytes.toString(family.getFirst()).startsWith("L#")) continue;
                newDesc.setValue("SPLIT_POLICY", IndexRegionSplitPolicy.class.getName());
                break;
            }
            if (!modifyExistingMetaData || existingDesc.equals(newDesc)) {
                object = existingDesc;
                return object;
            }
            this.modifyTable(tableName, newDesc, true);
            object = newDesc;
            return object;
        }
        catch (IOException e) {
            sqlE = ServerUtil.parseServerException(e);
            return sqlE;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            sqlE = new SQLExceptionInfo.Builder(SQLExceptionCode.INTERRUPTED_EXCEPTION).setRootCause(e).build().buildException();
            return sqlE;
        }
        catch (TimeoutException e) {
            sqlE = new SQLExceptionInfo.Builder(SQLExceptionCode.OPERATION_TIMED_OUT).setRootCause(e.getCause() != null ? e.getCause() : e).build().buildException();
            return sqlE;
        }
        finally {
            try {
                if (admin != null) {
                    admin.close();
                }
            }
            catch (IOException e) {
                if (sqlE == null) {
                    sqlE = ServerUtil.parseServerException(e);
                }
                sqlE.setNextException(ServerUtil.parseServerException(e));
            }
            finally {
                if (sqlE == null) return null;
                throw sqlE;
            }
        }
    }

    private void modifyTable(byte[] tableName, HTableDescriptor newDesc, boolean shouldPoll) throws IOException, InterruptedException, TimeoutException {
        try (HBaseAdmin admin = new HBaseAdmin(this.config);){
            if (!this.allowOnlineTableSchemaUpdate()) {
                admin.disableTable(tableName);
                admin.modifyTable(tableName, newDesc);
                admin.enableTable(tableName);
            } else {
                admin.modifyTable(tableName, newDesc);
                if (shouldPoll) {
                    this.pollForUpdatedTableDescriptor(admin, newDesc, tableName);
                }
            }
        }
    }

    private static boolean isInvalidMutableIndexConfig(Long serverVersion) {
        if (serverVersion == null) {
            return false;
        }
        return !MetaDataUtil.decodeMutableIndexConfiguredProperly(serverVersion);
    }

    private static boolean isCompatible(Long serverVersion) {
        if (serverVersion == null) {
            return false;
        }
        return MetaDataUtil.areClientAndServerCompatible(serverVersion);
    }

    private void checkClientServerCompatibility() throws SQLException {
        StringBuilder buf = new StringBuilder("The following servers require an updated phoenix.jar to be put in the classpath of HBase: ");
        boolean isIncompatible = false;
        int minHBaseVersion = Integer.MAX_VALUE;
        try {
            List<HRegionLocation> locations = this.getAllTableRegions(PhoenixDatabaseMetaData.SYSTEM_CATALOG_NAME_BYTES);
            HashSet<HRegionLocation> serverMap = Sets.newHashSetWithExpectedSize(locations.size());
            TreeMap<byte[], HRegionLocation> regionMap = Maps.newTreeMap(Bytes.BYTES_COMPARATOR);
            ArrayList<byte[]> regionKeys = Lists.newArrayListWithExpectedSize(locations.size());
            for (HRegionLocation entry : locations) {
                if (serverMap.contains(entry)) continue;
                regionKeys.add(entry.getRegionInfo().getStartKey());
                regionMap.put(entry.getRegionInfo().getRegionName(), entry);
                serverMap.add(entry);
            }
            HTableInterface ht = this.getTable(PhoenixDatabaseMetaData.SYSTEM_CATALOG_NAME_BYTES);
            Map<byte[], Long> results = ht.coprocessorService(MetaDataProtos.MetaDataService.class, null, null, new Batch.Call<MetaDataProtos.MetaDataService, Long>(){

                @Override
                public Long call(MetaDataProtos.MetaDataService instance) throws IOException {
                    ServerRpcController controller = new ServerRpcController();
                    BlockingRpcCallback<MetaDataProtos.GetVersionResponse> rpcCallback = new BlockingRpcCallback<MetaDataProtos.GetVersionResponse>();
                    MetaDataProtos.GetVersionRequest.Builder builder = MetaDataProtos.GetVersionRequest.newBuilder();
                    instance.getVersion(controller, builder.build(), rpcCallback);
                    if (controller.getFailedOn() != null) {
                        throw controller.getFailedOn();
                    }
                    return rpcCallback.get().getVersion();
                }
            });
            for (Map.Entry<byte[], Long> result : results.entrySet()) {
                if (!ConnectionQueryServicesImpl.isCompatible(result.getValue())) {
                    isIncompatible = true;
                    HRegionLocation name = (HRegionLocation)regionMap.get(result.getKey());
                    buf.append(name);
                    buf.append(';');
                }
                this.hasInvalidIndexConfiguration |= ConnectionQueryServicesImpl.isInvalidMutableIndexConfig(result.getValue());
                if (minHBaseVersion <= MetaDataUtil.decodeHBaseVersion(result.getValue())) continue;
                minHBaseVersion = MetaDataUtil.decodeHBaseVersion(result.getValue());
            }
            this.lowestClusterHBaseVersion = minHBaseVersion;
        }
        catch (SQLException e) {
            throw e;
        }
        catch (Throwable t) {
            throw new SQLExceptionInfo.Builder(SQLExceptionCode.INCOMPATIBLE_CLIENT_SERVER_JAR).setRootCause(t).setMessage("Ensure that phoenix.jar is put on the classpath of HBase in every region server: " + t.getMessage()).build().buildException();
        }
        if (isIncompatible) {
            buf.setLength(buf.length() - 1);
            throw new SQLExceptionInfo.Builder(SQLExceptionCode.OUTDATED_JARS).setMessage(buf.toString()).build().buildException();
        }
    }

    private MetaDataProtocol.MetaDataMutationResult metaDataCoprocessorExec(byte[] tableKey, Batch.Call<MetaDataProtos.MetaDataService, MetaDataProtos.MetaDataResponse> callable) throws SQLException {
        return this.metaDataCoprocessorExec(tableKey, callable, PhoenixDatabaseMetaData.SYSTEM_CATALOG_NAME_BYTES);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private MetaDataProtocol.MetaDataMutationResult metaDataCoprocessorExec(byte[] tableKey, Batch.Call<MetaDataProtos.MetaDataService, MetaDataProtos.MetaDataResponse> callable, byte[] tableName) throws SQLException {
        try {
            boolean retried = false;
            while (true) {
                if (retried) {
                    this.connection.relocateRegion(TableName.valueOf(tableName), tableKey);
                }
                HTableInterface ht = this.getTable(tableName);
                try {
                    Map<byte[], MetaDataProtos.MetaDataResponse> results = ht.coprocessorService(MetaDataProtos.MetaDataService.class, tableKey, tableKey, callable);
                    assert (results.size() == 1);
                    MetaDataProtos.MetaDataResponse result = results.values().iterator().next();
                    if (result.getReturnCode() == MetaDataProtos.MutationCode.TABLE_NOT_IN_REGION || result.getReturnCode() == MetaDataProtos.MutationCode.FUNCTION_NOT_IN_REGION) {
                        if (retried) {
                            MetaDataProtocol.MetaDataMutationResult metaDataMutationResult = MetaDataProtocol.MetaDataMutationResult.constructFromProto(result);
                            return metaDataMutationResult;
                        }
                        retried = true;
                        continue;
                    }
                    MetaDataProtocol.MetaDataMutationResult metaDataMutationResult = MetaDataProtocol.MetaDataMutationResult.constructFromProto(result);
                    return metaDataMutationResult;
                }
                finally {
                    Closeables.closeQuietly(ht);
                    continue;
                }
                break;
            }
        }
        catch (IOException e) {
            throw ServerUtil.parseServerException(e);
        }
        catch (Throwable t) {
            throw new SQLException(t);
        }
    }

    private void ensureViewIndexTableCreated(byte[] physicalTableName, Map<String, Object> tableProps, List<Pair<byte[], Map<String, Object>>> families, byte[][] splits, long timestamp) throws SQLException {
        Long maxFileSize = (Long)tableProps.get("MAX_FILESIZE");
        if (maxFileSize == null) {
            maxFileSize = this.config.getLong("hbase.hregion.max.filesize", 0x280000000L);
        }
        byte[] physicalIndexName = MetaDataUtil.getViewIndexPhysicalName(physicalTableName);
        Integer indexMaxFileSizePercProp = (Integer)tableProps.remove("phoenix.index.maxDataFileSizePerc");
        int indexMaxFileSizePerc = indexMaxFileSizePercProp == null ? this.config.getInt("phoenix.index.maxDataFileSizePerc", 50) : indexMaxFileSizePercProp.intValue();
        long indexMaxFileSize = maxFileSize * (long)indexMaxFileSizePerc / 100L;
        tableProps.put("MAX_FILESIZE", indexMaxFileSize);
        tableProps.put("IS_VIEW_INDEX_TABLE", TRUE_BYTES_AS_STRING);
        HTableDescriptor desc = this.ensureTableCreated(physicalIndexName, PTableType.TABLE, tableProps, families, splits, false);
        if (desc != null && !Boolean.TRUE.equals(PBoolean.INSTANCE.toObject(desc.getValue(MetaDataUtil.IS_VIEW_INDEX_TABLE_PROP_BYTES)))) {
            String fullTableName = Bytes.toString(physicalIndexName);
            throw new TableAlreadyExistsException("Unable to create shared physical table for indexes on views.", SchemaUtil.getSchemaNameFromFullName(fullTableName), SchemaUtil.getTableNameFromFullName(fullTableName));
        }
    }

    private boolean ensureViewIndexTableDropped(byte[] physicalTableName, long timestamp) throws SQLException {
        byte[] physicalIndexName = MetaDataUtil.getViewIndexPhysicalName(physicalTableName);
        HTableDescriptor desc = null;
        HBaseAdmin admin = null;
        boolean wasDeleted = false;
        try {
            admin = new HBaseAdmin(this.config);
            try {
                desc = admin.getTableDescriptor(physicalIndexName);
                if (Boolean.TRUE.equals(PBoolean.INSTANCE.toObject(desc.getValue(MetaDataUtil.IS_VIEW_INDEX_TABLE_PROP_BYTES)))) {
                    this.tableStatsCache.invalidate(new ImmutableBytesPtr(physicalIndexName));
                    ReadOnlyProps props = this.getProps();
                    boolean dropMetadata = props.getBoolean("phoenix.schema.dropMetaData", true);
                    if (dropMetadata) {
                        admin.disableTable(physicalIndexName);
                        admin.deleteTable(physicalIndexName);
                        this.clearTableRegionCache(physicalIndexName);
                        wasDeleted = true;
                    }
                }
            }
            catch (org.apache.hadoop.hbase.TableNotFoundException props) {
                // empty catch block
            }
        }
        catch (IOException e) {
            throw ServerUtil.parseServerException(e);
        }
        finally {
            try {
                if (admin != null) {
                    admin.close();
                }
            }
            catch (IOException e) {
                logger.warn("", e);
            }
        }
        return wasDeleted;
    }

    private boolean ensureLocalIndexTableDropped(byte[] physicalTableName, long timestamp) throws SQLException {
        HTableDescriptor desc = null;
        HBaseAdmin admin = null;
        boolean wasDeleted = false;
        try {
            admin = this.getAdmin();
            try {
                desc = admin.getTableDescriptor(physicalTableName);
                this.tableStatsCache.invalidate(new ImmutableBytesPtr(physicalTableName));
                ReadOnlyProps props = this.getProps();
                boolean dropMetadata = props.getBoolean("phoenix.schema.dropMetaData", true);
                if (dropMetadata) {
                    ArrayList<String> columnFamiles = new ArrayList<String>();
                    for (HColumnDescriptor cf : desc.getColumnFamilies()) {
                        if (!cf.getNameAsString().startsWith("L#")) continue;
                        columnFamiles.add(cf.getNameAsString());
                    }
                    for (String cf : columnFamiles) {
                        admin.deleteColumn(physicalTableName, cf);
                    }
                    this.clearTableRegionCache(physicalTableName);
                    wasDeleted = true;
                }
            }
            catch (org.apache.hadoop.hbase.TableNotFoundException props) {
                // empty catch block
            }
        }
        catch (IOException e) {
            throw ServerUtil.parseServerException(e);
        }
        finally {
            try {
                if (admin != null) {
                    admin.close();
                }
            }
            catch (IOException e) {
                logger.warn("", e);
            }
        }
        return wasDeleted;
    }

    @Override
    public MetaDataProtocol.MetaDataMutationResult createTable(final List<Mutation> tableMetaData, byte[] physicalTableName, PTableType tableType, Map<String, Object> tableProps, List<Pair<byte[], Map<String, Object>>> families, byte[][] splits) throws SQLException {
        byte[][] rowKeyMetadata = new byte[3][];
        Mutation m = MetaDataUtil.getPutOnlyTableHeaderRow(tableMetaData);
        byte[] key = m.getRow();
        SchemaUtil.getVarChars(key, rowKeyMetadata);
        byte[] tenantIdBytes = rowKeyMetadata[0];
        byte[] schemaBytes = rowKeyMetadata[1];
        byte[] tableBytes = rowKeyMetadata[2];
        byte[] tableName = physicalTableName != null ? physicalTableName : SchemaUtil.getTableNameAsBytes(schemaBytes, tableBytes);
        boolean localIndexTable = false;
        for (Pair<byte[], Map<String, Object>> family : families) {
            if (!Bytes.toString(family.getFirst()).startsWith("L#")) continue;
            localIndexTable = true;
            break;
        }
        if (tableType == PTableType.VIEW && physicalTableName != null || tableType != PTableType.VIEW && (physicalTableName == null || localIndexTable)) {
            this.ensureTableCreated(tableName, tableType, tableProps, families, splits, true);
        }
        ImmutableBytesWritable ptr = new ImmutableBytesWritable();
        if (tableType == PTableType.INDEX) {
            if (physicalTableName != null && !localIndexTable && !MetaDataUtil.isMultiTenant(m, this.kvBuilder, ptr)) {
                this.ensureViewIndexTableCreated(tenantIdBytes.length == 0 ? null : PNameFactory.newName(tenantIdBytes), physicalTableName, MetaDataUtil.getClientTimeStamp(m));
            }
        } else if (tableType == PTableType.TABLE && MetaDataUtil.isMultiTenant(m, this.kvBuilder, ptr)) {
            ptr.set(QueryConstants.DEFAULT_COLUMN_FAMILY_BYTES);
            MetaDataUtil.getMutationValue(m, PhoenixDatabaseMetaData.DEFAULT_COLUMN_FAMILY_NAME_BYTES, this.kvBuilder, ptr);
            List<Pair<byte[], Map<String, Object>>> familiesPlusDefault = null;
            for (Pair<byte[], Map<String, Object>> family : families) {
                byte[] cf = family.getFirst();
                if (Bytes.compareTo(cf, 0, cf.length, ptr.get(), ptr.getOffset(), ptr.getLength()) != 0) continue;
                familiesPlusDefault = families;
                break;
            }
            if (familiesPlusDefault == null) {
                byte[] defaultCF = ByteUtil.copyKeyBytesIfNecessary(ptr);
                familiesPlusDefault = Lists.newArrayList(families);
                familiesPlusDefault.add(new Pair(defaultCF, Collections.emptyMap()));
            }
            this.ensureViewIndexTableCreated(tableName, tableProps, familiesPlusDefault, MetaDataUtil.isSalted(m, this.kvBuilder, ptr) ? splits : (byte[][])null, MetaDataUtil.getClientTimeStamp(m));
        }
        byte[] tableKey = SchemaUtil.getTableKey(tenantIdBytes, schemaBytes, tableBytes);
        MetaDataProtocol.MetaDataMutationResult result = this.metaDataCoprocessorExec(tableKey, new Batch.Call<MetaDataProtos.MetaDataService, MetaDataProtos.MetaDataResponse>(){

            @Override
            public MetaDataProtos.MetaDataResponse call(MetaDataProtos.MetaDataService instance) throws IOException {
                ServerRpcController controller = new ServerRpcController();
                BlockingRpcCallback<MetaDataProtos.MetaDataResponse> rpcCallback = new BlockingRpcCallback<MetaDataProtos.MetaDataResponse>();
                MetaDataProtos.CreateTableRequest.Builder builder = MetaDataProtos.CreateTableRequest.newBuilder();
                for (Mutation m : tableMetaData) {
                    ClientProtos.MutationProto mp = ProtobufUtil.toProto(m);
                    builder.addTableMetadataMutations(mp.toByteString());
                }
                instance.createTable(controller, builder.build(), rpcCallback);
                if (controller.getFailedOn() != null) {
                    throw controller.getFailedOn();
                }
                return rpcCallback.get();
            }
        });
        return result;
    }

    @Override
    public MetaDataProtocol.MetaDataMutationResult getTable(PName tenantId, final byte[] schemaBytes, final byte[] tableBytes, final long tableTimestamp, final long clientTimestamp) throws SQLException {
        final byte[] tenantIdBytes = tenantId == null ? ByteUtil.EMPTY_BYTE_ARRAY : tenantId.getBytes();
        byte[] tableKey = SchemaUtil.getTableKey(tenantIdBytes, schemaBytes, tableBytes);
        return this.metaDataCoprocessorExec(tableKey, new Batch.Call<MetaDataProtos.MetaDataService, MetaDataProtos.MetaDataResponse>(){

            @Override
            public MetaDataProtos.MetaDataResponse call(MetaDataProtos.MetaDataService instance) throws IOException {
                ServerRpcController controller = new ServerRpcController();
                BlockingRpcCallback<MetaDataProtos.MetaDataResponse> rpcCallback = new BlockingRpcCallback<MetaDataProtos.MetaDataResponse>();
                MetaDataProtos.GetTableRequest.Builder builder = MetaDataProtos.GetTableRequest.newBuilder();
                builder.setTenantId(ByteStringer.wrap(tenantIdBytes));
                builder.setSchemaName(ByteStringer.wrap(schemaBytes));
                builder.setTableName(ByteStringer.wrap(tableBytes));
                builder.setTableTimestamp(tableTimestamp);
                builder.setClientTimestamp(clientTimestamp);
                instance.getTable(controller, builder.build(), rpcCallback);
                if (controller.getFailedOn() != null) {
                    throw controller.getFailedOn();
                }
                return rpcCallback.get();
            }
        });
    }

    @Override
    public MetaDataProtocol.MetaDataMutationResult dropTable(final List<Mutation> tableMetaData, final PTableType tableType, final boolean cascade) throws SQLException {
        byte[][] rowKeyMetadata = new byte[3][];
        SchemaUtil.getVarChars(tableMetaData.get(0).getRow(), rowKeyMetadata);
        byte[] tenantIdBytes = rowKeyMetadata[0];
        byte[] schemaBytes = rowKeyMetadata[1];
        byte[] tableBytes = rowKeyMetadata[2];
        byte[] tableKey = SchemaUtil.getTableKey(tenantIdBytes == null ? ByteUtil.EMPTY_BYTE_ARRAY : tenantIdBytes, schemaBytes, tableBytes);
        MetaDataProtocol.MetaDataMutationResult result = this.metaDataCoprocessorExec(tableKey, new Batch.Call<MetaDataProtos.MetaDataService, MetaDataProtos.MetaDataResponse>(){

            @Override
            public MetaDataProtos.MetaDataResponse call(MetaDataProtos.MetaDataService instance) throws IOException {
                ServerRpcController controller = new ServerRpcController();
                BlockingRpcCallback<MetaDataProtos.MetaDataResponse> rpcCallback = new BlockingRpcCallback<MetaDataProtos.MetaDataResponse>();
                MetaDataProtos.DropTableRequest.Builder builder = MetaDataProtos.DropTableRequest.newBuilder();
                for (Mutation m : tableMetaData) {
                    ClientProtos.MutationProto mp = ProtobufUtil.toProto(m);
                    builder.addTableMetadataMutations(mp.toByteString());
                }
                builder.setTableType(tableType.getSerializedValue());
                builder.setCascade(cascade);
                instance.dropTable(controller, builder.build(), rpcCallback);
                if (controller.getFailedOn() != null) {
                    throw controller.getFailedOn();
                }
                return rpcCallback.get();
            }
        });
        MetaDataProtocol.MutationCode code = result.getMutationCode();
        switch (code) {
            case TABLE_ALREADY_EXISTS: {
                ReadOnlyProps props = this.getProps();
                boolean dropMetadata = props.getBoolean("phoenix.schema.dropMetaData", true);
                if (dropMetadata) {
                    this.dropTables(result.getTableNamesToDelete());
                }
                this.invalidateTables(result.getTableNamesToDelete());
                if (tableType != PTableType.TABLE) break;
                byte[] physicalName = SchemaUtil.getTableNameAsBytes(schemaBytes, tableBytes);
                long timestamp = MetaDataUtil.getClientTimeStamp(tableMetaData);
                this.ensureViewIndexTableDropped(physicalName, timestamp);
                this.ensureLocalIndexTableDropped(physicalName, timestamp);
                this.tableStatsCache.invalidate(new ImmutableBytesPtr(physicalName));
                break;
            }
        }
        return result;
    }

    @Override
    public MetaDataProtocol.MetaDataMutationResult dropFunction(final List<Mutation> functionData, final boolean ifExists) throws SQLException {
        byte[][] rowKeyMetadata = new byte[2][];
        byte[] key = functionData.get(0).getRow();
        SchemaUtil.getVarChars(key, rowKeyMetadata);
        byte[] tenantIdBytes = rowKeyMetadata[0];
        byte[] functionBytes = rowKeyMetadata[1];
        byte[] functionKey = SchemaUtil.getFunctionKey(tenantIdBytes, functionBytes);
        MetaDataProtocol.MetaDataMutationResult result = this.metaDataCoprocessorExec(functionKey, new Batch.Call<MetaDataProtos.MetaDataService, MetaDataProtos.MetaDataResponse>(){

            @Override
            public MetaDataProtos.MetaDataResponse call(MetaDataProtos.MetaDataService instance) throws IOException {
                ServerRpcController controller = new ServerRpcController();
                BlockingRpcCallback<MetaDataProtos.MetaDataResponse> rpcCallback = new BlockingRpcCallback<MetaDataProtos.MetaDataResponse>();
                MetaDataProtos.DropFunctionRequest.Builder builder = MetaDataProtos.DropFunctionRequest.newBuilder();
                for (Mutation m : functionData) {
                    ClientProtos.MutationProto mp = ProtobufUtil.toProto(m);
                    builder.addTableMetadataMutations(mp.toByteString());
                }
                builder.setIfExists(ifExists);
                instance.dropFunction(controller, builder.build(), rpcCallback);
                if (controller.getFailedOn() != null) {
                    throw controller.getFailedOn();
                }
                return rpcCallback.get();
            }
        }, PhoenixDatabaseMetaData.SYSTEM_FUNCTION_NAME_BYTES);
        return result;
    }

    private void invalidateTables(List<byte[]> tableNamesToDelete) {
        if (tableNamesToDelete != null) {
            for (byte[] tableName : tableNamesToDelete) {
                this.tableStatsCache.invalidate(new ImmutableBytesPtr(tableName));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void dropTables(List<byte[]> tableNamesToDelete) throws SQLException {
        HBaseAdmin admin = null;
        SQLException sqlE = null;
        try {
            admin = new HBaseAdmin(this.config);
            if (tableNamesToDelete == null) return;
            for (byte[] tableName : tableNamesToDelete) {
                if (!admin.tableExists(tableName)) continue;
                admin.disableTable(tableName);
                admin.deleteTable(tableName);
                this.clearTableRegionCache(tableName);
            }
            return;
        }
        catch (IOException e) {
            sqlE = ServerUtil.parseServerException(e);
        }
        finally {
            try {
                if (admin != null) {
                    admin.close();
                }
            }
            catch (IOException e) {
                if (sqlE == null) {
                    sqlE = ServerUtil.parseServerException(e);
                }
                sqlE.setNextException(ServerUtil.parseServerException(e));
            }
            finally {
                if (sqlE == null) return;
                throw sqlE;
            }
        }
    }

    private static Map<String, Object> createPropertiesMap(Map<ImmutableBytesWritable, ImmutableBytesWritable> htableProps) {
        HashMap<String, Object> props = Maps.newHashMapWithExpectedSize(htableProps.size());
        for (Map.Entry<ImmutableBytesWritable, ImmutableBytesWritable> entry : htableProps.entrySet()) {
            ImmutableBytesWritable key = entry.getKey();
            ImmutableBytesWritable value = entry.getValue();
            props.put(Bytes.toString(key.get(), key.getOffset(), key.getLength()), Bytes.toString(value.get(), value.getOffset(), value.getLength()));
        }
        return props;
    }

    private void ensureViewIndexTableCreated(PName tenantId, byte[] physicalIndexTableName, long timestamp) throws SQLException {
        PTable table;
        block4: {
            String name = Bytes.toString(physicalIndexTableName, MetaDataUtil.VIEW_INDEX_TABLE_PREFIX_BYTES.length, physicalIndexTableName.length - MetaDataUtil.VIEW_INDEX_TABLE_PREFIX_BYTES.length);
            try {
                PMetaData metadata = this.latestMetaData;
                if (metadata == null) {
                    this.throwConnectionClosedException();
                }
                if ((table = metadata.getTable(new PTableKey(tenantId, name))).getTimeStamp() >= timestamp) {
                    throw new TableNotFoundException(table.getSchemaName().getString(), table.getTableName().getString());
                }
            }
            catch (TableNotFoundException e) {
                byte[] schemaName = Bytes.toBytes(SchemaUtil.getSchemaNameFromFullName(name));
                byte[] tableName = Bytes.toBytes(SchemaUtil.getTableNameFromFullName(name));
                MetaDataProtocol.MetaDataMutationResult result = this.getTable(null, schemaName, tableName, Long.MAX_VALUE, timestamp);
                table = result.getTable();
                if (table != null) break block4;
                throw e;
            }
        }
        this.ensureViewIndexTableCreated(table, timestamp);
    }

    private void ensureViewIndexTableCreated(PTable table, long timestamp) throws SQLException {
        Object familyName;
        byte[] physicalTableName = table.getPhysicalName().getBytes();
        HTableDescriptor htableDesc = this.getTableDescriptor(physicalTableName);
        Map<String, Object> tableProps = ConnectionQueryServicesImpl.createPropertiesMap(htableDesc.getValues());
        ArrayList<Pair<byte[], Map<String, Object>>> families = Lists.newArrayListWithExpectedSize(Math.max(1, table.getColumnFamilies().size() + 1));
        if (families.isEmpty()) {
            familyName = SchemaUtil.getEmptyColumnFamily(table);
            Map<String, Object> familyProps = ConnectionQueryServicesImpl.createPropertiesMap(htableDesc.getFamily((byte[])familyName).getValues());
            families.add(new Pair<Object, Map<String, Object>>(familyName, familyProps));
        } else {
            familyName = table.getColumnFamilies().iterator();
            while (familyName.hasNext()) {
                PColumnFamily family = (PColumnFamily)familyName.next();
                byte[] familyName2 = family.getName().getBytes();
                Map<String, Object> familyProps = ConnectionQueryServicesImpl.createPropertiesMap(htableDesc.getFamily(familyName2).getValues());
                families.add(new Pair<byte[], Map<String, Object>>(familyName2, familyProps));
            }
            families.add(new Pair(table.getDefaultFamilyName().getBytes(), Collections.emptyMap()));
        }
        byte[][] splits = null;
        if (table.getBucketNum() != null) {
            splits = SaltingUtil.getSalteByteSplitPoints(table.getBucketNum());
        }
        this.ensureViewIndexTableCreated(physicalTableName, tableProps, families, splits, timestamp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MetaDataProtocol.MetaDataMutationResult addColumn(final List<Mutation> tableMetaData, PTable table, Map<String, List<Pair<String, Object>>> stmtProperties, Set<String> colFamiliesForPColumnsToBeAdded) throws SQLException {
        block16: {
            ArrayList<Pair<byte[], Map<String, Object>>> families = new ArrayList<Pair<byte[], Map<String, Object>>>(stmtProperties.size());
            HashMap<String, Object> tableProps = new HashMap<String, Object>();
            HTableDescriptor tableDescriptor = this.separateAndValidateProperties(table, stmtProperties, colFamiliesForPColumnsToBeAdded, families, tableProps);
            SQLException sqlE = null;
            if (tableDescriptor != null) {
                try {
                    boolean pollingNotNeeded = !tableProps.isEmpty() && families.isEmpty() && colFamiliesForPColumnsToBeAdded.isEmpty();
                    this.modifyTable(table.getPhysicalName().getBytes(), tableDescriptor, !pollingNotNeeded);
                }
                catch (IOException e) {
                    sqlE = ServerUtil.parseServerException(e);
                    return sqlE;
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    sqlE = new SQLExceptionInfo.Builder(SQLExceptionCode.INTERRUPTED_EXCEPTION).setRootCause(e).build().buildException();
                    return sqlE;
                }
                catch (TimeoutException e) {
                    sqlE = new SQLExceptionInfo.Builder(SQLExceptionCode.OPERATION_TIMED_OUT).setRootCause(e.getCause() != null ? e.getCause() : e).build().buildException();
                    return sqlE;
                }
                finally {
                    if (sqlE == null) break block16;
                    throw sqlE;
                }
            }
        }
        if (tableMetaData.isEmpty() || tableMetaData.size() == 1 && tableMetaData.get(0).isEmpty()) {
            return new MetaDataProtocol.MetaDataMutationResult(MetaDataProtocol.MutationCode.NO_OP, System.currentTimeMillis(), table);
        }
        byte[][] rowKeyMetaData = new byte[3][];
        PTableType tableType = table.getType();
        Mutation m = tableMetaData.get(0);
        byte[] rowKey = m.getRow();
        SchemaUtil.getVarChars(rowKey, rowKeyMetaData);
        byte[] tenantIdBytes = rowKeyMetaData[0];
        byte[] schemaBytes = rowKeyMetaData[1];
        byte[] tableBytes = rowKeyMetaData[2];
        byte[] tableKey = SchemaUtil.getTableKey(tenantIdBytes, schemaBytes, tableBytes);
        ImmutableBytesWritable ptr = new ImmutableBytesWritable();
        MetaDataProtocol.MetaDataMutationResult result = this.metaDataCoprocessorExec(tableKey, new Batch.Call<MetaDataProtos.MetaDataService, MetaDataProtos.MetaDataResponse>(){

            @Override
            public MetaDataProtos.MetaDataResponse call(MetaDataProtos.MetaDataService instance) throws IOException {
                ServerRpcController controller = new ServerRpcController();
                BlockingRpcCallback<MetaDataProtos.MetaDataResponse> rpcCallback = new BlockingRpcCallback<MetaDataProtos.MetaDataResponse>();
                MetaDataProtos.AddColumnRequest.Builder builder = MetaDataProtos.AddColumnRequest.newBuilder();
                for (Mutation m : tableMetaData) {
                    ClientProtos.MutationProto mp = ProtobufUtil.toProto(m);
                    builder.addTableMetadataMutations(mp.toByteString());
                }
                instance.addColumn(controller, builder.build(), rpcCallback);
                if (controller.getFailedOn() != null) {
                    throw controller.getFailedOn();
                }
                return rpcCallback.get();
            }
        });
        if (result.getMutationCode() == MetaDataProtocol.MutationCode.COLUMN_NOT_FOUND) {
            if (MetaDataUtil.getMutationValue(m, PhoenixDatabaseMetaData.DISABLE_WAL_BYTES, this.kvBuilder, ptr) && Boolean.FALSE.equals(PBoolean.INSTANCE.toObject(ptr))) {
                this.flushTable(table.getPhysicalName().getBytes());
            }
            if (tableType == PTableType.TABLE && MetaDataUtil.getMutationValue(m, PhoenixDatabaseMetaData.MULTI_TENANT_BYTES, this.kvBuilder, ptr)) {
                long timestamp = MetaDataUtil.getClientTimeStamp(m);
                if (Boolean.TRUE.equals(PBoolean.INSTANCE.toObject(ptr.get(), ptr.getOffset(), ptr.getLength()))) {
                    this.ensureViewIndexTableCreated(table, timestamp);
                } else {
                    this.ensureViewIndexTableDropped(table.getPhysicalName().getBytes(), timestamp);
                }
            }
        }
        return result;
    }

    /*
     * WARNING - void declaration
     */
    private HTableDescriptor separateAndValidateProperties(PTable table, Map<String, List<Pair<String, Object>>> properties, Set<String> colFamiliesForPColumnsToBeAdded, List<Pair<byte[], Map<String, Object>>> families, Map<String, Object> tableProps) throws SQLException {
        void var12_21;
        boolean isAddingPkColOnly;
        HashMap stmtFamiliesPropsMap = new HashMap(properties.size());
        Map<String, Object> commonFamilyProps = new HashMap();
        boolean addingColumns = colFamiliesForPColumnsToBeAdded != null && colFamiliesForPColumnsToBeAdded.size() > 0;
        HashSet<String> existingColumnFamilies = this.existingColumnFamilies(table);
        HashMap<String, Map<String, Object>> allFamiliesProps = new HashMap<String, Map<String, Object>>(existingColumnFamilies.size());
        for (String string : properties.keySet()) {
            List<Pair<String, Object>> propsList = properties.get(string);
            if (propsList == null || propsList.size() <= 0) continue;
            HashMap<String, Object> colFamilyPropsMap = new HashMap<String, Object>(propsList.size());
            for (Pair<String, Object> pair : propsList) {
                String propName = pair.getFirst();
                Object propValue = pair.getSecond();
                if ((this.isHTableProperty(propName) || TableProperty.isPhoenixTableProperty(propName)) && addingColumns) {
                    throw new SQLExceptionInfo.Builder(SQLExceptionCode.CANNOT_SET_TABLE_PROPERTY_ADD_COLUMN).setMessage("Property: " + propName).build().buildException();
                }
                if (this.isHTableProperty(propName)) {
                    if (!string.equals("")) {
                        throw new SQLExceptionInfo.Builder(SQLExceptionCode.COLUMN_FAMILY_NOT_ALLOWED_TABLE_PROPERTY).setMessage("Column Family: " + string + ", Property: " + propName).build().buildException();
                    }
                    tableProps.put(propName, propValue);
                    continue;
                }
                if (TableProperty.isPhoenixTableProperty(propName)) {
                    TableProperty.valueOf(propName).validate(true, !string.equals(""), table.getType());
                    if (!propName.equals("TTL")) continue;
                    commonFamilyProps.put(propName, pair.getSecond());
                    continue;
                }
                if (this.isHColumnProperty(propName)) {
                    if (string.equals("")) {
                        commonFamilyProps.put(propName, pair.getSecond());
                        continue;
                    }
                    colFamilyPropsMap.put(propName, pair.getSecond());
                    continue;
                }
                throw new SQLExceptionInfo.Builder(SQLExceptionCode.SET_UNSUPPORTED_PROP_ON_ALTER_TABLE).setMessage("Column Family: " + string + ", Property: " + propName).build().buildException();
            }
            if (colFamilyPropsMap.isEmpty()) continue;
            stmtFamiliesPropsMap.put(string, colFamilyPropsMap);
        }
        commonFamilyProps = Collections.unmodifiableMap(commonFamilyProps);
        boolean bl = isAddingPkColOnly = colFamiliesForPColumnsToBeAdded.size() == 1 && colFamiliesForPColumnsToBeAdded.contains(null);
        if (!commonFamilyProps.isEmpty()) {
            HashMap<String, Object> m;
            if (!addingColumns) {
                for (String existingColFamily : existingColumnFamilies) {
                    m = new HashMap<String, Object>(commonFamilyProps.size());
                    m.putAll(commonFamilyProps);
                    allFamiliesProps.put(existingColFamily, m);
                }
            } else {
                for (String colFamily : colFamiliesForPColumnsToBeAdded) {
                    if (colFamily != null) {
                        m = new HashMap(commonFamilyProps.size());
                        m.putAll(commonFamilyProps);
                        allFamiliesProps.put(colFamily, m);
                        continue;
                    }
                    if (!isAddingPkColOnly) continue;
                    throw new SQLExceptionInfo.Builder(SQLExceptionCode.SET_UNSUPPORTED_PROP_ON_ALTER_TABLE).build().buildException();
                }
            }
        }
        for (String f : stmtFamiliesPropsMap.keySet()) {
            if (!addingColumns && !existingColumnFamilies.contains(f)) {
                throw new ColumnFamilyNotFoundException(f);
            }
            if (addingColumns && !colFamiliesForPColumnsToBeAdded.contains(f)) {
                throw new SQLExceptionInfo.Builder(SQLExceptionCode.CANNOT_SET_PROPERTY_FOR_COLUMN_NOT_ADDED).build().buildException();
            }
            Map commonProps = (Map)allFamiliesProps.get(f);
            Map stmtProps = (Map)stmtFamiliesPropsMap.get(f);
            if (commonProps != null) {
                if (stmtProps == null) continue;
                commonProps.putAll(stmtProps);
                continue;
            }
            if (stmtProps == null) continue;
            allFamiliesProps.put(f, stmtProps);
        }
        for (String cf : colFamiliesForPColumnsToBeAdded) {
            if (cf == null || allFamiliesProps.get(cf) != null) continue;
            allFamiliesProps.put(cf, new HashMap());
        }
        if (table.getColumnFamilies().isEmpty() && !addingColumns && !commonFamilyProps.isEmpty()) {
            allFamiliesProps.put(Bytes.toString(table.getDefaultFamilyName() == null ? QueryConstants.DEFAULT_COLUMN_FAMILY_BYTES : table.getDefaultFamilyName().getBytes()), commonFamilyProps);
        }
        if (!(table.getType() != PTableType.VIEW || stmtFamiliesPropsMap.isEmpty() && commonFamilyProps.isEmpty() && tableProps.isEmpty())) {
            throw new SQLExceptionInfo.Builder(SQLExceptionCode.VIEW_WITH_PROPERTIES).build().buildException();
        }
        Object var12_19 = null;
        if (!allFamiliesProps.isEmpty() || !tableProps.isEmpty()) {
            byte[] tableNameBytes = Bytes.toBytes(table.getPhysicalName().getString());
            HTableDescriptor existingTableDescriptor = this.getTableDescriptor(tableNameBytes);
            HTableDescriptor hTableDescriptor = new HTableDescriptor(existingTableDescriptor);
            if (!tableProps.isEmpty()) {
                for (Map.Entry entry : tableProps.entrySet()) {
                    hTableDescriptor.setValue((String)entry.getKey(), entry.getValue() != null ? entry.getValue().toString() : null);
                }
            }
            if (addingColumns) {
                this.setTTLToEmptyCFTTL(allFamiliesProps, table, hTableDescriptor);
            }
            for (Map.Entry entry : allFamiliesProps.entrySet()) {
                byte[] cf = ((String)entry.getKey()).getBytes();
                HColumnDescriptor colDescriptor = hTableDescriptor.getFamily(cf);
                if (colDescriptor == null) {
                    colDescriptor = this.generateColumnFamilyDescriptor(new Pair<byte[], Map<String, Object>>(cf, (Map<String, Object>)entry.getValue()), table.getType());
                    hTableDescriptor.addFamily(colDescriptor);
                    continue;
                }
                this.modifyColumnFamilyDescriptor(colDescriptor, (Map)entry.getValue());
            }
        }
        return var12_21;
    }

    private boolean isHColumnProperty(String propName) {
        return HColumnDescriptor.getDefaultValues().containsKey(propName);
    }

    private boolean isHTableProperty(String propName) {
        return !this.isHColumnProperty(propName) && !TableProperty.isPhoenixTableProperty(propName);
    }

    private HashSet<String> existingColumnFamilies(PTable table) {
        List<PColumnFamily> cfs = table.getColumnFamilies();
        HashSet<String> cfNames = new HashSet<String>(cfs.size());
        for (PColumnFamily cf : table.getColumnFamilies()) {
            cfNames.add(cf.getName().getString());
        }
        return cfNames;
    }

    private int getTTLForEmptyCf(byte[] emptyCf, byte[] tableNameBytes, HTableDescriptor tableDescriptor) throws SQLException {
        if (tableDescriptor == null) {
            tableDescriptor = this.getTableDescriptor(tableNameBytes);
        }
        return tableDescriptor.getFamily(emptyCf).getTimeToLive();
    }

    private void setTTLToEmptyCFTTL(Map<String, Map<String, Object>> familyProps, PTable table, HTableDescriptor tableDesc) throws SQLException {
        if (!familyProps.isEmpty()) {
            int emptyCFTTL = this.getTTLForEmptyCf(SchemaUtil.getEmptyColumnFamily(table), table.getPhysicalName().getBytes(), tableDesc);
            for (String family : familyProps.keySet()) {
                Map<Object, Object> props = familyProps.get(family) != null ? familyProps.get(family) : new HashMap();
                props.put("TTL", emptyCFTTL);
            }
        }
    }

    @Override
    public MetaDataProtocol.MetaDataMutationResult dropColumn(final List<Mutation> tableMetaData, PTableType tableType) throws SQLException {
        byte[][] rowKeyMetadata = new byte[3][];
        SchemaUtil.getVarChars(tableMetaData.get(0).getRow(), rowKeyMetadata);
        byte[] tenantIdBytes = rowKeyMetadata[0];
        byte[] schemaBytes = rowKeyMetadata[1];
        byte[] tableBytes = rowKeyMetadata[2];
        byte[] tableKey = SchemaUtil.getTableKey(tenantIdBytes, schemaBytes, tableBytes);
        MetaDataProtocol.MetaDataMutationResult result = this.metaDataCoprocessorExec(tableKey, new Batch.Call<MetaDataProtos.MetaDataService, MetaDataProtos.MetaDataResponse>(){

            @Override
            public MetaDataProtos.MetaDataResponse call(MetaDataProtos.MetaDataService instance) throws IOException {
                ServerRpcController controller = new ServerRpcController();
                BlockingRpcCallback<MetaDataProtos.MetaDataResponse> rpcCallback = new BlockingRpcCallback<MetaDataProtos.MetaDataResponse>();
                MetaDataProtos.DropColumnRequest.Builder builder = MetaDataProtos.DropColumnRequest.newBuilder();
                for (Mutation m : tableMetaData) {
                    ClientProtos.MutationProto mp = ProtobufUtil.toProto(m);
                    builder.addTableMetadataMutations(mp.toByteString());
                }
                instance.dropColumn(controller, builder.build(), rpcCallback);
                if (controller.getFailedOn() != null) {
                    throw controller.getFailedOn();
                }
                return rpcCallback.get();
            }
        });
        MetaDataProtocol.MutationCode code = result.getMutationCode();
        switch (code) {
            case TABLE_ALREADY_EXISTS: {
                ReadOnlyProps props = this.getProps();
                boolean dropMetadata = props.getBoolean("phoenix.schema.dropMetaData", true);
                if (dropMetadata) {
                    this.dropTables(result.getTableNamesToDelete());
                }
                this.invalidateTables(result.getTableNamesToDelete());
                break;
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PhoenixConnection addColumnsIfNotExists(PhoenixConnection oldMetaConnection, String tableName, long timestamp, String columns) throws SQLException {
        PhoenixConnection metaConnection;
        block12: {
            Properties props = new Properties(oldMetaConnection.getClientInfo());
            props.setProperty("CurrentSCN", Long.toString(timestamp));
            metaConnection = new PhoenixConnection(this, oldMetaConnection.getURL(), props, oldMetaConnection.getMetaDataCache());
            SQLException sqlE = null;
            try {
                metaConnection.createStatement().executeUpdate("ALTER TABLE " + tableName + " ADD IF NOT EXISTS " + columns);
            }
            catch (SQLException e) {
                logger.warn("addColumnsIfNotExists failed due to:" + e);
                sqlE = e;
                return sqlE;
            }
            finally {
                try {
                    oldMetaConnection.close();
                }
                catch (SQLException e) {
                    if (sqlE != null) {
                        sqlE.setNextException(e);
                    }
                    sqlE = e;
                }
                if (sqlE == null) break block12;
                throw sqlE;
            }
        }
        return metaConnection;
    }

    @Override
    public void init(final String url, final Properties props) throws SQLException {
        try {
            PhoenixContextExecutor.call(new Callable<Void>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                @Override
                public Void call() throws Exception {
                    if (ConnectionQueryServicesImpl.this.initialized) {
                        if (ConnectionQueryServicesImpl.this.initializationException == null) return null;
                        throw ConnectionQueryServicesImpl.this.initializationException;
                    }
                    ConnectionQueryServicesImpl connectionQueryServicesImpl = ConnectionQueryServicesImpl.this;
                    synchronized (connectionQueryServicesImpl) {
                        if (ConnectionQueryServicesImpl.this.initialized) {
                            if (ConnectionQueryServicesImpl.this.initializationException == null) return null;
                            throw ConnectionQueryServicesImpl.this.initializationException;
                        }
                        ConnectionQueryServicesImpl.this.checkClosed();
                        PhoenixConnection metaConnection = null;
                        try {
                            block71: {
                                ConnectionQueryServicesImpl.this.openConnection();
                                Properties scnProps = PropertiesUtil.deepCopy(props);
                                scnProps.setProperty("CurrentSCN", Long.toString(8L));
                                scnProps.remove("TenantId");
                                String globalUrl = JDBCUtil.removeProperty(url, "TenantId");
                                metaConnection = new PhoenixConnection(ConnectionQueryServicesImpl.this, globalUrl, scnProps, ConnectionQueryServicesImpl.this.newEmptyMetaData());
                                try {
                                    metaConnection.createStatement().executeUpdate(QueryConstants.CREATE_TABLE_METADATA);
                                }
                                catch (NewerTableAlreadyExistsException newerTableAlreadyExistsException) {
                                }
                                catch (TableAlreadyExistsException e) {
                                    PhoenixConnection newMetaConnection;
                                    long currentServerSideTableTimeStamp = e.getTable().getTimeStamp();
                                    String columnsToAdd = "";
                                    if (currentServerSideTableTimeStamp < 8L) {
                                        columnsToAdd = "IS_ROW_TIMESTAMP " + PBoolean.INSTANCE.getSqlTypeName();
                                    }
                                    if (currentServerSideTableTimeStamp < 7L) {
                                        columnsToAdd = columnsToAdd + ", STORE_NULLS " + PBoolean.INSTANCE.getSqlTypeName();
                                        try (HBaseAdmin admin = null;){
                                            HTableDescriptor[] localIndexTables;
                                            admin = ConnectionQueryServicesImpl.this.getAdmin();
                                            for (HTableDescriptor table : localIndexTables = admin.listTables("_LOCAL_IDX_.*")) {
                                                if (table.getValue("PARENT_TABLE") != null || table.getValue("IS_LOCAL_INDEX_TABLE") == null) continue;
                                                table.setValue("PARENT_TABLE", MetaDataUtil.getUserTableName(table.getNameAsString()));
                                                admin.disableTable(table.getTableName());
                                                admin.modifyTable(table.getTableName(), table);
                                                admin.enableTable(table.getTableName());
                                            }
                                        }
                                    }
                                    if (currentServerSideTableTimeStamp < 3L) {
                                        columnsToAdd = columnsToAdd + ", INDEX_TYPE " + PUnsignedTinyint.INSTANCE.getSqlTypeName() + ", " + "INDEX_DISABLE_TIMESTAMP" + " " + PLong.INSTANCE.getSqlTypeName();
                                    }
                                    if (columnsToAdd.isEmpty()) break block71;
                                    metaConnection = newMetaConnection = ConnectionQueryServicesImpl.this.addColumnsIfNotExists(metaConnection, "SYSTEM.\"CATALOG\"", 8L, columnsToAdd);
                                }
                            }
                            int nSaltBuckets = ConnectionQueryServicesImpl.this.props.getInt("phoenix.sequence.saltBuckets", QueryServicesOptions.DEFAULT_SEQUENCE_TABLE_SALT_BUCKETS);
                            try {
                                String createSequenceTable = Sequence.getCreateTableStatement(nSaltBuckets);
                                metaConnection.createStatement().executeUpdate(createSequenceTable);
                                ConnectionQueryServicesImpl.this.nSequenceSaltBuckets = nSaltBuckets;
                            }
                            catch (NewerTableAlreadyExistsException e) {
                                ConnectionQueryServicesImpl.this.nSequenceSaltBuckets = ConnectionQueryServicesImpl.getSaltBuckets(e);
                            }
                            catch (TableAlreadyExistsException e) {
                                long currentServerSideTableTimeStamp = e.getTable().getTimeStamp();
                                if (currentServerSideTableTimeStamp < 3L) {
                                    String columnsToAdd = "MIN_VALUE " + PLong.INSTANCE.getSqlTypeName() + ", " + "MAX_VALUE" + " " + PLong.INSTANCE.getSqlTypeName() + ", " + "CYCLE_FLAG" + " " + PBoolean.INSTANCE.getSqlTypeName() + ", " + "LIMIT_REACHED_FLAG" + " " + PBoolean.INSTANCE.getSqlTypeName();
                                    ConnectionQueryServicesImpl.this.addColumnsIfNotExists(metaConnection, "SYSTEM.\"CATALOG\"", 8L, columnsToAdd);
                                }
                                if (currentServerSideTableTimeStamp < 5L) {
                                    if (UpgradeUtil.upgradeSequenceTable(metaConnection, nSaltBuckets, e.getTable())) {
                                        metaConnection.removeTable(null, "SYSTEM", "SEQUENCE", 8L);
                                        ConnectionQueryServicesImpl.this.clearTableFromCache(ByteUtil.EMPTY_BYTE_ARRAY, PhoenixDatabaseMetaData.SEQUENCE_SCHEMA_NAME_BYTES, PhoenixDatabaseMetaData.SEQUENCE_TABLE_NAME_BYTES, 8L);
                                        ConnectionQueryServicesImpl.this.clearTableRegionCache(PhoenixDatabaseMetaData.SEQUENCE_FULLNAME_BYTES);
                                    }
                                    ConnectionQueryServicesImpl.this.nSequenceSaltBuckets = nSaltBuckets;
                                }
                                ConnectionQueryServicesImpl.this.nSequenceSaltBuckets = ConnectionQueryServicesImpl.getSaltBuckets(e);
                            }
                            try {
                                metaConnection.createStatement().executeUpdate(QueryConstants.CREATE_STATS_TABLE_METADATA);
                            }
                            catch (NewerTableAlreadyExistsException e) {
                            }
                            catch (TableAlreadyExistsException ignore) {
                                metaConnection = ConnectionQueryServicesImpl.this.addColumnsIfNotExists(metaConnection, PhoenixDatabaseMetaData.SYSTEM_STATS_NAME, 8L, "GUIDE_POSTS_ROW_COUNT " + PLong.INSTANCE.getSqlTypeName());
                            }
                            try {
                                metaConnection.createStatement().executeUpdate(QueryConstants.CREATE_FUNCTION_METADATA);
                            }
                            catch (NewerTableAlreadyExistsException newerTableAlreadyExistsException) {
                            }
                            catch (TableAlreadyExistsException tableAlreadyExistsException) {
                                // empty catch block
                            }
                        }
                        catch (Exception e) {
                            if (e instanceof SQLException) {
                                ConnectionQueryServicesImpl.this.initializationException = (SQLException)e;
                            } else {
                                ConnectionQueryServicesImpl.this.initializationException = new SQLException(e);
                            }
                        }
                        finally {
                            try {
                                if (metaConnection != null) {
                                    metaConnection.close();
                                }
                            }
                            catch (SQLException e) {
                                if (ConnectionQueryServicesImpl.this.initializationException != null) {
                                    ConnectionQueryServicesImpl.this.initializationException.setNextException(e);
                                } else {
                                    ConnectionQueryServicesImpl.this.initializationException = e;
                                }
                            }
                            finally {
                                try {
                                    if (ConnectionQueryServicesImpl.this.initializationException != null) {
                                        throw ConnectionQueryServicesImpl.this.initializationException;
                                    }
                                }
                                finally {
                                    ConnectionQueryServicesImpl.this.initialized = true;
                                }
                            }
                        }
                        return null;
                    }
                }
            });
        }
        catch (Exception e) {
            Throwables.propagateIfInstanceOf(e, SQLException.class);
            throw Throwables.propagate(e);
        }
    }

    private static int getSaltBuckets(TableAlreadyExistsException e) {
        PTable table = e.getTable();
        Integer sequenceSaltBuckets = table == null ? null : table.getBucketNum();
        return sequenceSaltBuckets == null ? 0 : sequenceSaltBuckets;
    }

    @Override
    public MutationState updateData(MutationPlan plan) throws SQLException {
        return plan.execute();
    }

    @Override
    public int getLowestClusterHBaseVersion() {
        return this.lowestClusterHBaseVersion;
    }

    @Override
    public boolean hasInvalidIndexConfiguration() {
        return this.hasInvalidIndexConfiguration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void clearCache() throws SQLException {
        try {
            SQLException sqlE = null;
            HTableInterface htable = this.getTable(PhoenixDatabaseMetaData.SYSTEM_CATALOG_NAME_BYTES);
            try {
                htable.coprocessorService(MetaDataProtos.MetaDataService.class, HConstants.EMPTY_START_ROW, HConstants.EMPTY_END_ROW, new Batch.Call<MetaDataProtos.MetaDataService, MetaDataProtos.ClearCacheResponse>(){

                    @Override
                    public MetaDataProtos.ClearCacheResponse call(MetaDataProtos.MetaDataService instance) throws IOException {
                        ServerRpcController controller = new ServerRpcController();
                        BlockingRpcCallback<MetaDataProtos.ClearCacheResponse> rpcCallback = new BlockingRpcCallback<MetaDataProtos.ClearCacheResponse>();
                        MetaDataProtos.ClearCacheRequest.Builder builder = MetaDataProtos.ClearCacheRequest.newBuilder();
                        instance.clearCache(controller, builder.build(), rpcCallback);
                        if (controller.getFailedOn() != null) {
                            throw controller.getFailedOn();
                        }
                        return rpcCallback.get();
                    }
                });
            }
            catch (IOException e) {
                throw ServerUtil.parseServerException(e);
            }
            catch (Throwable e) {
                sqlE = new SQLException(e);
            }
            finally {
                try {
                    this.tableStatsCache.invalidateAll();
                    htable.close();
                }
                catch (IOException e) {
                    if (sqlE == null) {
                        sqlE = ServerUtil.parseServerException(e);
                    }
                    sqlE.setNextException(ServerUtil.parseServerException(e));
                }
                finally {
                    if (sqlE == null) return;
                    throw sqlE;
                }
            }
        }
        catch (Exception e) {
            throw new SQLException(ServerUtil.parseServerException(e));
        }
    }

    private void flushTable(byte[] tableName) throws SQLException {
        HBaseAdmin admin = this.getAdmin();
        try {
            admin.flush(tableName);
        }
        catch (IOException e) {
            throw new PhoenixIOException(e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new SQLExceptionInfo.Builder(SQLExceptionCode.INTERRUPTED_EXCEPTION).setRootCause(e).build().buildException();
        }
        finally {
            Closeables.closeQuietly(admin);
        }
    }

    @Override
    public HBaseAdmin getAdmin() throws SQLException {
        try {
            return new HBaseAdmin(this.config);
        }
        catch (IOException e) {
            throw new PhoenixIOException(e);
        }
    }

    @Override
    public MetaDataProtocol.MetaDataMutationResult updateIndexState(final List<Mutation> tableMetaData, String parentTableName) throws SQLException {
        byte[][] rowKeyMetadata = new byte[3][];
        SchemaUtil.getVarChars(tableMetaData.get(0).getRow(), rowKeyMetadata);
        byte[] tableKey = SchemaUtil.getTableKey(ByteUtil.EMPTY_BYTE_ARRAY, rowKeyMetadata[1], rowKeyMetadata[2]);
        return this.metaDataCoprocessorExec(tableKey, new Batch.Call<MetaDataProtos.MetaDataService, MetaDataProtos.MetaDataResponse>(){

            @Override
            public MetaDataProtos.MetaDataResponse call(MetaDataProtos.MetaDataService instance) throws IOException {
                ServerRpcController controller = new ServerRpcController();
                BlockingRpcCallback<MetaDataProtos.MetaDataResponse> rpcCallback = new BlockingRpcCallback<MetaDataProtos.MetaDataResponse>();
                MetaDataProtos.UpdateIndexStateRequest.Builder builder = MetaDataProtos.UpdateIndexStateRequest.newBuilder();
                for (Mutation m : tableMetaData) {
                    ClientProtos.MutationProto mp = ProtobufUtil.toProto(m);
                    builder.addTableMetadataMutations(mp.toByteString());
                }
                instance.updateIndexState(controller, builder.build(), rpcCallback);
                if (controller.getFailedOn() != null) {
                    throw controller.getFailedOn();
                }
                return rpcCallback.get();
            }
        });
    }

    /*
     * Loose catch block
     */
    @Override
    public long createSequence(String tenantId, String schemaName, String sequenceName, long startWith, long incrementBy, long cacheSize, long minValue, long maxValue, boolean cycle, long timestamp) throws SQLException {
        SequenceKey sequenceKey = new SequenceKey(tenantId, schemaName, sequenceName, this.nSequenceSaltBuckets);
        Sequence newSequences = new Sequence(sequenceKey);
        Sequence sequence = this.sequenceMap.putIfAbsent(sequenceKey, newSequences);
        if (sequence == null) {
            sequence = newSequences;
        }
        try {
            sequence.getLock().lock();
            Append append = sequence.createSequence(startWith, incrementBy, cacheSize, timestamp, minValue, maxValue, cycle);
            HTableInterface htable = this.getTable(PhoenixDatabaseMetaData.SEQUENCE_FULLNAME_BYTES);
            htable.setAutoFlush(true);
            try {
                Result result = htable.append(append);
                long l = sequence.createSequence(result, minValue, maxValue, cycle);
                return l;
            }
            catch (IOException e) {
                throw ServerUtil.parseServerException(e);
            }
            finally {
                Closeables.closeQuietly(htable);
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            sequence.getLock().unlock();
        }
    }

    /*
     * Loose catch block
     */
    @Override
    public long dropSequence(String tenantId, String schemaName, String sequenceName, long timestamp) throws SQLException {
        SequenceKey sequenceKey = new SequenceKey(tenantId, schemaName, sequenceName, this.nSequenceSaltBuckets);
        Sequence newSequences = new Sequence(sequenceKey);
        Sequence sequence = this.sequenceMap.putIfAbsent(sequenceKey, newSequences);
        if (sequence == null) {
            sequence = newSequences;
        }
        try {
            sequence.getLock().lock();
            Append append = sequence.dropSequence(timestamp);
            HTableInterface htable = this.getTable(PhoenixDatabaseMetaData.SEQUENCE_FULLNAME_BYTES);
            try {
                Result result = htable.append(append);
                long l = sequence.dropSequence(result);
                return l;
            }
            catch (IOException e) {
                throw ServerUtil.parseServerException(e);
            }
            finally {
                Closeables.closeQuietly(htable);
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            sequence.getLock().unlock();
        }
    }

    @Override
    public long currentSequenceValue(SequenceKey sequenceKey, long timestamp) throws SQLException {
        Sequence sequence = (Sequence)this.sequenceMap.get(sequenceKey);
        if (sequence == null) {
            throw new SQLExceptionInfo.Builder(SQLExceptionCode.CANNOT_CALL_CURRENT_BEFORE_NEXT_VALUE).setSchemaName(sequenceKey.getSchemaName()).setTableName(sequenceKey.getSequenceName()).build().buildException();
        }
        sequence.getLock().lock();
        try {
            long l = sequence.currentValue(timestamp);
            return l;
        }
        catch (EmptySequenceCacheException e) {
            throw new SQLExceptionInfo.Builder(SQLExceptionCode.CANNOT_CALL_CURRENT_BEFORE_NEXT_VALUE).setSchemaName(sequenceKey.getSchemaName()).setTableName(sequenceKey.getSequenceName()).build().buildException();
        }
        finally {
            sequence.getLock().unlock();
        }
    }

    @Override
    public void validateSequences(List<SequenceKey> sequenceKeys, long timestamp, long[] values, SQLException[] exceptions, Sequence.ValueOp action) throws SQLException {
        this.incrementSequenceValues(sequenceKeys, timestamp, values, exceptions, action);
    }

    @Override
    public void incrementSequences(List<SequenceKey> sequenceKeys, long timestamp, long[] values, SQLException[] exceptions) throws SQLException {
        this.incrementSequenceValues(sequenceKeys, timestamp, values, exceptions, Sequence.ValueOp.INCREMENT_SEQUENCE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void incrementSequenceValues(List<SequenceKey> keys, long timestamp, long[] values, SQLException[] exceptions, Sequence.ValueOp op) throws SQLException {
        ArrayList<Sequence> sequences = Lists.newArrayListWithExpectedSize(keys.size());
        for (SequenceKey key : keys) {
            Sequence newSequences;
            Sequence sequence = this.sequenceMap.putIfAbsent(key, newSequences = new Sequence(key));
            if (sequence == null) {
                sequence = newSequences;
            }
            sequences.add(sequence);
        }
        try {
            Object[] resultObjects;
            ArrayList<Sequence> toIncrementList;
            block32: {
                for (Sequence sequence : sequences) {
                    sequence.getLock().lock();
                }
                ArrayList<Increment> incrementBatch = Lists.newArrayListWithExpectedSize(sequences.size());
                toIncrementList = Lists.newArrayListWithExpectedSize(sequences.size());
                int[] indexes = new int[sequences.size()];
                for (int i = 0; i < sequences.size(); ++i) {
                    Sequence sequence = (Sequence)sequences.get(i);
                    try {
                        values[i] = sequence.incrementValue(timestamp, op);
                        continue;
                    }
                    catch (EmptySequenceCacheException e) {
                        indexes[toIncrementList.size()] = i;
                        toIncrementList.add(sequence);
                        Increment inc = sequence.newIncrement(timestamp, op);
                        incrementBatch.add(inc);
                        continue;
                    }
                    catch (SQLException e) {
                        exceptions[i] = e;
                    }
                }
                if (toIncrementList.isEmpty()) {
                    return;
                }
                HTableInterface hTable = this.getTable(PhoenixDatabaseMetaData.SEQUENCE_FULLNAME_BYTES);
                resultObjects = null;
                SQLException sqlE = null;
                try {
                    resultObjects = hTable.batch(incrementBatch);
                }
                catch (IOException e) {
                    sqlE = ServerUtil.parseServerException(e);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    sqlE = new SQLExceptionInfo.Builder(SQLExceptionCode.INTERRUPTED_EXCEPTION).setRootCause(e).build().buildException();
                }
                finally {
                    try {
                        hTable.close();
                    }
                    catch (IOException e) {
                        if (sqlE == null) {
                            sqlE = ServerUtil.parseServerException(e);
                        }
                        sqlE.setNextException(ServerUtil.parseServerException(e));
                    }
                    if (sqlE == null) break block32;
                    throw sqlE;
                }
            }
            for (int i = 0; i < resultObjects.length; ++i) {
                Sequence sequence = (Sequence)toIncrementList.get(i);
                Result result = (Result)resultObjects[i];
                try {
                    values[indexes[i]] = sequence.incrementValue(result, op);
                    continue;
                }
                catch (SQLException e) {
                    exceptions[indexes[i]] = e;
                }
            }
        }
        finally {
            for (Sequence sequence : sequences) {
                sequence.getLock().unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void clearTableFromCache(final byte[] tenantId, final byte[] schemaName, final byte[] tableName, final long clientTS) throws SQLException {
        try {
            SQLException sqlE = null;
            HTableInterface htable = this.getTable(PhoenixDatabaseMetaData.SYSTEM_CATALOG_NAME_BYTES);
            try {
                htable.coprocessorService(MetaDataProtos.MetaDataService.class, HConstants.EMPTY_START_ROW, HConstants.EMPTY_END_ROW, new Batch.Call<MetaDataProtos.MetaDataService, MetaDataProtos.ClearTableFromCacheResponse>(){

                    @Override
                    public MetaDataProtos.ClearTableFromCacheResponse call(MetaDataProtos.MetaDataService instance) throws IOException {
                        ServerRpcController controller = new ServerRpcController();
                        BlockingRpcCallback<MetaDataProtos.ClearTableFromCacheResponse> rpcCallback = new BlockingRpcCallback<MetaDataProtos.ClearTableFromCacheResponse>();
                        MetaDataProtos.ClearTableFromCacheRequest.Builder builder = MetaDataProtos.ClearTableFromCacheRequest.newBuilder();
                        builder.setTenantId(ByteStringer.wrap(tenantId));
                        builder.setTableName(ByteStringer.wrap(tableName));
                        builder.setSchemaName(ByteStringer.wrap(schemaName));
                        builder.setClientTimestamp(clientTS);
                        instance.clearTableFromCache(controller, builder.build(), rpcCallback);
                        if (controller.getFailedOn() != null) {
                            throw controller.getFailedOn();
                        }
                        return rpcCallback.get();
                    }
                });
            }
            catch (IOException e) {
                throw ServerUtil.parseServerException(e);
            }
            catch (Throwable e) {
                sqlE = new SQLException(e);
            }
            finally {
                try {
                    if (tenantId.length == 0) {
                        this.tableStatsCache.invalidate(new ImmutableBytesPtr(SchemaUtil.getTableNameAsBytes(schemaName, tableName)));
                    }
                    htable.close();
                }
                catch (IOException e) {
                    if (sqlE == null) {
                        sqlE = ServerUtil.parseServerException(e);
                    }
                    sqlE.setNextException(ServerUtil.parseServerException(e));
                }
                finally {
                    if (sqlE == null) return;
                    throw sqlE;
                }
            }
        }
        catch (Exception e) {
            throw new SQLException(ServerUtil.parseServerException(e));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void returnSequences(List<SequenceKey> keys, long timestamp, SQLException[] exceptions) throws SQLException {
        ArrayList<Sequence> sequences = Lists.newArrayListWithExpectedSize(keys.size());
        for (SequenceKey key : keys) {
            Sequence newSequences;
            Sequence sequence = this.sequenceMap.putIfAbsent(key, newSequences = new Sequence(key));
            if (sequence == null) {
                sequence = newSequences;
            }
            sequences.add(sequence);
        }
        try {
            Object[] resultObjects;
            ArrayList<Sequence> toReturnList;
            block31: {
                for (Sequence sequence : sequences) {
                    sequence.getLock().lock();
                }
                ArrayList<Append> mutations = Lists.newArrayListWithExpectedSize(sequences.size());
                toReturnList = Lists.newArrayListWithExpectedSize(sequences.size());
                int[] indexes = new int[sequences.size()];
                for (int i = 0; i < sequences.size(); ++i) {
                    Sequence sequence = (Sequence)sequences.get(i);
                    try {
                        Append append = sequence.newReturn(timestamp);
                        toReturnList.add(sequence);
                        mutations.add(append);
                        continue;
                    }
                    catch (EmptySequenceCacheException append) {
                        // empty catch block
                    }
                }
                if (toReturnList.isEmpty()) {
                    return;
                }
                HTableInterface hTable = this.getTable(PhoenixDatabaseMetaData.SEQUENCE_FULLNAME_BYTES);
                resultObjects = null;
                SQLException sqlE = null;
                try {
                    resultObjects = hTable.batch(mutations);
                }
                catch (IOException e) {
                    sqlE = ServerUtil.parseServerException(e);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    sqlE = new SQLExceptionInfo.Builder(SQLExceptionCode.INTERRUPTED_EXCEPTION).setRootCause(e).build().buildException();
                }
                finally {
                    try {
                        hTable.close();
                    }
                    catch (IOException e) {
                        if (sqlE == null) {
                            sqlE = ServerUtil.parseServerException(e);
                        }
                        sqlE.setNextException(ServerUtil.parseServerException(e));
                    }
                    if (sqlE == null) break block31;
                    throw sqlE;
                }
            }
            for (int i = 0; i < resultObjects.length; ++i) {
                Sequence sequence = (Sequence)toReturnList.get(i);
                Result result = (Result)resultObjects[i];
                try {
                    sequence.returnValue(result);
                    continue;
                }
                catch (SQLException e) {
                    exceptions[indexes[i]] = e;
                }
            }
        }
        finally {
            for (Sequence sequence : sequences) {
                sequence.getLock().unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void returnAllSequences(ConcurrentMap<SequenceKey, Sequence> sequenceMap) throws SQLException {
        block18: {
            ArrayList<Append> mutations = Lists.newArrayListWithExpectedSize(sequenceMap.size());
            for (Sequence sequence : sequenceMap.values()) {
                mutations.addAll(sequence.newReturns());
            }
            if (mutations.isEmpty()) {
                return;
            }
            HTableInterface hTable = this.getTable(PhoenixDatabaseMetaData.SEQUENCE_FULLNAME_BYTES);
            SQLException sqlE = null;
            try {
                hTable.batch(mutations);
            }
            catch (IOException e) {
                sqlE = ServerUtil.parseServerException(e);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                sqlE = new SQLExceptionInfo.Builder(SQLExceptionCode.INTERRUPTED_EXCEPTION).setRootCause(e).build().buildException();
            }
            finally {
                try {
                    hTable.close();
                }
                catch (IOException e) {
                    if (sqlE == null) {
                        sqlE = ServerUtil.parseServerException(e);
                    }
                    sqlE.setNextException(ServerUtil.parseServerException(e));
                }
                if (sqlE == null) break block18;
                throw sqlE;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addConnection(PhoenixConnection connection) throws SQLException {
        Object object = this.connectionCountLock;
        synchronized (object) {
            ++this.connectionCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeConnection(PhoenixConnection connection) throws SQLException {
        ConcurrentMap<SequenceKey, Sequence> formerSequenceMap = null;
        Object object = this.connectionCountLock;
        synchronized (object) {
            if (--this.connectionCount == 0 && !this.sequenceMap.isEmpty()) {
                formerSequenceMap = this.sequenceMap;
                this.sequenceMap = Maps.newConcurrentMap();
            }
        }
        if (formerSequenceMap != null) {
            this.returnAllSequences(formerSequenceMap);
        }
    }

    @Override
    public KeyValueBuilder getKeyValueBuilder() {
        return this.kvBuilder;
    }

    @Override
    public boolean supportsFeature(ConnectionQueryServices.Feature feature) {
        FeatureSupported supported = this.featureMap.get((Object)feature);
        if (supported == null) {
            return false;
        }
        return supported.isSupported(this);
    }

    @Override
    public String getUserName() {
        return this.userName;
    }

    private void checkClosed() {
        if (this.closed) {
            this.throwConnectionClosedException();
        }
    }

    private void throwConnectionClosedIfNullMetaData() {
        if (this.latestMetaData == null) {
            this.throwConnectionClosedException();
        }
    }

    private void throwConnectionClosedException() {
        throw new IllegalStateException("Connection to the cluster is closed");
    }

    @Override
    public PTableStats getTableStats(final byte[] physicalName, final long clientTimeStamp) throws SQLException {
        try {
            return this.tableStatsCache.get(new ImmutableBytesPtr(physicalName), new Callable<PTableStats>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public PTableStats call() throws Exception {
                    HTableInterface statsHTable = ConnectionQueryServicesImpl.this.getTable(PhoenixDatabaseMetaData.SYSTEM_STATS_NAME_BYTES);
                    try {
                        PTableStats pTableStats = StatisticsUtil.readStatistics(statsHTable, physicalName, clientTimeStamp);
                        return pTableStats;
                    }
                    catch (IOException e) {
                        logger.warn("Unable to read from stats table", e);
                        PTableStats pTableStats = PTableStats.EMPTY_STATS;
                        return pTableStats;
                    }
                    finally {
                        try {
                            statsHTable.close();
                        }
                        catch (IOException e) {
                            logger.warn("Unable to close stats table", e);
                        }
                    }
                }
            });
        }
        catch (ExecutionException e) {
            throw ServerUtil.parseServerException(e);
        }
    }

    @Override
    public int getSequenceSaltBuckets() {
        return this.nSequenceSaltBuckets;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PMetaData addFunction(PFunction function) throws SQLException {
        Object object = this.latestMetaDataLock;
        synchronized (object) {
            try {
                this.throwConnectionClosedIfNullMetaData();
                PFunction existingFunction = this.latestMetaData.getFunction(new PTableKey(function.getTenantId(), function.getFunctionName()));
                if (existingFunction.getTimeStamp() >= function.getTimeStamp()) {
                    return this.latestMetaData;
                }
            }
            catch (FunctionNotFoundException functionNotFoundException) {
                // empty catch block
            }
            this.latestMetaData = this.latestMetaData.addFunction(function);
            this.latestMetaDataLock.notifyAll();
            return this.latestMetaData;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PMetaData removeFunction(PName tenantId, String function, long functionTimeStamp) throws SQLException {
        Object object = this.latestMetaDataLock;
        synchronized (object) {
            this.throwConnectionClosedIfNullMetaData();
            this.latestMetaData = this.latestMetaData.removeFunction(tenantId, function, functionTimeStamp);
            this.latestMetaDataLock.notifyAll();
            return this.latestMetaData;
        }
    }

    @Override
    public MetaDataProtocol.MetaDataMutationResult getFunctions(PName tenantId, final List<Pair<byte[], Long>> functions, final long clientTimestamp) throws SQLException {
        final byte[] tenantIdBytes = tenantId == null ? ByteUtil.EMPTY_BYTE_ARRAY : tenantId.getBytes();
        return this.metaDataCoprocessorExec(tenantIdBytes, new Batch.Call<MetaDataProtos.MetaDataService, MetaDataProtos.MetaDataResponse>(){

            @Override
            public MetaDataProtos.MetaDataResponse call(MetaDataProtos.MetaDataService instance) throws IOException {
                ServerRpcController controller = new ServerRpcController();
                BlockingRpcCallback<MetaDataProtos.MetaDataResponse> rpcCallback = new BlockingRpcCallback<MetaDataProtos.MetaDataResponse>();
                MetaDataProtos.GetFunctionsRequest.Builder builder = MetaDataProtos.GetFunctionsRequest.newBuilder();
                builder.setTenantId(ByteStringer.wrap(tenantIdBytes));
                for (Pair function : functions) {
                    builder.addFunctionNames(ByteStringer.wrap((byte[])function.getFirst()));
                    builder.addFunctionTimestamps((Long)function.getSecond());
                }
                builder.setClientTimestamp(clientTimestamp);
                instance.getFunctions(controller, builder.build(), rpcCallback);
                if (controller.getFailedOn() != null) {
                    throw controller.getFailedOn();
                }
                return rpcCallback.get();
            }
        }, PhoenixDatabaseMetaData.SYSTEM_FUNCTION_NAME_BYTES);
    }

    @Override
    public MetaDataProtocol.MetaDataMutationResult createFunction(final List<Mutation> functionData, PFunction function, final boolean temporary) throws SQLException {
        byte[][] rowKeyMetadata = new byte[2][];
        Mutation m = MetaDataUtil.getPutOnlyTableHeaderRow(functionData);
        byte[] key = m.getRow();
        SchemaUtil.getVarChars(key, rowKeyMetadata);
        byte[] tenantIdBytes = rowKeyMetadata[0];
        byte[] functionBytes = rowKeyMetadata[1];
        byte[] functionKey = SchemaUtil.getFunctionKey(tenantIdBytes, functionBytes);
        MetaDataProtocol.MetaDataMutationResult result = this.metaDataCoprocessorExec(functionKey, new Batch.Call<MetaDataProtos.MetaDataService, MetaDataProtos.MetaDataResponse>(){

            @Override
            public MetaDataProtos.MetaDataResponse call(MetaDataProtos.MetaDataService instance) throws IOException {
                ServerRpcController controller = new ServerRpcController();
                BlockingRpcCallback<MetaDataProtos.MetaDataResponse> rpcCallback = new BlockingRpcCallback<MetaDataProtos.MetaDataResponse>();
                MetaDataProtos.CreateFunctionRequest.Builder builder = MetaDataProtos.CreateFunctionRequest.newBuilder();
                for (Mutation m : functionData) {
                    ClientProtos.MutationProto mp = ProtobufUtil.toProto(m);
                    builder.addTableMetadataMutations(mp.toByteString());
                }
                builder.setTemporary(temporary);
                instance.createFunction(controller, builder.build(), rpcCallback);
                if (controller.getFailedOn() != null) {
                    throw controller.getFailedOn();
                }
                return rpcCallback.get();
            }
        }, PhoenixDatabaseMetaData.SYSTEM_FUNCTION_NAME_BYTES);
        return result;
    }

    @Override
    public HRegionLocation getTableRegionLocation(byte[] tableName, byte[] row) throws SQLException {
        int retryCount = 0;
        int maxRetryCount = 1;
        boolean reload = false;
        while (true) {
            try {
                return this.connection.getRegionLocation(TableName.valueOf(tableName), row, reload);
            }
            catch (org.apache.hadoop.hbase.TableNotFoundException e) {
                String fullName = Bytes.toString(tableName);
                throw new TableNotFoundException(SchemaUtil.getSchemaNameFromFullName(fullName), SchemaUtil.getTableNameFromFullName(fullName));
            }
            catch (IOException e) {
                if (retryCount++ < maxRetryCount) {
                    reload = true;
                    continue;
                }
                throw new SQLExceptionInfo.Builder(SQLExceptionCode.GET_TABLE_REGIONS_FAIL).setRootCause(e).build().buildException();
            }
            break;
        }
    }

    private static interface RetriableOperation {
        public boolean checkForCompletion() throws TimeoutException, IOException;

        public String getOperatioName();
    }

    private static interface Mutator {
        public PMetaData mutate(PMetaData var1) throws SQLException;
    }

    private static interface FeatureSupported {
        public boolean isSupported(ConnectionQueryServices var1);
    }
}

