/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.mapreduce.index;

import com.google.common.base.Preconditions;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.mapreduce.HFileOutputFormat;
import org.apache.hadoop.hbase.mapreduce.LoadIncrementalHFiles;
import org.apache.hadoop.hbase.mapreduce.TableMapReduceUtil;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.apache.phoenix.compile.PostIndexDDLCompiler;
import org.apache.phoenix.jdbc.PhoenixConnection;
import org.apache.phoenix.mapreduce.index.PhoenixIndexDBWritable;
import org.apache.phoenix.mapreduce.index.PhoenixIndexImportMapper;
import org.apache.phoenix.mapreduce.util.ColumnInfoToStringEncoderDecoder;
import org.apache.phoenix.mapreduce.util.ConnectionUtil;
import org.apache.phoenix.mapreduce.util.PhoenixConfigurationUtil;
import org.apache.phoenix.mapreduce.util.PhoenixMapReduceUtil;
import org.apache.phoenix.parse.HintNode;
import org.apache.phoenix.schema.PIndexState;
import org.apache.phoenix.schema.PTable;
import org.apache.phoenix.schema.TableRef;
import org.apache.phoenix.util.ColumnInfo;
import org.apache.phoenix.util.PhoenixRuntime;
import org.apache.phoenix.util.QueryUtil;
import org.apache.phoenix.util.SchemaUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IndexTool
extends Configured
implements Tool {
    private static final Logger LOG = LoggerFactory.getLogger(IndexTool.class);
    private static final Option SCHEMA_NAME_OPTION = new Option("s", "schema", true, "Phoenix schema name (optional)");
    private static final Option DATA_TABLE_OPTION = new Option("dt", "data-table", true, "Data table name (mandatory)");
    private static final Option INDEX_TABLE_OPTION = new Option("it", "index-table", true, "Index table name(mandatory)");
    private static final Option OUTPUT_PATH_OPTION = new Option("op", "output-path", true, "Output path where the files are written(mandatory)");
    private static final Option HELP_OPTION = new Option("h", "help", false, "Help");
    private static final String ALTER_INDEX_QUERY_TEMPLATE = "ALTER INDEX IF EXISTS %s ON %s %s";
    private static final String INDEX_JOB_NAME_TEMPLATE = "PHOENIX_%s_INDX_%s";

    private Options getOptions() {
        Options options = new Options();
        options.addOption(SCHEMA_NAME_OPTION);
        options.addOption(DATA_TABLE_OPTION);
        options.addOption(INDEX_TABLE_OPTION);
        options.addOption(OUTPUT_PATH_OPTION);
        options.addOption(HELP_OPTION);
        return options;
    }

    private CommandLine parseOptions(String[] args) {
        Options options = this.getOptions();
        PosixParser parser = new PosixParser();
        CommandLine cmdLine = null;
        try {
            cmdLine = parser.parse(options, args);
        }
        catch (ParseException e) {
            this.printHelpAndExit("Error parsing command line options: " + e.getMessage(), options);
        }
        if (cmdLine.hasOption(HELP_OPTION.getOpt())) {
            this.printHelpAndExit(options, 0);
        }
        if (!cmdLine.hasOption(DATA_TABLE_OPTION.getOpt())) {
            throw new IllegalStateException(DATA_TABLE_OPTION.getLongOpt() + " is a mandatory parameter");
        }
        if (!cmdLine.hasOption(INDEX_TABLE_OPTION.getOpt())) {
            throw new IllegalStateException(INDEX_TABLE_OPTION.getLongOpt() + " is a mandatory parameter");
        }
        if (!cmdLine.hasOption(OUTPUT_PATH_OPTION.getOpt())) {
            throw new IllegalStateException(OUTPUT_PATH_OPTION.getLongOpt() + " is a mandatory parameter");
        }
        return cmdLine;
    }

    private void printHelpAndExit(String errorMessage, Options options) {
        System.err.println(errorMessage);
        this.printHelpAndExit(options, 1);
    }

    private void printHelpAndExit(Options options, int exitCode) {
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp("help", options);
        System.exit(exitCode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int run(String[] args) throws Exception {
        Connection connection = null;
        try {
            CommandLine cmdLine = null;
            try {
                cmdLine = this.parseOptions(args);
            }
            catch (IllegalStateException e) {
                this.printHelpAndExit(e.getMessage(), this.getOptions());
            }
            Configuration configuration = HBaseConfiguration.addHbaseResources(this.getConf());
            String schemaName = cmdLine.getOptionValue(SCHEMA_NAME_OPTION.getOpt());
            String dataTable = cmdLine.getOptionValue(DATA_TABLE_OPTION.getOpt());
            String indexTable = cmdLine.getOptionValue(INDEX_TABLE_OPTION.getOpt());
            String qDataTable = SchemaUtil.getTableName(schemaName, dataTable);
            String qIndexTable = SchemaUtil.getTableName(schemaName, indexTable);
            connection = ConnectionUtil.getInputConnection(configuration);
            if (!this.isValidIndexTable(connection, qDataTable, indexTable)) {
                throw new IllegalArgumentException(String.format(" %s is not an index table for %s ", qIndexTable, qDataTable));
            }
            PTable pdataTable = PhoenixRuntime.getTable(connection, qDataTable);
            PTable pindexTable = PhoenixRuntime.getTable(connection, qIndexTable);
            long indxTimestamp = pindexTable.getTimeStamp();
            configuration.set("phoenix.mr.currentscn.value", Long.toString(indxTimestamp + 1L));
            String logicalIndexTable = qIndexTable;
            if (PTable.IndexType.LOCAL.equals((Object)pindexTable.getIndexType())) {
                logicalIndexTable = qDataTable;
            }
            PhoenixConnection pConnection = connection.unwrap(PhoenixConnection.class);
            PostIndexDDLCompiler ddlCompiler = new PostIndexDDLCompiler(pConnection, new TableRef(pdataTable));
            ddlCompiler.compile(pindexTable);
            List<String> indexColumns = ddlCompiler.getIndexColumnNames();
            String selectQuery = ddlCompiler.getSelectQuery();
            String upsertQuery = QueryUtil.constructUpsertStatement(qIndexTable, indexColumns, HintNode.Hint.NO_INDEX);
            configuration.set("phoenix.upsert.stmt", upsertQuery);
            PhoenixConfigurationUtil.setPhysicalTableName(configuration, logicalIndexTable);
            PhoenixConfigurationUtil.setOutputTableName(configuration, qIndexTable);
            PhoenixConfigurationUtil.setUpsertColumnNames(configuration, indexColumns.toArray(new String[indexColumns.size()]));
            List<ColumnInfo> columnMetadataList = PhoenixRuntime.generateColumnInfo(connection, qIndexTable, indexColumns);
            ColumnInfoToStringEncoderDecoder.encode(configuration, columnMetadataList);
            Path outputPath = new Path(cmdLine.getOptionValue(OUTPUT_PATH_OPTION.getOpt()), logicalIndexTable);
            String jobName = String.format(INDEX_JOB_NAME_TEMPLATE, dataTable, indexTable);
            Job job = Job.getInstance(configuration, jobName);
            job.setJarByClass(IndexTool.class);
            job.setMapperClass(PhoenixIndexImportMapper.class);
            job.setMapOutputKeyClass(ImmutableBytesWritable.class);
            job.setMapOutputValueClass(KeyValue.class);
            PhoenixMapReduceUtil.setInput(job, PhoenixIndexDBWritable.class, dataTable, selectQuery);
            TableMapReduceUtil.initCredentials(job);
            FileOutputFormat.setOutputPath(job, outputPath);
            HTable htable = new HTable(configuration, logicalIndexTable);
            HFileOutputFormat.configureIncrementalLoad(job, htable);
            boolean status = job.waitForCompletion(true);
            if (!status) {
                LOG.error("Failed to run the IndexTool job. ");
                htable.close();
                int n = -1;
                return n;
            }
            LOG.info("Loading HFiles from {}", outputPath);
            LoadIncrementalHFiles loader = new LoadIncrementalHFiles(configuration);
            loader.doBulkLoad(outputPath, htable);
            htable.close();
            LOG.info("Removing output directory {}", outputPath);
            if (!FileSystem.get(configuration).delete(outputPath, true)) {
                LOG.error("Removing output directory {} failed", outputPath);
            }
            this.updateIndexState(connection, qDataTable, indexTable, PIndexState.ACTIVE);
            int n = 0;
            return n;
        }
        catch (Exception ex) {
            LOG.error(" An exception occured while performing the indexing job : " + ExceptionUtils.getStackTrace(ex));
            int n = -1;
            return n;
        }
        finally {
            try {
                if (connection != null) {
                    connection.close();
                }
            }
            catch (SQLException sqle) {
                LOG.error(" Failed to close connection ", (Object)sqle.getMessage());
                throw new RuntimeException("Failed to close connection");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isValidIndexTable(Connection connection, String masterTable, String indexTable) throws SQLException {
        DatabaseMetaData dbMetaData = connection.getMetaData();
        String schemaName = SchemaUtil.getSchemaNameFromFullName(masterTable);
        String tableName = SchemaUtil.getTableNameFromFullName(masterTable);
        try (ResultSet rs = null;){
            rs = dbMetaData.getIndexInfo(null, schemaName, tableName, false, false);
            while (rs.next()) {
                String indexName = rs.getString(6);
                if (!indexTable.equalsIgnoreCase(indexName)) continue;
                boolean bl = true;
                return bl;
            }
        }
        return false;
    }

    private void updateIndexState(Connection connection, String masterTable, String indexTable, PIndexState state) throws SQLException {
        Preconditions.checkNotNull(connection);
        String alterQuery = String.format(ALTER_INDEX_QUERY_TEMPLATE, indexTable, masterTable, state.name());
        connection.createStatement().execute(alterQuery);
        LOG.info(" Updated the status of the index {} to {} ", (Object)indexTable, (Object)state.name());
    }

    public static void main(String[] args) throws Exception {
        int result = ToolRunner.run(new IndexTool(), args);
        System.exit(result);
    }
}

