/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.mapreduce;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.sql.Connection;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.mapreduce.InputFormat;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.db.DBWritable;
import org.apache.phoenix.compile.QueryPlan;
import org.apache.phoenix.iterate.MapReduceParallelScanGrouper;
import org.apache.phoenix.jdbc.PhoenixStatement;
import org.apache.phoenix.mapreduce.PhoenixInputSplit;
import org.apache.phoenix.mapreduce.PhoenixRecordReader;
import org.apache.phoenix.mapreduce.util.ConnectionUtil;
import org.apache.phoenix.mapreduce.util.PhoenixConfigurationUtil;
import org.apache.phoenix.query.KeyRange;

public class PhoenixInputFormat<T extends DBWritable>
extends InputFormat<NullWritable, T> {
    private static final Log LOG = LogFactory.getLog(PhoenixInputFormat.class);

    @Override
    public RecordReader<NullWritable, T> createRecordReader(InputSplit split, TaskAttemptContext context) throws IOException, InterruptedException {
        Configuration configuration = context.getConfiguration();
        QueryPlan queryPlan = this.getQueryPlan(context, configuration);
        Class<?> inputClass = PhoenixConfigurationUtil.getInputClass(configuration);
        return new PhoenixRecordReader(inputClass, configuration, queryPlan);
    }

    @Override
    public List<InputSplit> getSplits(JobContext context) throws IOException, InterruptedException {
        Configuration configuration = context.getConfiguration();
        QueryPlan queryPlan = this.getQueryPlan(context, configuration);
        List<KeyRange> allSplits = queryPlan.getSplits();
        List<InputSplit> splits = this.generateSplits(queryPlan, allSplits);
        return splits;
    }

    private List<InputSplit> generateSplits(QueryPlan qplan, List<KeyRange> splits) throws IOException {
        Preconditions.checkNotNull(qplan);
        Preconditions.checkNotNull(splits);
        ArrayList<InputSplit> psplits = Lists.newArrayListWithExpectedSize(splits.size());
        for (List<Scan> scans : qplan.getScans()) {
            psplits.add(new PhoenixInputSplit(scans));
        }
        return psplits;
    }

    private QueryPlan getQueryPlan(JobContext context, Configuration configuration) throws IOException {
        Preconditions.checkNotNull(context);
        try {
            String currentScnValue = configuration.get("phoenix.mr.currentscn.value");
            Properties overridingProps = new Properties();
            if (currentScnValue != null) {
                overridingProps.put("CurrentSCN", currentScnValue);
            }
            Connection connection = ConnectionUtil.getInputConnection(configuration, overridingProps);
            String selectStatement = PhoenixConfigurationUtil.getSelectStatement(configuration);
            Preconditions.checkNotNull(selectStatement);
            Statement statement = connection.createStatement();
            PhoenixStatement pstmt = statement.unwrap(PhoenixStatement.class);
            QueryPlan queryPlan = pstmt.optimizeQuery(selectStatement);
            queryPlan.iterator(MapReduceParallelScanGrouper.getInstance());
            return queryPlan;
        }
        catch (Exception exception) {
            LOG.error(String.format("Failed to get the query plan with error [%s]", exception.getMessage()));
            throw new RuntimeException(exception);
        }
    }
}

