/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.mapreduce;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.util.Base64;
import org.apache.phoenix.mapreduce.CsvToKeyValueMapper;
import org.apache.phoenix.mapreduce.ImportPreUpsertKeyValueProcessor;
import org.apache.phoenix.util.ColumnInfo;

public class CsvBulkImportUtil {
    public static void initCsvImportJob(Configuration conf, String tableName, char fieldDelimiter, char quoteChar, char escapeChar, String arrayDelimiter, List<ColumnInfo> columnInfoList, boolean ignoreInvalidRows) {
        Preconditions.checkNotNull(tableName);
        Preconditions.checkNotNull(columnInfoList);
        Preconditions.checkArgument(!columnInfoList.isEmpty(), "Column info list is empty");
        conf.set("phoenix.mapreduce.import.tablename", tableName);
        CsvBulkImportUtil.setChar(conf, "phoenix.mapreduce.import.fielddelimiter", fieldDelimiter);
        CsvBulkImportUtil.setChar(conf, "phoenix.mapreduce.import.quotechar", quoteChar);
        CsvBulkImportUtil.setChar(conf, "phoenix.mapreduce.import.escapechar", escapeChar);
        if (arrayDelimiter != null) {
            conf.set("phoenix.mapreduce.import.arraydelimiter", arrayDelimiter);
        }
        CsvToKeyValueMapper.configureColumnInfoList(conf, columnInfoList);
        conf.setBoolean("phoenix.mapreduce.import.ignoreinvalidrow", ignoreInvalidRows);
    }

    public static void configurePreUpsertProcessor(Configuration conf, Class<? extends ImportPreUpsertKeyValueProcessor> processorClass) {
        conf.setClass("phoenix.mapreduce.import.kvprocessor", processorClass, ImportPreUpsertKeyValueProcessor.class);
    }

    @VisibleForTesting
    static void setChar(Configuration conf, String confKey, char charValue) {
        conf.set(confKey, Base64.encodeBytes(Character.toString(charValue).getBytes()));
    }

    @VisibleForTesting
    static Character getCharacter(Configuration conf, String confKey) {
        String strValue = conf.get(confKey);
        if (strValue == null) {
            return null;
        }
        return Character.valueOf(new String(Base64.decode(strValue)).charAt(0));
    }
}

