/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.jdbc;

import com.google.common.base.Objects;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.io.EOFException;
import java.io.IOException;
import java.io.PrintStream;
import java.io.Reader;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.text.Format;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Executor;
import javax.annotation.Nullable;
import org.apache.hadoop.hbase.client.Consistency;
import org.apache.htrace.Sampler;
import org.apache.htrace.TraceScope;
import org.apache.phoenix.call.CallRunner;
import org.apache.phoenix.exception.SQLExceptionCode;
import org.apache.phoenix.exception.SQLExceptionInfo;
import org.apache.phoenix.execute.MutationState;
import org.apache.phoenix.expression.function.FunctionArgumentType;
import org.apache.phoenix.hbase.index.util.KeyValueBuilder;
import org.apache.phoenix.iterate.ParallelIteratorFactory;
import org.apache.phoenix.jdbc.Jdbc7Shim;
import org.apache.phoenix.jdbc.PhoenixDatabaseMetaData;
import org.apache.phoenix.jdbc.PhoenixPreparedStatement;
import org.apache.phoenix.jdbc.PhoenixStatement;
import org.apache.phoenix.jdbc.PhoenixStatementFactory;
import org.apache.phoenix.parse.PFunction;
import org.apache.phoenix.query.ConnectionQueryServices;
import org.apache.phoenix.query.DelegateConnectionQueryServices;
import org.apache.phoenix.query.MetaDataMutated;
import org.apache.phoenix.query.QueryServicesOptions;
import org.apache.phoenix.schema.PColumn;
import org.apache.phoenix.schema.PMetaData;
import org.apache.phoenix.schema.PName;
import org.apache.phoenix.schema.PTable;
import org.apache.phoenix.schema.PTableType;
import org.apache.phoenix.schema.types.PArrayDataType;
import org.apache.phoenix.schema.types.PDataType;
import org.apache.phoenix.schema.types.PDate;
import org.apache.phoenix.schema.types.PDecimal;
import org.apache.phoenix.schema.types.PTime;
import org.apache.phoenix.schema.types.PTimestamp;
import org.apache.phoenix.schema.types.PUnsignedDate;
import org.apache.phoenix.schema.types.PUnsignedTime;
import org.apache.phoenix.schema.types.PUnsignedTimestamp;
import org.apache.phoenix.trace.util.Tracing;
import org.apache.phoenix.util.DateUtil;
import org.apache.phoenix.util.JDBCUtil;
import org.apache.phoenix.util.PropertiesUtil;
import org.apache.phoenix.util.ReadOnlyProps;
import org.apache.phoenix.util.SQLCloseable;
import org.apache.phoenix.util.SQLCloseables;

public class PhoenixConnection
implements Connection,
Jdbc7Shim.Connection,
MetaDataMutated {
    private final String url;
    private final ConnectionQueryServices services;
    private final Properties info;
    private List<SQLCloseable> statements = new ArrayList<SQLCloseable>();
    private final Map<PDataType<?>, Format> formatters = new HashMap();
    private MutationState mutationState;
    private final int mutateBatchSize;
    private final Long scn;
    private boolean isAutoCommit = false;
    private PMetaData metaData;
    private final PName tenantId;
    private final String datePattern;
    private final String timePattern;
    private final String timestampPattern;
    private int statementExecutionCounter;
    private TraceScope traceScope = null;
    private boolean isClosed = false;
    private Sampler<?> sampler;
    private boolean readOnly = false;
    private Map<String, String> customTracingAnnotations = Collections.emptyMap();
    private Consistency consistency = Consistency.STRONG;
    private ParallelIteratorFactory parallelIteratorFactory;

    private static Properties newPropsWithSCN(long scn, Properties props) {
        props = new Properties(props);
        props.setProperty("CurrentSCN", Long.toString(scn));
        return props;
    }

    public PhoenixConnection(PhoenixConnection connection) throws SQLException {
        this(connection.getQueryServices(), connection.getURL(), connection.getClientInfo(), connection.getMetaDataCache());
        this.isAutoCommit = connection.isAutoCommit;
        this.sampler = connection.sampler;
        this.statementExecutionCounter = connection.statementExecutionCounter;
    }

    public PhoenixConnection(PhoenixConnection connection, long scn) throws SQLException {
        this(connection.getQueryServices(), connection, scn);
        this.sampler = connection.sampler;
        this.statementExecutionCounter = connection.statementExecutionCounter;
    }

    public PhoenixConnection(ConnectionQueryServices services, PhoenixConnection connection, long scn) throws SQLException {
        this(services, connection.getURL(), PhoenixConnection.newPropsWithSCN(scn, connection.getClientInfo()), connection.getMetaDataCache());
        this.isAutoCommit = connection.isAutoCommit;
        this.sampler = connection.sampler;
        this.statementExecutionCounter = connection.statementExecutionCounter;
    }

    public PhoenixConnection(ConnectionQueryServices services, String url, Properties info, PMetaData metaData) throws SQLException {
        this.url = url;
        this.info = info == null ? new Properties() : PropertiesUtil.deepCopy(info);
        final PName tenantId = JDBCUtil.getTenantId(url, info);
        if (this.info.isEmpty() && tenantId == null) {
            this.services = services;
        } else {
            ReadOnlyProps currentProps;
            ReadOnlyProps augmentedProps;
            if (tenantId != null) {
                services = services.getChildQueryServices(tenantId.getBytesPtr());
            }
            this.services = (augmentedProps = (currentProps = services.getProps()).addAll(PhoenixConnection.filterKnownNonProperties(this.info))) == currentProps ? services : new DelegateConnectionQueryServices(services){

                @Override
                public ReadOnlyProps getProps() {
                    return augmentedProps;
                }
            };
        }
        Long scnParam = JDBCUtil.getCurrentSCN(url, this.info);
        PhoenixConnection.checkScn(scnParam);
        this.scn = scnParam;
        this.isAutoCommit = JDBCUtil.getAutoCommit(url, this.info, this.services.getProps().getBoolean("phoenix.connection.autoCommit", false));
        this.consistency = JDBCUtil.getConsistencyLevel(url, this.info, this.services.getProps().get("phoenix.connection.consistency", QueryServicesOptions.DEFAULT_CONSISTENCY_LEVEL));
        this.tenantId = tenantId;
        this.mutateBatchSize = JDBCUtil.getMutateBatchSize(url, this.info, this.services.getProps());
        this.datePattern = this.services.getProps().get("phoenix.query.dateFormat", "yyyy-MM-dd HH:mm:ss.SSS");
        this.timePattern = this.services.getProps().get("phoenix.query.timeFormat", "yyyy-MM-dd HH:mm:ss.SSS");
        this.timestampPattern = this.services.getProps().get("phoenix.query.timestampFormat", "yyyy-MM-dd HH:mm:ss.SSS");
        String numberPattern = this.services.getProps().get("phoenix.query.numberFormat", "#,##0.###");
        int maxSize = this.services.getProps().getInt("phoenix.mutate.maxSize", 500000);
        Format dateFormat = DateUtil.getDateFormatter(this.datePattern);
        Format timeFormat = DateUtil.getDateFormatter(this.timePattern);
        Format timestampFormat = DateUtil.getDateFormatter(this.timestampPattern);
        this.formatters.put(PDate.INSTANCE, dateFormat);
        this.formatters.put(PTime.INSTANCE, timeFormat);
        this.formatters.put(PTimestamp.INSTANCE, timestampFormat);
        this.formatters.put(PUnsignedDate.INSTANCE, dateFormat);
        this.formatters.put(PUnsignedTime.INSTANCE, timeFormat);
        this.formatters.put(PUnsignedTimestamp.INSTANCE, timestampFormat);
        this.formatters.put(PDecimal.INSTANCE, FunctionArgumentType.NUMERIC.getFormatter(numberPattern));
        PMetaData.Pruner pruner = new PMetaData.Pruner(){

            @Override
            public boolean prune(PTable table) {
                long maxTimestamp = PhoenixConnection.this.scn == null ? Long.MAX_VALUE : PhoenixConnection.this.scn;
                return table.getType() != PTableType.SYSTEM && (table.getTimeStamp() >= maxTimestamp || !Objects.equal(tenantId, table.getTenantId()));
            }

            @Override
            public boolean prune(PFunction function) {
                long maxTimestamp = PhoenixConnection.this.scn == null ? Long.MAX_VALUE : PhoenixConnection.this.scn;
                return function.getTimeStamp() >= maxTimestamp || !Objects.equal(tenantId, function.getTenantId());
            }
        };
        this.mutationState = this.newMutationState(maxSize);
        this.metaData = metaData.pruneTables(pruner);
        this.metaData = metaData.pruneFunctions(pruner);
        this.services.addConnection(this);
        this.sampler = Tracing.getConfiguredSampler(this);
        this.customTracingAnnotations = this.getImmutableCustomTracingAnnotations();
    }

    private static void checkScn(Long scnParam) throws SQLException {
        if (scnParam != null && scnParam < 0L) {
            throw new SQLExceptionInfo.Builder(SQLExceptionCode.INVALID_SCN).build().buildException();
        }
    }

    private static Properties filterKnownNonProperties(Properties info) {
        Properties prunedProperties = info;
        if (info.contains("CurrentSCN")) {
            if (prunedProperties == info) {
                prunedProperties = PropertiesUtil.deepCopy(info);
            }
            prunedProperties.remove("CurrentSCN");
        }
        if (info.contains("TenantId")) {
            if (prunedProperties == info) {
                prunedProperties = PropertiesUtil.deepCopy(info);
            }
            prunedProperties.remove("TenantId");
        }
        return prunedProperties;
    }

    private ImmutableMap<String, String> getImmutableCustomTracingAnnotations() {
        ImmutableMap.Builder<String, String> result = ImmutableMap.builder();
        result.putAll(JDBCUtil.getAnnotations(this.url, this.info));
        if (this.getSCN() != null) {
            result.put("CurrentSCN", this.getSCN().toString());
        }
        if (this.getTenantId() != null) {
            result.put("TenantId", this.getTenantId().getString());
        }
        return result.build();
    }

    public Sampler<?> getSampler() {
        return this.sampler;
    }

    public void setSampler(Sampler<?> sampler) throws SQLException {
        this.sampler = sampler;
    }

    public Map<String, String> getCustomTracingAnnotations() {
        return this.customTracingAnnotations;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public int executeStatements(Reader reader, List<Object> binds, PrintStream out) throws IOException, SQLException {
        bindsOffset = 0;
        nStatements = 0;
        parser = new PhoenixStatement.PhoenixStatementParser(reader);
        try {
            while (true) lbl-1000:
            // 3 sources

            {
                stmt = null;
                try {
                    stmt = new PhoenixPreparedStatement(this, parser);
                    paramMetaData = stmt.getParameterMetaData();
                    for (i = 0; i < paramMetaData.getParameterCount(); ++i) {
                        stmt.setObject(i + 1, binds.get(bindsOffset + i));
                    }
                    start = System.currentTimeMillis();
                    isQuery = stmt.execute();
                    if (isQuery) {
                        rs = stmt.getResultSet();
                        if (!rs.next()) {
                            if (out != null) {
                                out.println("no rows selected");
                            }
                        } else {
                            columnCount = 0;
                            if (out != null) {
                                md = rs.getMetaData();
                                columnCount = md.getColumnCount();
                                for (i = 1; i <= columnCount; ++i) {
                                    displayWidth = md.getColumnDisplaySize(i);
                                    label = md.getColumnLabel(i);
                                    if (md.isSigned(i)) {
                                        out.print(displayWidth < label.length() ? label.substring(0, displayWidth) : Strings.padStart(label, displayWidth, ' '));
                                        out.print(' ');
                                        continue;
                                    }
                                    out.print(displayWidth < label.length() ? label.substring(0, displayWidth) : Strings.padEnd(md.getColumnLabel(i), displayWidth, ' '));
                                    out.print(' ');
                                }
                                out.println();
                                for (i = 1; i <= columnCount; ++i) {
                                    displayWidth = md.getColumnDisplaySize(i);
                                    out.print(Strings.padStart("", displayWidth, '-'));
                                    out.print(' ');
                                }
                                out.println();
                            }
                            do {
                                if (out == null) continue;
                                md = rs.getMetaData();
                                for (i = 1; i <= columnCount; ++i) {
                                    displayWidth = md.getColumnDisplaySize(i);
                                    value = rs.getString(i);
                                    v0 = valueString = value == null ? "<null>" : value;
                                    if (md.isSigned(i)) {
                                        out.print(Strings.padStart(valueString, displayWidth, ' '));
                                    } else {
                                        out.print(Strings.padEnd(valueString, displayWidth, ' '));
                                    }
                                    out.print(' ');
                                }
                                out.println();
                            } while (rs.next());
                        }
                    } else if (out != null && (updateCount = stmt.getUpdateCount()) >= 0) {
                        out.println((updateCount == 0 ? "no" : Integer.valueOf(updateCount)) + (updateCount == 1 ? " row " : " rows ") + stmt.getUpdateOperation().toString());
                    }
                    bindsOffset += paramMetaData.getParameterCount();
                    elapsedDuration = (double)(System.currentTimeMillis() - start) / 1000.0;
                    out.println("Time: " + elapsedDuration + " sec(s)\n");
                    ++nStatements;
                }
                finally {
                    if (stmt == null) continue;
                    stmt.close();
                    continue;
                }
                break;
            }
        }
        catch (EOFException var7_8) {
            return nStatements;
        }
        ** GOTO lbl-1000
    }

    @Nullable
    public PName getTenantId() {
        return this.tenantId;
    }

    public Long getSCN() {
        return this.scn;
    }

    public int getMutateBatchSize() {
        return this.mutateBatchSize;
    }

    public PMetaData getMetaDataCache() {
        return this.metaData;
    }

    protected MutationState newMutationState(int maxSize) {
        return new MutationState(maxSize, this);
    }

    public MutationState getMutationState() {
        return this.mutationState;
    }

    public String getDatePattern() {
        return this.datePattern;
    }

    public Format getFormatter(PDataType type) {
        return this.formatters.get(type);
    }

    public String getURL() {
        return this.url;
    }

    public ConnectionQueryServices getQueryServices() {
        return this.services;
    }

    @Override
    public void clearWarnings() throws SQLException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeStatements() throws SQLException {
        List<SQLCloseable> statements = this.statements;
        this.statements = Lists.newArrayList();
        try {
            this.mutationState.rollback(this);
        }
        finally {
            try {
                SQLCloseables.closeAll(statements);
            }
            finally {
                statements.clear();
            }
        }
    }

    @Override
    public void close() throws SQLException {
        if (this.isClosed) {
            return;
        }
        try {
            try {
                if (this.traceScope != null) {
                    this.traceScope.close();
                }
                this.closeStatements();
            }
            finally {
                this.services.removeConnection(this);
            }
        }
        finally {
            this.isClosed = true;
        }
    }

    @Override
    public void commit() throws SQLException {
        CallRunner.run(new CallRunner.CallableThrowable<Void, SQLException>(){

            @Override
            public Void call() throws SQLException {
                PhoenixConnection.this.mutationState.commit();
                return null;
            }
        }, Tracing.withTracing(this, "committing mutations"));
        this.statementExecutionCounter = 0;
    }

    @Override
    public Array createArrayOf(String typeName, Object[] elements) throws SQLException {
        PDataType arrayPrimitiveType = PDataType.fromSqlTypeName(typeName);
        return PArrayDataType.instantiatePhoenixArray(arrayPrimitiveType, elements);
    }

    @Override
    public Blob createBlob() throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public Clob createClob() throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public NClob createNClob() throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public SQLXML createSQLXML() throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public Statement createStatement() throws SQLException {
        PhoenixStatement statement = new PhoenixStatement(this);
        this.statements.add(statement);
        return statement;
    }

    public PhoenixStatement createStatement(PhoenixStatementFactory statementFactory) throws SQLException {
        PhoenixStatement statement = statementFactory.newStatement(this);
        this.statements.add(statement);
        return statement;
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        if (resultSetType != 1003 || resultSetConcurrency != 1007) {
            throw new SQLFeatureNotSupportedException();
        }
        return this.createStatement();
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        if (resultSetHoldability != 2) {
            throw new SQLFeatureNotSupportedException();
        }
        return this.createStatement(resultSetType, resultSetConcurrency);
    }

    @Override
    public Struct createStruct(String typeName, Object[] attributes) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public boolean getAutoCommit() throws SQLException {
        return this.isAutoCommit;
    }

    public Consistency getConsistency() {
        return this.consistency;
    }

    @Override
    public String getCatalog() throws SQLException {
        return "";
    }

    @Override
    public Properties getClientInfo() throws SQLException {
        return new Properties(this.info);
    }

    @Override
    public String getClientInfo(String name) {
        return this.info.getProperty(name);
    }

    @Override
    public int getHoldability() throws SQLException {
        return 2;
    }

    @Override
    public DatabaseMetaData getMetaData() throws SQLException {
        return new PhoenixDatabaseMetaData(this);
    }

    @Override
    public int getTransactionIsolation() throws SQLException {
        return 2;
    }

    @Override
    public Map<String, Class<?>> getTypeMap() throws SQLException {
        return Collections.emptyMap();
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        return null;
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.isClosed;
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        return this.readOnly;
    }

    @Override
    public boolean isValid(int timeout) throws SQLException {
        return !this.isClosed;
    }

    @Override
    public String nativeSQL(String sql) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public CallableStatement prepareCall(String sql) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public PreparedStatement prepareStatement(String sql) throws SQLException {
        PhoenixPreparedStatement statement = new PhoenixPreparedStatement(this, sql);
        this.statements.add(statement);
        return statement;
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        if (resultSetType != 1003 || resultSetConcurrency != 1007) {
            throw new SQLFeatureNotSupportedException();
        }
        return this.prepareStatement(sql);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        if (resultSetHoldability != 2) {
            throw new SQLFeatureNotSupportedException();
        }
        return this.prepareStatement(sql, resultSetType, resultSetConcurrency);
    }

    @Override
    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void rollback() throws SQLException {
        this.mutationState.rollback(this);
        this.statementExecutionCounter = 0;
    }

    @Override
    public void rollback(Savepoint savepoint) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setAutoCommit(boolean isAutoCommit) throws SQLException {
        this.isAutoCommit = isAutoCommit;
    }

    public void setConsistency(Consistency val) {
        this.consistency = val;
    }

    @Override
    public void setCatalog(String catalog) throws SQLException {
        if (!this.getCatalog().equalsIgnoreCase(catalog)) {
            throw new SQLFeatureNotSupportedException();
        }
    }

    @Override
    public void setClientInfo(Properties properties) throws SQLClientInfoException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setClientInfo(String name, String value) throws SQLClientInfoException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setHoldability(int holdability) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setReadOnly(boolean readOnly) throws SQLException {
        this.readOnly = readOnly;
    }

    @Override
    public Savepoint setSavepoint() throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public Savepoint setSavepoint(String name) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setTransactionIsolation(int level) throws SQLException {
        if (level != 2) {
            throw new SQLFeatureNotSupportedException();
        }
    }

    @Override
    public void setTypeMap(Map<String, Class<?>> map) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return iface.isInstance(this);
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        if (!iface.isInstance(this)) {
            throw new SQLExceptionInfo.Builder(SQLExceptionCode.CLASS_NOT_UNWRAPPABLE).setMessage(this.getClass().getName() + " not unwrappable from " + iface.getName()).build().buildException();
        }
        return (T)this;
    }

    @Override
    public void setSchema(String schema) throws SQLException {
    }

    @Override
    public String getSchema() throws SQLException {
        return null;
    }

    @Override
    public void abort(Executor executor) throws SQLException {
    }

    @Override
    public void setNetworkTimeout(Executor executor, int milliseconds) throws SQLException {
    }

    @Override
    public int getNetworkTimeout() throws SQLException {
        return 0;
    }

    @Override
    public PMetaData addTable(PTable table) throws SQLException {
        if (this.scn == null || this.scn > table.getTimeStamp()) {
            this.metaData = this.metaData.addTable(table);
        }
        this.getQueryServices().addTable(table);
        return this.metaData;
    }

    @Override
    public PMetaData addFunction(PFunction function) throws SQLException {
        if (this.scn == null || this.scn > function.getTimeStamp()) {
            this.metaData = this.metaData.addFunction(function);
        }
        this.getQueryServices().addFunction(function);
        return this.metaData;
    }

    @Override
    public PMetaData addColumn(PName tenantId, String tableName, List<PColumn> columns, long tableTimeStamp, long tableSeqNum, boolean isImmutableRows, boolean isWalDisabled, boolean isMultitenant, boolean storeNulls) throws SQLException {
        this.metaData = this.metaData.addColumn(tenantId, tableName, columns, tableTimeStamp, tableSeqNum, isImmutableRows, isWalDisabled, isMultitenant, storeNulls);
        this.getQueryServices().addColumn(tenantId, tableName, columns, tableTimeStamp, tableSeqNum, isImmutableRows, isWalDisabled, isMultitenant, storeNulls);
        return this.metaData;
    }

    @Override
    public PMetaData removeTable(PName tenantId, String tableName, String parentTableName, long tableTimeStamp) throws SQLException {
        this.metaData = this.metaData.removeTable(tenantId, tableName, parentTableName, tableTimeStamp);
        this.getQueryServices().removeTable(tenantId, tableName, parentTableName, tableTimeStamp);
        return this.metaData;
    }

    @Override
    public PMetaData removeFunction(PName tenantId, String functionName, long tableTimeStamp) throws SQLException {
        this.metaData = this.metaData.removeFunction(tenantId, functionName, tableTimeStamp);
        this.getQueryServices().removeFunction(tenantId, functionName, tableTimeStamp);
        return this.metaData;
    }

    @Override
    public PMetaData removeColumn(PName tenantId, String tableName, List<PColumn> columnsToRemove, long tableTimeStamp, long tableSeqNum) throws SQLException {
        this.metaData = this.metaData.removeColumn(tenantId, tableName, columnsToRemove, tableTimeStamp, tableSeqNum);
        this.getQueryServices().removeColumn(tenantId, tableName, columnsToRemove, tableTimeStamp, tableSeqNum);
        return this.metaData;
    }

    protected boolean removeStatement(PhoenixStatement statement) throws SQLException {
        return this.statements.remove(statement);
    }

    public KeyValueBuilder getKeyValueBuilder() {
        return this.services.getKeyValueBuilder();
    }

    public int getStatementExecutionCounter() {
        return this.statementExecutionCounter;
    }

    public void incrementStatementExecutionCounter() {
        ++this.statementExecutionCounter;
    }

    public TraceScope getTraceScope() {
        return this.traceScope;
    }

    public void setTraceScope(TraceScope traceScope) {
        this.traceScope = traceScope;
    }

    public ParallelIteratorFactory getIteratorFactory() {
        return this.parallelIteratorFactory;
    }

    public void setIteratorFactory(ParallelIteratorFactory parallelIteratorFactory) {
        this.parallelIteratorFactory = parallelIteratorFactory;
    }

    static {
        Tracing.addTraceMetricsSource();
    }
}

