/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.iterate;

import com.google.common.collect.Lists;
import java.sql.SQLException;
import java.util.Collections;
import java.util.List;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.phoenix.compile.QueryPlan;
import org.apache.phoenix.iterate.LookAheadResultIterator;
import org.apache.phoenix.iterate.PeekingResultIterator;
import org.apache.phoenix.iterate.ResultIterators;
import org.apache.phoenix.query.KeyRange;
import org.apache.phoenix.util.ServerUtil;

public class UnionResultIterators
implements ResultIterators {
    private final List<KeyRange> splits;
    private final List<List<Scan>> scans;
    private final List<PeekingResultIterator> iterators;
    private final List<QueryPlan> plans;

    public UnionResultIterators(List<QueryPlan> plans) throws SQLException {
        this.plans = plans;
        int nPlans = plans.size();
        this.iterators = Lists.newArrayListWithExpectedSize(nPlans);
        this.splits = Lists.newArrayListWithExpectedSize(nPlans * 30);
        this.scans = Lists.newArrayListWithExpectedSize(nPlans * 10);
        for (QueryPlan plan : this.plans) {
            this.iterators.add(LookAheadResultIterator.wrap(plan.iterator()));
            this.splits.addAll(plan.getSplits());
            this.scans.addAll(plan.getScans());
        }
    }

    @Override
    public List<KeyRange> getSplits() {
        if (this.splits == null) {
            return Collections.emptyList();
        }
        return this.splits;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws SQLException {
        block10: {
            SQLException toThrow = null;
            try {
                if (this.iterators != null) {
                    for (int index = 0; index < this.iterators.size(); ++index) {
                        PeekingResultIterator iterator = this.iterators.get(index);
                        try {
                            iterator.close();
                            continue;
                        }
                        catch (Exception e) {
                            if (toThrow == null) {
                                toThrow = ServerUtil.parseServerException(e);
                                continue;
                            }
                            toThrow.setNextException(ServerUtil.parseServerException(e));
                        }
                    }
                }
            }
            catch (Exception e) {
                toThrow = ServerUtil.parseServerException(e);
            }
            finally {
                if (toThrow == null) break block10;
                throw toThrow;
            }
        }
    }

    @Override
    public List<List<Scan>> getScans() {
        if (this.scans == null) {
            return Collections.emptyList();
        }
        return this.scans;
    }

    @Override
    public int size() {
        return this.scans.size();
    }

    @Override
    public void explain(List<String> planSteps) {
        for (int index = 0; index < this.iterators.size(); ++index) {
            this.iterators.get(index).explain(planSteps);
        }
    }

    @Override
    public List<PeekingResultIterator> getIterators() throws SQLException {
        return this.iterators;
    }
}

