/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.iterate;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.sql.SQLException;
import java.util.List;
import org.apache.commons.io.output.DeferredFileOutputStream;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.io.WritableUtils;
import org.apache.phoenix.compile.StatementContext;
import org.apache.phoenix.iterate.ParallelIteratorFactory;
import org.apache.phoenix.iterate.PeekingResultIterator;
import org.apache.phoenix.iterate.ResultIterator;
import org.apache.phoenix.iterate.SpoolTooBigToDiskException;
import org.apache.phoenix.memory.MemoryManager;
import org.apache.phoenix.monitoring.PhoenixMetrics;
import org.apache.phoenix.query.QueryServices;
import org.apache.phoenix.schema.tuple.ResultTuple;
import org.apache.phoenix.schema.tuple.Tuple;
import org.apache.phoenix.util.ByteUtil;
import org.apache.phoenix.util.ResultUtil;
import org.apache.phoenix.util.ServerUtil;
import org.apache.phoenix.util.TupleUtil;

public class SpoolingResultIterator
implements PeekingResultIterator {
    private final PeekingResultIterator spoolFrom;

    public SpoolingResultIterator(ResultIterator scanner, QueryServices services) throws SQLException {
        this(scanner, services.getMemoryManager(), services.getProps().getInt("phoenix.query.spoolThresholdBytes", 0x1400000), services.getProps().getLong("phoenix.query.maxSpoolToDiskBytes", 1024000000L), services.getProps().get("phoenix.spool.directory", "/tmp"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    SpoolingResultIterator(ResultIterator scanner, MemoryManager mm, int thresholdBytes, long maxSpoolToDisk, String spoolDirectory) throws SQLException {
        boolean success = false;
        final MemoryManager.MemoryChunk chunk = mm.allocate(0L, thresholdBytes);
        DeferredFileOutputStream spoolTo = null;
        try {
            int size = (int)chunk.getSize();
            spoolTo = new DeferredFileOutputStream(size, "ResultSpooler", ".bin", new File(spoolDirectory)){

                @Override
                protected void thresholdReached() throws IOException {
                    super.thresholdReached();
                    chunk.close();
                }
            };
            DataOutputStream out = new DataOutputStream(spoolTo);
            long maxBytesAllowed = maxSpoolToDisk == -1L ? Long.MAX_VALUE : (long)thresholdBytes + maxSpoolToDisk;
            long bytesWritten = 0L;
            Tuple result = scanner.next();
            while (result != null) {
                int length = TupleUtil.write(result, out);
                if ((bytesWritten += (long)length) > maxBytesAllowed) {
                    throw new SpoolTooBigToDiskException("result too big, max allowed(bytes): " + maxBytesAllowed);
                }
                result = scanner.next();
            }
            if (spoolTo.isInMemory()) {
                byte[] data = spoolTo.getData();
                chunk.resize(data.length);
                this.spoolFrom = new InMemoryResultIterator(data, chunk);
            } else {
                PhoenixMetrics.CountMetric.NUM_SPOOL_FILE.increment();
                PhoenixMetrics.SizeMetric.SPOOL_FILE_SIZE.update(spoolTo.getFile().length());
                this.spoolFrom = new OnDiskResultIterator(spoolTo.getFile());
                if (spoolTo.getFile() != null) {
                    spoolTo.getFile().deleteOnExit();
                }
            }
            success = true;
        }
        catch (IOException e) {
            throw ServerUtil.parseServerException(e);
        }
        finally {
            try {
                scanner.close();
            }
            finally {
                try {
                    if (spoolTo != null) {
                        if (!success && spoolTo.getFile() != null) {
                            spoolTo.getFile().delete();
                        }
                        spoolTo.close();
                    }
                }
                catch (IOException iOException) {
                }
                finally {
                    if (!success) {
                        chunk.close();
                    }
                }
            }
        }
    }

    @Override
    public Tuple peek() throws SQLException {
        return this.spoolFrom.peek();
    }

    @Override
    public Tuple next() throws SQLException {
        return this.spoolFrom.next();
    }

    @Override
    public void close() throws SQLException {
        this.spoolFrom.close();
    }

    @Override
    public void explain(List<String> planSteps) {
    }

    private static class OnDiskResultIterator
    implements PeekingResultIterator {
        private final File file;
        private DataInputStream spoolFrom;
        private Tuple next;
        private boolean isClosed;

        private OnDiskResultIterator(File file) {
            this.file = file;
        }

        private synchronized void init() throws IOException {
            if (this.spoolFrom == null) {
                this.spoolFrom = new DataInputStream(new BufferedInputStream(new FileInputStream(this.file)));
                this.advance();
            }
        }

        private synchronized void reachedEnd() throws IOException {
            this.next = null;
            this.isClosed = true;
            try {
                if (this.spoolFrom != null) {
                    this.spoolFrom.close();
                }
            }
            finally {
                this.file.delete();
            }
        }

        private synchronized Tuple advance() throws IOException {
            int bytesRead;
            int length;
            if (this.isClosed) {
                return this.next;
            }
            try {
                length = WritableUtils.readVInt(this.spoolFrom);
            }
            catch (EOFException e) {
                this.reachedEnd();
                return this.next;
            }
            int offset = 0;
            byte[] buffer = new byte[length];
            for (int totalBytesRead = 0; totalBytesRead < length; totalBytesRead += bytesRead) {
                bytesRead = this.spoolFrom.read(buffer, offset, length);
                if (bytesRead == -1) {
                    this.reachedEnd();
                    return this.next;
                }
                offset += bytesRead;
            }
            this.next = new ResultTuple(ResultUtil.toResult(new ImmutableBytesWritable(buffer, 0, length)));
            return this.next;
        }

        @Override
        public synchronized Tuple peek() throws SQLException {
            try {
                this.init();
                return this.next;
            }
            catch (IOException e) {
                throw ServerUtil.parseServerException(e);
            }
        }

        @Override
        public synchronized Tuple next() throws SQLException {
            try {
                this.init();
                Tuple current = this.next;
                this.advance();
                return current;
            }
            catch (IOException e) {
                throw ServerUtil.parseServerException(e);
            }
        }

        @Override
        public synchronized void close() throws SQLException {
            try {
                if (!this.isClosed) {
                    this.reachedEnd();
                }
            }
            catch (IOException e) {
                throw ServerUtil.parseServerException(e);
            }
        }

        @Override
        public void explain(List<String> planSteps) {
        }
    }

    private static class InMemoryResultIterator
    implements PeekingResultIterator {
        private final MemoryManager.MemoryChunk memoryChunk;
        private final byte[] bytes;
        private Tuple next;
        private int offset;

        private InMemoryResultIterator(byte[] bytes, MemoryManager.MemoryChunk memoryChunk) throws SQLException {
            this.bytes = bytes;
            this.memoryChunk = memoryChunk;
            this.advance();
        }

        private Tuple advance() throws SQLException {
            if (this.offset >= this.bytes.length) {
                this.next = null;
                return null;
            }
            int resultSize = ByteUtil.vintFromBytes(this.bytes, this.offset);
            this.offset += WritableUtils.getVIntSize(resultSize);
            ImmutableBytesWritable value = new ImmutableBytesWritable(this.bytes, this.offset, resultSize);
            this.offset += resultSize;
            ResultTuple result = new ResultTuple(ResultUtil.toResult(value));
            this.next = result;
            return this.next;
        }

        @Override
        public Tuple peek() throws SQLException {
            return this.next;
        }

        @Override
        public Tuple next() throws SQLException {
            Tuple current = this.next;
            this.advance();
            return current;
        }

        @Override
        public void close() {
            this.memoryChunk.close();
        }

        @Override
        public void explain(List<String> planSteps) {
        }
    }

    public static class SpoolingResultIteratorFactory
    implements ParallelIteratorFactory {
        private final QueryServices services;

        public SpoolingResultIteratorFactory(QueryServices services) {
            this.services = services;
        }

        @Override
        public PeekingResultIterator newIterator(StatementContext context, ResultIterator scanner, Scan scan) throws SQLException {
            return new SpoolingResultIterator(scanner, this.services);
        }
    }
}

