/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.iterate;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.NavigableSet;
import java.util.Queue;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.UUID;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.filter.FirstKeyOnlyFilter;
import org.apache.hadoop.hbase.filter.PageFilter;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.phoenix.compile.QueryPlan;
import org.apache.phoenix.compile.RowProjector;
import org.apache.phoenix.compile.ScanRanges;
import org.apache.phoenix.compile.StatementContext;
import org.apache.phoenix.exception.SQLExceptionCode;
import org.apache.phoenix.exception.SQLExceptionInfo;
import org.apache.phoenix.filter.ColumnProjectionFilter;
import org.apache.phoenix.hbase.index.util.ImmutableBytesPtr;
import org.apache.phoenix.iterate.ConcatResultIterator;
import org.apache.phoenix.iterate.ExplainTable;
import org.apache.phoenix.iterate.ParallelScanGrouper;
import org.apache.phoenix.iterate.PeekingResultIterator;
import org.apache.phoenix.iterate.ResultIterators;
import org.apache.phoenix.monitoring.PhoenixMetrics;
import org.apache.phoenix.parse.FilterableStatement;
import org.apache.phoenix.parse.HintNode;
import org.apache.phoenix.query.ConnectionQueryServices;
import org.apache.phoenix.query.KeyRange;
import org.apache.phoenix.query.QueryConstants;
import org.apache.phoenix.schema.MetaDataClient;
import org.apache.phoenix.schema.PColumnFamily;
import org.apache.phoenix.schema.PTable;
import org.apache.phoenix.schema.StaleRegionBoundaryCacheException;
import org.apache.phoenix.schema.TableRef;
import org.apache.phoenix.schema.stats.GuidePostsInfo;
import org.apache.phoenix.schema.stats.PTableStats;
import org.apache.phoenix.util.ByteUtil;
import org.apache.phoenix.util.LogUtil;
import org.apache.phoenix.util.SQLCloseables;
import org.apache.phoenix.util.ScanUtil;
import org.apache.phoenix.util.SchemaUtil;
import org.apache.phoenix.util.ServerUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseResultIterators
extends ExplainTable
implements ResultIterators {
    private static final Logger logger = LoggerFactory.getLogger(BaseResultIterators.class);
    private static final int ESTIMATED_GUIDEPOSTS_PER_REGION = 20;
    private final List<List<Scan>> scans;
    private final List<KeyRange> splits;
    private final PTableStats tableStats;
    private final byte[] physicalTableName;
    private final QueryPlan plan;
    protected final String scanId;
    private final ParallelScanGrouper scanGrouper;
    private final List<List<List<Pair<Scan, Future<PeekingResultIterator>>>>> allFutures;
    static final Function<HRegionLocation, KeyRange> TO_KEY_RANGE = new Function<HRegionLocation, KeyRange>(){

        @Override
        public KeyRange apply(HRegionLocation region) {
            return KeyRange.getKeyRange(region.getRegionInfo().getStartKey(), region.getRegionInfo().getEndKey());
        }
    };

    private PTable getTable() {
        return this.plan.getTableRef().getTable();
    }

    private boolean useStats() {
        Scan scan = this.context.getScan();
        boolean isPointLookup = this.context.getScanRanges().isPointLookup();
        return !isPointLookup && !ScanUtil.isAnalyzeTable(scan);
    }

    public BaseResultIterators(QueryPlan plan, Integer perScanLimit, ParallelScanGrouper scanGrouper) throws SQLException {
        boolean keyOnlyFilter;
        Scan scan;
        FilterableStatement statement;
        PTable table;
        StatementContext context;
        block8: {
            Object ecf;
            block6: {
                Map<byte[], NavigableSet<byte[]>> familyMap;
                block7: {
                    super(plan.getContext(), plan.getTableRef(), plan.getGroupBy(), plan.getOrderBy(), plan.getStatement().getHint(), plan.getLimit());
                    this.plan = plan;
                    this.scanGrouper = scanGrouper;
                    context = plan.getContext();
                    TableRef tableRef = plan.getTableRef();
                    table = tableRef.getTable();
                    statement = plan.getStatement();
                    RowProjector projector = plan.getProjector();
                    this.physicalTableName = table.getPhysicalName().getBytes();
                    this.tableStats = this.useStats() ? new MetaDataClient(context.getConnection()).getTableStats(table) : PTableStats.EMPTY_STATS;
                    scan = context.getScan();
                    this.scanId = UUID.randomUUID().toString();
                    familyMap = scan.getFamilyMap();
                    boolean bl = keyOnlyFilter = familyMap.isEmpty() && context.getWhereCoditionColumns().isEmpty();
                    if (!projector.isProjectEmptyKeyValue()) break block6;
                    if (!familyMap.isEmpty() || !context.getWhereCoditionColumns().isEmpty() || table.getColumnFamilies().size() != 1) break block7;
                    scan.addFamily(table.getColumnFamilies().get(0).getName().getBytes());
                    break block8;
                }
                ecf = SchemaUtil.getEmptyColumnFamily(table);
                if (familyMap.containsKey(ecf) && familyMap.get(ecf) == null) break block8;
                scan.addColumn((byte[])ecf, QueryConstants.EMPTY_COLUMN_BYTES);
                break block8;
            }
            if (table.getViewType() == PTable.ViewType.MAPPED) {
                ecf = table.getColumnFamilies().iterator();
                while (ecf.hasNext()) {
                    PColumnFamily family = (PColumnFamily)ecf.next();
                    scan.addFamily(family.getName().getBytes());
                }
            }
        }
        if (keyOnlyFilter) {
            ScanUtil.andFilterAtBeginning(scan, new FirstKeyOnlyFilter());
        }
        if (perScanLimit != null) {
            ScanUtil.andFilterAtEnd(scan, new PageFilter(perScanLimit.intValue()));
        }
        this.doColumnProjectionOptimization(context, scan, table, statement);
        this.scans = this.getParallelScans();
        ArrayList<KeyRange> splitRanges = Lists.newArrayListWithExpectedSize(this.scans.size() * 20);
        for (List<Scan> scanList : this.scans) {
            for (Scan aScan : scanList) {
                splitRanges.add(KeyRange.getKeyRange(aScan.getStartRow(), aScan.getStopRow()));
            }
        }
        this.splits = ImmutableList.copyOf(splitRanges);
        this.allFutures = Lists.newArrayListWithExpectedSize(1);
    }

    private void doColumnProjectionOptimization(StatementContext context, Scan scan, PTable table, FilterableStatement statement) {
        Map<byte[], NavigableSet<byte[]>> familyMap = scan.getFamilyMap();
        if (familyMap != null && !familyMap.isEmpty()) {
            boolean useOptimization;
            TreeMap<ImmutableBytesPtr, NavigableSet<ImmutableBytesPtr>> columnsTracker = new TreeMap<ImmutableBytesPtr, NavigableSet<ImmutableBytesPtr>>();
            TreeSet<byte[]> conditionOnlyCfs = new TreeSet<byte[]>(Bytes.BYTES_COMPARATOR);
            int referencedCfCount = familyMap.size();
            for (Pair<byte[], byte[]> whereCol : context.getWhereCoditionColumns()) {
                if (familyMap.containsKey(whereCol.getFirst())) continue;
                ++referencedCfCount;
            }
            if (statement.getHint().hasHint(HintNode.Hint.SEEK_TO_COLUMN)) {
                useOptimization = false;
            } else if (statement.getHint().hasHint(HintNode.Hint.NO_SEEK_TO_COLUMN)) {
                useOptimization = true;
            } else {
                boolean bl = useOptimization = referencedCfCount == 1;
            }
            if (useOptimization) {
                for (Map.Entry entry : familyMap.entrySet()) {
                    ImmutableBytesPtr cf = new ImmutableBytesPtr((byte[])entry.getKey());
                    NavigableSet qs = (NavigableSet)entry.getValue();
                    TreeSet<ImmutableBytesPtr> cols = null;
                    if (qs != null) {
                        cols = new TreeSet<ImmutableBytesPtr>();
                        for (byte[] q : qs) {
                            cols.add(new ImmutableBytesPtr(q));
                        }
                    }
                    columnsTracker.put(cf, cols);
                }
            }
            for (Pair pair : context.getWhereCoditionColumns()) {
                if (useOptimization) {
                    if (familyMap.containsKey(pair.getFirst())) continue;
                    scan.addFamily((byte[])pair.getFirst());
                    conditionOnlyCfs.add((byte[])pair.getFirst());
                    continue;
                }
                if (familyMap.containsKey(pair.getFirst())) {
                    NavigableSet<byte[]> cols = familyMap.get(pair.getFirst());
                    if (cols == null) continue;
                    scan.addColumn((byte[])pair.getFirst(), (byte[])pair.getSecond());
                    continue;
                }
                scan.addColumn((byte[])pair.getFirst(), (byte[])pair.getSecond());
            }
            if (useOptimization && !columnsTracker.isEmpty()) {
                for (ImmutableBytesPtr immutableBytesPtr : columnsTracker.keySet()) {
                    scan.addFamily(immutableBytesPtr.get());
                }
                if (!statement.isAggregate()) {
                    ScanUtil.andFilterAtEnd(scan, new ColumnProjectionFilter(SchemaUtil.getEmptyColumnFamily(table), columnsTracker, conditionOnlyCfs));
                }
            }
        }
    }

    @Override
    public List<KeyRange> getSplits() {
        if (this.splits == null) {
            return Collections.emptyList();
        }
        return this.splits;
    }

    @Override
    public List<List<Scan>> getScans() {
        if (this.scans == null) {
            return Collections.emptyList();
        }
        return this.scans;
    }

    private static List<byte[]> toBoundaries(List<HRegionLocation> regionLocations) {
        int nBoundaries = regionLocations.size() - 1;
        ArrayList<byte[]> ranges = Lists.newArrayListWithExpectedSize(nBoundaries);
        for (int i = 0; i < nBoundaries; ++i) {
            HRegionInfo regionInfo = regionLocations.get(i).getRegionInfo();
            ranges.add(regionInfo.getEndKey());
        }
        return ranges;
    }

    private static int getIndexContainingInclusive(List<byte[]> boundaries, byte[] inclusiveKey) {
        int guideIndex = Collections.binarySearch(boundaries, inclusiveKey, Bytes.BYTES_COMPARATOR);
        guideIndex = guideIndex < 0 ? -(guideIndex + 1) : guideIndex + 1;
        return guideIndex;
    }

    private static int getIndexContainingExclusive(List<byte[]> boundaries, byte[] exclusiveKey) {
        int guideIndex = Collections.binarySearch(boundaries, exclusiveKey, Bytes.BYTES_COMPARATOR);
        guideIndex = guideIndex < 0 ? -(guideIndex + 1) : guideIndex;
        return guideIndex;
    }

    private List<byte[]> getGuidePosts() {
        if (!this.useStats()) {
            return Collections.emptyList();
        }
        List<byte[]> gps = null;
        PTable table = this.getTable();
        SortedMap<byte[], GuidePostsInfo> guidePostMap = this.tableStats.getGuidePosts();
        byte[] defaultCF = SchemaUtil.getEmptyColumnFamily(this.getTable());
        if (table.getColumnFamilies().isEmpty()) {
            if (guidePostMap.get(defaultCF) != null) {
                gps = ((GuidePostsInfo)guidePostMap.get(defaultCF)).getGuidePosts();
            }
        } else {
            Scan scan = this.context.getScan();
            if (scan.getFamilyMap().size() > 0 && !scan.getFamilyMap().containsKey(defaultCF)) {
                GuidePostsInfo guidePostsInfo = (GuidePostsInfo)guidePostMap.get(scan.getFamilyMap().keySet().iterator().next());
                if (guidePostsInfo != null) {
                    gps = guidePostsInfo.getGuidePosts();
                }
            } else if (guidePostMap.get(defaultCF) != null) {
                gps = ((GuidePostsInfo)guidePostMap.get(defaultCF)).getGuidePosts();
            }
        }
        if (gps == null) {
            return Collections.emptyList();
        }
        return gps;
    }

    private static String toString(List<byte[]> gps) {
        StringBuilder buf = new StringBuilder(gps.size() * 100);
        buf.append("[");
        for (int i = 0; i < gps.size(); ++i) {
            buf.append(Bytes.toStringBinary(gps.get(i)));
            buf.append(",");
            if (i <= 0 || i >= gps.size() - 1 || i % 10 != 0) continue;
            buf.append("\n");
        }
        buf.setCharAt(buf.length() - 1, ']');
        return buf.toString();
    }

    private List<Scan> addNewScan(List<List<Scan>> parallelScans, List<Scan> scans, Scan scan, byte[] startKey, boolean crossedRegionBoundary) {
        boolean startNewScan = this.scanGrouper.shouldStartNewScan(this.plan, scans, startKey, crossedRegionBoundary);
        if (scan != null) {
            scans.add(scan);
        }
        if (startNewScan && !scans.isEmpty()) {
            parallelScans.add(scans);
            scans = Lists.newArrayListWithExpectedSize(1);
        }
        return scans;
    }

    private List<List<Scan>> getParallelScans() throws SQLException {
        return this.getParallelScans(ByteUtil.EMPTY_BYTE_ARRAY, ByteUtil.EMPTY_BYTE_ARRAY);
    }

    private List<List<Scan>> getParallelScans(byte[] startKey, byte[] stopKey) throws SQLException {
        boolean traverseAllRegions;
        Scan scan = this.context.getScan();
        List<HRegionLocation> regionLocations = this.context.getConnection().getQueryServices().getAllTableRegions(this.physicalTableName);
        List<byte[]> regionBoundaries = BaseResultIterators.toBoundaries(regionLocations);
        ScanRanges scanRanges = this.context.getScanRanges();
        PTable table = this.getTable();
        boolean isSalted = table.getBucketNum() != null;
        boolean isLocalIndex = table.getIndexType() == PTable.IndexType.LOCAL;
        List<byte[]> gps = this.getGuidePosts();
        if (logger.isDebugEnabled()) {
            logger.debug("Guideposts: " + BaseResultIterators.toString(gps));
        }
        boolean bl = traverseAllRegions = isSalted || isLocalIndex;
        if (!traverseAllRegions) {
            byte[] scanStartRow = scan.getStartRow();
            if (scanStartRow.length != 0 && Bytes.compareTo(scanStartRow, startKey) > 0) {
                startKey = scanStartRow;
            }
            byte[] scanStopRow = scan.getStopRow();
            if (stopKey.length == 0 || Bytes.compareTo(scanStopRow, stopKey) < 0) {
                stopKey = scanStopRow;
            }
        }
        int regionIndex = 0;
        int stopIndex = regionBoundaries.size();
        if (startKey.length > 0) {
            regionIndex = BaseResultIterators.getIndexContainingInclusive(regionBoundaries, startKey);
        }
        if (stopKey.length > 0) {
            stopIndex = Math.min(stopIndex, regionIndex + BaseResultIterators.getIndexContainingExclusive(regionBoundaries.subList(regionIndex, stopIndex), stopKey));
            if (isLocalIndex) {
                stopKey = regionLocations.get(stopIndex).getRegionInfo().getEndKey();
            }
        }
        ArrayList<List<Scan>> parallelScans = Lists.newArrayListWithExpectedSize(stopIndex - regionIndex + 1);
        byte[] currentKey = startKey;
        int guideIndex = currentKey.length == 0 ? 0 : BaseResultIterators.getIndexContainingInclusive(gps, currentKey);
        int gpsSize = gps.size();
        int estGuidepostsPerRegion = gpsSize == 0 ? 1 : gpsSize / regionLocations.size() + 1;
        int keyOffset = 0;
        List<Scan> scans = Lists.newArrayListWithExpectedSize(estGuidepostsPerRegion);
        while (regionIndex <= stopIndex) {
            Scan newScan;
            byte[] currentGuidePost;
            byte[] endRegionKey = ByteUtil.EMPTY_BYTE_ARRAY;
            byte[] endKey = regionIndex == stopIndex ? stopKey : regionBoundaries.get(regionIndex);
            if (isLocalIndex) {
                HRegionInfo regionInfo = regionLocations.get(regionIndex).getRegionInfo();
                endRegionKey = regionInfo.getEndKey();
                keyOffset = ScanUtil.getRowKeyOffset(regionInfo.getStartKey(), endRegionKey);
            }
            while (guideIndex < gpsSize && (Bytes.compareTo(currentGuidePost = gps.get(guideIndex), endKey) <= 0 || endKey.length == 0)) {
                newScan = scanRanges.intersectScan(scan, currentKey, currentGuidePost, keyOffset, false);
                scans = this.addNewScan(parallelScans, scans, newScan, currentGuidePost, false);
                currentKey = currentGuidePost;
                ++guideIndex;
            }
            newScan = scanRanges.intersectScan(scan, currentKey, endKey, keyOffset, true);
            if (isLocalIndex) {
                if (newScan != null) {
                    newScan.setAttribute("_ExpectedUpperRegionKey", endRegionKey);
                } else if (!scans.isEmpty()) {
                    ((Scan)scans.get(scans.size() - 1)).setAttribute("_ExpectedUpperRegionKey", endRegionKey);
                }
            }
            scans = this.addNewScan(parallelScans, scans, newScan, endKey, true);
            currentKey = endKey;
            ++regionIndex;
        }
        if (!scans.isEmpty()) {
            parallelScans.add(scans);
        }
        return parallelScans;
    }

    public static <T> List<T> reverseIfNecessary(List<T> list, boolean reverse) {
        if (!reverse) {
            return list;
        }
        return Lists.reverse(list);
    }

    @Override
    public List<PeekingResultIterator> getIterators() throws SQLException {
        Scan scan = this.context.getScan();
        if (logger.isDebugEnabled()) {
            logger.debug(LogUtil.addCustomAnnotations("Getting iterators for " + this, ScanUtil.getCustomAnnotations(scan)));
        }
        boolean isReverse = ScanUtil.isReversed(scan);
        boolean isLocalIndex = this.getTable().getIndexType() == PTable.IndexType.LOCAL;
        ConnectionQueryServices services = this.context.getConnection().getQueryServices();
        int queryTimeOut = this.context.getStatement().getQueryTimeout() * 1000;
        long startTime = System.currentTimeMillis();
        long maxQueryEndTime = startTime + (long)queryTimeOut;
        ConcurrentLinkedQueue<PeekingResultIterator> allIterators = new ConcurrentLinkedQueue<PeekingResultIterator>();
        int numScans = this.size();
        ArrayList<PeekingResultIterator> iterators = new ArrayList<PeekingResultIterator>(numScans);
        return this.getIterators(this.scans, services, isLocalIndex, allIterators, iterators, isReverse, maxQueryEndTime, this.splits.size());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public List<PeekingResultIterator> getIterators(List<List<Scan>> scan, ConnectionQueryServices services, boolean isLocalIndex, Queue<PeekingResultIterator> allIterators, List<PeekingResultIterator> iterators, boolean isReverse, long maxQueryEndTime, int splitSize) throws SQLException {
        block86: {
            boolean success = false;
            ArrayList<List<Pair<Scan, Future<PeekingResultIterator>>>> futures = Lists.newArrayListWithExpectedSize(scan.size());
            this.allFutures.add(futures);
            SQLException toThrow = null;
            try {
                this.submitWork(scan, futures, allIterators, splitSize);
                boolean clearedCache = false;
                for (List<Pair<Scan, Future<PeekingResultIterator>>> future : BaseResultIterators.reverseIfNecessary(futures, isReverse)) {
                    ArrayList<PeekingResultIterator> concatIterators = Lists.newArrayListWithExpectedSize(future.size());
                    for (Pair<Scan, Future<PeekingResultIterator>> scanPair : BaseResultIterators.reverseIfNecessary(future, isReverse)) {
                        try {
                            long timeOutForScan = maxQueryEndTime - System.currentTimeMillis();
                            if (timeOutForScan < 0L) {
                                throw new SQLExceptionInfo.Builder(SQLExceptionCode.OPERATION_TIMED_OUT).setMessage(". Query couldn't be completed in the alloted time: " + this.context.getStatement().getQueryTimeout() * 1000 + " ms").build().buildException();
                            }
                            PeekingResultIterator iterator2 = scanPair.getSecond().get(timeOutForScan, TimeUnit.MILLISECONDS);
                            concatIterators.add(iterator2);
                        }
                        catch (ExecutionException e) {
                            try {
                                throw ServerUtil.parseServerException(e);
                            }
                            catch (StaleRegionBoundaryCacheException e2) {
                                if (!clearedCache) {
                                    services.clearTableRegionCache(this.physicalTableName);
                                }
                                Scan oldScan = scanPair.getFirst();
                                byte[] startKey = oldScan.getStartRow();
                                byte[] endKey = oldScan.getStopRow();
                                if (isLocalIndex) {
                                    endKey = oldScan.getAttribute("_ExpectedUpperRegionKey");
                                }
                                List<List<Scan>> newNestedScans = this.getParallelScans(startKey, endKey);
                                this.addIterator(iterators, concatIterators);
                                concatIterators = Lists.newArrayList();
                                this.getIterators(newNestedScans, services, isLocalIndex, allIterators, iterators, isReverse, maxQueryEndTime, newNestedScans.size());
                            }
                        }
                    }
                    this.addIterator(iterators, concatIterators);
                }
                success = true;
                List<PeekingResultIterator> list = iterators;
                return list;
            }
            catch (TimeoutException e) {
                PhoenixMetrics.CountMetric.QUERY_TIMEOUT.increment();
                toThrow = new SQLExceptionInfo.Builder(SQLExceptionCode.OPERATION_TIMED_OUT).setMessage(". Query couldn't be completed in the alloted time: " + this.context.getStatement().getQueryTimeout() * 1000 + " ms").setRootCause(e).build().buildException();
                return toThrow;
            }
            catch (SQLException e) {
                toThrow = e;
                return toThrow;
            }
            catch (Exception e) {
                toThrow = ServerUtil.parseServerException(e);
                return toThrow;
            }
            finally {
                try {
                    if (!success) {
                        this.close();
                        try {
                            SQLCloseables.closeAll(allIterators);
                        }
                        catch (Exception e) {
                            if (toThrow == null) {
                                toThrow = ServerUtil.parseServerException(e);
                            }
                            toThrow.setNextException(ServerUtil.parseServerException(e));
                        }
                        catch (Exception e) {
                            block84: {
                                try {
                                    if (toThrow == null) {
                                        toThrow = ServerUtil.parseServerException(e);
                                        break block84;
                                    }
                                    toThrow.setNextException(ServerUtil.parseServerException(e));
                                }
                                catch (Throwable throwable) {
                                    block85: {
                                        try {
                                            SQLCloseables.closeAll(allIterators);
                                        }
                                        catch (Exception e2) {
                                            if (toThrow == null) {
                                                toThrow = ServerUtil.parseServerException(e2);
                                                break block85;
                                            }
                                            toThrow.setNextException(ServerUtil.parseServerException(e2));
                                        }
                                    }
                                    throw throwable;
                                }
                            }
                            try {
                                SQLCloseables.closeAll(allIterators);
                            }
                            catch (Exception e3) {
                                if (toThrow == null) {
                                    toThrow = ServerUtil.parseServerException(e3);
                                }
                                toThrow.setNextException(ServerUtil.parseServerException(e3));
                            }
                        }
                    }
                }
                finally {
                    if (toThrow == null) break block86;
                    PhoenixMetrics.CountMetric.FAILED_QUERY.increment();
                    throw toThrow;
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws SQLException {
        boolean cancelledWork = false;
        try {
            for (List<List<Pair<Scan, Future<PeekingResultIterator>>>> futures : this.allFutures) {
                for (List<Pair<Scan, Future<PeekingResultIterator>>> futureScans : futures) {
                    for (Pair<Scan, Future<PeekingResultIterator>> futurePair : futureScans) {
                        Future<PeekingResultIterator> future;
                        if (futurePair == null || (future = futurePair.getSecond()) == null) continue;
                        cancelledWork |= future.cancel(false);
                    }
                }
            }
        }
        finally {
            if (cancelledWork) {
                this.context.getConnection().getQueryServices().getExecutor().purge();
            }
        }
    }

    private void addIterator(List<PeekingResultIterator> parentIterators, List<PeekingResultIterator> childIterators) throws SQLException {
        if (!childIterators.isEmpty()) {
            if (this.plan.useRoundRobinIterator()) {
                parentIterators.addAll(childIterators);
            } else {
                parentIterators.add(ConcatResultIterator.newIterator(childIterators));
            }
        }
    }

    protected abstract String getName();

    protected abstract void submitWork(List<List<Scan>> var1, List<List<Pair<Scan, Future<PeekingResultIterator>>>> var2, Queue<PeekingResultIterator> var3, int var4);

    @Override
    public int size() {
        return this.scans.size();
    }

    @Override
    public void explain(List<String> planSteps) {
        boolean displayChunkCount = this.context.getConnection().getQueryServices().getProps().getBoolean("phoenix.explain.displayChunkCount", true);
        StringBuilder buf = new StringBuilder();
        buf.append("CLIENT " + (displayChunkCount ? this.splits.size() + "-CHUNK " : "") + this.getName() + " " + this.size() + "-WAY ");
        this.explain(buf.toString(), planSteps);
    }

    public String toString() {
        return "ResultIterators [name=" + this.getName() + ",id=" + this.scanId + ",scans=" + this.scans + "]";
    }

    protected static final class ScanLocator {
        private final int outerListIndex;
        private final int innerListIndex;
        private final Scan scan;

        public ScanLocator(Scan scan, int outerListIndex, int innerListIndex) {
            this.outerListIndex = outerListIndex;
            this.innerListIndex = innerListIndex;
            this.scan = scan;
        }

        public int getOuterListIndex() {
            return this.outerListIndex;
        }

        public int getInnerListIndex() {
            return this.innerListIndex;
        }

        public Scan getScan() {
            return this.scan;
        }
    }
}

