/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.hbase.index.write.recovery;

import com.google.common.collect.Multimap;
import java.io.IOException;
import java.util.List;
import org.apache.hadoop.hbase.Stoppable;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessorEnvironment;
import org.apache.hadoop.hbase.regionserver.Region;
import org.apache.phoenix.hbase.index.exception.MultiIndexWriteFailureException;
import org.apache.phoenix.hbase.index.table.HTableInterfaceReference;
import org.apache.phoenix.hbase.index.write.IndexFailurePolicy;
import org.apache.phoenix.hbase.index.write.KillServerOnFailurePolicy;
import org.apache.phoenix.hbase.index.write.recovery.PerRegionIndexWriteCache;

public class StoreFailuresInCachePolicy
implements IndexFailurePolicy {
    private KillServerOnFailurePolicy delegate;
    private PerRegionIndexWriteCache cache;
    private Region region;

    public StoreFailuresInCachePolicy(PerRegionIndexWriteCache failedIndexEdits) {
        this.cache = failedIndexEdits;
    }

    @Override
    public void setup(Stoppable parent, RegionCoprocessorEnvironment env) {
        this.region = env.getRegion();
        this.delegate = new KillServerOnFailurePolicy();
        this.delegate.setup(parent, env);
    }

    @Override
    public void handleFailure(Multimap<HTableInterfaceReference, Mutation> attempted, Exception cause) throws IOException {
        if (!(cause instanceof MultiIndexWriteFailureException)) {
            this.delegate.handleFailure(attempted, cause);
        }
        List<HTableInterfaceReference> failedTables = ((MultiIndexWriteFailureException)cause).getFailedTables();
        for (HTableInterfaceReference table : failedTables) {
            this.cache.addEdits(this.region, table, attempted.get(table));
        }
    }

    @Override
    public void stop(String why) {
        this.delegate.stop(why);
    }

    @Override
    public boolean isStopped() {
        return this.delegate.isStopped();
    }
}

