/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.hbase.index.write.recovery;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.regionserver.Region;
import org.apache.phoenix.hbase.index.table.HTableInterfaceReference;

public class PerRegionIndexWriteCache {
    private Map<Region, Multimap<HTableInterfaceReference, Mutation>> cache = new HashMap<Region, Multimap<HTableInterfaceReference, Mutation>>();

    public Multimap<HTableInterfaceReference, Mutation> getEdits(Region region) {
        return this.cache.remove(region);
    }

    public void addEdits(Region region, HTableInterfaceReference table, Collection<Mutation> collection) {
        Multimap<HTableInterfaceReference, Mutation> edits = this.cache.get(region);
        if (edits == null) {
            edits = ArrayListMultimap.create();
            this.cache.put(region, edits);
        }
        edits.putAll(table, collection);
    }
}

