/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.hbase.index.table;

import java.io.IOException;
import java.util.Map;
import org.apache.commons.collections.map.AbstractLinkedMap;
import org.apache.commons.collections.map.LRUMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.client.HTableInterface;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.phoenix.hbase.index.table.HTableFactory;
import org.apache.phoenix.hbase.index.util.ImmutableBytesPtr;

public class CachingHTableFactory
implements HTableFactory {
    private static final Log LOG = LogFactory.getLog(CachingHTableFactory.class);
    private static final String CACHE_SIZE_KEY = "index.tablefactory.cache.size";
    private static final int DEFAULT_CACHE_SIZE = 10;
    private HTableFactory delegate;
    Map openTables;

    public static int getCacheSize(Configuration conf) {
        return conf.getInt(CACHE_SIZE_KEY, 10);
    }

    public CachingHTableFactory(HTableFactory tableFactory, Configuration conf) {
        this(tableFactory, CachingHTableFactory.getCacheSize(conf));
    }

    public CachingHTableFactory(HTableFactory factory, int cacheSize) {
        this.delegate = factory;
        this.openTables = new HTableInterfaceLRUMap(cacheSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HTableInterface getTable(ImmutableBytesPtr tablename) throws IOException {
        ImmutableBytesPtr tableBytes = new ImmutableBytesPtr(tablename);
        Map map = this.openTables;
        synchronized (map) {
            HTableInterface table = (HTableInterface)this.openTables.get(tableBytes);
            if (table == null) {
                table = this.delegate.getTable(tablename);
                this.openTables.put(tableBytes, table);
            }
            return table;
        }
    }

    @Override
    public void shutdown() {
        this.delegate.shutdown();
    }

    public class HTableInterfaceLRUMap
    extends LRUMap {
        public HTableInterfaceLRUMap(int cacheSize) {
            super(cacheSize);
        }

        @Override
        protected boolean removeLRU(AbstractLinkedMap.LinkEntry entry) {
            HTableInterface table = (HTableInterface)entry.getValue();
            if (LOG.isDebugEnabled()) {
                LOG.debug("Closing connection to table: " + Bytes.toString(table.getTableName()) + " because it was evicted from the cache.");
            }
            try {
                table.close();
            }
            catch (IOException e) {
                LOG.info("Failed to correctly close HTable: " + Bytes.toString(table.getTableName()) + " ignoring since being removed from queue.");
            }
            return true;
        }
    }
}

