/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.hbase.index.covered.update;

import com.google.common.collect.Iterators;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.PriorityQueue;

class SortedCollection<T>
implements Collection<T>,
Iterable<T> {
    private PriorityQueue<T> queue;
    private Comparator<T> comparator;

    public SortedCollection(Comparator<T> comparator) {
        this.queue = new PriorityQueue<T>(1, comparator);
        this.comparator = comparator;
    }

    public SortedCollection() {
        this.queue = new PriorityQueue();
    }

    @Override
    public int size() {
        return this.queue.size();
    }

    @Override
    public boolean isEmpty() {
        return this.queue.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.queue.contains(o);
    }

    @Override
    public Iterator<T> iterator() {
        Object[] array = this.queue.toArray();
        if (this.comparator == null) {
            Arrays.sort(array);
        } else {
            Arrays.sort(array, this.comparator);
        }
        return Iterators.forArray(array);
    }

    @Override
    public Object[] toArray() {
        return this.queue.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.queue.toArray(a);
    }

    @Override
    public boolean add(T e) {
        return this.queue.add(e);
    }

    @Override
    public boolean remove(Object o) {
        return this.queue.remove(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.queue.containsAll(c);
    }

    @Override
    public boolean addAll(Collection<? extends T> c) {
        return this.queue.addAll(c);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return this.queue.removeAll(c);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return this.queue.retainAll(c);
    }

    @Override
    public void clear() {
        this.queue.clear();
    }
}

