/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.hbase.index.covered;

import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.phoenix.hbase.index.covered.update.ColumnTracker;

public class IndexUpdate {
    Mutation update;
    byte[] tableName;
    ColumnTracker columns;

    public IndexUpdate(ColumnTracker tracker) {
        this.columns = tracker;
    }

    public void setUpdate(Mutation p) {
        this.update = p;
    }

    public void setTable(byte[] tableName) {
        this.tableName = tableName;
    }

    public Mutation getUpdate() {
        return this.update;
    }

    public byte[] getTableName() {
        return this.tableName;
    }

    public ColumnTracker getIndexedColumns() {
        return this.columns;
    }

    public String toString() {
        return "IndexUpdate: \n\ttable - " + Bytes.toString(this.tableName) + "\n\tupdate: " + this.update + "\n\tcolumns: " + this.columns;
    }

    public static IndexUpdate createIndexUpdateForTesting(ColumnTracker tracker, byte[] table, Put p) {
        IndexUpdate update = new IndexUpdate(tracker);
        update.setTable(table);
        update.setUpdate(p);
        return update;
    }

    public boolean isValid() {
        return this.tableName != null && this.update != null;
    }
}

