/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.filter;

import java.io.IOException;
import org.apache.hadoop.hbase.exceptions.DeserializationException;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Writables;
import org.apache.phoenix.expression.Expression;
import org.apache.phoenix.filter.MultiKeyValueComparisonFilter;

public class MultiCFCQKeyValueComparisonFilter
extends MultiKeyValueComparisonFilter {
    private final ImmutablePairBytesPtr ptr = new ImmutablePairBytesPtr();

    public MultiCFCQKeyValueComparisonFilter() {
    }

    public MultiCFCQKeyValueComparisonFilter(Expression expression) {
        super(expression);
    }

    @Override
    protected Object setColumnKey(byte[] cf, int cfOffset, int cfLength, byte[] cq, int cqOffset, int cqLength) {
        this.ptr.set(cf, cfOffset, cfLength, cq, cqOffset, cqLength);
        return this.ptr;
    }

    @Override
    protected Object newColumnKey(byte[] cf, int cfOffset, int cfLength, byte[] cq, int cqOffset, int cqLength) {
        byte[] cfKey;
        if (cfOffset == 0 && cf.length == cfLength) {
            cfKey = cf;
        } else {
            cfKey = new byte[cfLength];
            System.arraycopy(cf, cfOffset, cfKey, 0, cfLength);
        }
        this.cfSet.add(cfKey);
        return new ImmutablePairBytesPtr(cf, cfOffset, cfLength, cq, cqOffset, cqLength);
    }

    public static MultiCFCQKeyValueComparisonFilter parseFrom(byte[] pbBytes) throws DeserializationException {
        try {
            return (MultiCFCQKeyValueComparisonFilter)Writables.getWritable(pbBytes, new MultiCFCQKeyValueComparisonFilter());
        }
        catch (IOException e) {
            throw new DeserializationException(e);
        }
    }

    private static class ImmutablePairBytesPtr {
        private byte[] bytes1;
        private int offset1;
        private int length1;
        private byte[] bytes2;
        private int offset2;
        private int length2;
        private int hashCode;

        private ImmutablePairBytesPtr() {
        }

        private ImmutablePairBytesPtr(byte[] bytes1, int offset1, int length1, byte[] bytes2, int offset2, int length2) {
            this.set(bytes1, offset1, length1, bytes2, offset2, length2);
        }

        public int hashCode() {
            return this.hashCode;
        }

        public void set(byte[] bytes1, int offset1, int length1, byte[] bytes2, int offset2, int length2) {
            int i;
            this.bytes1 = bytes1;
            this.offset1 = offset1;
            this.length1 = length1;
            this.bytes2 = bytes2;
            this.offset2 = offset2;
            this.length2 = length2;
            int hash = 1;
            for (i = offset1; i < offset1 + length1; ++i) {
                hash = 31 * hash + bytes1[i];
            }
            for (i = offset2; i < offset2 + length2; ++i) {
                hash = 31 * hash + bytes2[i];
            }
            this.hashCode = hash;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ImmutablePairBytesPtr that = (ImmutablePairBytesPtr)obj;
            if (this.hashCode != that.hashCode) {
                return false;
            }
            if (Bytes.compareTo(this.bytes2, this.offset2, this.length2, that.bytes2, that.offset2, that.length2) != 0) {
                return false;
            }
            return Bytes.compareTo(this.bytes1, this.offset1, this.length1, that.bytes1, that.offset1, that.length1) == 0;
        }
    }
}

