/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.expression.function;

import java.sql.SQLException;
import java.util.List;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.phoenix.expression.Expression;
import org.apache.phoenix.expression.function.ScalarFunction;
import org.apache.phoenix.parse.FunctionParseNode;
import org.apache.phoenix.schema.tuple.Tuple;
import org.apache.phoenix.schema.types.PDataType;
import org.apache.phoenix.schema.types.PDecimal;
import org.apache.phoenix.schema.types.PInteger;
import org.apache.phoenix.schema.types.PNumericType;

@FunctionParseNode.BuiltInFunction(name="SIGN", args={@FunctionParseNode.Argument(allowedTypes={PDecimal.class})})
public class SignFunction
extends ScalarFunction {
    public static final String NAME = "SIGN";
    private static final byte[][] RESULT = new byte[][]{PInteger.INSTANCE.toBytes(-1), PInteger.INSTANCE.toBytes(0), PInteger.INSTANCE.toBytes(1)};

    public SignFunction() {
    }

    public SignFunction(List<Expression> children) throws SQLException {
        super(children);
    }

    @Override
    public boolean evaluate(Tuple tuple, ImmutableBytesWritable ptr) {
        Expression childExpr = (Expression)this.children.get(0);
        PDataType dataType = childExpr.getDataType();
        if (childExpr.evaluate(tuple, ptr)) {
            int ret = ((PNumericType)dataType).signum(ptr, childExpr.getSortOrder());
            ptr.set(RESULT[ret + 1]);
            return true;
        }
        return false;
    }

    @Override
    public PDataType getDataType() {
        return PInteger.INSTANCE;
    }

    @Override
    public String getName() {
        return NAME;
    }
}

