/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.expression.function;

import com.google.common.collect.Lists;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.sql.Date;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.hadoop.hbase.filter.CompareFilter;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.io.WritableUtils;
import org.apache.phoenix.compile.KeyPart;
import org.apache.phoenix.expression.Determinism;
import org.apache.phoenix.expression.Expression;
import org.apache.phoenix.expression.LiteralExpression;
import org.apache.phoenix.expression.function.FunctionExpression;
import org.apache.phoenix.expression.function.ScalarFunction;
import org.apache.phoenix.expression.function.TimeUnit;
import org.apache.phoenix.query.KeyRange;
import org.apache.phoenix.schema.PColumn;
import org.apache.phoenix.schema.SortOrder;
import org.apache.phoenix.schema.tuple.Tuple;
import org.apache.phoenix.schema.types.PDataType;
import org.apache.phoenix.schema.types.PInteger;
import org.apache.phoenix.schema.types.PVarchar;
import org.apache.phoenix.util.ByteUtil;

public class RoundDateExpression
extends ScalarFunction {
    long divBy;
    public static final String NAME = "ROUND";
    private static final long[] TIME_UNIT_MS = new long[]{86400000L, 3600000L, 60000L, 1000L, 1L};

    public RoundDateExpression() {
    }

    public static Expression create(Expression expr, TimeUnit timeUnit) throws SQLException {
        return RoundDateExpression.create(expr, timeUnit, 1);
    }

    public static Expression create(Expression expr, TimeUnit timeUnit, int multiplier) throws SQLException {
        Expression timeUnitExpr = RoundDateExpression.getTimeUnitExpr(timeUnit);
        Expression defaultMultiplierExpr = RoundDateExpression.getMultiplierExpr(multiplier);
        ArrayList<Expression> expressions = Lists.newArrayList(expr, timeUnitExpr, defaultMultiplierExpr);
        return RoundDateExpression.create(expressions);
    }

    public static Expression create(List<Expression> children) throws SQLException {
        return new RoundDateExpression(children);
    }

    static Expression getTimeUnitExpr(TimeUnit timeUnit) throws SQLException {
        return LiteralExpression.newConstant((Object)timeUnit.name(), (PDataType)PVarchar.INSTANCE, Determinism.ALWAYS);
    }

    static Expression getMultiplierExpr(int multiplier) throws SQLException {
        return LiteralExpression.newConstant((Object)multiplier, (PDataType)PInteger.INSTANCE, Determinism.ALWAYS);
    }

    RoundDateExpression(List<Expression> children) {
        super(children.subList(0, 1));
        int numChildren = children.size();
        if (numChildren < 2 || numChildren > 3) {
            throw new IllegalArgumentException("Wrong number of arguments : " + numChildren);
        }
        Object timeUnitValue = ((LiteralExpression)children.get(1)).getValue();
        Object multiplierValue = numChildren > 2 ? ((LiteralExpression)children.get(2)).getValue() : null;
        int multiplier = multiplierValue == null ? 1 : ((Number)multiplierValue).intValue();
        TimeUnit timeUnit = TimeUnit.getTimeUnit(timeUnitValue != null ? timeUnitValue.toString() : null);
        this.divBy = (long)multiplier * TIME_UNIT_MS[timeUnit.ordinal()];
    }

    protected long getRoundUpAmount() {
        return this.divBy / 2L;
    }

    protected long roundTime(long time) {
        long roundUpAmount = this.getRoundUpAmount();
        long value = time <= Long.MAX_VALUE - roundUpAmount ? (time + roundUpAmount) / this.divBy : (time - roundUpAmount) / this.divBy + 1L;
        return value * this.divBy;
    }

    @Override
    public boolean evaluate(Tuple tuple, ImmutableBytesWritable ptr) {
        if (((Expression)this.children.get(0)).evaluate(tuple, ptr)) {
            PDataType dataType = this.getDataType();
            long time = dataType.getCodec().decodeLong(ptr, ((Expression)this.children.get(0)).getSortOrder());
            long value = this.roundTime(time);
            Date d = new Date(value);
            byte[] byteValue = dataType.toBytes(d);
            ptr.set(byteValue);
            return true;
        }
        return false;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        long roundUpAmount = this.getRoundUpAmount();
        result = 31 * result + (int)(this.divBy ^ this.divBy >>> 32);
        result = 31 * result + (int)(roundUpAmount ^ roundUpAmount >>> 32);
        result = 31 * result + ((Expression)this.children.get(0)).hashCode();
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RoundDateExpression other = (RoundDateExpression)obj;
        if (this.divBy != other.divBy) {
            return false;
        }
        if (this.getRoundUpAmount() != other.getRoundUpAmount()) {
            return false;
        }
        return ((Expression)this.children.get(0)).equals(other.children.get(0));
    }

    @Override
    public void readFields(DataInput input) throws IOException {
        super.readFields(input);
        this.divBy = WritableUtils.readVLong(input);
    }

    @Override
    public void write(DataOutput output) throws IOException {
        super.write(output);
        WritableUtils.writeVLong(output, this.divBy);
    }

    @Override
    public Integer getMaxLength() {
        return ((Expression)this.children.get(0)).getMaxLength();
    }

    @Override
    public PDataType getDataType() {
        return ((Expression)this.children.get(0)).getDataType();
    }

    @Override
    public boolean isNullable() {
        return ((Expression)this.children.get(0)).isNullable() || this.divBy == 0L;
    }

    protected PDataType.PDataCodec getKeyRangeCodec(PDataType columnDataType) {
        return columnDataType.getCodec();
    }

    @Override
    public KeyPart newKeyPart(final KeyPart childPart) {
        return new KeyPart(){
            private final List<Expression> extractNodes;
            {
                this.extractNodes = Collections.singletonList(RoundDateExpression.this);
            }

            @Override
            public PColumn getColumn() {
                return childPart.getColumn();
            }

            @Override
            public List<Expression> getExtractNodes() {
                return this.extractNodes;
            }

            @Override
            public KeyRange getKeyRange(CompareFilter.CompareOp op, Expression rhs) {
                PDataType type = this.getColumn().getDataType();
                ImmutableBytesWritable ptr = new ImmutableBytesWritable();
                rhs.evaluate(null, ptr);
                byte[] key = ByteUtil.copyKeyBytesIfNecessary(ptr);
                PDataType.PDataCodec codec = RoundDateExpression.this.getKeyRangeCodec(type);
                int offset = ByteUtil.isInclusive(op) ? 1 : 0;
                long value = codec.decodeLong(key, 0, SortOrder.getDefault());
                byte[] nextKey = new byte[type.getByteSize().intValue()];
                switch (op) {
                    case EQUAL: {
                        if (value % RoundDateExpression.this.divBy != 0L) {
                            return KeyRange.EMPTY_RANGE;
                        }
                        codec.encodeLong(value + RoundDateExpression.this.divBy, nextKey, 0);
                        return type.getKeyRange(key, true, nextKey, false);
                    }
                    case GREATER: 
                    case GREATER_OR_EQUAL: {
                        codec.encodeLong((value + RoundDateExpression.this.divBy - (long)offset) / RoundDateExpression.this.divBy * RoundDateExpression.this.divBy, nextKey, 0);
                        return type.getKeyRange(nextKey, true, KeyRange.UNBOUND, false);
                    }
                    case LESS: 
                    case LESS_OR_EQUAL: {
                        codec.encodeLong((value + RoundDateExpression.this.divBy - (long)(1 - offset)) / RoundDateExpression.this.divBy * RoundDateExpression.this.divBy, nextKey, 0);
                        return type.getKeyRange(KeyRange.UNBOUND, false, nextKey, false);
                    }
                }
                return childPart.getKeyRange(op, rhs);
            }
        };
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public FunctionExpression.OrderPreserving preservesOrder() {
        return FunctionExpression.OrderPreserving.YES;
    }

    @Override
    public int getKeyFormationTraversalIndex() {
        return 0;
    }
}

