/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.expression.function;

import java.sql.SQLException;
import java.util.List;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.phoenix.exception.SQLExceptionCode;
import org.apache.phoenix.exception.SQLExceptionInfo;
import org.apache.phoenix.expression.CoerceExpression;
import org.apache.phoenix.expression.Expression;
import org.apache.phoenix.expression.function.ScalarFunction;
import org.apache.phoenix.hbase.index.util.ImmutableBytesPtr;
import org.apache.phoenix.parse.FunctionParseNode;
import org.apache.phoenix.schema.tuple.Tuple;
import org.apache.phoenix.schema.types.PDataType;
import org.apache.phoenix.util.ExpressionUtil;

@FunctionParseNode.BuiltInFunction(name="COALESCE", args={@FunctionParseNode.Argument, @FunctionParseNode.Argument})
public class CoalesceFunction
extends ScalarFunction {
    public static final String NAME = "COALESCE";

    public CoalesceFunction() {
    }

    public CoalesceFunction(List<Expression> children) throws SQLException {
        super(children);
        Expression firstChild = children.get(0);
        Expression secondChild = children.get(1);
        if (ExpressionUtil.isConstant(secondChild)) {
            ImmutableBytesPtr ptr = new ImmutableBytesPtr();
            secondChild.evaluate(null, ptr);
            if (!secondChild.getDataType().isCoercibleTo(firstChild.getDataType(), secondChild.getDataType().toObject(ptr))) {
                throw new SQLExceptionInfo.Builder(SQLExceptionCode.TYPE_MISMATCH).setMessage(this.getName() + " expected " + firstChild.getDataType() + ", but got " + secondChild.getDataType()).build().buildException();
            }
        } else if (!secondChild.getDataType().isCoercibleTo(this.getDataType())) {
            children.add(1, CoerceExpression.create(secondChild, firstChild.getDataType()));
        }
    }

    @Override
    public boolean evaluate(Tuple tuple, ImmutableBytesWritable ptr) {
        Expression secondChild;
        boolean evaluated = ((Expression)this.children.get(0)).evaluate(tuple, ptr);
        if (evaluated) {
            return true;
        }
        if (tuple.isImmutable() && (secondChild = (Expression)this.children.get(1)).evaluate(tuple, ptr)) {
            this.getDataType().coerceBytes(ptr, secondChild.getDataType(), secondChild.getSortOrder(), this.getSortOrder());
            return true;
        }
        return false;
    }

    @Override
    public PDataType getDataType() {
        return ((Expression)this.children.get(0)).getDataType();
    }

    @Override
    public Integer getMaxLength() {
        Integer maxLength2;
        Integer maxLength1 = ((Expression)this.children.get(0)).getMaxLength();
        if (maxLength1 != null && (maxLength2 = ((Expression)this.children.get(1)).getMaxLength()) != null) {
            return maxLength1 > maxLength2 ? maxLength1 : maxLength2;
        }
        return null;
    }

    @Override
    public boolean isNullable() {
        return ((Expression)this.children.get(0)).isNullable() && ((Expression)this.children.get(1)).isNullable();
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public boolean requiresFinalEvaluation() {
        return true;
    }
}

