/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.expression.function;

import com.google.common.collect.Lists;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.apache.phoenix.expression.Expression;
import org.apache.phoenix.expression.function.RoundDateExpression;
import org.apache.phoenix.expression.function.TimeUnit;

public class CeilDateExpression
extends RoundDateExpression {
    public CeilDateExpression() {
    }

    public static Expression create(Expression expr, TimeUnit timeUnit) throws SQLException {
        return CeilDateExpression.create(expr, timeUnit, 1);
    }

    public static Expression create(Expression expr, TimeUnit timeUnit, int multiplier) throws SQLException {
        Expression timeUnitExpr = CeilDateExpression.getTimeUnitExpr(timeUnit);
        Expression defaultMultiplierExpr = CeilDateExpression.getMultiplierExpr(multiplier);
        ArrayList<Expression> expressions = Lists.newArrayList(expr, timeUnitExpr, defaultMultiplierExpr);
        return CeilDateExpression.create(expressions);
    }

    public static Expression create(List<Expression> children) throws SQLException {
        return new CeilDateExpression(children);
    }

    CeilDateExpression(List<Expression> children) {
        super(children);
    }

    @Override
    protected long getRoundUpAmount() {
        return this.divBy - 1L;
    }

    @Override
    public String getName() {
        return "CEIL";
    }
}

