/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.expression.aggregator;

import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.phoenix.expression.aggregator.Aggregator;
import org.apache.phoenix.expression.function.SingleAggregateFunction;
import org.apache.phoenix.schema.KeyValueSchema;
import org.apache.phoenix.schema.ValueBitSet;
import org.apache.phoenix.schema.tuple.Tuple;

public abstract class Aggregators {
    protected final int estimatedByteSize;
    protected final KeyValueSchema schema;
    protected final ImmutableBytesWritable ptr = new ImmutableBytesWritable();
    protected final ValueBitSet valueSet;
    protected final Aggregator[] aggregators;
    protected final SingleAggregateFunction[] functions;

    public int getEstimatedByteSize() {
        return this.estimatedByteSize;
    }

    public Aggregators(SingleAggregateFunction[] functions, Aggregator[] aggregators, int minNullableIndex) {
        this.functions = functions;
        this.aggregators = aggregators;
        this.estimatedByteSize = Aggregators.calculateSize(aggregators);
        this.schema = Aggregators.newValueSchema(aggregators, minNullableIndex);
        this.valueSet = ValueBitSet.newInstance(this.schema);
    }

    public KeyValueSchema getValueSchema() {
        return this.schema;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(this.getClass().getName() + " [" + this.functions.length + "]:");
        for (int i = 0; i < this.functions.length; ++i) {
            SingleAggregateFunction function = this.functions[i];
            buf.append("\t" + i + ") " + function);
        }
        return buf.toString();
    }

    public SingleAggregateFunction[] getFunctions() {
        return this.functions;
    }

    public abstract void aggregate(Aggregator[] var1, Tuple var2);

    protected static int calculateSize(Aggregator[] aggregators) {
        int size = 24 + 8 * aggregators.length;
        for (Aggregator aggregator : aggregators) {
            size += aggregator.getSize();
        }
        return size;
    }

    private static KeyValueSchema newValueSchema(Aggregator[] aggregators, int minNullableIndex) {
        KeyValueSchema.KeyValueSchemaBuilder builder = new KeyValueSchema.KeyValueSchemaBuilder(minNullableIndex);
        for (int i = 0; i < aggregators.length; ++i) {
            Aggregator aggregator = aggregators[i];
            builder.addField(aggregator);
        }
        return builder.build();
    }

    public byte[] toBytes(Aggregator[] aggregators) {
        return this.schema.toBytes(aggregators, this.valueSet, this.ptr);
    }

    public int getAggregatorCount() {
        return this.aggregators.length;
    }

    public Aggregator[] getAggregators() {
        return this.aggregators;
    }

    public abstract Aggregator[] newAggregators();

    public void reset(Aggregator[] aggregators) {
        for (int i = 0; i < aggregators.length; ++i) {
            aggregators[i].reset();
        }
    }

    protected Aggregator getAggregator(int position) {
        return this.aggregators[position];
    }
}

