/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.expression;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.hadoop.hbase.filter.CompareFilter;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.io.WritableUtils;
import org.apache.phoenix.expression.BaseExpression;
import org.apache.phoenix.expression.BaseSingleExpression;
import org.apache.phoenix.expression.ComparisonExpression;
import org.apache.phoenix.expression.Determinism;
import org.apache.phoenix.expression.Expression;
import org.apache.phoenix.expression.LiteralExpression;
import org.apache.phoenix.expression.NotExpression;
import org.apache.phoenix.expression.visitor.ExpressionVisitor;
import org.apache.phoenix.hbase.index.util.ImmutableBytesPtr;
import org.apache.phoenix.schema.SortOrder;
import org.apache.phoenix.schema.tuple.Tuple;
import org.apache.phoenix.schema.types.PBoolean;
import org.apache.phoenix.schema.types.PDataType;
import org.apache.phoenix.util.ByteUtil;
import org.apache.phoenix.util.ExpressionUtil;

public class InListExpression
extends BaseSingleExpression {
    private Set<ImmutableBytesPtr> values;
    private ImmutableBytesPtr minValue;
    private ImmutableBytesPtr maxValue;
    private int valuesByteLength;
    private int fixedWidth = -1;
    private List<Expression> keyExpressions;

    public static Expression create(List<Expression> children, boolean isNegate, ImmutableBytesWritable ptr) throws SQLException {
        Expression firstChild = children.get(0);
        if (firstChild.isStateless() && (!firstChild.evaluate(null, ptr) || ptr.getLength() == 0)) {
            return LiteralExpression.newConstant(null, (PDataType)PBoolean.INSTANCE, firstChild.getDeterminism());
        }
        if (children.size() == 2) {
            return ComparisonExpression.create(isNegate ? CompareFilter.CompareOp.NOT_EQUAL : CompareFilter.CompareOp.EQUAL, children, ptr);
        }
        boolean addedNull = false;
        SQLException sqlE = null;
        ArrayList<Expression> coercedKeyExpressions = Lists.newArrayListWithExpectedSize(children.size());
        coercedKeyExpressions.add(firstChild);
        for (int i = 1; i < children.size(); ++i) {
            try {
                Expression rhs = BaseExpression.coerce(firstChild, children.get(i), CompareFilter.CompareOp.EQUAL);
                coercedKeyExpressions.add(rhs);
                continue;
            }
            catch (SQLException e) {
                sqlE = e;
            }
        }
        if (coercedKeyExpressions.size() == 1) {
            throw sqlE;
        }
        if (coercedKeyExpressions.size() == 2 && addedNull) {
            return LiteralExpression.newConstant(null, (PDataType)PBoolean.INSTANCE, Determinism.ALWAYS);
        }
        Expression expression = new InListExpression(coercedKeyExpressions);
        if (isNegate) {
            expression = NotExpression.create(expression, ptr);
        }
        if (ExpressionUtil.isConstant(expression)) {
            return ExpressionUtil.getConstantExpression(expression, ptr);
        }
        return expression;
    }

    public InListExpression() {
    }

    public InListExpression(List<Expression> keyExpressions) {
        super(keyExpressions.get(0));
        this.keyExpressions = keyExpressions.subList(1, keyExpressions.size());
        HashSet<ImmutableBytesPtr> values = Sets.newHashSetWithExpectedSize(keyExpressions.size() - 1);
        int fixedWidth = -1;
        boolean isFixedLength = true;
        for (int i = 1; i < keyExpressions.size(); ++i) {
            ImmutableBytesPtr ptr = new ImmutableBytesPtr();
            Expression child = keyExpressions.get(i);
            child.evaluate(null, ptr);
            if (ptr.getLength() <= 0 || !values.add(ptr)) continue;
            int length = ptr.getLength();
            if (fixedWidth == -1) {
                fixedWidth = length;
            } else {
                isFixedLength &= fixedWidth == length;
            }
            this.valuesByteLength += ptr.getLength();
        }
        this.fixedWidth = isFixedLength ? fixedWidth : -1;
        ImmutableBytesPtr[] valuesArray = values.toArray(new ImmutableBytesPtr[values.size()]);
        Arrays.sort(valuesArray, ByteUtil.BYTES_PTR_COMPARATOR);
        if (values.isEmpty()) {
            this.minValue = ByteUtil.EMPTY_BYTE_ARRAY_PTR;
            this.maxValue = ByteUtil.EMPTY_BYTE_ARRAY_PTR;
            this.values = Collections.emptySet();
        } else {
            this.minValue = valuesArray[0];
            this.maxValue = valuesArray[valuesArray.length - 1];
            this.values = new LinkedHashSet<ImmutableBytesPtr>(Arrays.asList(valuesArray));
        }
    }

    @Override
    public boolean evaluate(Tuple tuple, ImmutableBytesWritable ptr) {
        if (!this.getChild().evaluate(tuple, ptr)) {
            return false;
        }
        if (ptr.getLength() == 0) {
            ptr.set(ByteUtil.EMPTY_BYTE_ARRAY);
            return true;
        }
        if (this.values.contains(ptr)) {
            ptr.set(PDataType.TRUE_BYTES);
            return true;
        }
        ptr.set(PDataType.FALSE_BYTES);
        return true;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.values.hashCode();
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        InListExpression other = (InListExpression)obj;
        return this.values.equals(other.values);
    }

    @Override
    public PDataType getDataType() {
        return PBoolean.INSTANCE;
    }

    private int readValue(DataInput input, byte[] valuesBytes, int offset, ImmutableBytesPtr ptr) throws IOException {
        int valueLen = this.fixedWidth == -1 ? WritableUtils.readVInt(input) : this.fixedWidth;
        this.values.add(new ImmutableBytesPtr(valuesBytes, offset, valueLen));
        return offset + valueLen;
    }

    @Override
    public void readFields(DataInput input) throws IOException {
        super.readFields(input);
        input.readBoolean();
        this.fixedWidth = WritableUtils.readVInt(input);
        byte[] valuesBytes = Bytes.readByteArray(input);
        this.valuesByteLength = valuesBytes.length;
        int len = this.fixedWidth == -1 ? WritableUtils.readVInt(input) : this.valuesByteLength / this.fixedWidth;
        this.values = Sets.newLinkedHashSetWithExpectedSize(len);
        int offset = 0;
        int i = 0;
        if (i < len) {
            this.minValue = new ImmutableBytesPtr();
            offset = this.readValue(input, valuesBytes, offset, this.minValue);
            while (++i < len - 1) {
                offset = this.readValue(input, valuesBytes, offset, new ImmutableBytesPtr());
            }
            if (i < len) {
                this.maxValue = new ImmutableBytesPtr();
                offset = this.readValue(input, valuesBytes, offset, this.maxValue);
            } else {
                this.maxValue = this.minValue;
            }
        } else {
            this.minValue = this.maxValue = new ImmutableBytesPtr(ByteUtil.EMPTY_BYTE_ARRAY);
        }
    }

    @Override
    public void write(DataOutput output) throws IOException {
        super.write(output);
        output.writeBoolean(false);
        WritableUtils.writeVInt(output, this.fixedWidth);
        WritableUtils.writeVInt(output, this.valuesByteLength);
        for (ImmutableBytesPtr ptr : this.values) {
            output.write(ptr.get(), ptr.getOffset(), ptr.getLength());
        }
        if (this.fixedWidth == -1) {
            WritableUtils.writeVInt(output, this.values.size());
            for (ImmutableBytesPtr ptr : this.values) {
                WritableUtils.writeVInt(output, ptr.getLength());
            }
        }
    }

    @Override
    public final <T> T accept(ExpressionVisitor<T> visitor) {
        List<T> l = this.acceptChildren(visitor, visitor.visitEnter(this));
        T t = visitor.visitLeave(this, l);
        if (t == null) {
            t = visitor.defaultReturn(this, l);
        }
        return t;
    }

    public List<Expression> getKeyExpressions() {
        return this.keyExpressions;
    }

    public ImmutableBytesWritable getMinKey() {
        return this.minValue;
    }

    public ImmutableBytesWritable getMaxKey() {
        return this.maxValue;
    }

    public String toString() {
        int maxToStringLen = 200;
        Expression firstChild = (Expression)this.children.get(0);
        PDataType type = firstChild.getDataType();
        StringBuilder buf = new StringBuilder(firstChild + " IN (");
        for (ImmutableBytesPtr value : this.values) {
            if (firstChild.getSortOrder() != null) {
                type.coerceBytes(value, type, firstChild.getSortOrder(), SortOrder.getDefault());
            }
            buf.append(type.toStringLiteral(value, null));
            buf.append(',');
            if (buf.length() < maxToStringLen) continue;
            buf.append("... ");
            break;
        }
        buf.setCharAt(buf.length() - 1, ')');
        return buf.toString();
    }
}

