/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.coprocessor;

import com.google.common.cache.Cache;
import com.google.common.collect.Lists;
import com.google.protobuf.ByteString;
import com.google.protobuf.RpcCallback;
import com.google.protobuf.RpcController;
import com.google.protobuf.Service;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.Coprocessor;
import org.apache.hadoop.hbase.CoprocessorEnvironment;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.HTableInterface;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.coprocessor.CoprocessorException;
import org.apache.hadoop.hbase.coprocessor.CoprocessorService;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessorEnvironment;
import org.apache.hadoop.hbase.filter.CompareFilter;
import org.apache.hadoop.hbase.filter.FilterList;
import org.apache.hadoop.hbase.filter.FirstKeyOnlyFilter;
import org.apache.hadoop.hbase.filter.SingleColumnValueFilter;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.regionserver.Region;
import org.apache.hadoop.hbase.regionserver.RegionScanner;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.phoenix.cache.GlobalCache;
import org.apache.phoenix.compile.ScanRanges;
import org.apache.phoenix.coprocessor.MetaDataProtocol;
import org.apache.phoenix.coprocessor.SuffixFilter;
import org.apache.phoenix.coprocessor.generated.MetaDataProtos;
import org.apache.phoenix.expression.LiteralExpression;
import org.apache.phoenix.hbase.index.covered.update.ColumnReference;
import org.apache.phoenix.hbase.index.util.GenericKeyValueBuilder;
import org.apache.phoenix.hbase.index.util.ImmutableBytesPtr;
import org.apache.phoenix.hbase.index.util.IndexManagementUtil;
import org.apache.phoenix.index.IndexMaintainer;
import org.apache.phoenix.jdbc.PhoenixConnection;
import org.apache.phoenix.jdbc.PhoenixDatabaseMetaData;
import org.apache.phoenix.metrics.Metrics;
import org.apache.phoenix.parse.LiteralParseNode;
import org.apache.phoenix.parse.PFunction;
import org.apache.phoenix.protobuf.ProtobufUtil;
import org.apache.phoenix.query.KeyRange;
import org.apache.phoenix.query.QueryConstants;
import org.apache.phoenix.schema.AmbiguousColumnException;
import org.apache.phoenix.schema.ColumnFamilyNotFoundException;
import org.apache.phoenix.schema.ColumnNotFoundException;
import org.apache.phoenix.schema.PColumn;
import org.apache.phoenix.schema.PColumnFamily;
import org.apache.phoenix.schema.PColumnImpl;
import org.apache.phoenix.schema.PIndexState;
import org.apache.phoenix.schema.PMetaDataEntity;
import org.apache.phoenix.schema.PName;
import org.apache.phoenix.schema.PNameFactory;
import org.apache.phoenix.schema.PTable;
import org.apache.phoenix.schema.PTableImpl;
import org.apache.phoenix.schema.PTableType;
import org.apache.phoenix.schema.SortOrder;
import org.apache.phoenix.schema.TableNotFoundException;
import org.apache.phoenix.schema.stats.PTableStats;
import org.apache.phoenix.schema.stats.StatisticsUtil;
import org.apache.phoenix.schema.tuple.ResultTuple;
import org.apache.phoenix.schema.types.PBinary;
import org.apache.phoenix.schema.types.PBoolean;
import org.apache.phoenix.schema.types.PDataType;
import org.apache.phoenix.schema.types.PInteger;
import org.apache.phoenix.schema.types.PLong;
import org.apache.phoenix.schema.types.PVarbinary;
import org.apache.phoenix.schema.types.PVarchar;
import org.apache.phoenix.trace.util.Tracing;
import org.apache.phoenix.util.ByteUtil;
import org.apache.phoenix.util.EnvironmentEdgeManager;
import org.apache.phoenix.util.KeyValueUtil;
import org.apache.phoenix.util.MetaDataUtil;
import org.apache.phoenix.util.QueryUtil;
import org.apache.phoenix.util.ScanUtil;
import org.apache.phoenix.util.SchemaUtil;
import org.apache.phoenix.util.ServerUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetaDataEndpointImpl
extends MetaDataProtocol
implements CoprocessorService,
Coprocessor {
    private static final Logger logger = LoggerFactory.getLogger(MetaDataEndpointImpl.class);
    private static final KeyValue TABLE_TYPE_KV = KeyValue.createFirstOnRow(ByteUtil.EMPTY_BYTE_ARRAY, PhoenixDatabaseMetaData.TABLE_FAMILY_BYTES, PhoenixDatabaseMetaData.TABLE_TYPE_BYTES);
    private static final KeyValue TABLE_SEQ_NUM_KV = KeyValue.createFirstOnRow(ByteUtil.EMPTY_BYTE_ARRAY, PhoenixDatabaseMetaData.TABLE_FAMILY_BYTES, PhoenixDatabaseMetaData.TABLE_SEQ_NUM_BYTES);
    private static final KeyValue COLUMN_COUNT_KV = KeyValue.createFirstOnRow(ByteUtil.EMPTY_BYTE_ARRAY, PhoenixDatabaseMetaData.TABLE_FAMILY_BYTES, PhoenixDatabaseMetaData.COLUMN_COUNT_BYTES);
    private static final KeyValue SALT_BUCKETS_KV = KeyValue.createFirstOnRow(ByteUtil.EMPTY_BYTE_ARRAY, PhoenixDatabaseMetaData.TABLE_FAMILY_BYTES, PhoenixDatabaseMetaData.SALT_BUCKETS_BYTES);
    private static final KeyValue PK_NAME_KV = KeyValue.createFirstOnRow(ByteUtil.EMPTY_BYTE_ARRAY, PhoenixDatabaseMetaData.TABLE_FAMILY_BYTES, PhoenixDatabaseMetaData.PK_NAME_BYTES);
    private static final KeyValue DATA_TABLE_NAME_KV = KeyValue.createFirstOnRow(ByteUtil.EMPTY_BYTE_ARRAY, PhoenixDatabaseMetaData.TABLE_FAMILY_BYTES, PhoenixDatabaseMetaData.DATA_TABLE_NAME_BYTES);
    private static final KeyValue INDEX_STATE_KV = KeyValue.createFirstOnRow(ByteUtil.EMPTY_BYTE_ARRAY, PhoenixDatabaseMetaData.TABLE_FAMILY_BYTES, PhoenixDatabaseMetaData.INDEX_STATE_BYTES);
    private static final KeyValue IMMUTABLE_ROWS_KV = KeyValue.createFirstOnRow(ByteUtil.EMPTY_BYTE_ARRAY, PhoenixDatabaseMetaData.TABLE_FAMILY_BYTES, PhoenixDatabaseMetaData.IMMUTABLE_ROWS_BYTES);
    private static final KeyValue VIEW_EXPRESSION_KV = KeyValue.createFirstOnRow(ByteUtil.EMPTY_BYTE_ARRAY, PhoenixDatabaseMetaData.TABLE_FAMILY_BYTES, PhoenixDatabaseMetaData.VIEW_STATEMENT_BYTES);
    private static final KeyValue DEFAULT_COLUMN_FAMILY_KV = KeyValue.createFirstOnRow(ByteUtil.EMPTY_BYTE_ARRAY, PhoenixDatabaseMetaData.TABLE_FAMILY_BYTES, PhoenixDatabaseMetaData.DEFAULT_COLUMN_FAMILY_NAME_BYTES);
    private static final KeyValue DISABLE_WAL_KV = KeyValue.createFirstOnRow(ByteUtil.EMPTY_BYTE_ARRAY, PhoenixDatabaseMetaData.TABLE_FAMILY_BYTES, PhoenixDatabaseMetaData.DISABLE_WAL_BYTES);
    private static final KeyValue MULTI_TENANT_KV = KeyValue.createFirstOnRow(ByteUtil.EMPTY_BYTE_ARRAY, PhoenixDatabaseMetaData.TABLE_FAMILY_BYTES, PhoenixDatabaseMetaData.MULTI_TENANT_BYTES);
    private static final KeyValue VIEW_TYPE_KV = KeyValue.createFirstOnRow(ByteUtil.EMPTY_BYTE_ARRAY, PhoenixDatabaseMetaData.TABLE_FAMILY_BYTES, PhoenixDatabaseMetaData.VIEW_TYPE_BYTES);
    private static final KeyValue VIEW_INDEX_ID_KV = KeyValue.createFirstOnRow(ByteUtil.EMPTY_BYTE_ARRAY, PhoenixDatabaseMetaData.TABLE_FAMILY_BYTES, PhoenixDatabaseMetaData.VIEW_INDEX_ID_BYTES);
    private static final KeyValue INDEX_TYPE_KV = KeyValue.createFirstOnRow(ByteUtil.EMPTY_BYTE_ARRAY, PhoenixDatabaseMetaData.TABLE_FAMILY_BYTES, PhoenixDatabaseMetaData.INDEX_TYPE_BYTES);
    private static final KeyValue INDEX_DISABLE_TIMESTAMP_KV = KeyValue.createFirstOnRow(ByteUtil.EMPTY_BYTE_ARRAY, PhoenixDatabaseMetaData.TABLE_FAMILY_BYTES, PhoenixDatabaseMetaData.INDEX_DISABLE_TIMESTAMP_BYTES);
    private static final KeyValue STORE_NULLS_KV = KeyValue.createFirstOnRow(ByteUtil.EMPTY_BYTE_ARRAY, PhoenixDatabaseMetaData.TABLE_FAMILY_BYTES, PhoenixDatabaseMetaData.STORE_NULLS_BYTES);
    private static final KeyValue EMPTY_KEYVALUE_KV = KeyValue.createFirstOnRow(ByteUtil.EMPTY_BYTE_ARRAY, PhoenixDatabaseMetaData.TABLE_FAMILY_BYTES, QueryConstants.EMPTY_COLUMN_BYTES);
    private static final List<KeyValue> TABLE_KV_COLUMNS = Arrays.asList(EMPTY_KEYVALUE_KV, TABLE_TYPE_KV, TABLE_SEQ_NUM_KV, COLUMN_COUNT_KV, SALT_BUCKETS_KV, PK_NAME_KV, DATA_TABLE_NAME_KV, INDEX_STATE_KV, IMMUTABLE_ROWS_KV, VIEW_EXPRESSION_KV, DEFAULT_COLUMN_FAMILY_KV, DISABLE_WAL_KV, MULTI_TENANT_KV, VIEW_TYPE_KV, VIEW_INDEX_ID_KV, INDEX_TYPE_KV, INDEX_DISABLE_TIMESTAMP_KV, STORE_NULLS_KV);
    private static final int TABLE_TYPE_INDEX;
    private static final int TABLE_SEQ_NUM_INDEX;
    private static final int COLUMN_COUNT_INDEX;
    private static final int SALT_BUCKETS_INDEX;
    private static final int PK_NAME_INDEX;
    private static final int DATA_TABLE_NAME_INDEX;
    private static final int INDEX_STATE_INDEX;
    private static final int IMMUTABLE_ROWS_INDEX;
    private static final int VIEW_STATEMENT_INDEX;
    private static final int DEFAULT_COLUMN_FAMILY_INDEX;
    private static final int DISABLE_WAL_INDEX;
    private static final int MULTI_TENANT_INDEX;
    private static final int VIEW_TYPE_INDEX;
    private static final int VIEW_INDEX_ID_INDEX;
    private static final int INDEX_TYPE_INDEX;
    private static final int STORE_NULLS_INDEX;
    private static final KeyValue DECIMAL_DIGITS_KV;
    private static final KeyValue COLUMN_SIZE_KV;
    private static final KeyValue NULLABLE_KV;
    private static final KeyValue DATA_TYPE_KV;
    private static final KeyValue ORDINAL_POSITION_KV;
    private static final KeyValue SORT_ORDER_KV;
    private static final KeyValue ARRAY_SIZE_KV;
    private static final KeyValue VIEW_CONSTANT_KV;
    private static final KeyValue IS_VIEW_REFERENCED_KV;
    private static final KeyValue COLUMN_DEF_KV;
    private static final KeyValue IS_ROW_TIMESTAMP_KV;
    private static final List<KeyValue> COLUMN_KV_COLUMNS;
    private static final int DECIMAL_DIGITS_INDEX;
    private static final int COLUMN_SIZE_INDEX;
    private static final int NULLABLE_INDEX;
    private static final int DATA_TYPE_INDEX;
    private static final int ORDINAL_POSITION_INDEX;
    private static final int SORT_ORDER_INDEX;
    private static final int ARRAY_SIZE_INDEX;
    private static final int VIEW_CONSTANT_INDEX;
    private static final int IS_VIEW_REFERENCED_INDEX;
    private static final int COLUMN_DEF_INDEX;
    private static final int IS_ROW_TIMESTAMP_INDEX;
    private static final int LINK_TYPE_INDEX = 0;
    private static final KeyValue CLASS_NAME_KV;
    private static final KeyValue JAR_PATH_KV;
    private static final KeyValue RETURN_TYPE_KV;
    private static final KeyValue NUM_ARGS_KV;
    private static final KeyValue TYPE_KV;
    private static final KeyValue IS_CONSTANT_KV;
    private static final KeyValue DEFAULT_VALUE_KV;
    private static final KeyValue MIN_VALUE_KV;
    private static final KeyValue MAX_VALUE_KV;
    private static final KeyValue IS_ARRAY_KV;
    private static final List<KeyValue> FUNCTION_KV_COLUMNS;
    private static final int CLASS_NAME_INDEX;
    private static final int JAR_PATH_INDEX;
    private static final int RETURN_TYPE_INDEX;
    private static final int NUM_ARGS_INDEX;
    private static final List<KeyValue> FUNCTION_ARG_KV_COLUMNS;
    private static final int TYPE_INDEX;
    private static final int IS_ARRAY_INDEX;
    private static final int IS_CONSTANT_INDEX;
    private static final int DEFAULT_VALUE_INDEX;
    private static final int MIN_VALUE_INDEX;
    private static final int MAX_VALUE_INDEX;
    private RegionCoprocessorEnvironment env;
    private static final byte[] PHYSICAL_TABLE_BYTES;

    private static PName newPName(byte[] keyBuffer, int keyOffset, int keyLength) {
        if (keyLength <= 0) {
            return null;
        }
        int length = SchemaUtil.getVarCharLength(keyBuffer, keyOffset, keyLength);
        return PNameFactory.newName(keyBuffer, keyOffset, length);
    }

    @Override
    public void start(CoprocessorEnvironment env) throws IOException {
        if (!(env instanceof RegionCoprocessorEnvironment)) {
            throw new CoprocessorException("Must be loaded on a table region!");
        }
        this.env = (RegionCoprocessorEnvironment)env;
        logger.info("Starting Tracing-Metrics Systems");
        Tracing.addTraceMetricsSource();
        Metrics.ensureConfigured();
    }

    @Override
    public void stop(CoprocessorEnvironment env) throws IOException {
    }

    @Override
    public Service getService() {
        return this;
    }

    @Override
    public void getTable(RpcController controller, MetaDataProtos.GetTableRequest request, RpcCallback<MetaDataProtos.MetaDataResponse> done) {
        MetaDataProtos.MetaDataResponse.Builder builder = MetaDataProtos.MetaDataResponse.newBuilder();
        byte[] tenantId = request.getTenantId().toByteArray();
        byte[] schemaName = request.getSchemaName().toByteArray();
        byte[] tableName = request.getTableName().toByteArray();
        byte[] key = SchemaUtil.getTableKey(tenantId, schemaName, tableName);
        long tableTimeStamp = request.getTableTimestamp();
        try {
            Region region = this.env.getRegion();
            MetaDataProtocol.MetaDataMutationResult result = MetaDataEndpointImpl.checkTableKeyInRegion(key, region);
            if (result != null) {
                done.run(MetaDataProtocol.MetaDataMutationResult.toProto(result));
                return;
            }
            long currentTime = EnvironmentEdgeManager.currentTimeMillis();
            PTable table = this.doGetTable(key, request.getClientTimestamp());
            if (table == null) {
                builder.setReturnCode(MetaDataProtos.MutationCode.TABLE_NOT_FOUND);
                builder.setMutationTime(currentTime);
                done.run(builder.build());
                return;
            }
            builder.setReturnCode(MetaDataProtos.MutationCode.TABLE_ALREADY_EXISTS);
            builder.setMutationTime(currentTime);
            if (table.getTimeStamp() != tableTimeStamp) {
                builder.setTable(PTableImpl.toProto(table));
            }
            done.run(builder.build());
            return;
        }
        catch (Throwable t) {
            logger.error("getTable failed", t);
            ProtobufUtil.setControllerException(controller, ServerUtil.createIOException(SchemaUtil.getTableName(schemaName, tableName), t));
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PTable buildTable(byte[] key, ImmutableBytesPtr cacheKey, Region region, long clientTimeStamp) throws IOException, SQLException {
        Scan scan = MetaDataUtil.newTableRowsScan(key, 0L, clientTimeStamp);
        Cache<ImmutableBytesPtr, PMetaDataEntity> metaDataCache = GlobalCache.getInstance(this.env).getMetaDataCache();
        try (RegionScanner scanner = region.getScanner(scan);){
            PTable oldTable = (PTable)metaDataCache.getIfPresent(cacheKey);
            long tableTimeStamp = oldTable == null ? -1L : oldTable.getTimeStamp();
            PTable newTable = this.getTable(scanner, clientTimeStamp, tableTimeStamp);
            if (newTable == null) {
                PTable pTable = null;
                return pTable;
            }
            if (oldTable == null || tableTimeStamp < newTable.getTimeStamp()) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Caching table " + Bytes.toStringBinary(cacheKey.get(), cacheKey.getOffset(), cacheKey.getLength()) + " at seqNum " + newTable.getSequenceNumber() + " with newer timestamp " + newTable.getTimeStamp() + " versus " + tableTimeStamp);
                }
                metaDataCache.put(cacheKey, newTable);
            }
            PTable pTable = newTable;
            return pTable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<PFunction> buildFunctions(List<byte[]> keys, Region region, long clientTimeStamp) throws IOException, SQLException {
        ArrayList<KeyRange> keyRanges = Lists.newArrayListWithExpectedSize(keys.size());
        for (byte[] key : keys) {
            byte[] stopKey = ByteUtil.concat(key, new byte[][]{QueryConstants.SEPARATOR_BYTE_ARRAY});
            ByteUtil.nextKey(stopKey, stopKey.length);
            keyRanges.add(PVarbinary.INSTANCE.getKeyRange(key, true, stopKey, false));
        }
        Scan scan = new Scan();
        scan.setTimeRange(0L, clientTimeStamp);
        ScanRanges scanRanges = ScanRanges.create(SchemaUtil.VAR_BINARY_SCHEMA, Collections.singletonList(keyRanges), ScanUtil.SINGLE_COLUMN_SLOT_SPAN);
        scanRanges.initializeScan(scan);
        scan.setFilter(scanRanges.getSkipScanFilter());
        RegionScanner scanner = region.getScanner(scan);
        Cache<ImmutableBytesPtr, PMetaDataEntity> metaDataCache = GlobalCache.getInstance(this.env).getMetaDataCache();
        ArrayList<PFunction> functions = new ArrayList<PFunction>();
        PFunction function = null;
        try {
            for (int i = 0; i < keys.size(); ++i) {
                function = null;
                function = this.getFunction(scanner);
                if (function == null) {
                    List<PFunction> list = null;
                    return list;
                }
                byte[] functionKey = SchemaUtil.getFunctionKey(function.getTenantId() == null ? ByteUtil.EMPTY_BYTE_ARRAY : function.getTenantId().getBytes(), Bytes.toBytes(function.getFunctionName()));
                metaDataCache.put(new GlobalCache.FunctionBytesPtr(functionKey), function);
                functions.add(function);
            }
            ArrayList<PFunction> arrayList = functions;
            return arrayList;
        }
        finally {
            scanner.close();
        }
    }

    private void addIndexToTable(PName tenantId, PName schemaName, PName indexName, PName tableName, long clientTimeStamp, List<PTable> indexes) throws IOException, SQLException {
        byte[] key = SchemaUtil.getTableKey(tenantId == null ? ByteUtil.EMPTY_BYTE_ARRAY : tenantId.getBytes(), schemaName.getBytes(), indexName.getBytes());
        PTable indexTable = this.doGetTable(key, clientTimeStamp);
        if (indexTable == null) {
            ServerUtil.throwIOException("Index not found", new TableNotFoundException(schemaName.getString(), indexName.getString()));
            return;
        }
        indexes.add(indexTable);
    }

    private void addColumnToTable(List<Cell> results, PName colName, PName famName, Cell[] colKeyValues, List<PColumn> columns, boolean isSalted) {
        Cell sortOrderKv;
        int i = 0;
        int j = 0;
        while (i < results.size() && j < COLUMN_KV_COLUMNS.size()) {
            Cell kv = results.get(i);
            Cell searchKv = COLUMN_KV_COLUMNS.get(j);
            int cmp = Bytes.compareTo(kv.getQualifierArray(), kv.getQualifierOffset(), kv.getQualifierLength(), searchKv.getQualifierArray(), searchKv.getQualifierOffset(), searchKv.getQualifierLength());
            if (cmp == 0) {
                colKeyValues[j++] = kv;
                ++i;
                continue;
            }
            if (cmp > 0) {
                colKeyValues[j++] = null;
                continue;
            }
            ++i;
        }
        if (colKeyValues[DATA_TYPE_INDEX] == null || colKeyValues[NULLABLE_INDEX] == null || colKeyValues[ORDINAL_POSITION_INDEX] == null) {
            throw new IllegalStateException("Didn't find all required key values in '" + colName.getString() + "' column metadata row");
        }
        Cell columnSizeKv = colKeyValues[COLUMN_SIZE_INDEX];
        Integer maxLength = columnSizeKv == null ? null : Integer.valueOf(PInteger.INSTANCE.getCodec().decodeInt(columnSizeKv.getValueArray(), columnSizeKv.getValueOffset(), SortOrder.getDefault()));
        Cell decimalDigitKv = colKeyValues[DECIMAL_DIGITS_INDEX];
        Integer scale = decimalDigitKv == null ? null : Integer.valueOf(PInteger.INSTANCE.getCodec().decodeInt(decimalDigitKv.getValueArray(), decimalDigitKv.getValueOffset(), SortOrder.getDefault()));
        Cell ordinalPositionKv = colKeyValues[ORDINAL_POSITION_INDEX];
        int position = PInteger.INSTANCE.getCodec().decodeInt(ordinalPositionKv.getValueArray(), ordinalPositionKv.getValueOffset(), SortOrder.getDefault()) + (isSalted ? 1 : 0);
        Cell nullableKv = colKeyValues[NULLABLE_INDEX];
        boolean isNullable = PInteger.INSTANCE.getCodec().decodeInt(nullableKv.getValueArray(), nullableKv.getValueOffset(), SortOrder.getDefault()) != 0;
        Cell dataTypeKv = colKeyValues[DATA_TYPE_INDEX];
        PDataType dataType = PDataType.fromTypeId(PInteger.INSTANCE.getCodec().decodeInt(dataTypeKv.getValueArray(), dataTypeKv.getValueOffset(), SortOrder.getDefault()));
        if (maxLength == null && dataType == PBinary.INSTANCE) {
            dataType = PVarbinary.INSTANCE;
        }
        SortOrder sortOrder = (sortOrderKv = colKeyValues[SORT_ORDER_INDEX]) == null ? SortOrder.getDefault() : SortOrder.fromSystemValue(PInteger.INSTANCE.getCodec().decodeInt(sortOrderKv.getValueArray(), sortOrderKv.getValueOffset(), SortOrder.getDefault()));
        Cell arraySizeKv = colKeyValues[ARRAY_SIZE_INDEX];
        Integer arraySize = arraySizeKv == null ? null : Integer.valueOf(PInteger.INSTANCE.getCodec().decodeInt(arraySizeKv.getValueArray(), arraySizeKv.getValueOffset(), SortOrder.getDefault()));
        Cell viewConstantKv = colKeyValues[VIEW_CONSTANT_INDEX];
        byte[] viewConstant = viewConstantKv == null ? null : viewConstantKv.getValue();
        Cell isViewReferencedKv = colKeyValues[IS_VIEW_REFERENCED_INDEX];
        boolean isViewReferenced = isViewReferencedKv != null && Boolean.TRUE.equals(PBoolean.INSTANCE.toObject(isViewReferencedKv.getValueArray(), isViewReferencedKv.getValueOffset(), isViewReferencedKv.getValueLength()));
        Cell columnDefKv = colKeyValues[COLUMN_DEF_INDEX];
        String expressionStr = columnDefKv == null ? null : (String)PVarchar.INSTANCE.toObject(columnDefKv.getValueArray(), columnDefKv.getValueOffset(), columnDefKv.getValueLength());
        Cell isRowTimestampKV = colKeyValues[IS_ROW_TIMESTAMP_INDEX];
        boolean isRowTimestamp = isRowTimestampKV == null ? false : Boolean.TRUE.equals(PBoolean.INSTANCE.toObject(isRowTimestampKV.getValueArray(), isRowTimestampKV.getValueOffset(), isRowTimestampKV.getValueLength()));
        PColumnImpl column = new PColumnImpl(colName, famName, dataType, maxLength, scale, isNullable, position - 1, sortOrder, arraySize, viewConstant, isViewReferenced, expressionStr, isRowTimestamp);
        columns.add(column);
    }

    private void addArgumentToFunction(List<Cell> results, PName functionName, PName type, Cell[] functionKeyValues, List<PFunction.FunctionArgument> arguments, short argPosition) throws SQLException {
        int i = 0;
        int j = 0;
        while (i < results.size() && j < FUNCTION_ARG_KV_COLUMNS.size()) {
            Cell kv = results.get(i);
            Cell searchKv = FUNCTION_ARG_KV_COLUMNS.get(j);
            int cmp = Bytes.compareTo(kv.getQualifierArray(), kv.getQualifierOffset(), kv.getQualifierLength(), searchKv.getQualifierArray(), searchKv.getQualifierOffset(), searchKv.getQualifierLength());
            if (cmp == 0) {
                functionKeyValues[j++] = kv;
                ++i;
                continue;
            }
            if (cmp > 0) {
                functionKeyValues[j++] = null;
                continue;
            }
            ++i;
        }
        Cell isArrayKv = functionKeyValues[IS_ARRAY_INDEX];
        boolean isArrayType = isArrayKv == null ? false : Boolean.TRUE.equals(PBoolean.INSTANCE.toObject(isArrayKv.getValueArray(), isArrayKv.getValueOffset(), isArrayKv.getValueLength()));
        Cell isConstantKv = functionKeyValues[IS_CONSTANT_INDEX];
        boolean isConstant = isConstantKv == null ? false : Boolean.TRUE.equals(PBoolean.INSTANCE.toObject(isConstantKv.getValueArray(), isConstantKv.getValueOffset(), isConstantKv.getValueLength()));
        Cell defaultValueKv = functionKeyValues[DEFAULT_VALUE_INDEX];
        String defaultValue = defaultValueKv == null ? null : (String)PVarchar.INSTANCE.toObject(defaultValueKv.getValueArray(), defaultValueKv.getValueOffset(), defaultValueKv.getValueLength());
        Cell minValueKv = functionKeyValues[MIN_VALUE_INDEX];
        String minValue = minValueKv == null ? null : (String)PVarchar.INSTANCE.toObject(minValueKv.getValueArray(), minValueKv.getValueOffset(), minValueKv.getValueLength());
        Cell maxValueKv = functionKeyValues[MAX_VALUE_INDEX];
        String maxValue = maxValueKv == null ? null : (String)PVarchar.INSTANCE.toObject(maxValueKv.getValueArray(), maxValueKv.getValueOffset(), maxValueKv.getValueLength());
        PFunction.FunctionArgument arg = new PFunction.FunctionArgument(type.getString(), isArrayType, isConstant, defaultValue == null ? null : LiteralExpression.newConstant(new LiteralParseNode(defaultValue).getValue()), minValue == null ? null : LiteralExpression.newConstant(new LiteralParseNode(minValue).getValue()), maxValue == null ? null : LiteralExpression.newConstant(new LiteralParseNode(maxValue).getValue()), argPosition);
        arguments.add(arg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PTable getTable(RegionScanner scanner, long clientTimeStamp, long tableTimeStamp) throws IOException, SQLException {
        Cell dataTableNameKv;
        Integer saltBucketNum;
        int tenantIdLength;
        ArrayList<Cell> results = Lists.newArrayList();
        scanner.next(results);
        if (results.isEmpty()) {
            return null;
        }
        Cell[] tableKeyValues = new Cell[TABLE_KV_COLUMNS.size()];
        Cell[] colKeyValues = new Cell[COLUMN_KV_COLUMNS.size()];
        Cell keyValue = (Cell)results.get(0);
        byte[] keyBuffer = keyValue.getRowArray();
        short keyLength = keyValue.getRowLength();
        int keyOffset = keyValue.getRowOffset();
        PName tenantId = MetaDataEndpointImpl.newPName(keyBuffer, keyOffset, keyLength);
        int n = tenantIdLength = tenantId == null ? 0 : tenantId.getBytes().length;
        if (tenantIdLength == 0) {
            tenantId = null;
        }
        PName schemaName = MetaDataEndpointImpl.newPName(keyBuffer, keyOffset + tenantIdLength + 1, keyLength);
        int schemaNameLength = schemaName.getBytes().length;
        int tableNameLength = keyLength - schemaNameLength - 1 - tenantIdLength - 1;
        byte[] tableNameBytes = new byte[tableNameLength];
        System.arraycopy(keyBuffer, keyOffset + schemaNameLength + 1 + tenantIdLength + 1, tableNameBytes, 0, tableNameLength);
        PName tableName = PNameFactory.newName(tableNameBytes);
        int offset = tenantIdLength + schemaNameLength + tableNameLength + 3;
        long timeStamp = keyValue.getTimestamp();
        int i = 0;
        int j = 0;
        while (i < results.size() && j < TABLE_KV_COLUMNS.size()) {
            Cell kv = (Cell)results.get(i);
            Cell searchKv = TABLE_KV_COLUMNS.get(j);
            int cmp = Bytes.compareTo(kv.getQualifierArray(), kv.getQualifierOffset(), kv.getQualifierLength(), searchKv.getQualifierArray(), searchKv.getQualifierOffset(), searchKv.getQualifierLength());
            if (cmp == 0) {
                timeStamp = Math.max(timeStamp, kv.getTimestamp());
                tableKeyValues[j++] = kv;
                ++i;
                continue;
            }
            if (cmp > 0) {
                timeStamp = Math.max(timeStamp, kv.getTimestamp());
                tableKeyValues[j++] = null;
                continue;
            }
            ++i;
        }
        if (tableKeyValues[TABLE_TYPE_INDEX] == null || tableKeyValues[TABLE_SEQ_NUM_INDEX] == null || tableKeyValues[COLUMN_COUNT_INDEX] == null) {
            throw new IllegalStateException("Didn't find expected key values for table row in metadata row");
        }
        Cell tableTypeKv = tableKeyValues[TABLE_TYPE_INDEX];
        PTableType tableType = PTableType.fromSerializedValue(tableTypeKv.getValueArray()[tableTypeKv.getValueOffset()]);
        Cell tableSeqNumKv = tableKeyValues[TABLE_SEQ_NUM_INDEX];
        long tableSeqNum = PLong.INSTANCE.getCodec().decodeLong(tableSeqNumKv.getValueArray(), tableSeqNumKv.getValueOffset(), SortOrder.getDefault());
        Cell columnCountKv = tableKeyValues[COLUMN_COUNT_INDEX];
        int columnCount = PInteger.INSTANCE.getCodec().decodeInt(columnCountKv.getValueArray(), columnCountKv.getValueOffset(), SortOrder.getDefault());
        Cell pkNameKv = tableKeyValues[PK_NAME_INDEX];
        PName pkName = pkNameKv != null ? MetaDataEndpointImpl.newPName(pkNameKv.getValueArray(), pkNameKv.getValueOffset(), pkNameKv.getValueLength()) : null;
        Cell saltBucketNumKv = tableKeyValues[SALT_BUCKETS_INDEX];
        Integer n2 = saltBucketNum = saltBucketNumKv != null ? Integer.valueOf(PInteger.INSTANCE.getCodec().decodeInt(saltBucketNumKv.getValueArray(), saltBucketNumKv.getValueOffset(), SortOrder.getDefault())) : null;
        if (saltBucketNum != null && saltBucketNum == 0) {
            saltBucketNum = null;
        }
        PName dataTableName = (dataTableNameKv = tableKeyValues[DATA_TABLE_NAME_INDEX]) != null ? MetaDataEndpointImpl.newPName(dataTableNameKv.getValueArray(), dataTableNameKv.getValueOffset(), dataTableNameKv.getValueLength()) : null;
        Cell indexStateKv = tableKeyValues[INDEX_STATE_INDEX];
        PIndexState indexState = indexStateKv == null ? null : PIndexState.fromSerializedValue(indexStateKv.getValueArray()[indexStateKv.getValueOffset()]);
        Cell immutableRowsKv = tableKeyValues[IMMUTABLE_ROWS_INDEX];
        boolean isImmutableRows = immutableRowsKv == null ? false : (Boolean)PBoolean.INSTANCE.toObject(immutableRowsKv.getValueArray(), immutableRowsKv.getValueOffset(), immutableRowsKv.getValueLength());
        Cell defaultFamilyNameKv = tableKeyValues[DEFAULT_COLUMN_FAMILY_INDEX];
        PName defaultFamilyName = defaultFamilyNameKv != null ? MetaDataEndpointImpl.newPName(defaultFamilyNameKv.getValueArray(), defaultFamilyNameKv.getValueOffset(), defaultFamilyNameKv.getValueLength()) : null;
        Cell viewStatementKv = tableKeyValues[VIEW_STATEMENT_INDEX];
        String viewStatement = viewStatementKv != null ? (String)PVarchar.INSTANCE.toObject(viewStatementKv.getValueArray(), viewStatementKv.getValueOffset(), viewStatementKv.getValueLength()) : null;
        Cell disableWALKv = tableKeyValues[DISABLE_WAL_INDEX];
        boolean disableWAL = disableWALKv == null ? false : Boolean.TRUE.equals(PBoolean.INSTANCE.toObject(disableWALKv.getValueArray(), disableWALKv.getValueOffset(), disableWALKv.getValueLength()));
        Cell multiTenantKv = tableKeyValues[MULTI_TENANT_INDEX];
        boolean multiTenant = multiTenantKv == null ? false : Boolean.TRUE.equals(PBoolean.INSTANCE.toObject(multiTenantKv.getValueArray(), multiTenantKv.getValueOffset(), multiTenantKv.getValueLength()));
        Cell storeNullsKv = tableKeyValues[STORE_NULLS_INDEX];
        boolean storeNulls = storeNullsKv == null ? false : Boolean.TRUE.equals(PBoolean.INSTANCE.toObject(storeNullsKv.getValueArray(), storeNullsKv.getValueOffset(), storeNullsKv.getValueLength()));
        Cell viewTypeKv = tableKeyValues[VIEW_TYPE_INDEX];
        PTable.ViewType viewType = viewTypeKv == null ? null : PTable.ViewType.fromSerializedValue(viewTypeKv.getValueArray()[viewTypeKv.getValueOffset()]);
        Cell viewIndexIdKv = tableKeyValues[VIEW_INDEX_ID_INDEX];
        Short viewIndexId = viewIndexIdKv == null ? null : Short.valueOf(MetaDataUtil.getViewIndexIdDataType().getCodec().decodeShort(viewIndexIdKv.getValueArray(), viewIndexIdKv.getValueOffset(), SortOrder.getDefault()));
        Cell indexTypeKv = tableKeyValues[INDEX_TYPE_INDEX];
        PTable.IndexType indexType = indexTypeKv == null ? null : PTable.IndexType.fromSerializedValue(indexTypeKv.getValueArray()[indexTypeKv.getValueOffset()]);
        ArrayList<PColumn> columns = Lists.newArrayListWithExpectedSize(columnCount);
        ArrayList<PTable> indexes = new ArrayList<PTable>();
        ArrayList<PName> physicalTables = new ArrayList<PName>();
        while (true) {
            results.clear();
            scanner.next(results);
            if (results.isEmpty()) break;
            Cell colKv = (Cell)results.get(0);
            short colKeyLength = colKv.getRowLength();
            PName colName = MetaDataEndpointImpl.newPName(colKv.getRowArray(), colKv.getRowOffset() + offset, colKeyLength - offset);
            int colKeyOffset = offset + colName.getBytes().length + 1;
            PName famName = MetaDataEndpointImpl.newPName(colKv.getRowArray(), colKv.getRowOffset() + colKeyOffset, colKeyLength - colKeyOffset);
            if (colName.getString().isEmpty() && famName != null) {
                PTable.LinkType linkType = PTable.LinkType.fromSerializedValue(colKv.getValueArray()[colKv.getValueOffset()]);
                if (linkType == PTable.LinkType.INDEX_TABLE) {
                    this.addIndexToTable(tenantId, schemaName, famName, tableName, clientTimeStamp, indexes);
                    continue;
                }
                if (linkType != PTable.LinkType.PHYSICAL_TABLE) continue;
                physicalTables.add(famName);
                continue;
            }
            this.addColumnToTable(results, colName, famName, colKeyValues, columns, saltBucketNum != null);
        }
        PName physicalTableName = physicalTables.isEmpty() ? PNameFactory.newName(SchemaUtil.getTableName(schemaName.getString(), tableName.getString())) : (PName)physicalTables.get(0);
        PTableStats stats = PTableStats.EMPTY_STATS;
        if (tenantId == null) {
            try (HTableInterface statsHTable = null;){
                statsHTable = ServerUtil.getHTableForCoprocessorScan(this.env, PhoenixDatabaseMetaData.SYSTEM_STATS_NAME_BYTES);
                stats = StatisticsUtil.readStatistics(statsHTable, physicalTableName.getBytes(), clientTimeStamp);
                timeStamp = Math.max(timeStamp, stats.getTimestamp());
            }
        }
        return PTableImpl.makePTable(tenantId, schemaName, tableName, tableType, indexState, timeStamp, tableSeqNum, pkName, saltBucketNum, columns, tableType == PTableType.INDEX ? schemaName : null, tableType == PTableType.INDEX ? dataTableName : null, indexes, isImmutableRows, physicalTables, defaultFamilyName, viewStatement, disableWAL, multiTenant, storeNulls, viewType, viewIndexId, indexType, stats);
    }

    private PFunction getFunction(RegionScanner scanner) throws IOException, SQLException {
        int tenantIdLength;
        ArrayList<Cell> results = Lists.newArrayList();
        scanner.next(results);
        if (results.isEmpty()) {
            return null;
        }
        Cell[] functionKeyValues = new Cell[FUNCTION_KV_COLUMNS.size()];
        Cell[] functionArgKeyValues = new Cell[FUNCTION_ARG_KV_COLUMNS.size()];
        Cell keyValue = (Cell)results.get(0);
        byte[] keyBuffer = keyValue.getRowArray();
        short keyLength = keyValue.getRowLength();
        int keyOffset = keyValue.getRowOffset();
        PName tenantId = MetaDataEndpointImpl.newPName(keyBuffer, keyOffset, keyLength);
        int n = tenantIdLength = tenantId == null ? 0 : tenantId.getBytes().length;
        if (tenantIdLength == 0) {
            tenantId = null;
        }
        PName functionName = MetaDataEndpointImpl.newPName(keyBuffer, keyOffset + tenantIdLength + 1, keyLength - tenantIdLength - 1);
        int functionNameLength = functionName.getBytes().length + 1;
        int offset = tenantIdLength + functionNameLength + 1;
        long timeStamp = keyValue.getTimestamp();
        int i = 0;
        int j = 0;
        while (i < results.size() && j < FUNCTION_KV_COLUMNS.size()) {
            Cell kv = (Cell)results.get(i);
            Cell searchKv = FUNCTION_KV_COLUMNS.get(j);
            int cmp = Bytes.compareTo(kv.getQualifierArray(), kv.getQualifierOffset(), kv.getQualifierLength(), searchKv.getQualifierArray(), searchKv.getQualifierOffset(), searchKv.getQualifierLength());
            if (cmp == 0) {
                timeStamp = Math.max(timeStamp, kv.getTimestamp());
                functionKeyValues[j++] = kv;
                ++i;
                continue;
            }
            if (cmp > 0) {
                timeStamp = Math.max(timeStamp, kv.getTimestamp());
                functionKeyValues[j++] = null;
                continue;
            }
            ++i;
        }
        if (functionKeyValues[CLASS_NAME_INDEX] == null || functionKeyValues[NUM_ARGS_INDEX] == null) {
            throw new IllegalStateException("Didn't find expected key values for function row in metadata row");
        }
        Cell classNameKv = functionKeyValues[CLASS_NAME_INDEX];
        PName className = MetaDataEndpointImpl.newPName(classNameKv.getValueArray(), classNameKv.getValueOffset(), classNameKv.getValueLength());
        Cell jarPathKv = functionKeyValues[JAR_PATH_INDEX];
        PName jarPath = null;
        if (jarPathKv != null) {
            jarPath = MetaDataEndpointImpl.newPName(jarPathKv.getValueArray(), jarPathKv.getValueOffset(), jarPathKv.getValueLength());
        }
        Cell numArgsKv = functionKeyValues[NUM_ARGS_INDEX];
        int numArgs = PInteger.INSTANCE.getCodec().decodeInt(numArgsKv.getValueArray(), numArgsKv.getValueOffset(), SortOrder.getDefault());
        Cell returnTypeKv = functionKeyValues[RETURN_TYPE_INDEX];
        PName returnType = returnTypeKv == null ? null : MetaDataEndpointImpl.newPName(returnTypeKv.getValueArray(), returnTypeKv.getValueOffset(), returnTypeKv.getValueLength());
        ArrayList<PFunction.FunctionArgument> arguments = Lists.newArrayListWithExpectedSize(numArgs);
        for (int k = 0; k < numArgs; ++k) {
            results.clear();
            scanner.next(results);
            if (results.isEmpty()) break;
            Cell typeKv = (Cell)results.get(0);
            short typeKeyLength = typeKv.getRowLength();
            PName typeName = MetaDataEndpointImpl.newPName(typeKv.getRowArray(), typeKv.getRowOffset() + offset, typeKeyLength - offset - 3);
            int argPositionOffset = offset + typeName.getBytes().length + 1;
            short argPosition = Bytes.toShort(typeKv.getRowArray(), typeKv.getRowOffset() + argPositionOffset, typeKeyLength - argPositionOffset);
            this.addArgumentToFunction(results, functionName, typeName, functionArgKeyValues, arguments, argPosition);
        }
        Collections.sort(arguments, new Comparator<PFunction.FunctionArgument>(){

            @Override
            public int compare(PFunction.FunctionArgument o1, PFunction.FunctionArgument o2) {
                return o1.getArgPosition() - o2.getArgPosition();
            }
        });
        return new PFunction(tenantId, functionName.getString(), arguments, returnType.getString(), className.getString(), jarPath == null ? null : jarPath.getString(), timeStamp);
    }

    private PTable buildDeletedTable(byte[] key, ImmutableBytesPtr cacheKey, Region region, long clientTimeStamp) throws IOException {
        Cell kv;
        if (clientTimeStamp == Long.MAX_VALUE) {
            return null;
        }
        Scan scan = MetaDataUtil.newTableRowsScan(key, clientTimeStamp, Long.MAX_VALUE);
        scan.setFilter(new FirstKeyOnlyFilter());
        scan.setRaw(true);
        ArrayList<Cell> results = Lists.newArrayList();
        try (RegionScanner scanner = region.getScanner(scan);){
            scanner.next(results);
        }
        if (!results.isEmpty() && ((Cell)results.get(0)).getTimestamp() > clientTimeStamp && (kv = (Cell)results.get(0)).getTypeByte() == KeyValue.Type.Delete.getCode()) {
            Cache<ImmutableBytesPtr, PMetaDataEntity> metaDataCache = GlobalCache.getInstance(this.env).getMetaDataCache();
            PTable table = MetaDataEndpointImpl.newDeletedTableMarker(kv.getTimestamp());
            metaDataCache.put(cacheKey, table);
            return table;
        }
        return null;
    }

    private PFunction buildDeletedFunction(byte[] key, ImmutableBytesPtr cacheKey, Region region, long clientTimeStamp) throws IOException {
        Cell kv;
        if (clientTimeStamp == Long.MAX_VALUE) {
            return null;
        }
        Scan scan = MetaDataUtil.newTableRowsScan(key, clientTimeStamp, Long.MAX_VALUE);
        scan.setFilter(new FirstKeyOnlyFilter());
        scan.setRaw(true);
        ArrayList<Cell> results = Lists.newArrayList();
        try (RegionScanner scanner = region.getScanner(scan);){
            scanner.next(results);
        }
        if (!results.isEmpty() && ((Cell)results.get(0)).getTimestamp() > clientTimeStamp && (kv = (Cell)results.get(0)).getTypeByte() == KeyValue.Type.Delete.getCode()) {
            Cache<ImmutableBytesPtr, PMetaDataEntity> metaDataCache = GlobalCache.getInstance(this.env).getMetaDataCache();
            PFunction function = MetaDataEndpointImpl.newDeletedFunctionMarker(kv.getTimestamp());
            metaDataCache.put(cacheKey, function);
            return function;
        }
        return null;
    }

    private static PTable newDeletedTableMarker(long timestamp) {
        return new PTableImpl(timestamp);
    }

    private static PFunction newDeletedFunctionMarker(long timestamp) {
        return new PFunction(timestamp);
    }

    private static boolean isTableDeleted(PTable table) {
        return table.getName() == null;
    }

    private static boolean isFunctionDeleted(PFunction function) {
        return function.getFunctionName() == null;
    }

    private PTable loadTable(RegionCoprocessorEnvironment env, byte[] key, ImmutableBytesPtr cacheKey, long clientTimeStamp, long asOfTimeStamp) throws IOException, SQLException {
        Region region = env.getRegion();
        Cache<ImmutableBytesPtr, PMetaDataEntity> metaDataCache = GlobalCache.getInstance(this.env).getMetaDataCache();
        PTable table = (PTable)metaDataCache.getIfPresent(cacheKey);
        if (table != null || (table = this.buildTable(key, cacheKey, region, asOfTimeStamp)) != null) {
            return table;
        }
        if (table == null && (table = this.buildDeletedTable(key, cacheKey, region, clientTimeStamp)) != null) {
            return table;
        }
        return null;
    }

    private PFunction loadFunction(RegionCoprocessorEnvironment env, byte[] key, ImmutableBytesPtr cacheKey, long clientTimeStamp, long asOfTimeStamp) throws IOException, SQLException {
        Region region = env.getRegion();
        Cache<ImmutableBytesPtr, PMetaDataEntity> metaDataCache = GlobalCache.getInstance(this.env).getMetaDataCache();
        PFunction function = (PFunction)metaDataCache.getIfPresent(cacheKey);
        if (function != null) {
            return function;
        }
        ArrayList<byte[]> arrayList = new ArrayList<byte[]>(1);
        arrayList.add(key);
        List<PFunction> functions = this.buildFunctions(arrayList, region, asOfTimeStamp);
        if (functions != null) {
            return functions.get(0);
        }
        if (function == null && (function = this.buildDeletedFunction(key, cacheKey, region, clientTimeStamp)) != null) {
            return function;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void createTable(RpcController controller, MetaDataProtos.CreateTableRequest request, RpcCallback<MetaDataProtos.MetaDataResponse> done) {
        MetaDataProtos.MetaDataResponse.Builder builder = MetaDataProtos.MetaDataResponse.newBuilder();
        byte[][] rowKeyMetaData = new byte[3][];
        byte[] schemaName = null;
        byte[] tableName = null;
        try {
            List<Mutation> tableMetadata = ProtobufUtil.getMutations(request);
            MetaDataUtil.getTenantIdAndSchemaAndTableName(tableMetadata, rowKeyMetaData);
            byte[] tenantIdBytes = rowKeyMetaData[0];
            schemaName = rowKeyMetaData[1];
            tableName = rowKeyMetaData[2];
            byte[] parentTableName = MetaDataUtil.getParentTableName(tableMetadata);
            byte[] lockTableName = parentTableName == null ? tableName : parentTableName;
            byte[] lockKey = SchemaUtil.getTableKey(tenantIdBytes, schemaName, lockTableName);
            byte[] key = parentTableName == null ? lockKey : SchemaUtil.getTableKey(tenantIdBytes, schemaName, tableName);
            byte[] parentKey = parentTableName == null ? null : lockKey;
            Region region = this.env.getRegion();
            MetaDataProtocol.MetaDataMutationResult result = MetaDataEndpointImpl.checkTableKeyInRegion(lockKey, region);
            if (result != null) {
                done.run(MetaDataProtocol.MetaDataMutationResult.toProto(result));
                return;
            }
            ArrayList<Region.RowLock> locks = Lists.newArrayList();
            long clientTimeStamp = MetaDataUtil.getClientTimeStamp(tableMetadata);
            try {
                ImmutableBytesPtr cacheKey;
                PTable table;
                MetaDataEndpointImpl.acquireLock(region, lockKey, locks);
                if (key != lockKey) {
                    MetaDataEndpointImpl.acquireLock(region, key, locks);
                }
                PTable parentTable = null;
                ImmutableBytesPtr parentCacheKey = null;
                if (parentKey != null) {
                    parentCacheKey = new ImmutableBytesPtr(parentKey);
                    parentTable = this.loadTable(this.env, parentKey, parentCacheKey, clientTimeStamp, clientTimeStamp);
                    if (parentTable == null || MetaDataEndpointImpl.isTableDeleted(parentTable)) {
                        builder.setReturnCode(MetaDataProtos.MutationCode.PARENT_TABLE_NOT_FOUND);
                        builder.setMutationTime(EnvironmentEdgeManager.currentTimeMillis());
                        builder.setTable(PTableImpl.toProto(parentTable));
                        done.run(builder.build());
                        return;
                    }
                    if (parentTable.getSequenceNumber() != MetaDataUtil.getParentSequenceNumber(tableMetadata)) {
                        builder.setReturnCode(MetaDataProtos.MutationCode.CONCURRENT_TABLE_MUTATION);
                        builder.setMutationTime(EnvironmentEdgeManager.currentTimeMillis());
                        builder.setTable(PTableImpl.toProto(parentTable));
                        done.run(builder.build());
                        return;
                    }
                }
                if ((table = this.loadTable(this.env, key, cacheKey = new ImmutableBytesPtr(key), clientTimeStamp, Long.MAX_VALUE)) != null) {
                    if (table.getTimeStamp() < clientTimeStamp) {
                        if (!MetaDataEndpointImpl.isTableDeleted(table)) {
                            builder.setReturnCode(MetaDataProtos.MutationCode.TABLE_ALREADY_EXISTS);
                            builder.setMutationTime(EnvironmentEdgeManager.currentTimeMillis());
                            builder.setTable(PTableImpl.toProto(table));
                            done.run(builder.build());
                            return;
                        }
                    } else {
                        builder.setReturnCode(MetaDataProtos.MutationCode.NEWER_TABLE_FOUND);
                        builder.setMutationTime(EnvironmentEdgeManager.currentTimeMillis());
                        builder.setTable(PTableImpl.toProto(table));
                        done.run(builder.build());
                        return;
                    }
                }
                region.mutateRowsWithLocks(tableMetadata, Collections.emptySet(), 0L, 0L);
                Cache<ImmutableBytesPtr, PMetaDataEntity> metaDataCache = GlobalCache.getInstance(this.env).getMetaDataCache();
                if (parentCacheKey != null) {
                    metaDataCache.invalidate(parentCacheKey);
                }
                metaDataCache.invalidate(cacheKey);
                long currentTimeStamp = MetaDataUtil.getClientTimeStamp(tableMetadata);
                builder.setReturnCode(MetaDataProtos.MutationCode.TABLE_NOT_FOUND);
                builder.setMutationTime(currentTimeStamp);
                done.run(builder.build());
                return;
            }
            finally {
                region.releaseRowLocks(locks);
            }
        }
        catch (Throwable t) {
            logger.error("createTable failed", t);
            ProtobufUtil.setControllerException(controller, ServerUtil.createIOException(SchemaUtil.getTableName(schemaName, tableName), t));
            return;
        }
    }

    private static void acquireLock(Region region, byte[] key, List<Region.RowLock> locks) throws IOException {
        Region.RowLock rowLock = region.getRowLock(key, true);
        if (rowLock == null) {
            throw new IOException("Failed to acquire lock on " + Bytes.toStringBinary(key));
        }
        locks.add(rowLock);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TableViewFinderResult findChildViews(Region region, byte[] tenantId, PTable table) throws IOException {
        byte[] schemaName = table.getSchemaName().getBytes();
        byte[] tableName = table.getTableName().getBytes();
        boolean isMultiTenant = table.isMultiTenant();
        Scan scan = new Scan();
        if (!isMultiTenant) {
            byte[] startRow = ByteUtil.concat(tenantId, new byte[][]{QueryConstants.SEPARATOR_BYTE_ARRAY});
            byte[] stopRow = ByteUtil.nextKey(startRow);
            scan.setStartRow(startRow);
            scan.setStopRow(stopRow);
        }
        SingleColumnValueFilter linkFilter = new SingleColumnValueFilter(PhoenixDatabaseMetaData.TABLE_FAMILY_BYTES, PhoenixDatabaseMetaData.LINK_TYPE_BYTES, CompareFilter.CompareOp.EQUAL, PHYSICAL_TABLE_BYTES);
        linkFilter.setFilterIfMissing(true);
        byte[] suffix = ByteUtil.concat(QueryConstants.SEPARATOR_BYTE_ARRAY, new byte[][]{SchemaUtil.getTableNameAsBytes(schemaName, tableName)});
        SuffixFilter rowFilter = new SuffixFilter(suffix);
        FilterList filter = new FilterList(linkFilter, rowFilter);
        scan.setFilter(filter);
        scan.addColumn(PhoenixDatabaseMetaData.TABLE_FAMILY_BYTES, PhoenixDatabaseMetaData.LINK_TYPE_BYTES);
        try (HTableInterface hTable = ServerUtil.getHTableForCoprocessorScan(this.env, PhoenixDatabaseMetaData.SYSTEM_CATALOG_NAME_BYTES);){
            boolean allViewsInCurrentRegion = true;
            int numOfChildViews = 0;
            ArrayList<Result> results = Lists.newArrayList();
            ResultScanner scanner = hTable.getScanner(scan);
            try {
                Result result = scanner.next();
                while (result != null) {
                    ++numOfChildViews;
                    ImmutableBytesWritable ptr = new ImmutableBytesWritable();
                    ResultTuple resultTuple = new ResultTuple(result);
                    resultTuple.getKey(ptr);
                    byte[] key = ptr.copyBytes();
                    if (MetaDataEndpointImpl.checkTableKeyInRegion(key, region) != null) {
                        allViewsInCurrentRegion = false;
                    }
                    results.add(result);
                    result = scanner.next();
                }
                TableViewFinderResult tableViewFinderResult = new TableViewFinderResult(results, table);
                if (numOfChildViews > 0 && !allViewsInCurrentRegion) {
                    tableViewFinderResult.setAllViewsNotInSingleRegion();
                }
                TableViewFinderResult tableViewFinderResult2 = tableViewFinderResult;
                scanner.close();
                return tableViewFinderResult2;
            }
            catch (Throwable throwable) {
                scanner.close();
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dropTable(RpcController controller, MetaDataProtos.DropTableRequest request, RpcCallback<MetaDataProtos.MetaDataResponse> done) {
        MetaDataProtos.MetaDataResponse.Builder builder = MetaDataProtos.MetaDataResponse.newBuilder();
        boolean isCascade = request.getCascade();
        byte[][] rowKeyMetaData = new byte[3][];
        String tableType = request.getTableType();
        byte[] schemaName = null;
        byte[] tableName = null;
        try {
            Region region;
            List<Mutation> tableMetadata = ProtobufUtil.getMutations(request);
            MetaDataUtil.getTenantIdAndSchemaAndTableName(tableMetadata, rowKeyMetaData);
            byte[] tenantIdBytes = rowKeyMetaData[0];
            schemaName = rowKeyMetaData[1];
            tableName = rowKeyMetaData[2];
            if (tableType.equals(PTableType.SYSTEM.getSerializedValue())) {
                builder.setReturnCode(MetaDataProtos.MutationCode.UNALLOWED_TABLE_MUTATION);
                builder.setMutationTime(EnvironmentEdgeManager.currentTimeMillis());
                done.run(builder.build());
                return;
            }
            ArrayList<byte[]> tableNamesToDelete = Lists.newArrayList();
            byte[] parentTableName = MetaDataUtil.getParentTableName(tableMetadata);
            byte[] lockTableName = parentTableName == null ? tableName : parentTableName;
            byte[] lockKey = SchemaUtil.getTableKey(tenantIdBytes, schemaName, lockTableName);
            byte[] key = parentTableName == null ? lockKey : SchemaUtil.getTableKey(tenantIdBytes, schemaName, tableName);
            MetaDataProtocol.MetaDataMutationResult result = MetaDataEndpointImpl.checkTableKeyInRegion(key, region = this.env.getRegion());
            if (result != null) {
                done.run(MetaDataProtocol.MetaDataMutationResult.toProto(result));
                return;
            }
            ArrayList<Region.RowLock> locks = Lists.newArrayList();
            try {
                MetaDataEndpointImpl.acquireLock(region, lockKey, locks);
                if (key != lockKey) {
                    MetaDataEndpointImpl.acquireLock(region, key, locks);
                }
                ArrayList<ImmutableBytesPtr> invalidateList = new ArrayList<ImmutableBytesPtr>();
                result = this.doDropTable(key, tenantIdBytes, schemaName, tableName, parentTableName, PTableType.fromSerializedValue(tableType), tableMetadata, invalidateList, locks, tableNamesToDelete, isCascade);
                if (result.getMutationCode() != MetaDataProtocol.MutationCode.TABLE_ALREADY_EXISTS) {
                    done.run(MetaDataProtocol.MetaDataMutationResult.toProto(result));
                    return;
                }
                Cache<ImmutableBytesPtr, PMetaDataEntity> metaDataCache = GlobalCache.getInstance(this.env).getMetaDataCache();
                region.mutateRowsWithLocks(tableMetadata, Collections.emptySet(), 0L, 0L);
                long currentTime = MetaDataUtil.getClientTimeStamp(tableMetadata);
                for (ImmutableBytesPtr ckey : invalidateList) {
                    metaDataCache.put(ckey, MetaDataEndpointImpl.newDeletedTableMarker(currentTime));
                }
                if (parentTableName != null) {
                    ImmutableBytesPtr parentCacheKey = new ImmutableBytesPtr(lockKey);
                    metaDataCache.invalidate(parentCacheKey);
                }
                done.run(MetaDataProtocol.MetaDataMutationResult.toProto(result));
                return;
            }
            finally {
                region.releaseRowLocks(locks);
            }
        }
        catch (Throwable t) {
            logger.error("dropTable failed", t);
            ProtobufUtil.setControllerException(controller, ServerUtil.createIOException(SchemaUtil.getTableName(schemaName, tableName), t));
            return;
        }
    }

    private MetaDataProtocol.MetaDataMutationResult doDropTable(byte[] key, byte[] tenantId, byte[] schemaName, byte[] tableName, byte[] parentTableName, PTableType tableType, List<Mutation> rowsToDelete, List<ImmutableBytesPtr> invalidateList, List<Region.RowLock> locks, List<byte[]> tableNamesToDelete, boolean isCascade) throws IOException, SQLException {
        long clientTimeStamp = MetaDataUtil.getClientTimeStamp(rowsToDelete);
        Region region = this.env.getRegion();
        ImmutableBytesPtr cacheKey = new ImmutableBytesPtr(key);
        Cache<ImmutableBytesPtr, PMetaDataEntity> metaDataCache = GlobalCache.getInstance(this.env).getMetaDataCache();
        PTable table = (PTable)metaDataCache.getIfPresent(cacheKey);
        if (table != null || (table = this.buildTable(key, cacheKey, region, Long.MAX_VALUE)) != null) {
            if (table.getTimeStamp() < clientTimeStamp) {
                if (MetaDataEndpointImpl.isTableDeleted(table) || tableType != table.getType()) {
                    return new MetaDataProtocol.MetaDataMutationResult(MetaDataProtocol.MutationCode.TABLE_NOT_FOUND, EnvironmentEdgeManager.currentTimeMillis(), null);
                }
            } else {
                return new MetaDataProtocol.MetaDataMutationResult(MetaDataProtocol.MutationCode.NEWER_TABLE_FOUND, EnvironmentEdgeManager.currentTimeMillis(), null);
            }
        }
        if (table == null) {
            if (this.buildDeletedTable(key, cacheKey, region, clientTimeStamp) != null) {
                return new MetaDataProtocol.MetaDataMutationResult(MetaDataProtocol.MutationCode.NEWER_TABLE_FOUND, EnvironmentEdgeManager.currentTimeMillis(), null);
            }
            return new MetaDataProtocol.MetaDataMutationResult(MetaDataProtocol.MutationCode.TABLE_NOT_FOUND, EnvironmentEdgeManager.currentTimeMillis(), null);
        }
        if (!Arrays.equals(parentTableName, table.getParentTableName() == null ? null : table.getParentTableName().getBytes())) {
            return new MetaDataProtocol.MetaDataMutationResult(MetaDataProtocol.MutationCode.TABLE_NOT_FOUND, EnvironmentEdgeManager.currentTimeMillis(), null);
        }
        Scan scan = MetaDataUtil.newTableRowsScan(key, 0L, clientTimeStamp);
        ArrayList<byte[]> indexNames = Lists.newArrayList();
        ArrayList<Cell> results = Lists.newArrayList();
        try (RegionScanner scanner = region.getScanner(scan);){
            scanner.next(results);
            if (results.isEmpty()) {
                MetaDataProtocol.MetaDataMutationResult metaDataMutationResult = new MetaDataProtocol.MetaDataMutationResult(MetaDataProtocol.MutationCode.TABLE_NOT_FOUND, EnvironmentEdgeManager.currentTimeMillis(), null);
                return metaDataMutationResult;
            }
            TableViewFinderResult tableViewFinderResult = this.findChildViews(region, tenantId, table);
            if (tableViewFinderResult.hasViews()) {
                if (isCascade) {
                    if (tableViewFinderResult.allViewsInMultipleRegions()) {
                        MetaDataProtocol.MetaDataMutationResult metaDataMutationResult = new MetaDataProtocol.MetaDataMutationResult(MetaDataProtocol.MutationCode.UNALLOWED_TABLE_MUTATION, EnvironmentEdgeManager.currentTimeMillis(), null);
                        return metaDataMutationResult;
                    }
                    if (tableViewFinderResult.allViewsInSingleRegion()) {
                        for (Result viewResult : tableViewFinderResult.getResults()) {
                            byte[][] rowKeyMetaData = new byte[3][];
                            SchemaUtil.getVarChars(viewResult.getRow(), 3, rowKeyMetaData);
                            byte[] viewTenantId = rowKeyMetaData[0];
                            byte[] viewSchemaName = rowKeyMetaData[1];
                            byte[] viewName = rowKeyMetaData[2];
                            byte[] viewKey = SchemaUtil.getTableKey(viewTenantId, viewSchemaName, viewName);
                            Delete delete = new Delete(viewKey, clientTimeStamp);
                            rowsToDelete.add(delete);
                            MetaDataEndpointImpl.acquireLock(region, viewKey, locks);
                            MetaDataProtocol.MetaDataMutationResult result = this.doDropTable(viewKey, viewTenantId, viewSchemaName, viewName, null, PTableType.VIEW, rowsToDelete, invalidateList, locks, tableNamesToDelete, false);
                            if (result.getMutationCode() == MetaDataProtocol.MutationCode.TABLE_ALREADY_EXISTS) continue;
                            MetaDataProtocol.MetaDataMutationResult metaDataMutationResult = result;
                            return metaDataMutationResult;
                        }
                    }
                } else {
                    MetaDataProtocol.MetaDataMutationResult metaDataMutationResult = new MetaDataProtocol.MetaDataMutationResult(MetaDataProtocol.MutationCode.UNALLOWED_TABLE_MUTATION, EnvironmentEdgeManager.currentTimeMillis(), null);
                    return metaDataMutationResult;
                }
            }
            if (tableType != PTableType.VIEW) {
                tableNamesToDelete.add(table.getName().getBytes());
            }
            invalidateList.add(cacheKey);
            byte[][] rowKeyMetaData = new byte[5][];
            do {
                Cell kv;
                int nColumns;
                if ((nColumns = SchemaUtil.getVarChars((kv = (Cell)results.get(0)).getRowArray(), kv.getRowOffset(), kv.getRowLength(), 0, rowKeyMetaData)) == 5 && rowKeyMetaData[3].length == 0 && rowKeyMetaData[4].length > 0 && Bytes.compareTo(kv.getQualifierArray(), kv.getQualifierOffset(), kv.getQualifierLength(), PhoenixDatabaseMetaData.LINK_TYPE_BYTES, 0, PhoenixDatabaseMetaData.LINK_TYPE_BYTES.length) == 0 && PTable.LinkType.fromSerializedValue(kv.getValueArray()[kv.getValueOffset()]) == PTable.LinkType.INDEX_TABLE) {
                    indexNames.add(rowKeyMetaData[4]);
                }
                Delete delete = new Delete(kv.getRowArray(), kv.getRowOffset(), kv.getRowLength(), clientTimeStamp);
                rowsToDelete.add(delete);
                results.clear();
                scanner.next(results);
            } while (!results.isEmpty());
        }
        for (byte[] indexName : indexNames) {
            byte[] indexKey = SchemaUtil.getTableKey(tenantId, schemaName, indexName);
            Delete delete = new Delete(indexKey, clientTimeStamp);
            rowsToDelete.add(delete);
            MetaDataEndpointImpl.acquireLock(region, indexKey, locks);
            MetaDataProtocol.MetaDataMutationResult result = this.doDropTable(indexKey, tenantId, schemaName, indexName, tableName, PTableType.INDEX, rowsToDelete, invalidateList, locks, tableNamesToDelete, false);
            if (result.getMutationCode() == MetaDataProtocol.MutationCode.TABLE_ALREADY_EXISTS) continue;
            return result;
        }
        return new MetaDataProtocol.MetaDataMutationResult(MetaDataProtocol.MutationCode.TABLE_ALREADY_EXISTS, EnvironmentEdgeManager.currentTimeMillis(), table, tableNamesToDelete);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private MetaDataProtocol.MetaDataMutationResult mutateColumn(List<Mutation> tableMetadata, ColumnMutator mutator) throws IOException {
        byte[][] rowKeyMetaData = new byte[5][];
        MetaDataUtil.getTenantIdAndSchemaAndTableName(tableMetadata, rowKeyMetaData);
        byte[] tenantId = rowKeyMetaData[0];
        byte[] schemaName = rowKeyMetaData[1];
        byte[] tableName = rowKeyMetaData[2];
        try {
            byte[] key = SchemaUtil.getTableKey(tenantId, schemaName, tableName);
            Region region = this.env.getRegion();
            MetaDataProtocol.MetaDataMutationResult result = MetaDataEndpointImpl.checkTableKeyInRegion(key, region);
            if (result != null) {
                return result;
            }
            ArrayList<Region.RowLock> locks = Lists.newArrayList();
            try {
                MetaDataEndpointImpl.acquireLock(region, key, locks);
                ImmutableBytesPtr cacheKey = new ImmutableBytesPtr(key);
                ArrayList<ImmutableBytesPtr> invalidateList = new ArrayList<ImmutableBytesPtr>();
                invalidateList.add(cacheKey);
                Cache<ImmutableBytesPtr, PMetaDataEntity> metaDataCache = GlobalCache.getInstance(this.env).getMetaDataCache();
                PTable table = (PTable)metaDataCache.getIfPresent(cacheKey);
                if (logger.isDebugEnabled()) {
                    if (table == null) {
                        logger.debug("Table " + Bytes.toStringBinary(key) + " not found in cache. Will build through scan");
                    } else {
                        logger.debug("Table " + Bytes.toStringBinary(key) + " found in cache with timestamp " + table.getTimeStamp() + " seqNum " + table.getSequenceNumber());
                    }
                }
                long clientTimeStamp = MetaDataUtil.getClientTimeStamp(tableMetadata);
                if (table == null && (table = this.buildTable(key, cacheKey, region, Long.MAX_VALUE)) == null) {
                    if (this.buildDeletedTable(key, cacheKey, region, clientTimeStamp) != null) {
                        MetaDataProtocol.MetaDataMutationResult metaDataMutationResult = new MetaDataProtocol.MetaDataMutationResult(MetaDataProtocol.MutationCode.NEWER_TABLE_FOUND, EnvironmentEdgeManager.currentTimeMillis(), null);
                        return metaDataMutationResult;
                    }
                    MetaDataProtocol.MetaDataMutationResult metaDataMutationResult = new MetaDataProtocol.MetaDataMutationResult(MetaDataProtocol.MutationCode.TABLE_NOT_FOUND, EnvironmentEdgeManager.currentTimeMillis(), null);
                    return metaDataMutationResult;
                }
                if (table.getTimeStamp() >= clientTimeStamp) {
                    MetaDataProtocol.MetaDataMutationResult metaDataMutationResult = new MetaDataProtocol.MetaDataMutationResult(MetaDataProtocol.MutationCode.NEWER_TABLE_FOUND, EnvironmentEdgeManager.currentTimeMillis(), table);
                    return metaDataMutationResult;
                }
                if (MetaDataEndpointImpl.isTableDeleted(table)) {
                    MetaDataProtocol.MetaDataMutationResult metaDataMutationResult = new MetaDataProtocol.MetaDataMutationResult(MetaDataProtocol.MutationCode.TABLE_NOT_FOUND, EnvironmentEdgeManager.currentTimeMillis(), null);
                    return metaDataMutationResult;
                }
                long expectedSeqNum = MetaDataUtil.getSequenceNumber(tableMetadata) - 1L;
                if (logger.isDebugEnabled()) {
                    logger.debug("For table " + Bytes.toStringBinary(key) + " expecting seqNum " + expectedSeqNum + " and found seqNum " + table.getSequenceNumber() + " with " + table.getColumns().size() + " columns: " + table.getColumns());
                }
                if (expectedSeqNum != table.getSequenceNumber()) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("For table " + Bytes.toStringBinary(key) + " returning CONCURRENT_TABLE_MUTATION due to unexpected seqNum");
                    }
                    MetaDataProtocol.MetaDataMutationResult metaDataMutationResult = new MetaDataProtocol.MetaDataMutationResult(MetaDataProtocol.MutationCode.CONCURRENT_TABLE_MUTATION, EnvironmentEdgeManager.currentTimeMillis(), table);
                    return metaDataMutationResult;
                }
                PTableType type = table.getType();
                if (type == PTableType.INDEX) {
                    MetaDataProtocol.MetaDataMutationResult metaDataMutationResult = new MetaDataProtocol.MetaDataMutationResult(MetaDataProtocol.MutationCode.UNALLOWED_TABLE_MUTATION, EnvironmentEdgeManager.currentTimeMillis(), null);
                    return metaDataMutationResult;
                }
                Object expectedType = MetaDataUtil.getTableType(tableMetadata, GenericKeyValueBuilder.INSTANCE, new ImmutableBytesPtr());
                if (type != expectedType) {
                    MetaDataProtocol.MetaDataMutationResult metaDataMutationResult = new MetaDataProtocol.MetaDataMutationResult(MetaDataProtocol.MutationCode.TABLE_NOT_FOUND, EnvironmentEdgeManager.currentTimeMillis(), null);
                    return metaDataMutationResult;
                }
                if (this.findChildViews(region, tenantId, table).hasViews()) {
                    MetaDataProtocol.MetaDataMutationResult metaDataMutationResult = new MetaDataProtocol.MetaDataMutationResult(MetaDataProtocol.MutationCode.UNALLOWED_TABLE_MUTATION, EnvironmentEdgeManager.currentTimeMillis(), null);
                    return metaDataMutationResult;
                }
                result = mutator.updateMutation(table, rowKeyMetaData, tableMetadata, region, invalidateList, locks);
                if (result != null) {
                    expectedType = result;
                    return expectedType;
                }
                region.mutateRowsWithLocks(tableMetadata, Collections.emptySet(), 0L, 0L);
                for (ImmutableBytesPtr invalidateKey : invalidateList) {
                    metaDataCache.invalidate(invalidateKey);
                }
                long currentTime = MetaDataUtil.getClientTimeStamp(tableMetadata);
                MetaDataProtocol.MetaDataMutationResult metaDataMutationResult = new MetaDataProtocol.MetaDataMutationResult(MetaDataProtocol.MutationCode.TABLE_ALREADY_EXISTS, currentTime, null);
                return metaDataMutationResult;
            }
            finally {
                region.releaseRowLocks(locks);
            }
        }
        catch (Throwable t) {
            ServerUtil.throwIOException(SchemaUtil.getTableName(schemaName, tableName), t);
            return null;
        }
    }

    @Override
    public void addColumn(RpcController controller, MetaDataProtos.AddColumnRequest request, RpcCallback<MetaDataProtos.MetaDataResponse> done) {
        try {
            List<Mutation> tableMetaData = ProtobufUtil.getMutations(request);
            MetaDataProtocol.MetaDataMutationResult result = this.mutateColumn(tableMetaData, new ColumnMutator(){

                @Override
                public MetaDataProtocol.MetaDataMutationResult updateMutation(PTable table, byte[][] rowKeyMetaData, List<Mutation> tableMetaData, Region region, List<ImmutableBytesPtr> invalidateList, List<Region.RowLock> locks) {
                    byte[] tenantId = rowKeyMetaData[0];
                    byte[] schemaName = rowKeyMetaData[1];
                    byte[] tableName = rowKeyMetaData[2];
                    for (Mutation m : tableMetaData) {
                        byte[] key = m.getRow();
                        boolean addingPKColumn = false;
                        int pkCount = SchemaUtil.getVarChars(key, rowKeyMetaData);
                        if (pkCount <= 3 || Bytes.compareTo(schemaName, rowKeyMetaData[1]) != 0 || Bytes.compareTo(tableName, rowKeyMetaData[2]) != 0) continue;
                        try {
                            if (pkCount > 4 && rowKeyMetaData[4].length > 0) {
                                PColumnFamily family = table.getColumnFamily(rowKeyMetaData[4]);
                                family.getColumn(rowKeyMetaData[3]);
                            } else {
                                if (pkCount <= 3 || rowKeyMetaData[3].length <= 0) continue;
                                addingPKColumn = true;
                                table.getPKColumn(new String(rowKeyMetaData[3]));
                            }
                            return new MetaDataProtocol.MetaDataMutationResult(MetaDataProtocol.MutationCode.COLUMN_ALREADY_EXISTS, EnvironmentEdgeManager.currentTimeMillis(), table);
                        }
                        catch (ColumnFamilyNotFoundException e) {
                        }
                        catch (ColumnNotFoundException e) {
                            if (!addingPKColumn) continue;
                            for (PTable index : table.getIndexes()) {
                                invalidateList.add(new ImmutableBytesPtr(SchemaUtil.getTableKey(tenantId, index.getSchemaName().getBytes(), index.getTableName().getBytes())));
                            }
                        }
                    }
                    return null;
                }
            });
            if (result != null) {
                done.run(MetaDataProtocol.MetaDataMutationResult.toProto(result));
            }
        }
        catch (IOException ioe) {
            ProtobufUtil.setControllerException(controller, ioe);
        }
    }

    private PTable doGetTable(byte[] key, long clientTimeStamp) throws IOException, SQLException {
        return this.doGetTable(key, clientTimeStamp, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PTable doGetTable(byte[] key, long clientTimeStamp, Region.RowLock rowLock) throws IOException, SQLException {
        boolean wasLocked;
        ImmutableBytesPtr cacheKey = new ImmutableBytesPtr(key);
        Cache<ImmutableBytesPtr, PMetaDataEntity> metaDataCache = GlobalCache.getInstance(this.env).getMetaDataCache();
        PTable table = (PTable)metaDataCache.getIfPresent(cacheKey);
        if (table != null && table.getTimeStamp() < clientTimeStamp) {
            if (MetaDataEndpointImpl.isTableDeleted(table)) {
                return null;
            }
            return table;
        }
        Region region = this.env.getRegion();
        boolean bl = wasLocked = rowLock != null;
        if (!wasLocked && (rowLock = region.getRowLock(key, true)) == null) {
            throw new IOException("Failed to acquire lock on " + Bytes.toStringBinary(key));
        }
        try {
            table = (PTable)metaDataCache.getIfPresent(cacheKey);
            if (table != null && table.getTimeStamp() < clientTimeStamp) {
                if (MetaDataEndpointImpl.isTableDeleted(table)) {
                    PTable pTable = null;
                    return pTable;
                }
                PTable pTable = table;
                return pTable;
            }
            table = this.buildTable(key, cacheKey, region, Long.MAX_VALUE);
            if (table != null && table.getTimeStamp() < clientTimeStamp) {
                PTable pTable = table;
                return pTable;
            }
            PTable pTable = this.buildTable(key, cacheKey, region, clientTimeStamp);
            return pTable;
        }
        finally {
            if (!wasLocked) {
                rowLock.release();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<PFunction> doGetFunctions(List<byte[]> keys, long clientTimeStamp) throws IOException, SQLException {
        Cache<ImmutableBytesPtr, PMetaDataEntity> metaDataCache = GlobalCache.getInstance(this.env).getMetaDataCache();
        Region region = this.env.getRegion();
        Collections.sort(keys, new Comparator<byte[]>(){

            @Override
            public int compare(byte[] o1, byte[] o2) {
                return Bytes.compareTo(o1, o2);
            }
        });
        ArrayList<Region.RowLock> rowLocks = new ArrayList<Region.RowLock>(keys.size());
        try {
            Object object;
            Object key;
            rowLocks = new ArrayList(keys.size());
            for (int i = 0; i < keys.size(); ++i) {
                Region.RowLock rowLock = region.getRowLock(keys.get(i), true);
                if (rowLock == null) {
                    throw new IOException("Failed to acquire lock on " + Bytes.toStringBinary(keys.get(i)));
                }
                rowLocks.add(rowLock);
            }
            ArrayList<PFunction> functionsAvailable = new ArrayList<PFunction>(keys.size());
            int numFunctions = keys.size();
            Iterator<byte[]> iterator = keys.iterator();
            while (iterator.hasNext()) {
                key = iterator.next();
                PFunction function = (PFunction)metaDataCache.getIfPresent(new GlobalCache.FunctionBytesPtr((byte[])key));
                if (function == null || function.getTimeStamp() >= clientTimeStamp) continue;
                if (MetaDataEndpointImpl.isFunctionDeleted(function)) {
                    List<PFunction> list = null;
                    return list;
                }
                functionsAvailable.add(function);
                iterator.remove();
            }
            if (functionsAvailable.size() == numFunctions) {
                key = functionsAvailable;
                return key;
            }
            List<PFunction> buildFunctions = this.buildFunctions(keys, region, clientTimeStamp);
            if (buildFunctions == null || buildFunctions.isEmpty()) {
                object = null;
                return object;
            }
            functionsAvailable.addAll(buildFunctions);
            if (functionsAvailable.size() == numFunctions) {
                object = functionsAvailable;
                return object;
            }
            object = null;
            return object;
        }
        finally {
            for (Region.RowLock lock : rowLocks) {
                lock.release();
            }
            rowLocks.clear();
        }
    }

    @Override
    public void dropColumn(RpcController controller, MetaDataProtos.DropColumnRequest request, RpcCallback<MetaDataProtos.MetaDataResponse> done) {
        List<Mutation> tableMetaData = null;
        try {
            tableMetaData = ProtobufUtil.getMutations(request);
            final long clientTimeStamp = MetaDataUtil.getClientTimeStamp(tableMetaData);
            final ArrayList tableNamesToDelete = Lists.newArrayList();
            MetaDataProtocol.MetaDataMutationResult result = this.mutateColumn(tableMetaData, new ColumnMutator(){

                @Override
                public MetaDataProtocol.MetaDataMutationResult updateMutation(PTable table, byte[][] rowKeyMetaData, List<Mutation> tableMetaData, Region region, List<ImmutableBytesPtr> invalidateList, List<Region.RowLock> locks) throws IOException, SQLException {
                    byte[] tenantId = rowKeyMetaData[0];
                    byte[] schemaName = rowKeyMetaData[1];
                    byte[] tableName = rowKeyMetaData[2];
                    boolean deletePKColumn = false;
                    ArrayList<Delete> additionalTableMetaData = Lists.newArrayList();
                    for (Mutation m : tableMetaData) {
                        byte[] key;
                        int pkCount;
                        if (!(m instanceof Delete) || (pkCount = SchemaUtil.getVarChars(key = m.getRow(), rowKeyMetaData)) <= 3 || Bytes.compareTo(schemaName, rowKeyMetaData[1]) != 0 || Bytes.compareTo(tableName, rowKeyMetaData[2]) != 0) continue;
                        PColumn columnToDelete = null;
                        try {
                            if (pkCount > 4 && rowKeyMetaData[4].length > 0) {
                                PColumnFamily family = table.getColumnFamily(rowKeyMetaData[4]);
                                columnToDelete = family.getColumn(rowKeyMetaData[3]);
                            } else {
                                if (pkCount <= 3 || rowKeyMetaData[3].length <= 0) continue;
                                deletePKColumn = true;
                                columnToDelete = table.getPKColumn(new String(rowKeyMetaData[3]));
                            }
                            if (columnToDelete.isViewReferenced()) {
                                return new MetaDataProtocol.MetaDataMutationResult(MetaDataProtocol.MutationCode.UNALLOWED_TABLE_MUTATION, EnvironmentEdgeManager.currentTimeMillis(), table, columnToDelete);
                            }
                            PhoenixConnection connection = table.getIndexes().isEmpty() ? null : QueryUtil.getConnection(MetaDataEndpointImpl.this.env.getConfiguration()).unwrap(PhoenixConnection.class);
                            for (PTable index : table.getIndexes()) {
                                try {
                                    IndexMaintainer indexMaintainer = index.getIndexMaintainer(table, connection);
                                    Set<ColumnReference> indexColumns = indexMaintainer.getIndexedColumns();
                                    byte[] indexKey = SchemaUtil.getTableKey(tenantId, index.getSchemaName().getBytes(), index.getTableName().getBytes());
                                    if (indexColumns.contains(new ColumnReference(columnToDelete.getFamilyName().getBytes(), columnToDelete.getName().getBytes()))) {
                                        MetaDataEndpointImpl.acquireLock(region, indexKey, locks);
                                        additionalTableMetaData.add(new Delete(indexKey, clientTimeStamp));
                                        byte[] linkKey = MetaDataUtil.getParentLinkKey(tenantId, schemaName, tableName, index.getTableName().getBytes());
                                        additionalTableMetaData.add(new Delete(linkKey, clientTimeStamp));
                                        MetaDataEndpointImpl.this.doDropTable(indexKey, tenantId, index.getSchemaName().getBytes(), index.getTableName().getBytes(), tableName, index.getType(), additionalTableMetaData, invalidateList, locks, tableNamesToDelete, false);
                                        continue;
                                    }
                                    invalidateList.add(new ImmutableBytesPtr(indexKey));
                                }
                                catch (ColumnNotFoundException columnNotFoundException) {
                                }
                                catch (AmbiguousColumnException ambiguousColumnException) {}
                            }
                        }
                        catch (ColumnFamilyNotFoundException e) {
                            return new MetaDataProtocol.MetaDataMutationResult(MetaDataProtocol.MutationCode.COLUMN_NOT_FOUND, EnvironmentEdgeManager.currentTimeMillis(), table, columnToDelete);
                        }
                        catch (ColumnNotFoundException e) {
                            return new MetaDataProtocol.MetaDataMutationResult(MetaDataProtocol.MutationCode.COLUMN_NOT_FOUND, EnvironmentEdgeManager.currentTimeMillis(), table, columnToDelete);
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                        }
                    }
                    if (deletePKColumn && table.getPKColumns().size() == 1) {
                        return new MetaDataProtocol.MetaDataMutationResult(MetaDataProtocol.MutationCode.NO_PK_COLUMNS, EnvironmentEdgeManager.currentTimeMillis(), null);
                    }
                    tableMetaData.addAll(additionalTableMetaData);
                    return null;
                }
            });
            if (result != null) {
                done.run(MetaDataProtocol.MetaDataMutationResult.toProto(result));
            }
        }
        catch (IOException ioe) {
            ProtobufUtil.setControllerException(controller, ioe);
        }
    }

    @Override
    public void clearCache(RpcController controller, MetaDataProtos.ClearCacheRequest request, RpcCallback<MetaDataProtos.ClearCacheResponse> done) {
        GlobalCache cache = GlobalCache.getInstance(this.env);
        Cache<ImmutableBytesPtr, PMetaDataEntity> metaDataCache = GlobalCache.getInstance(this.env).getMetaDataCache();
        metaDataCache.invalidateAll();
        cache.clearTenantCache();
    }

    @Override
    public void getVersion(RpcController controller, MetaDataProtos.GetVersionRequest request, RpcCallback<MetaDataProtos.GetVersionResponse> done) {
        MetaDataProtos.GetVersionResponse.Builder builder = MetaDataProtos.GetVersionResponse.newBuilder();
        long version = MetaDataUtil.encodeHBaseAndPhoenixVersions(this.env.getHBaseVersion());
        version = MetaDataUtil.encodeMutableIndexConfiguredProperly(version, IndexManagementUtil.isWALEditCodecSet(this.env.getConfiguration()));
        builder.setVersion(version);
        done.run(builder.build());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateIndexState(RpcController controller, MetaDataProtos.UpdateIndexStateRequest request, RpcCallback<MetaDataProtos.MetaDataResponse> done) {
        MetaDataProtos.MetaDataResponse.Builder builder = MetaDataProtos.MetaDataResponse.newBuilder();
        byte[] schemaName = null;
        byte[] tableName = null;
        try {
            byte[][] rowKeyMetaData = new byte[3][];
            List<Mutation> tableMetadata = ProtobufUtil.getMutations(request);
            MetaDataUtil.getTenantIdAndSchemaAndTableName(tableMetadata, rowKeyMetaData);
            byte[] tenantId = rowKeyMetaData[0];
            schemaName = rowKeyMetaData[1];
            tableName = rowKeyMetaData[2];
            byte[] key = SchemaUtil.getTableKey(tenantId, schemaName, tableName);
            Region region = this.env.getRegion();
            MetaDataProtocol.MetaDataMutationResult result = MetaDataEndpointImpl.checkTableKeyInRegion(key, region);
            if (result != null) {
                done.run(MetaDataProtocol.MetaDataMutationResult.toProto(result));
                return;
            }
            long timeStamp = MetaDataUtil.getClientTimeStamp(tableMetadata);
            ImmutableBytesPtr cacheKey = new ImmutableBytesPtr(key);
            List newKVs = (List)tableMetadata.get(0).getFamilyCellMap().get(PhoenixDatabaseMetaData.TABLE_FAMILY_BYTES);
            Cell newKV = null;
            int disableTimeStampKVIndex = -1;
            int index = 0;
            for (Cell cell : newKVs) {
                if (Bytes.compareTo(cell.getQualifierArray(), cell.getQualifierOffset(), cell.getQualifierLength(), PhoenixDatabaseMetaData.INDEX_STATE_BYTES, 0, PhoenixDatabaseMetaData.INDEX_STATE_BYTES.length) == 0) {
                    newKV = cell;
                } else if (Bytes.compareTo(cell.getQualifierArray(), cell.getQualifierOffset(), cell.getQualifierLength(), PhoenixDatabaseMetaData.INDEX_DISABLE_TIMESTAMP_BYTES, 0, PhoenixDatabaseMetaData.INDEX_DISABLE_TIMESTAMP_BYTES.length) == 0) {
                    disableTimeStampKVIndex = index;
                }
                ++index;
            }
            PIndexState newState = PIndexState.fromSerializedValue(newKV.getValueArray()[newKV.getValueOffset()]);
            Region.RowLock rowLock = region.getRowLock(key, true);
            if (rowLock == null) {
                throw new IOException("Failed to acquire lock on " + Bytes.toStringBinary(key));
            }
            try {
                Get get = new Get(key);
                get.setTimeRange(0L, timeStamp);
                get.addColumn(PhoenixDatabaseMetaData.TABLE_FAMILY_BYTES, PhoenixDatabaseMetaData.DATA_TABLE_NAME_BYTES);
                get.addColumn(PhoenixDatabaseMetaData.TABLE_FAMILY_BYTES, PhoenixDatabaseMetaData.INDEX_STATE_BYTES);
                get.addColumn(PhoenixDatabaseMetaData.TABLE_FAMILY_BYTES, PhoenixDatabaseMetaData.INDEX_DISABLE_TIMESTAMP_BYTES);
                Result currentResult = region.get(get);
                if (currentResult.rawCells().length == 0) {
                    builder.setReturnCode(MetaDataProtos.MutationCode.TABLE_NOT_FOUND);
                    builder.setMutationTime(EnvironmentEdgeManager.currentTimeMillis());
                    done.run(builder.build());
                    return;
                }
                Cell dataTableKV = currentResult.getColumnLatestCell(PhoenixDatabaseMetaData.TABLE_FAMILY_BYTES, PhoenixDatabaseMetaData.DATA_TABLE_NAME_BYTES);
                Cell currentStateKV = currentResult.getColumnLatestCell(PhoenixDatabaseMetaData.TABLE_FAMILY_BYTES, PhoenixDatabaseMetaData.INDEX_STATE_BYTES);
                Cell currentDisableTimeStamp = currentResult.getColumnLatestCell(PhoenixDatabaseMetaData.TABLE_FAMILY_BYTES, PhoenixDatabaseMetaData.INDEX_DISABLE_TIMESTAMP_BYTES);
                PIndexState currentState = PIndexState.fromSerializedValue(currentStateKV.getValueArray()[currentStateKV.getValueOffset()]);
                if (newState == PIndexState.DISABLE && (currentState == PIndexState.DISABLE || currentState == PIndexState.INACTIVE) && currentDisableTimeStamp != null && currentDisableTimeStamp.getValueLength() > 0 && disableTimeStampKVIndex >= 0) {
                    Long curTimeStampVal = (Long)PLong.INSTANCE.toObject(currentDisableTimeStamp.getValueArray(), currentDisableTimeStamp.getValueOffset(), currentDisableTimeStamp.getValueLength());
                    Cell newDisableTimeStampCell = (Cell)newKVs.get(disableTimeStampKVIndex);
                    Long newDisableTimeStamp = (Long)PLong.INSTANCE.toObject(newDisableTimeStampCell.getValueArray(), newDisableTimeStampCell.getValueOffset(), newDisableTimeStampCell.getValueLength());
                    if (curTimeStampVal > 0L && curTimeStampVal < newDisableTimeStamp) {
                        newKVs.remove(disableTimeStampKVIndex);
                    }
                }
                if (currentState == PIndexState.BUILDING) {
                    if (newState == PIndexState.USABLE) {
                        builder.setReturnCode(MetaDataProtos.MutationCode.UNALLOWED_TABLE_MUTATION);
                        builder.setMutationTime(EnvironmentEdgeManager.currentTimeMillis());
                        done.run(builder.build());
                        return;
                    }
                } else if (currentState == PIndexState.DISABLE) {
                    if (newState != PIndexState.BUILDING && newState != PIndexState.DISABLE && newState != PIndexState.INACTIVE) {
                        builder.setReturnCode(MetaDataProtos.MutationCode.UNALLOWED_TABLE_MUTATION);
                        builder.setMutationTime(EnvironmentEdgeManager.currentTimeMillis());
                        done.run(builder.build());
                        return;
                    }
                    if (newState == PIndexState.ACTIVE) {
                        newState = PIndexState.DISABLE;
                    }
                }
                if (currentState == PIndexState.BUILDING && newState != PIndexState.ACTIVE) {
                    timeStamp = currentStateKV.getTimestamp();
                }
                if (currentState == PIndexState.UNUSABLE && newState == PIndexState.ACTIVE || currentState == PIndexState.ACTIVE && newState == PIndexState.UNUSABLE) {
                    newState = PIndexState.INACTIVE;
                    newKVs.set(0, KeyValueUtil.newKeyValue(key, PhoenixDatabaseMetaData.TABLE_FAMILY_BYTES, PhoenixDatabaseMetaData.INDEX_STATE_BYTES, timeStamp, Bytes.toBytes(newState.getSerializedValue())));
                } else if (currentState == PIndexState.INACTIVE && newState == PIndexState.USABLE) {
                    newState = PIndexState.ACTIVE;
                    newKVs.set(0, KeyValueUtil.newKeyValue(key, PhoenixDatabaseMetaData.TABLE_FAMILY_BYTES, PhoenixDatabaseMetaData.INDEX_STATE_BYTES, timeStamp, Bytes.toBytes(newState.getSerializedValue())));
                }
                if (currentState != newState) {
                    byte[] dataTableKey = null;
                    if (dataTableKV != null) {
                        dataTableKey = SchemaUtil.getTableKey(tenantId, schemaName, dataTableKV.getValue());
                    }
                    if (dataTableKey != null) {
                        tableMetadata = new ArrayList<Mutation>(tableMetadata);
                        Put p = new Put(dataTableKey);
                        p.add(PhoenixDatabaseMetaData.TABLE_FAMILY_BYTES, QueryConstants.EMPTY_COLUMN_BYTES, timeStamp, ByteUtil.EMPTY_BYTE_ARRAY);
                        tableMetadata.add(p);
                    }
                    region.mutateRowsWithLocks(tableMetadata, Collections.emptySet(), 0L, 0L);
                    Cache<ImmutableBytesPtr, PMetaDataEntity> metaDataCache = GlobalCache.getInstance(this.env).getMetaDataCache();
                    metaDataCache.invalidate(cacheKey);
                    if (dataTableKey != null) {
                        metaDataCache.invalidate(new ImmutableBytesPtr(dataTableKey));
                    }
                }
                long currentTime = MetaDataUtil.getClientTimeStamp(tableMetadata);
                builder.setReturnCode(MetaDataProtos.MutationCode.TABLE_ALREADY_EXISTS);
                builder.setMutationTime(currentTime);
                done.run(builder.build());
                return;
            }
            finally {
                rowLock.release();
            }
        }
        catch (Throwable t) {
            logger.error("updateIndexState failed", t);
            ProtobufUtil.setControllerException(controller, ServerUtil.createIOException(SchemaUtil.getTableName(schemaName, tableName), t));
            return;
        }
    }

    private static MetaDataProtocol.MetaDataMutationResult checkTableKeyInRegion(byte[] key, Region region) {
        byte[] startKey = region.getRegionInfo().getStartKey();
        byte[] endKey = region.getRegionInfo().getEndKey();
        if (Bytes.compareTo(startKey, key) <= 0 && (Bytes.compareTo(HConstants.LAST_ROW, endKey) == 0 || Bytes.compareTo(key, endKey) < 0)) {
            return null;
        }
        return new MetaDataProtocol.MetaDataMutationResult(MetaDataProtocol.MutationCode.TABLE_NOT_IN_REGION, EnvironmentEdgeManager.currentTimeMillis(), null);
    }

    private static MetaDataProtocol.MetaDataMutationResult checkFunctionKeyInRegion(byte[] key, Region region) {
        byte[] startKey = region.getRegionInfo().getStartKey();
        byte[] endKey = region.getRegionInfo().getEndKey();
        if (Bytes.compareTo(startKey, key) <= 0 && (Bytes.compareTo(HConstants.LAST_ROW, endKey) == 0 || Bytes.compareTo(key, endKey) < 0)) {
            return null;
        }
        return new MetaDataProtocol.MetaDataMutationResult(MetaDataProtocol.MutationCode.FUNCTION_NOT_IN_REGION, EnvironmentEdgeManager.currentTimeMillis(), null);
    }

    @Override
    public void clearTableFromCache(RpcController controller, MetaDataProtos.ClearTableFromCacheRequest request, RpcCallback<MetaDataProtos.ClearTableFromCacheResponse> done) {
        byte[] schemaName = request.getSchemaName().toByteArray();
        byte[] tableName = request.getTableName().toByteArray();
        try {
            byte[] tenantId = request.getTenantId().toByteArray();
            byte[] key = SchemaUtil.getTableKey(tenantId, schemaName, tableName);
            ImmutableBytesPtr cacheKey = new ImmutableBytesPtr(key);
            Cache<ImmutableBytesPtr, PMetaDataEntity> metaDataCache = GlobalCache.getInstance(this.env).getMetaDataCache();
            metaDataCache.invalidate(cacheKey);
        }
        catch (Throwable t) {
            logger.error("incrementTableTimeStamp failed", t);
            ProtobufUtil.setControllerException(controller, ServerUtil.createIOException(SchemaUtil.getTableName(schemaName, tableName), t));
        }
    }

    @Override
    public void getFunctions(RpcController controller, MetaDataProtos.GetFunctionsRequest request, RpcCallback<MetaDataProtos.MetaDataResponse> done) {
        MetaDataProtos.MetaDataResponse.Builder builder = MetaDataProtos.MetaDataResponse.newBuilder();
        byte[] tenantId = request.getTenantId().toByteArray();
        ArrayList<String> functionNames = new ArrayList<String>(request.getFunctionNamesCount());
        try {
            Region region = this.env.getRegion();
            List<ByteString> functionNamesList = request.getFunctionNamesList();
            List<Long> functionTimestampsList = request.getFunctionTimestampsList();
            ArrayList<byte[]> keys = new ArrayList<byte[]>(request.getFunctionNamesCount());
            ArrayList<Pair<byte[], Long>> functions = new ArrayList<Pair<byte[], Long>>(request.getFunctionNamesCount());
            for (int i = 0; i < functionNamesList.size(); ++i) {
                byte[] functionName = functionNamesList.get(i).toByteArray();
                functionNames.add(Bytes.toString(functionName));
                byte[] key = SchemaUtil.getFunctionKey(tenantId, functionName);
                MetaDataProtocol.MetaDataMutationResult result = MetaDataEndpointImpl.checkFunctionKeyInRegion(key, region);
                if (result != null) {
                    done.run(MetaDataProtocol.MetaDataMutationResult.toProto(result));
                    return;
                }
                functions.add(new Pair<byte[], Long>(functionName, functionTimestampsList.get(i)));
                keys.add(key);
            }
            long currentTime = EnvironmentEdgeManager.currentTimeMillis();
            List<PFunction> functionsAvailable = this.doGetFunctions(keys, request.getClientTimestamp());
            if (functionsAvailable == null) {
                builder.setReturnCode(MetaDataProtos.MutationCode.FUNCTION_NOT_FOUND);
                builder.setMutationTime(currentTime);
                done.run(builder.build());
                return;
            }
            builder.setReturnCode(MetaDataProtos.MutationCode.FUNCTION_ALREADY_EXISTS);
            builder.setMutationTime(currentTime);
            for (PFunction function : functionsAvailable) {
                builder.addFunction(PFunction.toProto(function));
            }
            done.run(builder.build());
            return;
        }
        catch (Throwable t) {
            logger.error("getFunctions failed", t);
            ProtobufUtil.setControllerException(controller, ServerUtil.createIOException(((Object)functionNames).toString(), t));
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void createFunction(RpcController controller, MetaDataProtos.CreateFunctionRequest request, RpcCallback<MetaDataProtos.MetaDataResponse> done) {
        MetaDataProtos.MetaDataResponse.Builder builder = MetaDataProtos.MetaDataResponse.newBuilder();
        byte[][] rowKeyMetaData = new byte[2][];
        byte[] functionName = null;
        try {
            List<Mutation> functionMetaData = ProtobufUtil.getMutations(request);
            boolean temporaryFunction = request.getTemporary();
            MetaDataUtil.getTenantIdAndFunctionName(functionMetaData, rowKeyMetaData);
            byte[] tenantIdBytes = rowKeyMetaData[0];
            functionName = rowKeyMetaData[1];
            byte[] lockKey = SchemaUtil.getFunctionKey(tenantIdBytes, functionName);
            Region region = this.env.getRegion();
            MetaDataProtocol.MetaDataMutationResult result = MetaDataEndpointImpl.checkFunctionKeyInRegion(lockKey, region);
            if (result != null) {
                done.run(MetaDataProtocol.MetaDataMutationResult.toProto(result));
                return;
            }
            ArrayList<Region.RowLock> locks = Lists.newArrayList();
            long clientTimeStamp = MetaDataUtil.getClientTimeStamp(functionMetaData);
            try {
                MetaDataEndpointImpl.acquireLock(region, lockKey, locks);
                GlobalCache.FunctionBytesPtr cacheKey = new GlobalCache.FunctionBytesPtr(lockKey);
                PFunction function = this.loadFunction(this.env, lockKey, cacheKey, clientTimeStamp, clientTimeStamp);
                if (function != null) {
                    if (function.getTimeStamp() < clientTimeStamp) {
                        if (!MetaDataEndpointImpl.isFunctionDeleted(function)) {
                            builder.setReturnCode(MetaDataProtos.MutationCode.FUNCTION_ALREADY_EXISTS);
                            builder.setMutationTime(EnvironmentEdgeManager.currentTimeMillis());
                            builder.addFunction(PFunction.toProto(function));
                            done.run(builder.build());
                            return;
                        }
                    } else {
                        builder.setReturnCode(MetaDataProtos.MutationCode.NEWER_FUNCTION_FOUND);
                        builder.setMutationTime(EnvironmentEdgeManager.currentTimeMillis());
                        builder.addFunction(PFunction.toProto(function));
                        done.run(builder.build());
                        return;
                    }
                }
                if (!temporaryFunction) {
                    region.mutateRowsWithLocks(functionMetaData, Collections.emptySet(), 0L, 0L);
                }
                Cache<ImmutableBytesPtr, PMetaDataEntity> metaDataCache = GlobalCache.getInstance(this.env).getMetaDataCache();
                metaDataCache.invalidate(cacheKey);
                long currentTimeStamp = MetaDataUtil.getClientTimeStamp(functionMetaData);
                builder.setReturnCode(MetaDataProtos.MutationCode.FUNCTION_NOT_FOUND);
                builder.setMutationTime(currentTimeStamp);
                done.run(builder.build());
                return;
            }
            finally {
                region.releaseRowLocks(locks);
            }
        }
        catch (Throwable t) {
            logger.error("createFunction failed", t);
            ProtobufUtil.setControllerException(controller, ServerUtil.createIOException(Bytes.toString(functionName), t));
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dropFunction(RpcController controller, MetaDataProtos.DropFunctionRequest request, RpcCallback<MetaDataProtos.MetaDataResponse> done) {
        byte[][] rowKeyMetaData = new byte[2][];
        byte[] functionName = null;
        try {
            List<Mutation> functionMetaData = ProtobufUtil.getMutations(request);
            MetaDataUtil.getTenantIdAndFunctionName(functionMetaData, rowKeyMetaData);
            byte[] tenantIdBytes = rowKeyMetaData[0];
            functionName = rowKeyMetaData[1];
            byte[] lockKey = SchemaUtil.getFunctionKey(tenantIdBytes, functionName);
            Region region = this.env.getRegion();
            MetaDataProtocol.MetaDataMutationResult result = MetaDataEndpointImpl.checkFunctionKeyInRegion(lockKey, region);
            if (result != null) {
                done.run(MetaDataProtocol.MetaDataMutationResult.toProto(result));
                return;
            }
            ArrayList<Region.RowLock> locks = Lists.newArrayList();
            long clientTimeStamp = MetaDataUtil.getClientTimeStamp(functionMetaData);
            try {
                MetaDataEndpointImpl.acquireLock(region, lockKey, locks);
                ArrayList<byte[]> keys = new ArrayList<byte[]>(1);
                keys.add(lockKey);
                ArrayList<ImmutableBytesPtr> invalidateList = new ArrayList<ImmutableBytesPtr>();
                result = this.doDropFunction(clientTimeStamp, keys, functionMetaData, invalidateList);
                if (result.getMutationCode() != MetaDataProtocol.MutationCode.FUNCTION_ALREADY_EXISTS) {
                    done.run(MetaDataProtocol.MetaDataMutationResult.toProto(result));
                    return;
                }
                region.mutateRowsWithLocks(functionMetaData, Collections.emptySet(), 0L, 0L);
                Cache<ImmutableBytesPtr, PMetaDataEntity> metaDataCache = GlobalCache.getInstance(this.env).getMetaDataCache();
                long currentTime = MetaDataUtil.getClientTimeStamp(functionMetaData);
                for (ImmutableBytesPtr ptr : invalidateList) {
                    metaDataCache.invalidate(ptr);
                    metaDataCache.put(ptr, MetaDataEndpointImpl.newDeletedFunctionMarker(currentTime));
                }
                done.run(MetaDataProtocol.MetaDataMutationResult.toProto(result));
                return;
            }
            finally {
                region.releaseRowLocks(locks);
            }
        }
        catch (Throwable t) {
            logger.error("dropFunction failed", t);
            ProtobufUtil.setControllerException(controller, ServerUtil.createIOException(Bytes.toString(functionName), t));
            return;
        }
    }

    private MetaDataProtocol.MetaDataMutationResult doDropFunction(long clientTimeStamp, List<byte[]> keys, List<Mutation> functionMetaData, List<ImmutableBytesPtr> invalidateList) throws IOException, SQLException {
        ArrayList<byte[]> keysClone = new ArrayList<byte[]>(keys);
        List<PFunction> functions = this.doGetFunctions(keysClone, clientTimeStamp);
        if (functions == null || functions.isEmpty()) {
            if (this.buildDeletedFunction(keys.get(0), new GlobalCache.FunctionBytesPtr(keys.get(0)), this.env.getRegion(), clientTimeStamp) != null) {
                return new MetaDataProtocol.MetaDataMutationResult(MetaDataProtocol.MutationCode.FUNCTION_ALREADY_EXISTS, EnvironmentEdgeManager.currentTimeMillis(), null);
            }
            return new MetaDataProtocol.MetaDataMutationResult(MetaDataProtocol.MutationCode.FUNCTION_NOT_FOUND, EnvironmentEdgeManager.currentTimeMillis(), null);
        }
        if (functions != null && !functions.isEmpty() && functions.get(0).getTimeStamp() < clientTimeStamp) {
            if (MetaDataEndpointImpl.isFunctionDeleted(functions.get(0))) {
                return new MetaDataProtocol.MetaDataMutationResult(MetaDataProtocol.MutationCode.FUNCTION_NOT_FOUND, EnvironmentEdgeManager.currentTimeMillis(), null);
            }
            invalidateList.add(new GlobalCache.FunctionBytesPtr(keys.get(0)));
            Region region = this.env.getRegion();
            Scan scan = MetaDataUtil.newTableRowsScan(keys.get(0), 0L, clientTimeStamp);
            ArrayList<Cell> results = Lists.newArrayList();
            try (RegionScanner scanner = region.getScanner(scan);){
                scanner.next(results);
                if (results.isEmpty()) {
                    MetaDataProtocol.MetaDataMutationResult metaDataMutationResult = new MetaDataProtocol.MetaDataMutationResult(MetaDataProtocol.MutationCode.FUNCTION_NOT_FOUND, EnvironmentEdgeManager.currentTimeMillis(), null);
                    return metaDataMutationResult;
                }
                do {
                    Cell kv = (Cell)results.get(0);
                    Delete delete = new Delete(kv.getRowArray(), kv.getRowOffset(), kv.getRowLength(), clientTimeStamp);
                    functionMetaData.add(delete);
                    results.clear();
                    scanner.next(results);
                } while (!results.isEmpty());
            }
            return new MetaDataProtocol.MetaDataMutationResult(MetaDataProtocol.MutationCode.FUNCTION_ALREADY_EXISTS, EnvironmentEdgeManager.currentTimeMillis(), functions, true);
        }
        return new MetaDataProtocol.MetaDataMutationResult(MetaDataProtocol.MutationCode.FUNCTION_NOT_FOUND, EnvironmentEdgeManager.currentTimeMillis(), null);
    }

    static {
        Collections.sort(TABLE_KV_COLUMNS, KeyValue.COMPARATOR);
        TABLE_TYPE_INDEX = TABLE_KV_COLUMNS.indexOf(TABLE_TYPE_KV);
        TABLE_SEQ_NUM_INDEX = TABLE_KV_COLUMNS.indexOf(TABLE_SEQ_NUM_KV);
        COLUMN_COUNT_INDEX = TABLE_KV_COLUMNS.indexOf(COLUMN_COUNT_KV);
        SALT_BUCKETS_INDEX = TABLE_KV_COLUMNS.indexOf(SALT_BUCKETS_KV);
        PK_NAME_INDEX = TABLE_KV_COLUMNS.indexOf(PK_NAME_KV);
        DATA_TABLE_NAME_INDEX = TABLE_KV_COLUMNS.indexOf(DATA_TABLE_NAME_KV);
        INDEX_STATE_INDEX = TABLE_KV_COLUMNS.indexOf(INDEX_STATE_KV);
        IMMUTABLE_ROWS_INDEX = TABLE_KV_COLUMNS.indexOf(IMMUTABLE_ROWS_KV);
        VIEW_STATEMENT_INDEX = TABLE_KV_COLUMNS.indexOf(VIEW_EXPRESSION_KV);
        DEFAULT_COLUMN_FAMILY_INDEX = TABLE_KV_COLUMNS.indexOf(DEFAULT_COLUMN_FAMILY_KV);
        DISABLE_WAL_INDEX = TABLE_KV_COLUMNS.indexOf(DISABLE_WAL_KV);
        MULTI_TENANT_INDEX = TABLE_KV_COLUMNS.indexOf(MULTI_TENANT_KV);
        VIEW_TYPE_INDEX = TABLE_KV_COLUMNS.indexOf(VIEW_TYPE_KV);
        VIEW_INDEX_ID_INDEX = TABLE_KV_COLUMNS.indexOf(VIEW_INDEX_ID_KV);
        INDEX_TYPE_INDEX = TABLE_KV_COLUMNS.indexOf(INDEX_TYPE_KV);
        STORE_NULLS_INDEX = TABLE_KV_COLUMNS.indexOf(STORE_NULLS_KV);
        DECIMAL_DIGITS_KV = KeyValue.createFirstOnRow(ByteUtil.EMPTY_BYTE_ARRAY, PhoenixDatabaseMetaData.TABLE_FAMILY_BYTES, PhoenixDatabaseMetaData.DECIMAL_DIGITS_BYTES);
        COLUMN_SIZE_KV = KeyValue.createFirstOnRow(ByteUtil.EMPTY_BYTE_ARRAY, PhoenixDatabaseMetaData.TABLE_FAMILY_BYTES, PhoenixDatabaseMetaData.COLUMN_SIZE_BYTES);
        NULLABLE_KV = KeyValue.createFirstOnRow(ByteUtil.EMPTY_BYTE_ARRAY, PhoenixDatabaseMetaData.TABLE_FAMILY_BYTES, PhoenixDatabaseMetaData.NULLABLE_BYTES);
        DATA_TYPE_KV = KeyValue.createFirstOnRow(ByteUtil.EMPTY_BYTE_ARRAY, PhoenixDatabaseMetaData.TABLE_FAMILY_BYTES, PhoenixDatabaseMetaData.DATA_TYPE_BYTES);
        ORDINAL_POSITION_KV = KeyValue.createFirstOnRow(ByteUtil.EMPTY_BYTE_ARRAY, PhoenixDatabaseMetaData.TABLE_FAMILY_BYTES, PhoenixDatabaseMetaData.ORDINAL_POSITION_BYTES);
        SORT_ORDER_KV = KeyValue.createFirstOnRow(ByteUtil.EMPTY_BYTE_ARRAY, PhoenixDatabaseMetaData.TABLE_FAMILY_BYTES, PhoenixDatabaseMetaData.SORT_ORDER_BYTES);
        ARRAY_SIZE_KV = KeyValue.createFirstOnRow(ByteUtil.EMPTY_BYTE_ARRAY, PhoenixDatabaseMetaData.TABLE_FAMILY_BYTES, PhoenixDatabaseMetaData.ARRAY_SIZE_BYTES);
        VIEW_CONSTANT_KV = KeyValue.createFirstOnRow(ByteUtil.EMPTY_BYTE_ARRAY, PhoenixDatabaseMetaData.TABLE_FAMILY_BYTES, PhoenixDatabaseMetaData.VIEW_CONSTANT_BYTES);
        IS_VIEW_REFERENCED_KV = KeyValue.createFirstOnRow(ByteUtil.EMPTY_BYTE_ARRAY, PhoenixDatabaseMetaData.TABLE_FAMILY_BYTES, PhoenixDatabaseMetaData.IS_VIEW_REFERENCED_BYTES);
        COLUMN_DEF_KV = KeyValue.createFirstOnRow(ByteUtil.EMPTY_BYTE_ARRAY, PhoenixDatabaseMetaData.TABLE_FAMILY_BYTES, PhoenixDatabaseMetaData.COLUMN_DEF_BYTES);
        IS_ROW_TIMESTAMP_KV = KeyValue.createFirstOnRow(ByteUtil.EMPTY_BYTE_ARRAY, PhoenixDatabaseMetaData.TABLE_FAMILY_BYTES, PhoenixDatabaseMetaData.IS_ROW_TIMESTAMP_BYTES);
        COLUMN_KV_COLUMNS = Arrays.asList(DECIMAL_DIGITS_KV, COLUMN_SIZE_KV, NULLABLE_KV, DATA_TYPE_KV, ORDINAL_POSITION_KV, SORT_ORDER_KV, DATA_TABLE_NAME_KV, ARRAY_SIZE_KV, VIEW_CONSTANT_KV, IS_VIEW_REFERENCED_KV, COLUMN_DEF_KV, IS_ROW_TIMESTAMP_KV);
        Collections.sort(COLUMN_KV_COLUMNS, KeyValue.COMPARATOR);
        DECIMAL_DIGITS_INDEX = COLUMN_KV_COLUMNS.indexOf(DECIMAL_DIGITS_KV);
        COLUMN_SIZE_INDEX = COLUMN_KV_COLUMNS.indexOf(COLUMN_SIZE_KV);
        NULLABLE_INDEX = COLUMN_KV_COLUMNS.indexOf(NULLABLE_KV);
        DATA_TYPE_INDEX = COLUMN_KV_COLUMNS.indexOf(DATA_TYPE_KV);
        ORDINAL_POSITION_INDEX = COLUMN_KV_COLUMNS.indexOf(ORDINAL_POSITION_KV);
        SORT_ORDER_INDEX = COLUMN_KV_COLUMNS.indexOf(SORT_ORDER_KV);
        ARRAY_SIZE_INDEX = COLUMN_KV_COLUMNS.indexOf(ARRAY_SIZE_KV);
        VIEW_CONSTANT_INDEX = COLUMN_KV_COLUMNS.indexOf(VIEW_CONSTANT_KV);
        IS_VIEW_REFERENCED_INDEX = COLUMN_KV_COLUMNS.indexOf(IS_VIEW_REFERENCED_KV);
        COLUMN_DEF_INDEX = COLUMN_KV_COLUMNS.indexOf(COLUMN_DEF_KV);
        IS_ROW_TIMESTAMP_INDEX = COLUMN_KV_COLUMNS.indexOf(IS_ROW_TIMESTAMP_KV);
        CLASS_NAME_KV = KeyValue.createFirstOnRow(ByteUtil.EMPTY_BYTE_ARRAY, PhoenixDatabaseMetaData.TABLE_FAMILY_BYTES, PhoenixDatabaseMetaData.CLASS_NAME_BYTES);
        JAR_PATH_KV = KeyValue.createFirstOnRow(ByteUtil.EMPTY_BYTE_ARRAY, PhoenixDatabaseMetaData.TABLE_FAMILY_BYTES, PhoenixDatabaseMetaData.JAR_PATH_BYTES);
        RETURN_TYPE_KV = KeyValue.createFirstOnRow(ByteUtil.EMPTY_BYTE_ARRAY, PhoenixDatabaseMetaData.TABLE_FAMILY_BYTES, PhoenixDatabaseMetaData.RETURN_TYPE_BYTES);
        NUM_ARGS_KV = KeyValue.createFirstOnRow(ByteUtil.EMPTY_BYTE_ARRAY, PhoenixDatabaseMetaData.TABLE_FAMILY_BYTES, PhoenixDatabaseMetaData.NUM_ARGS_BYTES);
        TYPE_KV = KeyValue.createFirstOnRow(ByteUtil.EMPTY_BYTE_ARRAY, PhoenixDatabaseMetaData.TABLE_FAMILY_BYTES, PhoenixDatabaseMetaData.TYPE_BYTES);
        IS_CONSTANT_KV = KeyValue.createFirstOnRow(ByteUtil.EMPTY_BYTE_ARRAY, PhoenixDatabaseMetaData.TABLE_FAMILY_BYTES, PhoenixDatabaseMetaData.IS_CONSTANT_BYTES);
        DEFAULT_VALUE_KV = KeyValue.createFirstOnRow(ByteUtil.EMPTY_BYTE_ARRAY, PhoenixDatabaseMetaData.TABLE_FAMILY_BYTES, PhoenixDatabaseMetaData.DEFAULT_VALUE_BYTES);
        MIN_VALUE_KV = KeyValue.createFirstOnRow(ByteUtil.EMPTY_BYTE_ARRAY, PhoenixDatabaseMetaData.TABLE_FAMILY_BYTES, PhoenixDatabaseMetaData.MIN_VALUE_BYTES);
        MAX_VALUE_KV = KeyValue.createFirstOnRow(ByteUtil.EMPTY_BYTE_ARRAY, PhoenixDatabaseMetaData.TABLE_FAMILY_BYTES, PhoenixDatabaseMetaData.MAX_VALUE_BYTES);
        IS_ARRAY_KV = KeyValue.createFirstOnRow(ByteUtil.EMPTY_BYTE_ARRAY, PhoenixDatabaseMetaData.TABLE_FAMILY_BYTES, PhoenixDatabaseMetaData.IS_ARRAY_BYTES);
        FUNCTION_KV_COLUMNS = Arrays.asList(EMPTY_KEYVALUE_KV, CLASS_NAME_KV, JAR_PATH_KV, RETURN_TYPE_KV, NUM_ARGS_KV);
        Collections.sort(FUNCTION_KV_COLUMNS, KeyValue.COMPARATOR);
        CLASS_NAME_INDEX = FUNCTION_KV_COLUMNS.indexOf(CLASS_NAME_KV);
        JAR_PATH_INDEX = FUNCTION_KV_COLUMNS.indexOf(JAR_PATH_KV);
        RETURN_TYPE_INDEX = FUNCTION_KV_COLUMNS.indexOf(RETURN_TYPE_KV);
        NUM_ARGS_INDEX = FUNCTION_KV_COLUMNS.indexOf(NUM_ARGS_KV);
        FUNCTION_ARG_KV_COLUMNS = Arrays.asList(TYPE_KV, IS_ARRAY_KV, IS_CONSTANT_KV, DEFAULT_VALUE_KV, MIN_VALUE_KV, MAX_VALUE_KV);
        Collections.sort(FUNCTION_ARG_KV_COLUMNS, KeyValue.COMPARATOR);
        TYPE_INDEX = FUNCTION_ARG_KV_COLUMNS.indexOf(TYPE_KV);
        IS_ARRAY_INDEX = FUNCTION_ARG_KV_COLUMNS.indexOf(IS_ARRAY_KV);
        IS_CONSTANT_INDEX = FUNCTION_ARG_KV_COLUMNS.indexOf(IS_CONSTANT_KV);
        DEFAULT_VALUE_INDEX = FUNCTION_ARG_KV_COLUMNS.indexOf(DEFAULT_VALUE_KV);
        MIN_VALUE_INDEX = FUNCTION_ARG_KV_COLUMNS.indexOf(MIN_VALUE_KV);
        MAX_VALUE_INDEX = FUNCTION_ARG_KV_COLUMNS.indexOf(MAX_VALUE_KV);
        PHYSICAL_TABLE_BYTES = new byte[]{PTable.LinkType.PHYSICAL_TABLE.getSerializedValue()};
    }

    private static class TableViewFinderResult {
        private List<Result> results = Lists.newArrayList();
        private boolean allViewsNotInSingleRegion = false;
        private PTable table;

        private TableViewFinderResult(List<Result> results, PTable table) {
            this.results = results;
            this.table = table;
        }

        public boolean hasViews() {
            int localIndexesCount = 0;
            for (PTable index : this.table.getIndexes()) {
                if (!index.getIndexType().equals((Object)PTable.IndexType.LOCAL)) continue;
                ++localIndexesCount;
            }
            return this.results.size() - localIndexesCount > 0;
        }

        private void setAllViewsNotInSingleRegion() {
            this.allViewsNotInSingleRegion = true;
        }

        private List<Result> getResults() {
            return this.results;
        }

        private boolean allViewsInSingleRegion() {
            return this.results.size() > 0 && !this.allViewsNotInSingleRegion;
        }

        private boolean allViewsInMultipleRegions() {
            return this.results.size() > 0 && this.allViewsNotInSingleRegion;
        }
    }

    private static interface ColumnMutator {
        public MetaDataProtocol.MetaDataMutationResult updateMutation(PTable var1, byte[][] var2, List<Mutation> var3, Region var4, List<ImmutableBytesPtr> var5, List<Region.RowLock> var6) throws IOException, SQLException;
    }
}

