/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.coprocessor;

import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.util.List;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CoprocessorEnvironment;
import org.apache.hadoop.hbase.DoNotRetryIOException;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.coprocessor.BaseRegionObserver;
import org.apache.hadoop.hbase.coprocessor.ObserverContext;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessorEnvironment;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.regionserver.Region;
import org.apache.hadoop.hbase.regionserver.RegionScanner;
import org.apache.hadoop.hbase.regionserver.ScannerContext;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.htrace.Span;
import org.apache.htrace.Trace;
import org.apache.phoenix.coprocessor.DelegateRegionScanner;
import org.apache.phoenix.execute.TupleProjector;
import org.apache.phoenix.expression.Expression;
import org.apache.phoenix.expression.KeyValueColumnExpression;
import org.apache.phoenix.hbase.index.covered.update.ColumnReference;
import org.apache.phoenix.index.IndexMaintainer;
import org.apache.phoenix.query.QueryConstants;
import org.apache.phoenix.schema.KeyValueSchema;
import org.apache.phoenix.schema.StaleRegionBoundaryCacheException;
import org.apache.phoenix.schema.ValueBitSet;
import org.apache.phoenix.schema.tuple.MultiKeyValueTuple;
import org.apache.phoenix.schema.tuple.ResultTuple;
import org.apache.phoenix.util.IndexUtil;
import org.apache.phoenix.util.ScanUtil;
import org.apache.phoenix.util.ServerUtil;

public abstract class BaseScannerRegionObserver
extends BaseRegionObserver {
    public static final String AGGREGATORS = "_Aggs";
    public static final String UNORDERED_GROUP_BY_EXPRESSIONS = "_UnorderedGroupByExpressions";
    public static final String KEY_ORDERED_GROUP_BY_EXPRESSIONS = "_OrderedGroupByExpressions";
    public static final String ESTIMATED_DISTINCT_VALUES = "_EstDistinctValues";
    public static final String NON_AGGREGATE_QUERY = "_NonAggregateQuery";
    public static final String TOPN = "_TopN";
    public static final String UNGROUPED_AGG = "_UngroupedAgg";
    public static final String DELETE_AGG = "_DeleteAgg";
    public static final String UPSERT_SELECT_TABLE = "_UpsertSelectTable";
    public static final String UPSERT_SELECT_EXPRS = "_UpsertSelectExprs";
    public static final String DELETE_CQ = "_DeleteCQ";
    public static final String DELETE_CF = "_DeleteCF";
    public static final String EMPTY_CF = "_EmptyCF";
    public static final String SPECIFIC_ARRAY_INDEX = "_SpecificArrayIndex";
    public static final String GROUP_BY_LIMIT = "_GroupByLimit";
    public static final String LOCAL_INDEX = "_LocalIndex";
    public static final String LOCAL_INDEX_BUILD = "_LocalIndexBuild";
    public static final String LOCAL_INDEX_JOIN_SCHEMA = "_LocalIndexJoinSchema";
    public static final String DATA_TABLE_COLUMNS_TO_JOIN = "_DataTableColumnsToJoin";
    public static final String VIEW_CONSTANTS = "_ViewConstants";
    public static final String STARTKEY_OFFSET = "_StartKeyOffset";
    public static final String EXPECTED_UPPER_REGION_KEY = "_ExpectedUpperRegionKey";
    public static final String REVERSE_SCAN = "_ReverseScan";
    public static final String ANALYZE_TABLE = "_ANALYZETABLE";
    public static final String GUIDEPOST_WIDTH_BYTES = "_GUIDEPOST_WIDTH_BYTES";
    public static final String GUIDEPOST_PER_REGION = "_GUIDEPOST_PER_REGION";
    public static final String SKIP_REGION_BOUNDARY_CHECK = "_SKIP_REGION_BOUNDARY_CHECK";
    public static final String CUSTOM_ANNOTATIONS = "_Annot";
    public static final String SCANNER_OPENED_TRACE_INFO = "Scanner opened on server";
    protected Configuration rawConf;

    @Override
    public void start(CoprocessorEnvironment e) throws IOException {
        super.start(e);
        this.rawConf = ((RegionCoprocessorEnvironment)e).getRegionServerServices().getConfiguration();
    }

    public String toString() {
        return this.getClass().getName();
    }

    private static void throwIfScanOutOfRegion(Scan scan, Region region) throws DoNotRetryIOException {
        boolean isStaleRegionBoundaries;
        boolean isLocalIndex = ScanUtil.isLocalIndex(scan);
        byte[] lowerInclusiveScanKey = scan.getStartRow();
        byte[] upperExclusiveScanKey = scan.getStopRow();
        byte[] lowerInclusiveRegionKey = region.getRegionInfo().getStartKey();
        byte[] upperExclusiveRegionKey = region.getRegionInfo().getEndKey();
        if (isLocalIndex) {
            byte[] expectedUpperRegionKey = scan.getAttribute(EXPECTED_UPPER_REGION_KEY);
            isStaleRegionBoundaries = expectedUpperRegionKey != null && Bytes.compareTo(upperExclusiveRegionKey, expectedUpperRegionKey) != 0;
        } else {
            boolean bl = isStaleRegionBoundaries = Bytes.compareTo(lowerInclusiveScanKey, lowerInclusiveRegionKey) < 0 || Bytes.compareTo(upperExclusiveScanKey, upperExclusiveRegionKey) > 0 && upperExclusiveRegionKey.length != 0;
        }
        if (isStaleRegionBoundaries) {
            StaleRegionBoundaryCacheException cause = new StaleRegionBoundaryCacheException(region.getRegionInfo().getTable().getNameAsString());
            throw new DoNotRetryIOException(cause.getMessage(), cause);
        }
    }

    protected abstract boolean isRegionObserverFor(Scan var1);

    protected abstract RegionScanner doPostScannerOpen(ObserverContext<RegionCoprocessorEnvironment> var1, Scan var2, RegionScanner var3) throws Throwable;

    protected boolean skipRegionBoundaryCheck(Scan scan) {
        byte[] skipCheckBytes = scan.getAttribute(SKIP_REGION_BOUNDARY_CHECK);
        return skipCheckBytes != null && Bytes.toBoolean(skipCheckBytes);
    }

    @Override
    public RegionScanner preScannerOpen(ObserverContext<RegionCoprocessorEnvironment> c, Scan scan, RegionScanner s) throws IOException {
        if (this.isRegionObserverFor(scan)) {
            if (!this.skipRegionBoundaryCheck(scan)) {
                BaseScannerRegionObserver.throwIfScanOutOfRegion(scan, c.getEnvironment().getRegion());
            }
            ScanUtil.setupReverseScan(scan);
        }
        return s;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final RegionScanner postScannerOpen(ObserverContext<RegionCoprocessorEnvironment> c, Scan scan, RegionScanner s) throws IOException {
        RegionScanner regionScanner;
        if (!this.isRegionObserverFor(scan)) {
            return s;
        }
        boolean success = false;
        Span savedSpan = Trace.currentSpan();
        final Span child = Trace.startSpan(SCANNER_OPENED_TRACE_INFO, savedSpan).getSpan();
        try {
            RegionScanner scanner = this.doPostScannerOpen(c, scan, s);
            scanner = new DelegateRegionScanner(scanner){

                @Override
                public void close() throws IOException {
                    try {
                        this.delegate.close();
                    }
                    finally {
                        if (child != null) {
                            child.stop();
                        }
                    }
                }
            };
            success = true;
            regionScanner = scanner;
        }
        catch (Throwable throwable) {
            try {
                try {
                    if (!success && child != null) {
                        child.stop();
                    }
                }
                finally {
                    Trace.continueSpan(savedSpan);
                }
                throw throwable;
            }
            catch (Throwable t) {
                ServerUtil.throwIOException(c.getEnvironment().getRegion().getRegionInfo().getRegionNameAsString(), t);
                return null;
            }
        }
        try {
            if (!success && child != null) {
                child.stop();
            }
        }
        finally {
            Trace.continueSpan(savedSpan);
        }
        return regionScanner;
    }

    protected RegionScanner getWrappedScanner(ObserverContext<RegionCoprocessorEnvironment> c, RegionScanner s, int offset, Scan scan, ColumnReference[] dataColumns, TupleProjector tupleProjector, Region dataRegion, IndexMaintainer indexMaintainer, byte[][] viewConstants, TupleProjector projector, ImmutableBytesWritable ptr) {
        return this.getWrappedScanner(c, s, null, null, offset, scan, dataColumns, tupleProjector, dataRegion, indexMaintainer, viewConstants, null, null, projector, ptr);
    }

    protected RegionScanner getWrappedScanner(final ObserverContext<RegionCoprocessorEnvironment> c, final RegionScanner s, final Set<KeyValueColumnExpression> arrayKVRefs, final Expression[] arrayFuncRefs, final int offset, final Scan scan, final ColumnReference[] dataColumns, final TupleProjector tupleProjector, final Region dataRegion, final IndexMaintainer indexMaintainer, final byte[][] viewConstants, final KeyValueSchema kvSchema, final ValueBitSet kvSchemaBitSet, final TupleProjector projector, final ImmutableBytesWritable ptr) {
        return new RegionScanner(){

            @Override
            public boolean next(List<Cell> results) throws IOException {
                try {
                    return s.next(results);
                }
                catch (Throwable t) {
                    ServerUtil.throwIOException(((RegionCoprocessorEnvironment)c.getEnvironment()).getRegion().getRegionInfo().getRegionNameAsString(), t);
                    return false;
                }
            }

            @Override
            public boolean next(List<Cell> result, ScannerContext scannerContext) throws IOException {
                try {
                    return s.next(result, scannerContext);
                }
                catch (Throwable t) {
                    ServerUtil.throwIOException(((RegionCoprocessorEnvironment)c.getEnvironment()).getRegion().getRegionInfo().getRegionNameAsString(), t);
                    return false;
                }
            }

            @Override
            public void close() throws IOException {
                s.close();
            }

            @Override
            public HRegionInfo getRegionInfo() {
                return s.getRegionInfo();
            }

            @Override
            public boolean isFilterDone() throws IOException {
                return s.isFilterDone();
            }

            @Override
            public boolean reseek(byte[] row) throws IOException {
                return s.reseek(row);
            }

            @Override
            public long getMvccReadPoint() {
                return s.getMvccReadPoint();
            }

            @Override
            public boolean nextRaw(List<Cell> result) throws IOException {
                try {
                    boolean next = s.nextRaw(result);
                    if (result.size() == 0) {
                        return next;
                    }
                    if (arrayFuncRefs != null && arrayFuncRefs.length > 0 && arrayKVRefs.size() > 0) {
                        this.replaceArrayIndexElement(arrayKVRefs, arrayFuncRefs, result);
                    }
                    if (ScanUtil.isLocalIndex(scan) && !ScanUtil.isAnalyzeTable(scan)) {
                        IndexUtil.wrapResultUsingOffset(c, result, offset, dataColumns, tupleProjector, dataRegion, indexMaintainer, viewConstants, ptr);
                    }
                    if (projector != null) {
                        TupleProjector.ProjectedValueTuple tuple = projector.projectResults(new ResultTuple(Result.create(result)));
                        result.clear();
                        result.add(tuple.getValue(0));
                    }
                    return next;
                }
                catch (Throwable t) {
                    ServerUtil.throwIOException(((RegionCoprocessorEnvironment)c.getEnvironment()).getRegion().getRegionInfo().getRegionNameAsString(), t);
                    return false;
                }
            }

            @Override
            public boolean nextRaw(List<Cell> result, ScannerContext scannerContext) throws IOException {
                try {
                    boolean next = s.nextRaw(result, scannerContext);
                    if (result.size() == 0) {
                        return next;
                    }
                    if (arrayFuncRefs != null && arrayFuncRefs.length > 0 && arrayKVRefs.size() > 0) {
                        this.replaceArrayIndexElement(arrayKVRefs, arrayFuncRefs, result);
                    }
                    if ((offset > 0 || ScanUtil.isLocalIndex(scan)) && !ScanUtil.isAnalyzeTable(scan)) {
                        IndexUtil.wrapResultUsingOffset(c, result, offset, dataColumns, tupleProjector, dataRegion, indexMaintainer, viewConstants, ptr);
                    }
                    if (projector != null) {
                        TupleProjector.ProjectedValueTuple tuple = projector.projectResults(new ResultTuple(Result.create(result)));
                        result.clear();
                        result.add(tuple.getValue(0));
                    }
                    return next;
                }
                catch (Throwable t) {
                    ServerUtil.throwIOException(((RegionCoprocessorEnvironment)c.getEnvironment()).getRegion().getRegionInfo().getRegionNameAsString(), t);
                    return false;
                }
            }

            private void replaceArrayIndexElement(Set<KeyValueColumnExpression> arrayKVRefs2, Expression[] arrayFuncRefs2, List<Cell> result) {
                MultiKeyValueTuple tuple = new MultiKeyValueTuple(ImmutableList.copyOf(result));
                Cell rowKv = result.get(0);
                block0: for (KeyValueColumnExpression kvExp : arrayKVRefs2) {
                    if (!kvExp.evaluate(tuple, ptr)) continue;
                    for (int idx = tuple.size() - 1; idx >= 0; --idx) {
                        Cell kv = tuple.getValue(idx);
                        if (!Bytes.equals(kvExp.getColumnFamily(), 0, kvExp.getColumnFamily().length, kv.getFamilyArray(), kv.getFamilyOffset(), kv.getFamilyLength()) || !Bytes.equals(kvExp.getColumnName(), 0, kvExp.getColumnName().length, kv.getQualifierArray(), kv.getQualifierOffset(), kv.getQualifierLength())) continue;
                        result.remove(idx);
                        continue block0;
                    }
                }
                byte[] value = kvSchema.toBytes(tuple, arrayFuncRefs2, kvSchemaBitSet, ptr);
                result.add(new KeyValue(rowKv.getRowArray(), rowKv.getRowOffset(), rowKv.getRowLength(), QueryConstants.ARRAY_VALUE_COLUMN_FAMILY, 0, QueryConstants.ARRAY_VALUE_COLUMN_FAMILY.length, QueryConstants.ARRAY_VALUE_COLUMN_QUALIFIER, 0, QueryConstants.ARRAY_VALUE_COLUMN_QUALIFIER.length, Long.MAX_VALUE, KeyValue.Type.codeToType(rowKv.getTypeByte()), value, 0, value.length));
            }

            @Override
            public long getMaxResultSize() {
                return s.getMaxResultSize();
            }

            @Override
            public int getBatch() {
                return s.getBatch();
            }
        };
    }
}

