/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.compile;

import com.google.common.collect.Lists;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.hadoop.hbase.filter.CompareFilter;
import org.apache.phoenix.compile.ColumnResolver;
import org.apache.phoenix.compile.FromCompiler;
import org.apache.phoenix.exception.SQLExceptionCode;
import org.apache.phoenix.exception.SQLExceptionInfo;
import org.apache.phoenix.jdbc.PhoenixConnection;
import org.apache.phoenix.parse.AliasedNode;
import org.apache.phoenix.parse.AndParseNode;
import org.apache.phoenix.parse.ArrayAllComparisonNode;
import org.apache.phoenix.parse.ArrayAnyComparisonNode;
import org.apache.phoenix.parse.BooleanParseNodeVisitor;
import org.apache.phoenix.parse.ColumnParseNode;
import org.apache.phoenix.parse.ComparisonParseNode;
import org.apache.phoenix.parse.CompoundParseNode;
import org.apache.phoenix.parse.DerivedTableNode;
import org.apache.phoenix.parse.ExistsParseNode;
import org.apache.phoenix.parse.HintNode;
import org.apache.phoenix.parse.InParseNode;
import org.apache.phoenix.parse.IsNullParseNode;
import org.apache.phoenix.parse.JoinTableNode;
import org.apache.phoenix.parse.LiteralParseNode;
import org.apache.phoenix.parse.ParseNode;
import org.apache.phoenix.parse.ParseNodeFactory;
import org.apache.phoenix.parse.ParseNodeRewriter;
import org.apache.phoenix.parse.RowValueConstructorParseNode;
import org.apache.phoenix.parse.SelectStatement;
import org.apache.phoenix.parse.StatelessTraverseAllParseNodeVisitor;
import org.apache.phoenix.parse.SubqueryParseNode;
import org.apache.phoenix.parse.TableName;
import org.apache.phoenix.parse.TableNode;
import org.apache.phoenix.schema.ColumnFamilyNotFoundException;
import org.apache.phoenix.schema.ColumnNotFoundException;
import org.apache.phoenix.schema.TableNotFoundException;

public class SubqueryRewriter
extends ParseNodeRewriter {
    private static final ParseNodeFactory NODE_FACTORY = new ParseNodeFactory();
    private final ColumnResolver resolver;
    private final PhoenixConnection connection;
    private TableNode tableNode;
    private ParseNode topNode;

    public static SelectStatement transform(SelectStatement select, ColumnResolver resolver, PhoenixConnection connection) throws SQLException {
        ParseNode where = select.getWhere();
        if (where == null) {
            return select;
        }
        SubqueryRewriter rewriter = new SubqueryRewriter(select, resolver, connection);
        ParseNode normWhere = SubqueryRewriter.rewrite(where, (ParseNodeRewriter)rewriter);
        if (normWhere == where) {
            return select;
        }
        return NODE_FACTORY.select(select, rewriter.tableNode, normWhere);
    }

    protected SubqueryRewriter(SelectStatement select, ColumnResolver resolver, PhoenixConnection connection) {
        this.resolver = resolver;
        this.connection = connection;
        this.tableNode = select.getFrom();
        this.topNode = null;
    }

    @Override
    protected void enterParseNode(ParseNode node) {
        if (this.topNode == null) {
            this.topNode = node;
        }
        super.enterParseNode(node);
    }

    @Override
    protected ParseNode leaveCompoundNode(CompoundParseNode node, List<ParseNode> children, ParseNodeRewriter.CompoundNodeFactory factory) {
        if (this.topNode == node) {
            this.topNode = null;
        }
        return super.leaveCompoundNode(node, children, factory);
    }

    @Override
    public boolean visitEnter(AndParseNode node) throws SQLException {
        return true;
    }

    @Override
    public ParseNode visitLeave(AndParseNode node, List<ParseNode> l) throws SQLException {
        return this.leaveCompoundNode(node, l, new ParseNodeRewriter.CompoundNodeFactory(){

            @Override
            public ParseNode createNode(List<ParseNode> children) {
                if (children.isEmpty()) {
                    return null;
                }
                if (children.size() == 1) {
                    return children.get(0);
                }
                return NODE_FACTORY.and(children);
            }
        });
    }

    @Override
    public ParseNode visitLeave(InParseNode node, List<ParseNode> l) throws SQLException {
        JoinTableNode.JoinType joinType;
        boolean isTopNode;
        boolean bl = isTopNode = this.topNode == node;
        if (isTopNode) {
            this.topNode = null;
        }
        SubqueryParseNode subqueryNode = (SubqueryParseNode)l.get(1);
        SelectStatement subquery = this.fixSubqueryStatement(subqueryNode.getSelectNode());
        String rhsTableAlias = ParseNodeFactory.createTempAlias();
        List<AliasedNode> selectNodes = this.fixAliasedNodes(subquery.getSelect(), true);
        subquery = NODE_FACTORY.select(subquery, !node.isSubqueryDistinct(), selectNodes);
        ParseNode onNode = this.getJoinConditionNode(l.get(0), selectNodes, rhsTableAlias);
        DerivedTableNode rhsTable = NODE_FACTORY.derivedTable(rhsTableAlias, subquery);
        JoinTableNode.JoinType joinType2 = isTopNode ? (node.isNegate() ? JoinTableNode.JoinType.Anti : JoinTableNode.JoinType.Semi) : (joinType = JoinTableNode.JoinType.Left);
        IsNullParseNode ret = isTopNode ? null : NODE_FACTORY.isNull(NODE_FACTORY.column(NODE_FACTORY.table(null, rhsTableAlias), selectNodes.get(0).getAlias(), null), !node.isNegate());
        this.tableNode = NODE_FACTORY.join(joinType, this.tableNode, rhsTable, onNode, false);
        return ret;
    }

    @Override
    public ParseNode visitLeave(ExistsParseNode node, List<ParseNode> l) throws SQLException {
        JoinTableNode.JoinType joinType;
        ParseNode where;
        boolean isTopNode;
        boolean bl = isTopNode = this.topNode == node;
        if (isTopNode) {
            this.topNode = null;
        }
        SubqueryParseNode subqueryNode = (SubqueryParseNode)l.get(0);
        SelectStatement subquery = this.fixSubqueryStatement(subqueryNode.getSelectNode());
        String rhsTableAlias = ParseNodeFactory.createTempAlias();
        JoinConditionExtractor conditionExtractor = new JoinConditionExtractor(subquery, this.resolver, this.connection, rhsTableAlias);
        ParseNode parseNode = where = subquery.getWhere() == null ? null : subquery.getWhere().accept(conditionExtractor);
        if (where == subquery.getWhere()) {
            subquery = NODE_FACTORY.select(subquery, NODE_FACTORY.limit(NODE_FACTORY.literal(1)));
            subqueryNode = NODE_FACTORY.subquery(subquery, false);
            node = NODE_FACTORY.exists(subqueryNode, node.isNegate());
            return super.visitLeave(node, (List)Collections.singletonList(subqueryNode));
        }
        List<AliasedNode> additionalSelectNodes = conditionExtractor.getAdditionalSelectNodes();
        ArrayList<AliasedNode> selectNodes = Lists.newArrayListWithExpectedSize(additionalSelectNodes.size() + 1);
        selectNodes.add(NODE_FACTORY.aliasedNode(ParseNodeFactory.createTempAlias(), LiteralParseNode.ONE));
        selectNodes.addAll(additionalSelectNodes);
        subquery = NODE_FACTORY.select(subquery, true, selectNodes, where);
        ParseNode onNode = conditionExtractor.getJoinCondition();
        DerivedTableNode rhsTable = NODE_FACTORY.derivedTable(rhsTableAlias, subquery);
        JoinTableNode.JoinType joinType2 = isTopNode ? (node.isNegate() ? JoinTableNode.JoinType.Anti : JoinTableNode.JoinType.Semi) : (joinType = JoinTableNode.JoinType.Left);
        IsNullParseNode ret = isTopNode ? null : NODE_FACTORY.isNull(NODE_FACTORY.column(NODE_FACTORY.table(null, rhsTableAlias), ((AliasedNode)selectNodes.get(0)).getAlias(), null), !node.isNegate());
        this.tableNode = NODE_FACTORY.join(joinType, this.tableNode, rhsTable, onNode, false);
        return ret;
    }

    @Override
    public ParseNode visitLeave(ComparisonParseNode node, List<ParseNode> l) throws SQLException {
        ParseNode where;
        ParseNode secondChild;
        boolean isTopNode;
        boolean bl = isTopNode = this.topNode == node;
        if (isTopNode) {
            this.topNode = null;
        }
        if (!((secondChild = l.get(1)) instanceof SubqueryParseNode)) {
            return super.visitLeave(node, (List)l);
        }
        SubqueryParseNode subqueryNode = (SubqueryParseNode)secondChild;
        SelectStatement subquery = this.fixSubqueryStatement(subqueryNode.getSelectNode());
        String rhsTableAlias = ParseNodeFactory.createTempAlias();
        JoinConditionExtractor conditionExtractor = new JoinConditionExtractor(subquery, this.resolver, this.connection, rhsTableAlias);
        ParseNode parseNode = where = subquery.getWhere() == null ? null : subquery.getWhere().accept(conditionExtractor);
        if (where == subquery.getWhere()) {
            subquery = NODE_FACTORY.select(subquery, NODE_FACTORY.limit(NODE_FACTORY.literal(2)));
            subqueryNode = NODE_FACTORY.subquery(subquery, true);
            l = Lists.newArrayList(l.get(0), subqueryNode);
            node = NODE_FACTORY.comparison(node.getFilterOp(), l.get(0), l.get(1));
            return super.visitLeave(node, (List)l);
        }
        ParseNode rhsNode = null;
        boolean isGroupby = !subquery.getGroupBy().isEmpty();
        boolean isAggregate = subquery.isAggregate();
        List<AliasedNode> aliasedNodes = subquery.getSelect();
        if (aliasedNodes.size() == 1) {
            rhsNode = aliasedNodes.get(0).getNode();
        } else {
            ArrayList<ParseNode> nodes = Lists.newArrayListWithExpectedSize(aliasedNodes.size());
            for (AliasedNode aliasedNode : aliasedNodes) {
                nodes.add(aliasedNode.getNode());
            }
            rhsNode = NODE_FACTORY.rowValueConstructor(nodes);
        }
        List<AliasedNode> additionalSelectNodes = conditionExtractor.getAdditionalSelectNodes();
        ArrayList<AliasedNode> selectNodes = Lists.newArrayListWithExpectedSize(additionalSelectNodes.size() + 1);
        selectNodes.add(NODE_FACTORY.aliasedNode(ParseNodeFactory.createTempAlias(), rhsNode));
        selectNodes.addAll(additionalSelectNodes);
        if (!isAggregate) {
            subquery = NODE_FACTORY.select(subquery, subquery.isDistinct(), selectNodes, where);
        } else {
            ArrayList<ParseNode> groupbyNodes = Lists.newArrayListWithExpectedSize(additionalSelectNodes.size() + subquery.getGroupBy().size());
            for (AliasedNode aliasedNode : additionalSelectNodes) {
                groupbyNodes.add(aliasedNode.getNode());
            }
            groupbyNodes.addAll(subquery.getGroupBy());
            subquery = NODE_FACTORY.select(subquery, subquery.isDistinct(), selectNodes, where, groupbyNodes, true);
        }
        ParseNode onNode = conditionExtractor.getJoinCondition();
        DerivedTableNode rhsTable = NODE_FACTORY.derivedTable(rhsTableAlias, subquery);
        JoinTableNode.JoinType joinType = isTopNode ? JoinTableNode.JoinType.Inner : JoinTableNode.JoinType.Left;
        ComparisonParseNode ret = NODE_FACTORY.comparison(node.getFilterOp(), l.get(0), NODE_FACTORY.column(NODE_FACTORY.table(null, rhsTableAlias), ((AliasedNode)selectNodes.get(0)).getAlias(), null));
        this.tableNode = NODE_FACTORY.join(joinType, this.tableNode, rhsTable, onNode, !isAggregate || isGroupby);
        return ret;
    }

    @Override
    public ParseNode visitLeave(ArrayAnyComparisonNode node, List<ParseNode> l) throws SQLException {
        List<ParseNode> children = this.leaveArrayComparisonNode(node, l);
        if (children == l) {
            return super.visitLeave(node, (List)l);
        }
        node = NODE_FACTORY.arrayAny(children.get(0), (ComparisonParseNode)children.get(1));
        return node;
    }

    @Override
    public ParseNode visitLeave(ArrayAllComparisonNode node, List<ParseNode> l) throws SQLException {
        List<ParseNode> children = this.leaveArrayComparisonNode(node, l);
        if (children == l) {
            return super.visitLeave(node, (List)l);
        }
        node = NODE_FACTORY.arrayAll(children.get(0), (ComparisonParseNode)children.get(1));
        return node;
    }

    protected List<ParseNode> leaveArrayComparisonNode(ParseNode node, List<ParseNode> l) throws SQLException {
        ParseNode where;
        ParseNode firstChild;
        boolean isTopNode;
        boolean bl = isTopNode = this.topNode == node;
        if (isTopNode) {
            this.topNode = null;
        }
        if (!((firstChild = l.get(0)) instanceof SubqueryParseNode)) {
            return l;
        }
        SubqueryParseNode subqueryNode = (SubqueryParseNode)firstChild;
        SelectStatement subquery = this.fixSubqueryStatement(subqueryNode.getSelectNode());
        String rhsTableAlias = ParseNodeFactory.createTempAlias();
        JoinConditionExtractor conditionExtractor = new JoinConditionExtractor(subquery, this.resolver, this.connection, rhsTableAlias);
        ParseNode parseNode = where = subquery.getWhere() == null ? null : subquery.getWhere().accept(conditionExtractor);
        if (where == subquery.getWhere()) {
            return l;
        }
        ParseNode rhsNode = null;
        boolean isNonGroupByAggregate = subquery.getGroupBy().isEmpty() && subquery.isAggregate();
        List<AliasedNode> aliasedNodes = subquery.getSelect();
        String derivedTableAlias = null;
        if (!subquery.getGroupBy().isEmpty()) {
            derivedTableAlias = ParseNodeFactory.createTempAlias();
            aliasedNodes = this.fixAliasedNodes(aliasedNodes, false);
        }
        if (aliasedNodes.size() == 1) {
            rhsNode = derivedTableAlias == null ? aliasedNodes.get(0).getNode() : NODE_FACTORY.column(NODE_FACTORY.table(null, derivedTableAlias), aliasedNodes.get(0).getAlias(), null);
        } else {
            ArrayList<ParseNode> nodes = Lists.newArrayListWithExpectedSize(aliasedNodes.size());
            for (AliasedNode aliasedNode : aliasedNodes) {
                nodes.add(derivedTableAlias == null ? aliasedNode.getNode() : NODE_FACTORY.column(NODE_FACTORY.table(null, derivedTableAlias), aliasedNode.getAlias(), null));
            }
            rhsNode = NODE_FACTORY.rowValueConstructor(nodes);
        }
        if (!isNonGroupByAggregate) {
            rhsNode = NODE_FACTORY.function("COLLECTDISTINCT", Collections.singletonList(rhsNode));
        }
        List<AliasedNode> additionalSelectNodes = conditionExtractor.getAdditionalSelectNodes();
        ArrayList<AliasedNode> selectNodes = Lists.newArrayListWithExpectedSize(additionalSelectNodes.size() + 1);
        selectNodes.add(NODE_FACTORY.aliasedNode(ParseNodeFactory.createTempAlias(), rhsNode));
        selectNodes.addAll(additionalSelectNodes);
        ArrayList<ParseNode> groupbyNodes = Lists.newArrayListWithExpectedSize(additionalSelectNodes.size());
        for (AliasedNode aliasedNode : additionalSelectNodes) {
            groupbyNodes.add(aliasedNode.getNode());
        }
        if (derivedTableAlias == null) {
            subquery = NODE_FACTORY.select(subquery, false, selectNodes, where, groupbyNodes, true);
        } else {
            ArrayList<ParseNode> derivedTableGroupBy = Lists.newArrayListWithExpectedSize(subquery.getGroupBy().size() + groupbyNodes.size());
            derivedTableGroupBy.addAll(groupbyNodes);
            derivedTableGroupBy.addAll(subquery.getGroupBy());
            ArrayList<AliasedNode> derivedTableSelect = Lists.newArrayListWithExpectedSize(aliasedNodes.size() + selectNodes.size() - 1);
            derivedTableSelect.addAll(aliasedNodes);
            for (int i = 1; i < selectNodes.size(); ++i) {
                AliasedNode aliasedNode = (AliasedNode)selectNodes.get(i);
                String alias = ParseNodeFactory.createTempAlias();
                derivedTableSelect.add(NODE_FACTORY.aliasedNode(alias, aliasedNode.getNode()));
                aliasedNode = NODE_FACTORY.aliasedNode(aliasedNode.getAlias(), NODE_FACTORY.column(NODE_FACTORY.table(null, derivedTableAlias), alias, null));
                selectNodes.set(i, aliasedNode);
                groupbyNodes.set(i - 1, aliasedNode.getNode());
            }
            SelectStatement derivedTableStmt = NODE_FACTORY.select(subquery, subquery.isDistinct(), derivedTableSelect, where, derivedTableGroupBy, true);
            subquery = NODE_FACTORY.select(NODE_FACTORY.derivedTable(derivedTableAlias, derivedTableStmt), subquery.getHint(), false, selectNodes, null, groupbyNodes, null, Collections.emptyList(), null, subquery.getBindCount(), true, false, Collections.emptyList(), subquery.getUdfParseNodes());
        }
        ParseNode onNode = conditionExtractor.getJoinCondition();
        DerivedTableNode rhsTable = NODE_FACTORY.derivedTable(rhsTableAlias, subquery);
        JoinTableNode.JoinType joinType = isTopNode ? JoinTableNode.JoinType.Inner : JoinTableNode.JoinType.Left;
        this.tableNode = NODE_FACTORY.join(joinType, this.tableNode, rhsTable, onNode, false);
        firstChild = NODE_FACTORY.column(NODE_FACTORY.table(null, rhsTableAlias), ((AliasedNode)selectNodes.get(0)).getAlias(), null);
        if (isNonGroupByAggregate) {
            firstChild = NODE_FACTORY.upsertStmtArrayNode(Collections.singletonList(firstChild));
        }
        ComparisonParseNode secondChild = (ComparisonParseNode)l.get(1);
        secondChild = NODE_FACTORY.comparison(secondChild.getFilterOp(), secondChild.getLHS(), NODE_FACTORY.elementRef(Lists.newArrayList(firstChild, NODE_FACTORY.literal(1))));
        return Lists.newArrayList(firstChild, secondChild);
    }

    private SelectStatement fixSubqueryStatement(SelectStatement select) {
        if (!select.isUnion()) {
            return select;
        }
        return NODE_FACTORY.select(NODE_FACTORY.derivedTable(ParseNodeFactory.createTempAlias(), select), HintNode.EMPTY_HINT_NODE, false, select.getSelect(), null, null, null, null, null, select.getBindCount(), false, false, Collections.emptyList(), select.getUdfParseNodes());
    }

    private List<AliasedNode> fixAliasedNodes(List<AliasedNode> nodes, boolean addSelectOne) {
        ArrayList<AliasedNode> normNodes = Lists.newArrayListWithExpectedSize(nodes.size() + (addSelectOne ? 1 : 0));
        if (addSelectOne) {
            normNodes.add(NODE_FACTORY.aliasedNode(ParseNodeFactory.createTempAlias(), LiteralParseNode.ONE));
        }
        for (int i = 0; i < nodes.size(); ++i) {
            AliasedNode aliasedNode = nodes.get(i);
            normNodes.add(NODE_FACTORY.aliasedNode(ParseNodeFactory.createTempAlias(), aliasedNode.getNode()));
        }
        return normNodes;
    }

    private ParseNode getJoinConditionNode(ParseNode lhs, List<AliasedNode> rhs, String rhsTableAlias) throws SQLException {
        List<ParseNode> lhsNodes = lhs instanceof RowValueConstructorParseNode ? ((RowValueConstructorParseNode)lhs).getChildren() : Collections.singletonList(lhs);
        if (lhsNodes.size() != rhs.size() - 1) {
            throw new SQLExceptionInfo.Builder(SQLExceptionCode.SUBQUERY_RETURNS_DIFFERENT_NUMBER_OF_FIELDS).build().buildException();
        }
        int count = lhsNodes.size();
        TableName rhsTableName = NODE_FACTORY.table(null, rhsTableAlias);
        ArrayList<ParseNode> equalNodes = Lists.newArrayListWithExpectedSize(count);
        for (int i = 0; i < count; ++i) {
            ColumnParseNode rhsNode = NODE_FACTORY.column(rhsTableName, rhs.get(i + 1).getAlias(), null);
            equalNodes.add(NODE_FACTORY.equal(lhsNodes.get(i), rhsNode));
        }
        return count == 1 ? (ParseNode)equalNodes.get(0) : NODE_FACTORY.and(equalNodes);
    }

    private static class ColumnResolveVisitor
    extends StatelessTraverseAllParseNodeVisitor {
        private final ColumnResolver localResolver;
        private final ColumnResolver outerResolver;
        private ColumnResolveType type;

        public ColumnResolveVisitor(ColumnResolver localResolver, ColumnResolver outerResolver) {
            this.localResolver = localResolver;
            this.outerResolver = outerResolver;
            this.type = ColumnResolveType.NONE;
        }

        public void reset() {
            this.type = ColumnResolveType.NONE;
        }

        public ColumnResolveType getColumnResolveType() {
            return this.type;
        }

        @Override
        public Void visit(ColumnParseNode node) throws SQLException {
            try {
                this.localResolver.resolveColumn(node.getSchemaName(), node.getTableName(), node.getName());
                this.addType(true);
                return null;
            }
            catch (TableNotFoundException tableNotFoundException) {
            }
            catch (ColumnNotFoundException columnNotFoundException) {
            }
            catch (ColumnFamilyNotFoundException columnFamilyNotFoundException) {
                // empty catch block
            }
            this.outerResolver.resolveColumn(node.getSchemaName(), node.getTableName(), node.getName());
            this.addType(false);
            return null;
        }

        private void addType(boolean isLocal) {
            switch (this.type) {
                case NONE: {
                    this.type = isLocal ? ColumnResolveType.LOCAL : ColumnResolveType.OUTER;
                    break;
                }
                case LOCAL: {
                    this.type = isLocal ? ColumnResolveType.LOCAL : ColumnResolveType.MIXED;
                    break;
                }
                case OUTER: {
                    this.type = isLocal ? ColumnResolveType.MIXED : ColumnResolveType.OUTER;
                    break;
                }
            }
        }

        public static enum ColumnResolveType {
            NONE,
            LOCAL,
            OUTER,
            MIXED;

        }
    }

    private static class JoinConditionExtractor
    extends BooleanParseNodeVisitor<ParseNode> {
        private final TableName tableName;
        private ColumnResolveVisitor columnResolveVisitor;
        private List<AliasedNode> additionalSelectNodes;
        private List<ParseNode> joinConditions;

        public JoinConditionExtractor(SelectStatement subquery, ColumnResolver outerResolver, PhoenixConnection connection, String tableAlias) throws SQLException {
            this.tableName = NODE_FACTORY.table(null, tableAlias);
            ColumnResolver localResolver = FromCompiler.getResolverForQuery(subquery, connection);
            this.columnResolveVisitor = new ColumnResolveVisitor(localResolver, outerResolver);
            this.additionalSelectNodes = Lists.newArrayList();
            this.joinConditions = Lists.newArrayList();
        }

        public List<AliasedNode> getAdditionalSelectNodes() {
            return this.additionalSelectNodes;
        }

        public ParseNode getJoinCondition() {
            if (this.joinConditions.isEmpty()) {
                return null;
            }
            if (this.joinConditions.size() == 1) {
                return this.joinConditions.get(0);
            }
            return NODE_FACTORY.and(this.joinConditions);
        }

        @Override
        public List<ParseNode> newElementList(int size) {
            return Lists.newArrayListWithExpectedSize(size);
        }

        @Override
        public void addElement(List<ParseNode> l, ParseNode element) {
            if (element != null) {
                l.add(element);
            }
        }

        @Override
        public boolean visitEnter(AndParseNode node) throws SQLException {
            return true;
        }

        @Override
        public ParseNode visitLeave(AndParseNode node, List<ParseNode> l) throws SQLException {
            if (l.equals(node.getChildren())) {
                return node;
            }
            if (l.isEmpty()) {
                return null;
            }
            if (l.size() == 1) {
                return l.get(0);
            }
            return NODE_FACTORY.and(l);
        }

        @Override
        protected boolean enterBooleanNode(ParseNode node) throws SQLException {
            return false;
        }

        @Override
        protected ParseNode leaveBooleanNode(ParseNode node, List<ParseNode> l) throws SQLException {
            this.columnResolveVisitor.reset();
            node.accept(this.columnResolveVisitor);
            ColumnResolveVisitor.ColumnResolveType type = this.columnResolveVisitor.getColumnResolveType();
            if (type != ColumnResolveVisitor.ColumnResolveType.NONE && type != ColumnResolveVisitor.ColumnResolveType.LOCAL) {
                throw new SQLFeatureNotSupportedException("Does not support non-standard or non-equi correlated-subquery conditions.");
            }
            return node;
        }

        @Override
        protected boolean enterNonBooleanNode(ParseNode node) throws SQLException {
            return false;
        }

        @Override
        protected ParseNode leaveNonBooleanNode(ParseNode node, List<ParseNode> l) throws SQLException {
            return node;
        }

        @Override
        public ParseNode visitLeave(ComparisonParseNode node, List<ParseNode> l) throws SQLException {
            if (node.getFilterOp() != CompareFilter.CompareOp.EQUAL) {
                return this.leaveBooleanNode((ParseNode)node, (List)l);
            }
            this.columnResolveVisitor.reset();
            node.getLHS().accept(this.columnResolveVisitor);
            ColumnResolveVisitor.ColumnResolveType lhsType = this.columnResolveVisitor.getColumnResolveType();
            this.columnResolveVisitor.reset();
            node.getRHS().accept(this.columnResolveVisitor);
            ColumnResolveVisitor.ColumnResolveType rhsType = this.columnResolveVisitor.getColumnResolveType();
            if (!(lhsType != ColumnResolveVisitor.ColumnResolveType.NONE && lhsType != ColumnResolveVisitor.ColumnResolveType.LOCAL || rhsType != ColumnResolveVisitor.ColumnResolveType.NONE && rhsType != ColumnResolveVisitor.ColumnResolveType.LOCAL)) {
                return node;
            }
            if (lhsType == ColumnResolveVisitor.ColumnResolveType.LOCAL && rhsType == ColumnResolveVisitor.ColumnResolveType.OUTER) {
                String alias = ParseNodeFactory.createTempAlias();
                this.additionalSelectNodes.add(NODE_FACTORY.aliasedNode(alias, node.getLHS()));
                ColumnParseNode lhsNode = NODE_FACTORY.column(this.tableName, alias, null);
                this.joinConditions.add(NODE_FACTORY.equal(lhsNode, node.getRHS()));
                return null;
            }
            if (lhsType == ColumnResolveVisitor.ColumnResolveType.OUTER && rhsType == ColumnResolveVisitor.ColumnResolveType.LOCAL) {
                String alias = ParseNodeFactory.createTempAlias();
                this.additionalSelectNodes.add(NODE_FACTORY.aliasedNode(alias, node.getRHS()));
                ColumnParseNode rhsNode = NODE_FACTORY.column(this.tableName, alias, null);
                this.joinConditions.add(NODE_FACTORY.equal(node.getLHS(), rhsNode));
                return null;
            }
            throw new SQLFeatureNotSupportedException("Does not support non-standard or non-equi correlated-subquery conditions.");
        }
    }
}

