/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.compile;

import com.google.common.collect.Lists;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.phoenix.compile.ColumnResolver;
import org.apache.phoenix.parse.AliasedNode;
import org.apache.phoenix.parse.ArrayElemRefNode;
import org.apache.phoenix.parse.BetweenParseNode;
import org.apache.phoenix.parse.BindTableNode;
import org.apache.phoenix.parse.ColumnParseNode;
import org.apache.phoenix.parse.ComparisonParseNode;
import org.apache.phoenix.parse.DerivedTableNode;
import org.apache.phoenix.parse.FamilyWildcardParseNode;
import org.apache.phoenix.parse.JoinTableNode;
import org.apache.phoenix.parse.LessThanOrEqualParseNode;
import org.apache.phoenix.parse.NamedTableNode;
import org.apache.phoenix.parse.ParseNode;
import org.apache.phoenix.parse.ParseNodeRewriter;
import org.apache.phoenix.parse.SelectStatement;
import org.apache.phoenix.parse.TableName;
import org.apache.phoenix.parse.TableNodeVisitor;
import org.apache.phoenix.parse.TableWildcardParseNode;
import org.apache.phoenix.parse.WildcardParseNode;
import org.apache.phoenix.util.SchemaUtil;

public class StatementNormalizer
extends ParseNodeRewriter {
    private boolean multiTable;

    public StatementNormalizer(ColumnResolver resolver, int expectedAliasCount, boolean multiTable) {
        super(resolver, expectedAliasCount);
        this.multiTable = multiTable;
    }

    public static ParseNode normalize(ParseNode where, ColumnResolver resolver) throws SQLException {
        return StatementNormalizer.rewrite(where, (ParseNodeRewriter)new StatementNormalizer(resolver, 0, false));
    }

    public static SelectStatement normalize(SelectStatement statement, ColumnResolver resolver) throws SQLException {
        boolean multiTable = statement.isJoin();
        if (multiTable) {
            List<AliasedNode> selectNodes;
            List<AliasedNode> normSelectNodes = selectNodes = statement.getSelect();
            for (int i = 0; i < selectNodes.size(); ++i) {
                AliasedNode aliasedNode = selectNodes.get(i);
                ParseNode selectNode = aliasedNode.getNode();
                if (selectNode == WildcardParseNode.INSTANCE) {
                    if (selectNodes == normSelectNodes) {
                        normSelectNodes = Lists.newArrayList(selectNodes.subList(0, i));
                    }
                    List<TableName> tableNames = statement.getFrom().accept(new TableNameVisitor());
                    for (TableName tableName : tableNames) {
                        TableWildcardParseNode node = NODE_FACTORY.tableWildcard(tableName);
                        normSelectNodes.add(NODE_FACTORY.aliasedNode(null, node));
                    }
                    continue;
                }
                if (selectNodes == normSelectNodes) continue;
                normSelectNodes.add(aliasedNode);
            }
            if (selectNodes != normSelectNodes) {
                statement = NODE_FACTORY.select(statement.getFrom(), statement.getHint(), statement.isDistinct(), normSelectNodes, statement.getWhere(), statement.getGroupBy(), statement.getHaving(), statement.getOrderBy(), statement.getLimit(), statement.getBindCount(), statement.isAggregate(), statement.hasSequence(), statement.getSelects(), statement.getUdfParseNodes());
            }
        }
        return StatementNormalizer.rewrite(statement, (ParseNodeRewriter)new StatementNormalizer(resolver, statement.getSelect().size(), multiTable));
    }

    @Override
    public ParseNode visitLeave(ComparisonParseNode node, List<ParseNode> nodes) throws SQLException {
        if (nodes.get(0).isStateless() && !nodes.get(1).isStateless() && !(nodes.get(1) instanceof ArrayElemRefNode)) {
            ArrayList<ParseNode> normNodes = Lists.newArrayListWithExpectedSize(2);
            normNodes.add(nodes.get(1));
            normNodes.add(nodes.get(0));
            nodes = normNodes;
            node = NODE_FACTORY.comparison(node.getInvertFilterOp(), nodes.get(0), nodes.get(1));
        }
        return super.visitLeave(node, (List)nodes);
    }

    @Override
    public ParseNode visitLeave(BetweenParseNode node, List<ParseNode> nodes) throws SQLException {
        LessThanOrEqualParseNode lhsNode = NODE_FACTORY.lte(node.getChildren().get(1), node.getChildren().get(0));
        LessThanOrEqualParseNode rhsNode = NODE_FACTORY.lte(node.getChildren().get(0), node.getChildren().get(2));
        ArrayList<Object> parseNodes = Lists.newArrayListWithExpectedSize(2);
        parseNodes.add(this.visitLeave((ComparisonParseNode)lhsNode, (List)lhsNode.getChildren()));
        parseNodes.add(this.visitLeave((ComparisonParseNode)rhsNode, (List)rhsNode.getChildren()));
        return super.visitLeave(node, (List)parseNodes);
    }

    @Override
    public ParseNode visit(ColumnParseNode node) throws SQLException {
        if (this.multiTable && node.getAlias() != null && node.getTableName() != null && SchemaUtil.normalizeIdentifier(node.getAlias()).equals(node.getName())) {
            node = NODE_FACTORY.column(TableName.create(node.getSchemaName(), node.getTableName()), node.isCaseSensitive() ? '\"' + node.getName() + '\"' : node.getName(), node.isCaseSensitive() ? '\"' + node.getFullName() + '\"' : node.getFullName());
        }
        return super.visit(node);
    }

    @Override
    public ParseNode visit(FamilyWildcardParseNode node) throws SQLException {
        if (!this.multiTable) {
            return super.visit(node);
        }
        return super.visit(NODE_FACTORY.tableWildcard(NODE_FACTORY.table(null, node.isCaseSensitive() ? '\"' + node.getName() + '\"' : node.getName())));
    }

    private static class TableNameVisitor
    implements TableNodeVisitor<List<TableName>> {
        private TableNameVisitor() {
        }

        @Override
        public List<TableName> visit(BindTableNode boundTableNode) throws SQLException {
            TableName name = boundTableNode.getAlias() == null ? boundTableNode.getName() : TableName.create(null, boundTableNode.getAlias());
            return Collections.singletonList(name);
        }

        @Override
        public List<TableName> visit(JoinTableNode joinNode) throws SQLException {
            List<TableName> lhs = joinNode.getLHS().accept(this);
            List rhs = joinNode.getType() == JoinTableNode.JoinType.Semi || joinNode.getType() == JoinTableNode.JoinType.Anti ? Collections.emptyList() : joinNode.getRHS().accept(this);
            ArrayList<TableName> ret = Lists.newArrayListWithExpectedSize(lhs.size() + rhs.size());
            ret.addAll(lhs);
            ret.addAll(rhs);
            return ret;
        }

        @Override
        public List<TableName> visit(NamedTableNode namedTableNode) throws SQLException {
            TableName name = namedTableNode.getAlias() == null ? namedTableNode.getName() : TableName.create(null, namedTableNode.getAlias());
            return Collections.singletonList(name);
        }

        @Override
        public List<TableName> visit(DerivedTableNode subselectNode) throws SQLException {
            TableName name = TableName.create(null, subselectNode.getAlias());
            return Collections.singletonList(name);
        }
    }
}

