/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.compile;

import com.google.common.collect.Maps;
import java.sql.SQLException;
import java.text.Format;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.phoenix.compile.AggregationManager;
import org.apache.phoenix.compile.BindManager;
import org.apache.phoenix.compile.ColumnResolver;
import org.apache.phoenix.compile.ExpressionManager;
import org.apache.phoenix.compile.FromCompiler;
import org.apache.phoenix.compile.ScanRanges;
import org.apache.phoenix.compile.SequenceManager;
import org.apache.phoenix.jdbc.PhoenixConnection;
import org.apache.phoenix.jdbc.PhoenixStatement;
import org.apache.phoenix.parse.SelectStatement;
import org.apache.phoenix.schema.MetaDataClient;
import org.apache.phoenix.schema.PColumn;
import org.apache.phoenix.schema.PTable;
import org.apache.phoenix.schema.PTableType;
import org.apache.phoenix.schema.TableRef;
import org.apache.phoenix.util.DateUtil;

public class StatementContext {
    private ColumnResolver resolver;
    private final BindManager binds;
    private final Scan scan;
    private final ExpressionManager expressions;
    private final AggregationManager aggregates;
    private final String dateFormat;
    private final Format dateFormatter;
    private final String timeFormat;
    private final Format timeFormatter;
    private final String timestampFormat;
    private final Format timestampFormatter;
    private final TimeZone dateFormatTimeZone;
    private final String numberFormat;
    private final ImmutableBytesWritable tempPtr;
    private final PhoenixStatement statement;
    private final Map<PColumn, Integer> dataColumns;
    private long currentTime = -1L;
    private ScanRanges scanRanges = ScanRanges.EVERYTHING;
    private final SequenceManager sequences;
    private TableRef currentTable;
    private List<Pair<byte[], byte[]>> whereConditionColumns;
    private Map<SelectStatement, Object> subqueryResults;

    public StatementContext(PhoenixStatement statement) {
        this(statement, new Scan());
    }

    public StatementContext(PhoenixStatement statement, Scan scan) {
        this(statement, FromCompiler.EMPTY_TABLE_RESOLVER, new Scan(), new SequenceManager(statement));
    }

    public StatementContext(PhoenixStatement statement, ColumnResolver resolver) {
        this(statement, resolver, new Scan(), new SequenceManager(statement));
    }

    public StatementContext(PhoenixStatement statement, ColumnResolver resolver, Scan scan, SequenceManager seqManager) {
        this.statement = statement;
        this.resolver = resolver;
        this.scan = scan;
        this.sequences = seqManager;
        this.binds = new BindManager(statement.getParameters());
        this.aggregates = new AggregationManager();
        this.expressions = new ExpressionManager();
        PhoenixConnection connection = statement.getConnection();
        this.dateFormat = connection.getQueryServices().getProps().get("phoenix.query.dateFormat", "yyyy-MM-dd HH:mm:ss.SSS");
        this.dateFormatter = DateUtil.getDateFormatter(this.dateFormat);
        this.timeFormat = connection.getQueryServices().getProps().get("phoenix.query.timeFormat", "yyyy-MM-dd HH:mm:ss.SSS");
        this.timeFormatter = DateUtil.getTimeFormatter(this.timeFormat);
        this.timestampFormat = connection.getQueryServices().getProps().get("phoenix.query.timestampFormat", "yyyy-MM-dd HH:mm:ss.SSS");
        this.timestampFormatter = DateUtil.getTimestampFormatter(this.timestampFormat);
        this.dateFormatTimeZone = TimeZone.getTimeZone(connection.getQueryServices().getProps().get("phoenix.query.dateFormatTimeZone", "GMT"));
        this.numberFormat = connection.getQueryServices().getProps().get("phoenix.query.numberFormat", "#,##0.###");
        this.tempPtr = new ImmutableBytesWritable();
        this.currentTable = resolver != null && !resolver.getTables().isEmpty() ? resolver.getTables().get(0) : null;
        this.whereConditionColumns = new ArrayList<Pair<byte[], byte[]>>();
        this.dataColumns = this.currentTable == null ? Collections.emptyMap() : Maps.newLinkedHashMap();
        this.subqueryResults = Maps.newHashMap();
    }

    public int getDataColumnPosition(PColumn column) {
        Integer pos = this.dataColumns.get(column);
        if (pos == null) {
            pos = this.dataColumns.size();
            this.dataColumns.put(column, pos);
        }
        return pos;
    }

    public Set<PColumn> getDataColumns() {
        return this.dataColumns.keySet();
    }

    public Map<PColumn, Integer> getDataColumnsMap() {
        return this.dataColumns;
    }

    public String getDateFormat() {
        return this.dateFormat;
    }

    public TimeZone getDateFormatTimeZone() {
        return this.dateFormatTimeZone;
    }

    public Format getDateFormatter() {
        return this.dateFormatter;
    }

    public String getTimeFormat() {
        return this.timeFormat;
    }

    public Format getTimeFormatter() {
        return this.timeFormatter;
    }

    public String getTimestampFormat() {
        return this.timestampFormat;
    }

    public Format getTimestampFormatter() {
        return this.timestampFormatter;
    }

    public String getNumberFormat() {
        return this.numberFormat;
    }

    public Scan getScan() {
        return this.scan;
    }

    public BindManager getBindManager() {
        return this.binds;
    }

    public TableRef getCurrentTable() {
        return this.currentTable;
    }

    public void setCurrentTable(TableRef table) {
        this.currentTable = table;
    }

    public AggregationManager getAggregationManager() {
        return this.aggregates;
    }

    public ColumnResolver getResolver() {
        return this.resolver;
    }

    public void setResolver(ColumnResolver resolver) {
        this.resolver = resolver;
    }

    public ExpressionManager getExpressionManager() {
        return this.expressions;
    }

    public ImmutableBytesWritable getTempPtr() {
        return this.tempPtr;
    }

    public ScanRanges getScanRanges() {
        return this.scanRanges;
    }

    public void setScanRanges(ScanRanges scanRanges) {
        this.scanRanges = scanRanges;
        scanRanges.initializeScan(this.scan);
    }

    public PhoenixConnection getConnection() {
        return this.statement.getConnection();
    }

    public PhoenixStatement getStatement() {
        return this.statement;
    }

    public long getCurrentTime() throws SQLException {
        long ts = this.getCurrentTable().getTimeStamp();
        if (this.getCurrentTable().getTable().getType() != PTableType.PROJECTED && ts != -1L) {
            return ts;
        }
        if (this.currentTime != -1L) {
            return this.currentTime;
        }
        PTable table = this.getCurrentTable().getTable();
        PhoenixConnection connection = this.getConnection();
        MetaDataClient client = new MetaDataClient(connection);
        this.currentTime = client.getCurrentTime(table.getSchemaName().getString(), table.getTableName().getString());
        return this.currentTime;
    }

    public SequenceManager getSequenceManager() {
        return this.sequences;
    }

    public void addWhereCoditionColumn(byte[] cf, byte[] q) {
        this.whereConditionColumns.add(new Pair<byte[], byte[]>(cf, q));
    }

    public List<Pair<byte[], byte[]>> getWhereCoditionColumns() {
        return this.whereConditionColumns;
    }

    public boolean isSubqueryResultAvailable(SelectStatement select) {
        return this.subqueryResults.containsKey(select);
    }

    public Object getSubqueryResult(SelectStatement select) {
        return this.subqueryResults.get(select);
    }

    public void setSubqueryResult(SelectStatement select, Object result) {
        this.subqueryResults.put(select, result);
    }
}

