/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.compile;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.phoenix.compile.ColumnResolver;
import org.apache.phoenix.compile.FromCompiler;
import org.apache.phoenix.compile.GroupByCompiler;
import org.apache.phoenix.compile.HavingCompiler;
import org.apache.phoenix.compile.JoinCompiler;
import org.apache.phoenix.compile.LimitCompiler;
import org.apache.phoenix.compile.OrderByCompiler;
import org.apache.phoenix.compile.ProjectionCompiler;
import org.apache.phoenix.compile.QueryPlan;
import org.apache.phoenix.compile.RowProjector;
import org.apache.phoenix.compile.SequenceManager;
import org.apache.phoenix.compile.StatementContext;
import org.apache.phoenix.compile.StatementNormalizer;
import org.apache.phoenix.compile.SubqueryRewriter;
import org.apache.phoenix.compile.SubselectRewriter;
import org.apache.phoenix.compile.TupleProjectionCompiler;
import org.apache.phoenix.compile.UnionCompiler;
import org.apache.phoenix.compile.WhereCompiler;
import org.apache.phoenix.compile.WhereOptimizer;
import org.apache.phoenix.execute.AggregatePlan;
import org.apache.phoenix.execute.ClientAggregatePlan;
import org.apache.phoenix.execute.ClientScanPlan;
import org.apache.phoenix.execute.HashJoinPlan;
import org.apache.phoenix.execute.ScanPlan;
import org.apache.phoenix.execute.SortMergeJoinPlan;
import org.apache.phoenix.execute.TupleProjectionPlan;
import org.apache.phoenix.execute.TupleProjector;
import org.apache.phoenix.execute.UnionPlan;
import org.apache.phoenix.expression.Expression;
import org.apache.phoenix.expression.LiteralExpression;
import org.apache.phoenix.expression.RowValueConstructorExpression;
import org.apache.phoenix.hbase.index.util.ImmutableBytesPtr;
import org.apache.phoenix.iterate.ParallelIteratorFactory;
import org.apache.phoenix.jdbc.PhoenixConnection;
import org.apache.phoenix.jdbc.PhoenixDatabaseMetaData;
import org.apache.phoenix.jdbc.PhoenixStatement;
import org.apache.phoenix.join.HashJoinInfo;
import org.apache.phoenix.parse.EqualParseNode;
import org.apache.phoenix.parse.FilterableStatement;
import org.apache.phoenix.parse.HintNode;
import org.apache.phoenix.parse.JoinTableNode;
import org.apache.phoenix.parse.NamedTableNode;
import org.apache.phoenix.parse.OrderByNode;
import org.apache.phoenix.parse.ParseNode;
import org.apache.phoenix.parse.ParseNodeFactory;
import org.apache.phoenix.parse.SQLParser;
import org.apache.phoenix.parse.SelectStatement;
import org.apache.phoenix.parse.SubqueryParseNode;
import org.apache.phoenix.parse.UDFParseNode;
import org.apache.phoenix.query.QueryConstants;
import org.apache.phoenix.schema.PDatum;
import org.apache.phoenix.schema.PTable;
import org.apache.phoenix.schema.TableRef;
import org.apache.phoenix.util.ScanUtil;

public class QueryCompiler {
    private static final ParseNodeFactory NODE_FACTORY = new ParseNodeFactory();
    private static final String LOAD_COLUMN_FAMILIES_ON_DEMAND_ATTR = "_ondemand_";
    private final PhoenixStatement statement;
    private final Scan scan;
    private final Scan originalScan;
    private final ColumnResolver resolver;
    private final SelectStatement select;
    private final List<? extends PDatum> targetColumns;
    private final ParallelIteratorFactory parallelIteratorFactory;
    private final SequenceManager sequenceManager;
    private final boolean projectTuples;
    private final boolean useSortMergeJoin;
    private final boolean noChildParentJoinOptimization;

    public QueryCompiler(PhoenixStatement statement, SelectStatement select, ColumnResolver resolver) throws SQLException {
        this(statement, select, resolver, Collections.emptyList(), null, new SequenceManager(statement), true);
    }

    public QueryCompiler(PhoenixStatement statement, SelectStatement select, ColumnResolver resolver, boolean projectTuples) throws SQLException {
        this(statement, select, resolver, Collections.emptyList(), null, new SequenceManager(statement), projectTuples);
    }

    public QueryCompiler(PhoenixStatement statement, SelectStatement select, ColumnResolver resolver, List<? extends PDatum> targetColumns, ParallelIteratorFactory parallelIteratorFactory, SequenceManager sequenceManager, boolean projectTuples) throws SQLException {
        this.statement = statement;
        this.select = select;
        this.resolver = resolver;
        this.scan = new Scan();
        this.targetColumns = targetColumns;
        this.parallelIteratorFactory = parallelIteratorFactory;
        this.sequenceManager = sequenceManager;
        this.projectTuples = projectTuples;
        this.useSortMergeJoin = select.getHint().hasHint(HintNode.Hint.USE_SORT_MERGE_JOIN);
        this.noChildParentJoinOptimization = select.getHint().hasHint(HintNode.Hint.NO_CHILD_PARENT_JOIN_OPTIMIZATION);
        if (statement.getConnection().getQueryServices().getLowestClusterHBaseVersion() >= PhoenixDatabaseMetaData.ESSENTIAL_FAMILY_VERSION_THRESHOLD) {
            this.scan.setAttribute(LOAD_COLUMN_FAMILIES_ON_DEMAND_ATTR, QueryConstants.TRUE);
        }
        if (select.getHint().hasHint(HintNode.Hint.NO_CACHE)) {
            this.scan.setCacheBlocks(false);
        }
        this.scan.setCaching(statement.getFetchSize());
        this.applyNativeTimeStampHintToScan();
        this.originalScan = ScanUtil.newScan(this.scan);
    }

    public QueryCompiler(PhoenixStatement statement, SelectStatement select, ColumnResolver resolver, List<? extends PDatum> targetColumns, ParallelIteratorFactory parallelIteratorFactory, SequenceManager sequenceManager) throws SQLException {
        this(statement, select, resolver, targetColumns, parallelIteratorFactory, sequenceManager, true);
    }

    public QueryPlan compile() throws SQLException {
        QueryPlan plan = this.select.isUnion() ? this.compileUnionAll(this.select) : this.compileSelect(this.select);
        return plan;
    }

    public QueryPlan compileUnionAll(SelectStatement select) throws SQLException {
        List<SelectStatement> unionAllSelects = select.getSelects();
        ArrayList<QueryPlan> plans = new ArrayList<QueryPlan>();
        for (int i = 0; i < unionAllSelects.size(); ++i) {
            SelectStatement subSelect = unionAllSelects.get(i);
            if (!select.getOrderBy().isEmpty() || select.getLimit() != null) {
                subSelect = NODE_FACTORY.select(subSelect, select.getOrderBy(), select.getLimit());
            }
            QueryPlan subPlan = this.compileSubquery(subSelect, true);
            TupleProjector projector = new TupleProjector(subPlan.getProjector());
            subPlan = new TupleProjectionPlan(subPlan, projector, null);
            plans.add(subPlan);
        }
        UnionCompiler.checkProjectionNumAndTypes(plans);
        TableRef tableRef = UnionCompiler.contructSchemaTable(this.statement, (QueryPlan)plans.get(0), select.hasWildcard() ? null : select.getSelect());
        ColumnResolver resolver = FromCompiler.getResolver(tableRef);
        StatementContext context = new StatementContext(this.statement, resolver, this.scan, this.sequenceManager);
        QueryPlan plan = this.compileSingleFlatQuery(context, select, this.statement.getParameters(), false, false, null, null, false);
        plan = new UnionPlan(context, select, tableRef, plan.getProjector(), plan.getLimit(), plan.getOrderBy(), GroupByCompiler.GroupBy.EMPTY_GROUP_BY, plans, null);
        return plan;
    }

    public QueryPlan compileSelect(SelectStatement select) throws SQLException {
        List<Object> binds = this.statement.getParameters();
        StatementContext context = new StatementContext(this.statement, this.resolver, this.scan, this.sequenceManager);
        if (select.isJoin()) {
            if (this.select != (select = JoinCompiler.optimize(this.statement, select, this.resolver))) {
                ColumnResolver resolver = FromCompiler.getResolverForQuery(select, this.statement.getConnection());
                context = new StatementContext(this.statement, resolver, this.scan, this.sequenceManager);
            }
            JoinCompiler.JoinTable joinTable = JoinCompiler.compile(this.statement, select, context.getResolver());
            return this.compileJoinQuery(context, binds, joinTable, false, false, null);
        }
        return this.compileSingleQuery(context, select, binds, false, true);
    }

    protected QueryPlan compileJoinQuery(StatementContext context, List<Object> binds, JoinCompiler.JoinTable joinTable, boolean asSubquery, boolean projectPKColumns, List<OrderByNode> orderBy) throws SQLException {
        int fieldPosition;
        boolean[] starJoinVector;
        byte[] emptyByteArray = new byte[]{};
        List<JoinCompiler.JoinSpec> joinSpecs = joinTable.getJoinSpecs();
        if (joinSpecs.isEmpty()) {
            JoinCompiler.Table table = joinTable.getTable();
            SelectStatement subquery = table.getAsSubquery(orderBy);
            if (!table.isSubselect()) {
                context.setCurrentTable(table.getTableRef());
                PTable projectedTable = table.createProjectedTable(!projectPKColumns, context);
                TupleProjector projector = new TupleProjector(projectedTable);
                TupleProjector.serializeProjectorIntoScan(context.getScan(), projector);
                context.setResolver(FromCompiler.getResolverForProjectedTable(projectedTable, context.getConnection(), subquery.getUdfParseNodes()));
                table.projectColumns(context.getScan());
                return this.compileSingleFlatQuery(context, subquery, binds, asSubquery, !asSubquery, null, projectPKColumns ? projector : null, true);
            }
            QueryPlan plan = this.compileSubquery(subquery, false);
            PTable projectedTable = table.createProjectedTable(plan.getProjector());
            context.setResolver(FromCompiler.getResolverForProjectedTable(projectedTable, context.getConnection(), subquery.getUdfParseNodes()));
            return new TupleProjectionPlan(plan, new TupleProjector(plan.getProjector()), table.compilePostFilterExpression(context));
        }
        if (!this.useSortMergeJoin && (starJoinVector = joinTable.getStarJoinVector()) != null) {
            TupleProjector tupleProjector;
            SelectStatement query;
            TableRef tableRef;
            PTable initialProjectedTable;
            JoinCompiler.Table table = joinTable.getTable();
            if (!table.isSubselect()) {
                context.setCurrentTable(table.getTableRef());
                initialProjectedTable = table.createProjectedTable(!projectPKColumns, context);
                tableRef = table.getTableRef();
                table.projectColumns(context.getScan());
                query = joinTable.getAsSingleSubquery(table.getAsSubquery(orderBy), asSubquery);
                tupleProjector = new TupleProjector(initialProjectedTable);
            } else {
                SelectStatement subquery = table.getAsSubquery(orderBy);
                QueryPlan plan = this.compileSubquery(subquery, false);
                initialProjectedTable = table.createProjectedTable(plan.getProjector());
                tableRef = plan.getTableRef();
                context.getScan().setFamilyMap(plan.getContext().getScan().getFamilyMap());
                query = joinTable.getAsSingleSubquery((SelectStatement)plan.getStatement(), asSubquery);
                tupleProjector = new TupleProjector(plan.getProjector());
            }
            context.setCurrentTable(tableRef);
            PTable projectedTable = initialProjectedTable;
            int count = joinSpecs.size();
            ImmutableBytesPtr[] joinIds = new ImmutableBytesPtr[count];
            List[] joinExpressions = new List[count];
            JoinTableNode.JoinType[] joinTypes = new JoinTableNode.JoinType[count];
            PTable[] tables = new PTable[count];
            int[] fieldPositions = new int[count];
            HashJoinPlan.SubPlan[] subPlans = new HashJoinPlan.HashSubPlan[count];
            fieldPositions[0] = projectedTable.getColumns().size() - projectedTable.getPKColumns().size();
            for (int i = 0; i < count; ++i) {
                JoinCompiler.JoinSpec joinSpec = joinSpecs.get(i);
                Scan subScan = ScanUtil.newScan(this.originalScan);
                StatementContext subContext = new StatementContext(this.statement, context.getResolver(), subScan, new SequenceManager(this.statement));
                QueryPlan joinPlan = this.compileJoinQuery(subContext, binds, joinSpec.getJoinTable(), true, true, null);
                boolean hasPostReference = joinSpec.getJoinTable().hasPostReference();
                if (hasPostReference) {
                    tables[i] = subContext.getResolver().getTables().get(0).getTable();
                    projectedTable = JoinCompiler.joinProjectedTables(projectedTable, tables[i], joinSpec.getType());
                } else {
                    tables[i] = null;
                }
                context.setResolver(FromCompiler.getResolverForProjectedTable(projectedTable, context.getConnection(), query.getUdfParseNodes()));
                joinIds[i] = new ImmutableBytesPtr(emptyByteArray);
                Pair<List<Expression>, List<Expression>> joinConditions = joinSpec.compileJoinConditions(context, subContext, true);
                joinExpressions[i] = joinConditions.getFirst();
                List<Expression> hashExpressions = joinConditions.getSecond();
                Pair<Object, Object> keyRangeExpressions = new Pair<Object, Object>(null, null);
                boolean optimized = this.getKeyExpressionCombinations(keyRangeExpressions, context, joinTable.getStatement(), tableRef, joinSpec.getType(), joinExpressions[i], hashExpressions);
                Expression keyRangeLhsExpression = keyRangeExpressions.getFirst();
                Expression keyRangeRhsExpression = keyRangeExpressions.getSecond();
                joinTypes[i] = joinSpec.getType();
                if (i < count - 1) {
                    fieldPositions[i + 1] = fieldPositions[i] + (tables[i] == null ? 0 : tables[i].getColumns().size() - tables[i].getPKColumns().size());
                }
                subPlans[i] = new HashJoinPlan.HashSubPlan(i, joinPlan, optimized ? null : hashExpressions, joinSpec.isSingleValueOnly(), keyRangeLhsExpression, keyRangeRhsExpression);
            }
            TupleProjector.serializeProjectorIntoScan(context.getScan(), tupleProjector);
            QueryPlan plan = this.compileSingleFlatQuery(context, query, binds, asSubquery, !asSubquery && joinTable.isAllLeftJoin(), null, !table.isSubselect() && projectPKColumns ? tupleProjector : null, true);
            Expression postJoinFilterExpression = joinTable.compilePostFilterExpression(context, table);
            Integer limit = null;
            if (!query.isAggregate() && !query.isDistinct() && query.getOrderBy().isEmpty()) {
                limit = plan.getLimit();
            }
            HashJoinInfo joinInfo = new HashJoinInfo(projectedTable, joinIds, joinExpressions, joinTypes, starJoinVector, tables, fieldPositions, postJoinFilterExpression, limit);
            return HashJoinPlan.create(joinTable.getStatement(), plan, joinInfo, subPlans);
        }
        JoinCompiler.JoinSpec lastJoinSpec = joinSpecs.get(joinSpecs.size() - 1);
        JoinTableNode.JoinType type = lastJoinSpec.getType();
        if (!this.useSortMergeJoin && (type == JoinTableNode.JoinType.Right || type == JoinTableNode.JoinType.Inner) && lastJoinSpec.getJoinTable().getJoinSpecs().isEmpty() && lastJoinSpec.getJoinTable().getTable().isFlat()) {
            int fieldPosition2;
            TupleProjector tupleProjector;
            SelectStatement rhs;
            TableRef rhsTableRef;
            PTable rhsProjTable;
            JoinCompiler.JoinTable rhsJoinTable = lastJoinSpec.getJoinTable();
            JoinCompiler.Table rhsTable = rhsJoinTable.getTable();
            JoinCompiler.JoinTable lhsJoin = joinTable.getSubJoinTableWithoutPostFilters();
            Scan subScan = ScanUtil.newScan(this.originalScan);
            StatementContext lhsCtx = new StatementContext(this.statement, context.getResolver(), subScan, new SequenceManager(this.statement));
            QueryPlan lhsPlan = this.compileJoinQuery(lhsCtx, binds, lhsJoin, true, true, null);
            if (!rhsTable.isSubselect()) {
                context.setCurrentTable(rhsTable.getTableRef());
                rhsProjTable = rhsTable.createProjectedTable(!projectPKColumns, context);
                rhsTableRef = rhsTable.getTableRef();
                rhsTable.projectColumns(context.getScan());
                rhs = rhsJoinTable.getAsSingleSubquery(rhsTable.getAsSubquery(orderBy), asSubquery);
                tupleProjector = new TupleProjector(rhsProjTable);
            } else {
                SelectStatement subquery = rhsTable.getAsSubquery(orderBy);
                QueryPlan plan = this.compileSubquery(subquery, false);
                rhsProjTable = rhsTable.createProjectedTable(plan.getProjector());
                rhsTableRef = plan.getTableRef();
                context.getScan().setFamilyMap(plan.getContext().getScan().getFamilyMap());
                rhs = rhsJoinTable.getAsSingleSubquery((SelectStatement)plan.getStatement(), asSubquery);
                tupleProjector = new TupleProjector(plan.getProjector());
            }
            context.setCurrentTable(rhsTableRef);
            context.setResolver(FromCompiler.getResolverForProjectedTable(rhsProjTable, context.getConnection(), rhs.getUdfParseNodes()));
            ImmutableBytesPtr[] joinIds = new ImmutableBytesPtr[]{new ImmutableBytesPtr(emptyByteArray)};
            Pair<List<Expression>, List<Expression>> joinConditions = lastJoinSpec.compileJoinConditions(lhsCtx, context, true);
            List<Expression> joinExpressions = joinConditions.getSecond();
            List<Expression> hashExpressions = joinConditions.getFirst();
            boolean needsMerge = lhsJoin.hasPostReference();
            PTable lhsTable = needsMerge ? lhsCtx.getResolver().getTables().get(0).getTable() : null;
            int n = fieldPosition2 = needsMerge ? rhsProjTable.getColumns().size() - rhsProjTable.getPKColumns().size() : 0;
            PTable projectedTable = needsMerge ? JoinCompiler.joinProjectedTables(rhsProjTable, lhsTable, type == JoinTableNode.JoinType.Right ? JoinTableNode.JoinType.Left : type) : rhsProjTable;
            TupleProjector.serializeProjectorIntoScan(context.getScan(), tupleProjector);
            context.setResolver(FromCompiler.getResolverForProjectedTable(projectedTable, context.getConnection(), rhs.getUdfParseNodes()));
            QueryPlan rhsPlan = this.compileSingleFlatQuery(context, rhs, binds, asSubquery, !asSubquery && type == JoinTableNode.JoinType.Right, null, !rhsTable.isSubselect() && projectPKColumns ? tupleProjector : null, true);
            Expression postJoinFilterExpression = joinTable.compilePostFilterExpression(context, rhsTable);
            Integer limit = null;
            if (!rhs.isAggregate() && !rhs.isDistinct() && rhs.getOrderBy().isEmpty()) {
                limit = rhsPlan.getLimit();
            }
            HashJoinInfo joinInfo = new HashJoinInfo(projectedTable, joinIds, new List[]{joinExpressions}, new JoinTableNode.JoinType[]{type == JoinTableNode.JoinType.Right ? JoinTableNode.JoinType.Left : type}, new boolean[]{true}, new PTable[]{lhsTable}, new int[]{fieldPosition2}, postJoinFilterExpression, limit);
            Pair<Object, Object> keyRangeExpressions = new Pair<Object, Object>(null, null);
            this.getKeyExpressionCombinations(keyRangeExpressions, context, joinTable.getStatement(), rhsTableRef, type, joinExpressions, hashExpressions);
            return HashJoinPlan.create(joinTable.getStatement(), rhsPlan, joinInfo, new HashJoinPlan.HashSubPlan[]{new HashJoinPlan.HashSubPlan(0, lhsPlan, hashExpressions, false, keyRangeExpressions.getFirst(), keyRangeExpressions.getSecond())});
        }
        JoinCompiler.JoinTable lhsJoin = joinTable.getSubJoinTableWithoutPostFilters();
        JoinCompiler.JoinTable rhsJoin = lastJoinSpec.getJoinTable();
        if (type == JoinTableNode.JoinType.Right) {
            JoinCompiler.JoinTable temp = lhsJoin;
            lhsJoin = rhsJoin;
            rhsJoin = temp;
        }
        List<EqualParseNode> joinConditionNodes = lastJoinSpec.getOnConditions();
        ArrayList<OrderByNode> lhsOrderBy = Lists.newArrayListWithExpectedSize(joinConditionNodes.size());
        ArrayList<OrderByNode> rhsOrderBy = Lists.newArrayListWithExpectedSize(joinConditionNodes.size());
        for (EqualParseNode condition : joinConditionNodes) {
            lhsOrderBy.add(NODE_FACTORY.orderBy(type == JoinTableNode.JoinType.Right ? condition.getRHS() : condition.getLHS(), false, true));
            rhsOrderBy.add(NODE_FACTORY.orderBy(type == JoinTableNode.JoinType.Right ? condition.getLHS() : condition.getRHS(), false, true));
        }
        Scan lhsScan = ScanUtil.newScan(this.originalScan);
        StatementContext lhsCtx = new StatementContext(this.statement, context.getResolver(), lhsScan, new SequenceManager(this.statement));
        boolean preserveRowkey = !projectPKColumns && type != JoinTableNode.JoinType.Full;
        QueryPlan lhsPlan = this.compileJoinQuery(lhsCtx, binds, lhsJoin, true, !preserveRowkey, lhsOrderBy);
        PTable lhsProjTable = lhsCtx.getResolver().getTables().get(0).getTable();
        boolean isInRowKeyOrder = preserveRowkey && lhsPlan.getOrderBy().getOrderByExpressions().isEmpty();
        Scan rhsScan = ScanUtil.newScan(this.originalScan);
        StatementContext rhsCtx = new StatementContext(this.statement, context.getResolver(), rhsScan, new SequenceManager(this.statement));
        QueryPlan rhsPlan = this.compileJoinQuery(rhsCtx, binds, rhsJoin, true, true, rhsOrderBy);
        PTable rhsProjTable = rhsCtx.getResolver().getTables().get(0).getTable();
        Pair<List<Expression>, List<Expression>> joinConditions = lastJoinSpec.compileJoinConditions(type == JoinTableNode.JoinType.Right ? rhsCtx : lhsCtx, type == JoinTableNode.JoinType.Right ? lhsCtx : rhsCtx, false);
        List<Expression> lhsKeyExpressions = type == JoinTableNode.JoinType.Right ? joinConditions.getSecond() : joinConditions.getFirst();
        List<Expression> rhsKeyExpressions = type == JoinTableNode.JoinType.Right ? joinConditions.getFirst() : joinConditions.getSecond();
        boolean needsMerge = rhsJoin.hasPostReference();
        int n = fieldPosition = needsMerge ? lhsProjTable.getColumns().size() - lhsProjTable.getPKColumns().size() : 0;
        PTable projectedTable = needsMerge ? JoinCompiler.joinProjectedTables(lhsProjTable, rhsProjTable, type == JoinTableNode.JoinType.Right ? JoinTableNode.JoinType.Left : type) : lhsProjTable;
        ColumnResolver resolver = FromCompiler.getResolverForProjectedTable(projectedTable, context.getConnection(), new HashMap<String, UDFParseNode>(1));
        TableRef tableRef = resolver.getTables().get(0);
        StatementContext subCtx = new StatementContext(this.statement, resolver, ScanUtil.newScan(this.originalScan), new SequenceManager(this.statement));
        subCtx.setCurrentTable(tableRef);
        SortMergeJoinPlan innerPlan = new SortMergeJoinPlan(subCtx, joinTable.getStatement(), tableRef, type == JoinTableNode.JoinType.Right ? JoinTableNode.JoinType.Left : type, lhsPlan, rhsPlan, lhsKeyExpressions, rhsKeyExpressions, projectedTable, lhsProjTable, needsMerge ? rhsProjTable : null, fieldPosition, lastJoinSpec.isSingleValueOnly());
        context.setCurrentTable(tableRef);
        context.setResolver(resolver);
        NamedTableNode from = NODE_FACTORY.namedTable(tableRef.getTableAlias(), NODE_FACTORY.table(tableRef.getTable().getSchemaName().getString(), tableRef.getTable().getTableName().getString()));
        ParseNode where = joinTable.getPostFiltersCombined();
        SelectStatement select = asSubquery ? NODE_FACTORY.select(from, joinTable.getStatement().getHint(), false, Collections.emptyList(), where, null, null, orderBy, null, 0, false, joinTable.getStatement().hasSequence(), Collections.emptyList(), joinTable.getStatement().getUdfParseNodes()) : NODE_FACTORY.select(joinTable.getStatement(), from, where);
        return this.compileSingleFlatQuery(context, select, binds, asSubquery, false, innerPlan, null, isInRowKeyOrder);
    }

    private boolean getKeyExpressionCombinations(Pair<Expression, Expression> combination, StatementContext context, SelectStatement select, TableRef table, JoinTableNode.JoinType type, List<Expression> joinExpressions, List<Expression> hashExpressions) throws SQLException {
        if (type != JoinTableNode.JoinType.Inner && type != JoinTableNode.JoinType.Semi || this.noChildParentJoinOptimization) {
            return false;
        }
        Scan scanCopy = ScanUtil.newScan(context.getScan());
        StatementContext contextCopy = new StatementContext(this.statement, context.getResolver(), scanCopy, new SequenceManager(this.statement));
        contextCopy.setCurrentTable(table);
        ArrayList<Expression> lhsCombination = Lists.newArrayList();
        boolean complete = WhereOptimizer.getKeyExpressionCombination(lhsCombination, contextCopy, select, joinExpressions);
        if (lhsCombination.isEmpty()) {
            return false;
        }
        ArrayList<Expression> rhsCombination = Lists.newArrayListWithExpectedSize(lhsCombination.size());
        block0: for (int i = 0; i < lhsCombination.size(); ++i) {
            Expression lhs = (Expression)lhsCombination.get(i);
            for (int j = 0; j < joinExpressions.size(); ++j) {
                if (lhs != joinExpressions.get(j)) continue;
                rhsCombination.add(hashExpressions.get(j));
                continue block0;
            }
        }
        if (lhsCombination.size() == 1) {
            combination.setFirst((Expression)lhsCombination.get(0));
            combination.setSecond((Expression)rhsCombination.get(0));
        } else {
            combination.setFirst(new RowValueConstructorExpression(lhsCombination, false));
            combination.setSecond(new RowValueConstructorExpression(rhsCombination, false));
        }
        return type == JoinTableNode.JoinType.Semi && complete;
    }

    protected QueryPlan compileSubquery(SelectStatement subquery, boolean pushDownMaxRows) throws SQLException {
        PhoenixConnection connection = this.statement.getConnection();
        subquery = SubselectRewriter.flatten(subquery, connection);
        ColumnResolver resolver = FromCompiler.getResolverForQuery(subquery, connection);
        SelectStatement transformedSubquery = SubqueryRewriter.transform(subquery = StatementNormalizer.normalize(subquery, resolver), resolver, connection);
        if (transformedSubquery != subquery) {
            resolver = FromCompiler.getResolverForQuery(transformedSubquery, connection);
            subquery = StatementNormalizer.normalize(transformedSubquery, resolver);
        }
        int maxRows = this.statement.getMaxRows();
        this.statement.setMaxRows(pushDownMaxRows ? maxRows : 0);
        QueryPlan plan = new QueryCompiler(this.statement, subquery, resolver, false).compile();
        plan = this.statement.getConnection().getQueryServices().getOptimizer().optimize(this.statement, plan);
        this.statement.setMaxRows(maxRows);
        return plan;
    }

    protected QueryPlan compileSingleQuery(StatementContext context, SelectStatement select, List<Object> binds, boolean asSubquery, boolean allowPageFilter) throws SQLException {
        SelectStatement innerSelect = select.getInnerSelectStatement();
        if (innerSelect == null) {
            return this.compileSingleFlatQuery(context, select, binds, asSubquery, allowPageFilter, null, null, true);
        }
        QueryPlan innerPlan = this.compileSubquery(innerSelect, false);
        TupleProjector tupleProjector = new TupleProjector(innerPlan.getProjector());
        innerPlan = new TupleProjectionPlan(innerPlan, tupleProjector, null);
        TableRef tableRef = context.getResolver().getTables().get(0);
        ColumnResolver resolver = FromCompiler.getResolverForCompiledDerivedTable(this.statement.getConnection(), tableRef, innerPlan.getProjector());
        context.setResolver(resolver);
        tableRef = resolver.getTables().get(0);
        context.setCurrentTable(tableRef);
        return this.compileSingleFlatQuery(context, select, binds, asSubquery, allowPageFilter, innerPlan, tupleProjector, innerPlan.getOrderBy().getOrderByExpressions().isEmpty());
    }

    protected QueryPlan compileSingleFlatQuery(StatementContext context, SelectStatement select, List<Object> binds, boolean asSubquery, boolean allowPageFilter, QueryPlan innerPlan, TupleProjector innerPlanTupleProjector, boolean isInRowKeyOrder) throws SQLException {
        QueryPlan plan;
        int maxRows;
        PTable projectedTable = null;
        if (this.projectTuples && (projectedTable = TupleProjectionCompiler.createProjectedTable(select, context)) != null) {
            context.setResolver(FromCompiler.getResolverForProjectedTable(projectedTable, context.getConnection(), select.getUdfParseNodes()));
        }
        ColumnResolver resolver = context.getResolver();
        TableRef tableRef = context.getCurrentTable();
        PTable table = tableRef.getTable();
        ParseNode viewWhere = null;
        if (table.getViewStatement() != null) {
            viewWhere = new SQLParser(table.getViewStatement()).parseQuery().getWhere();
        }
        Integer limit = LimitCompiler.compile(context, select);
        GroupByCompiler.GroupBy groupBy = GroupByCompiler.compile(context, select, innerPlanTupleProjector, isInRowKeyOrder);
        select = HavingCompiler.rewrite(context, select, groupBy);
        Expression having = HavingCompiler.compile(context, select, groupBy);
        if (innerPlan == null && !tableRef.equals(resolver.getTables().get(0))) {
            context.setResolver(FromCompiler.getResolver(context.getConnection(), tableRef, select.getUdfParseNodes()));
        }
        HashSet<SubqueryParseNode> subqueries = Sets.newHashSet();
        Expression where = WhereCompiler.compile(context, select, viewWhere, subqueries);
        context.setResolver(resolver);
        RowProjector projector = ProjectionCompiler.compile(context, select, groupBy, asSubquery ? Collections.emptyList() : this.targetColumns);
        OrderByCompiler.OrderBy orderBy = OrderByCompiler.compile(context, select, groupBy, limit, projector, groupBy == GroupByCompiler.GroupBy.EMPTY_GROUP_BY ? innerPlanTupleProjector : null, isInRowKeyOrder);
        context.getAggregationManager().compile(context, groupBy);
        if (!asSubquery && (maxRows = this.statement.getMaxRows()) > 0) {
            limit = limit != null ? Integer.valueOf(Math.min(limit, maxRows)) : Integer.valueOf(maxRows);
        }
        if (projectedTable != null) {
            TupleProjector.serializeProjectorIntoScan(context.getScan(), new TupleProjector(projectedTable));
        }
        if ((plan = innerPlan) == null) {
            ParallelIteratorFactory parallelIteratorFactory = asSubquery ? null : this.parallelIteratorFactory;
            QueryPlan queryPlan = plan = select.isAggregate() || select.isDistinct() ? new AggregatePlan(context, (FilterableStatement)select, tableRef, projector, limit, orderBy, parallelIteratorFactory, groupBy, having) : new ScanPlan(context, select, tableRef, projector, limit, orderBy, parallelIteratorFactory, allowPageFilter);
        }
        if (!subqueries.isEmpty()) {
            int count = subqueries.size();
            HashJoinPlan.SubPlan[] subPlans = new HashJoinPlan.WhereClauseSubPlan[count];
            int i = 0;
            for (SubqueryParseNode subqueryNode : subqueries) {
                SelectStatement stmt = subqueryNode.getSelectNode();
                subPlans[i++] = new HashJoinPlan.WhereClauseSubPlan(this.compileSubquery(stmt, false), stmt, subqueryNode.expectSingleRow());
            }
            plan = HashJoinPlan.create(select, plan, null, subPlans);
        }
        if (innerPlan != null) {
            if (LiteralExpression.isTrue(where)) {
                where = null;
            }
            plan = select.isAggregate() || select.isDistinct() ? new ClientAggregatePlan(context, select, tableRef, projector, limit, where, orderBy, groupBy, having, plan) : new ClientScanPlan(context, select, tableRef, projector, limit, where, orderBy, plan);
        }
        return plan;
    }

    private void applyNativeTimeStampHintToScan() {
        Pair<Long, Long> hintTimeRange = this.select.getHint().getNativeTimeStampRange();
        if (hintTimeRange != null) {
            Long minTimeStamp = hintTimeRange.getFirst();
            Long maxTimeStamp = hintTimeRange.getSecond();
            if (this.statement.getConnection().getSCN() != null && this.statement.getConnection().getSCN() < maxTimeStamp) {
                maxTimeStamp = this.statement.getConnection().getSCN();
            }
            try {
                this.scan.setTimeRange(minTimeStamp, maxTimeStamp);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

