/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.compile;

import com.google.common.collect.Lists;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NavigableSet;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.io.WritableUtils;
import org.apache.phoenix.compile.ColumnResolver;
import org.apache.phoenix.compile.ExpressionCompiler;
import org.apache.phoenix.compile.ExpressionProjector;
import org.apache.phoenix.compile.GroupByCompiler;
import org.apache.phoenix.compile.RowProjector;
import org.apache.phoenix.compile.StatementContext;
import org.apache.phoenix.exception.SQLExceptionCode;
import org.apache.phoenix.exception.SQLExceptionInfo;
import org.apache.phoenix.expression.BaseTerminalExpression;
import org.apache.phoenix.expression.CoerceExpression;
import org.apache.phoenix.expression.ColumnExpression;
import org.apache.phoenix.expression.Expression;
import org.apache.phoenix.expression.KeyValueColumnExpression;
import org.apache.phoenix.expression.LiteralExpression;
import org.apache.phoenix.expression.visitor.ExpressionVisitor;
import org.apache.phoenix.expression.visitor.KeyValueExpressionVisitor;
import org.apache.phoenix.jdbc.PhoenixConnection;
import org.apache.phoenix.parse.AliasedNode;
import org.apache.phoenix.parse.BindParseNode;
import org.apache.phoenix.parse.ColumnParseNode;
import org.apache.phoenix.parse.FamilyWildcardParseNode;
import org.apache.phoenix.parse.FunctionParseNode;
import org.apache.phoenix.parse.ParseNode;
import org.apache.phoenix.parse.SelectStatement;
import org.apache.phoenix.parse.SequenceValueParseNode;
import org.apache.phoenix.parse.TableName;
import org.apache.phoenix.parse.TableWildcardParseNode;
import org.apache.phoenix.parse.WildcardParseNode;
import org.apache.phoenix.query.QueryConstants;
import org.apache.phoenix.schema.AmbiguousColumnException;
import org.apache.phoenix.schema.ArgumentTypeMismatchException;
import org.apache.phoenix.schema.ColumnFamilyNotFoundException;
import org.apache.phoenix.schema.ColumnNotFoundException;
import org.apache.phoenix.schema.ColumnRef;
import org.apache.phoenix.schema.KeyValueSchema;
import org.apache.phoenix.schema.LocalIndexDataColumnRef;
import org.apache.phoenix.schema.PColumn;
import org.apache.phoenix.schema.PColumnFamily;
import org.apache.phoenix.schema.PDatum;
import org.apache.phoenix.schema.PName;
import org.apache.phoenix.schema.PTable;
import org.apache.phoenix.schema.PTableKey;
import org.apache.phoenix.schema.PTableType;
import org.apache.phoenix.schema.TableNotFoundException;
import org.apache.phoenix.schema.TableRef;
import org.apache.phoenix.schema.ValueBitSet;
import org.apache.phoenix.schema.tuple.Tuple;
import org.apache.phoenix.schema.types.PDataType;
import org.apache.phoenix.util.ByteUtil;
import org.apache.phoenix.util.IndexUtil;
import org.apache.phoenix.util.SchemaUtil;

public class ProjectionCompiler {
    private static ValueBitSet arrayIndexesBitSet;
    private static KeyValueSchema arrayIndexesSchema;

    private ProjectionCompiler() {
    }

    private static void projectColumnFamily(PTable table, Scan scan, byte[] family) {
        scan.addFamily(family);
    }

    public static RowProjector compile(StatementContext context, SelectStatement statement, GroupByCompiler.GroupBy groupBy) throws SQLException {
        return ProjectionCompiler.compile(context, statement, groupBy, Collections.emptyList());
    }

    private static int getMinPKOffset(PTable table, PName tenantId) {
        int posOffset;
        int n = posOffset = table.getBucketNum() == null ? 0 : 1;
        if (table.isMultiTenant() && tenantId != null) {
            ++posOffset;
        }
        if (table.getViewIndexId() != null) {
            ++posOffset;
        }
        return posOffset;
    }

    private static void projectAllTableColumns(StatementContext context, TableRef tableRef, boolean resolveColumn, List<Expression> projectedExpressions, List<ExpressionProjector> projectedColumns, List<? extends PDatum> targetColumns) throws SQLException {
        ColumnResolver resolver = context.getResolver();
        PTable table = tableRef.getTable();
        int projectedOffset = projectedExpressions.size();
        int posOffset = table.getBucketNum() == null ? 0 : 1;
        int minPKOffset = ProjectionCompiler.getMinPKOffset(table, context.getConnection().getTenantId());
        int j = posOffset;
        for (int i = posOffset; i < table.getColumns().size(); ++i) {
            PColumn column = table.getColumns().get(i);
            if (SchemaUtil.isPKColumn(column) && j++ < minPKOffset) {
                ++posOffset;
                continue;
            }
            ColumnRef ref = new ColumnRef(tableRef, i);
            String colName = ref.getColumn().getName().getString();
            String tableAlias = tableRef.getTableAlias();
            if (resolveColumn) {
                try {
                    String schemaName;
                    ref = tableAlias != null ? resolver.resolveColumn(null, tableAlias, colName) : resolver.resolveColumn((schemaName = table.getSchemaName().getString()).length() == 0 ? null : schemaName, table.getTableName().getString(), colName);
                }
                catch (AmbiguousColumnException e) {
                    if (column.getFamilyName() != null) {
                        ref = resolver.resolveColumn(tableAlias != null ? tableAlias : table.getTableName().getString(), column.getFamilyName().getString(), colName);
                    }
                    throw e;
                }
            }
            Expression expression = ref.newColumnExpression();
            expression = ProjectionCompiler.coerceIfNecessary(i - posOffset + projectedOffset, targetColumns, expression);
            ImmutableBytesWritable ptr = context.getTempPtr();
            if (IndexUtil.getViewConstantValue(column, ptr)) {
                expression = LiteralExpression.newConstant(column.getDataType().toObject(ptr), expression.getDataType());
            }
            projectedExpressions.add(expression);
            boolean isCaseSensitive = !SchemaUtil.normalizeIdentifier(colName).equals(colName);
            projectedColumns.add(new ExpressionProjector(colName, tableRef.getTableAlias() == null ? table.getName().getString() : tableRef.getTableAlias(), expression, isCaseSensitive));
        }
    }

    private static void projectAllIndexColumns(StatementContext context, TableRef tableRef, boolean resolveColumn, List<Expression> projectedExpressions, List<ExpressionProjector> projectedColumns, List<? extends PDatum> targetColumns) throws SQLException {
        ColumnResolver resolver = context.getResolver();
        PTable index = tableRef.getTable();
        int projectedOffset = projectedExpressions.size();
        PhoenixConnection conn = context.getConnection();
        PName tenantId = conn.getTenantId();
        String tableName = index.getParentName().getString();
        PTable dataTable = null;
        try {
            dataTable = conn.getMetaDataCache().getTable(new PTableKey(tenantId, tableName));
        }
        catch (TableNotFoundException e) {
            if (tenantId != null) {
                dataTable = conn.getMetaDataCache().getTable(new PTableKey(null, tableName));
            }
            throw e;
        }
        int tableOffset = dataTable.getBucketNum() == null ? 0 : 1;
        int minTablePKOffset = ProjectionCompiler.getMinPKOffset(dataTable, tenantId);
        int minIndexPKOffset = ProjectionCompiler.getMinPKOffset(index, tenantId);
        if (index.getIndexType() != PTable.IndexType.LOCAL && index.getColumns().size() - minIndexPKOffset != dataTable.getColumns().size() - minTablePKOffset) {
            throw new ColumnNotFoundException(WildcardParseNode.INSTANCE.toString());
        }
        int j = tableOffset;
        for (int i = tableOffset; i < dataTable.getColumns().size(); ++i) {
            PColumn column = dataTable.getColumns().get(i);
            if (SchemaUtil.isPKColumn(column) && j++ < minTablePKOffset) {
                ++tableOffset;
                continue;
            }
            PColumn tableColumn = dataTable.getColumns().get(i);
            String indexColName = IndexUtil.getIndexColumnName(tableColumn);
            PColumn indexColumn = null;
            ColumnRef ref = null;
            try {
                indexColumn = index.getColumn(indexColName);
                ref = new ColumnRef(tableRef, indexColumn.getPosition());
            }
            catch (ColumnNotFoundException e) {
                if (index.getIndexType() == PTable.IndexType.LOCAL) {
                    try {
                        ref = new LocalIndexDataColumnRef(context, indexColName);
                        indexColumn = ref.getColumn();
                    }
                    catch (ColumnFamilyNotFoundException c) {
                        throw e;
                    }
                }
                throw e;
            }
            String colName = tableColumn.getName().getString();
            String tableAlias = tableRef.getTableAlias();
            if (resolveColumn) {
                try {
                    String schemaName;
                    ref = tableAlias != null ? resolver.resolveColumn(null, tableAlias, indexColName) : resolver.resolveColumn((schemaName = index.getSchemaName().getString()).length() == 0 ? null : schemaName, index.getTableName().getString(), indexColName);
                }
                catch (AmbiguousColumnException e) {
                    if (indexColumn.getFamilyName() != null) {
                        ref = resolver.resolveColumn(tableAlias != null ? tableAlias : index.getTableName().getString(), indexColumn.getFamilyName().getString(), indexColName);
                    }
                    throw e;
                }
            }
            Expression expression = ref.newColumnExpression();
            expression = ProjectionCompiler.coerceIfNecessary(i - tableOffset + projectedOffset, targetColumns, expression);
            projectedExpressions.add(expression);
            boolean isCaseSensitive = !SchemaUtil.normalizeIdentifier(colName).equals(colName);
            ExpressionProjector projector = new ExpressionProjector(colName, tableRef.getTableAlias() == null ? dataTable.getName().getString() : tableRef.getTableAlias(), expression, isCaseSensitive);
            projectedColumns.add(projector);
        }
    }

    private static void projectTableColumnFamily(StatementContext context, String cfName, TableRef tableRef, boolean resolveColumn, List<Expression> projectedExpressions, List<ExpressionProjector> projectedColumns) throws SQLException {
        PTable table = tableRef.getTable();
        PColumnFamily pfamily = table.getColumnFamily(cfName);
        for (PColumn column : pfamily.getColumns()) {
            ColumnRef ref = new ColumnRef(tableRef, column.getPosition());
            if (resolveColumn) {
                ref = context.getResolver().resolveColumn(table.getTableName().getString(), cfName, column.getName().getString());
            }
            ColumnExpression expression = ref.newColumnExpression();
            projectedExpressions.add(expression);
            String colName = column.getName().toString();
            boolean isCaseSensitive = !SchemaUtil.normalizeIdentifier(colName).equals(colName);
            projectedColumns.add(new ExpressionProjector(colName, tableRef.getTableAlias() == null ? table.getName().getString() : tableRef.getTableAlias(), expression, isCaseSensitive));
        }
    }

    private static void projectIndexColumnFamily(StatementContext context, String cfName, TableRef tableRef, boolean resolveColumn, List<Expression> projectedExpressions, List<ExpressionProjector> projectedColumns) throws SQLException {
        PTable index = tableRef.getTable();
        PhoenixConnection conn = context.getConnection();
        String tableName = index.getParentName().getString();
        PTable table = conn.getMetaDataCache().getTable(new PTableKey(conn.getTenantId(), tableName));
        PColumnFamily pfamily = table.getColumnFamily(cfName);
        for (PColumn column : pfamily.getColumns()) {
            String indexColName = IndexUtil.getIndexColumnName(column);
            PColumn indexColumn = null;
            ColumnRef ref = null;
            String indexColumnFamily = null;
            try {
                indexColumn = index.getColumn(indexColName);
                ref = new ColumnRef(tableRef, indexColumn.getPosition());
                indexColumnFamily = indexColumn.getFamilyName() == null ? null : indexColumn.getFamilyName().getString();
            }
            catch (ColumnNotFoundException e) {
                if (index.getIndexType() == PTable.IndexType.LOCAL) {
                    try {
                        ref = new LocalIndexDataColumnRef(context, indexColName);
                        indexColumn = ref.getColumn();
                        indexColumnFamily = indexColumn.getFamilyName() == null ? null : (index.getIndexType() == PTable.IndexType.LOCAL ? IndexUtil.getLocalIndexColumnFamily(indexColumn.getFamilyName().getString()) : indexColumn.getFamilyName().getString());
                    }
                    catch (ColumnFamilyNotFoundException c) {
                        throw e;
                    }
                }
                throw e;
            }
            if (resolveColumn) {
                ref = context.getResolver().resolveColumn(index.getTableName().getString(), indexColumnFamily, indexColName);
            }
            ColumnExpression expression = ref.newColumnExpression();
            projectedExpressions.add(expression);
            String colName = column.getName().toString();
            boolean isCaseSensitive = !SchemaUtil.normalizeIdentifier(colName).equals(colName);
            projectedColumns.add(new ExpressionProjector(colName, tableRef.getTableAlias() == null ? table.getName().getString() : tableRef.getTableAlias(), expression, isCaseSensitive));
        }
    }

    private static Expression coerceIfNecessary(int index, List<? extends PDatum> targetColumns, Expression expression) throws SQLException {
        PDatum targetColumn;
        if (index < targetColumns.size() && (targetColumn = targetColumns.get(index)).getDataType() != expression.getDataType()) {
            PDataType targetType = targetColumn.getDataType();
            if (expression.getDataType() != null && !expression.getDataType().isCastableTo(targetType)) {
                throw new ArgumentTypeMismatchException(targetType, expression.getDataType(), "column: " + targetColumn);
            }
            expression = CoerceExpression.create(expression, targetType);
        }
        return expression;
    }

    public static RowProjector compile(StatementContext context, SelectStatement statement, GroupByCompiler.GroupBy groupBy, List<? extends PDatum> targetColumns) throws SQLException {
        boolean isProjectEmptyKeyValue;
        Object family;
        ArrayList<KeyValueColumnExpression> arrayKVRefs = new ArrayList<KeyValueColumnExpression>();
        ArrayList<Expression> arrayKVFuncs = new ArrayList<Expression>();
        List<AliasedNode> aliasedNodes = statement.getSelect();
        SelectClauseVisitor selectVisitor = new SelectClauseVisitor(context, groupBy, arrayKVRefs, arrayKVFuncs, statement);
        ArrayList<ExpressionProjector> projectedColumns = new ArrayList<ExpressionProjector>();
        ColumnResolver resolver = context.getResolver();
        TableRef tableRef = context.getCurrentTable();
        PTable table = tableRef.getTable();
        boolean resolveColumn = !tableRef.equals(resolver.getTables().get(0));
        boolean isWildcard = false;
        Scan scan = context.getScan();
        int index = 0;
        ArrayList<Expression> projectedExpressions = Lists.newArrayListWithExpectedSize(aliasedNodes.size());
        ArrayList<byte[]> projectedFamilies = Lists.newArrayListWithExpectedSize(aliasedNodes.size());
        for (AliasedNode aliasedNode : aliasedNodes) {
            Object columnAlias;
            ParseNode node = aliasedNode.getNode();
            if (node instanceof WildcardParseNode) {
                if (statement.isAggregate()) {
                    ExpressionCompiler.throwNonAggExpressionInAggException(node.toString());
                }
                isWildcard = true;
                if (tableRef.getTable().getType() == PTableType.INDEX && ((WildcardParseNode)node).isRewrite()) {
                    ProjectionCompiler.projectAllIndexColumns(context, tableRef, resolveColumn, projectedExpressions, projectedColumns, targetColumns);
                } else {
                    ProjectionCompiler.projectAllTableColumns(context, tableRef, resolveColumn, projectedExpressions, projectedColumns, targetColumns);
                }
            } else if (node instanceof TableWildcardParseNode) {
                TableName tableName = ((TableWildcardParseNode)node).getTableName();
                TableRef tRef = resolver.resolveTable(tableName.getSchemaName(), tableName.getTableName());
                if (tRef.equals(tableRef)) {
                    isWildcard = true;
                }
                if (tRef.getTable().getType() == PTableType.INDEX && ((TableWildcardParseNode)node).isRewrite()) {
                    ProjectionCompiler.projectAllIndexColumns(context, tRef, true, projectedExpressions, projectedColumns, targetColumns);
                } else {
                    ProjectionCompiler.projectAllTableColumns(context, tRef, true, projectedExpressions, projectedColumns, targetColumns);
                }
            } else if (node instanceof FamilyWildcardParseNode) {
                String string = ((FamilyWildcardParseNode)node).getName();
                projectedFamilies.add(Bytes.toBytes(string));
                if (tableRef.getTable().getType() == PTableType.INDEX && ((FamilyWildcardParseNode)node).isRewrite()) {
                    ProjectionCompiler.projectIndexColumnFamily(context, string, tableRef, resolveColumn, projectedExpressions, projectedColumns);
                } else {
                    ProjectionCompiler.projectTableColumnFamily(context, string, tableRef, resolveColumn, projectedExpressions, projectedColumns);
                }
            } else {
                Expression expression = node.accept(selectVisitor);
                projectedExpressions.add(expression);
                Expression expression2 = ProjectionCompiler.coerceIfNecessary(index, targetColumns, expression);
                if (node instanceof BindParseNode) {
                    context.getBindManager().addParamMetaData((BindParseNode)node, expression2);
                }
                if (!node.isStateless() && !selectVisitor.isAggregate() && statement.isAggregate()) {
                    ExpressionCompiler.throwNonAggExpressionInAggException(expression2.toString());
                }
                Object object = columnAlias = aliasedNode.getAlias() != null ? aliasedNode.getAlias() : SchemaUtil.normalizeIdentifier(aliasedNode.getNode().getAlias());
                boolean isCaseSensitive = aliasedNode.getAlias() != null ? aliasedNode.isCaseSensitve() : (columnAlias != null ? SchemaUtil.isCaseSensitive(aliasedNode.getNode().getAlias()) : selectVisitor.isCaseSensitive);
                Object name = columnAlias == null ? expression2.toString() : columnAlias;
                projectedColumns.add(new ExpressionProjector((String)name, tableRef.getTableAlias() == null ? table.getName().getString() : tableRef.getTableAlias(), expression2, isCaseSensitive));
            }
            if (arrayKVFuncs.size() > 0 && arrayKVRefs.size() > 0) {
                ProjectionCompiler.serailizeArrayIndexInformationAndSetInScan(context, arrayKVFuncs, arrayKVRefs);
                KeyValueSchema.KeyValueSchemaBuilder keyValueSchemaBuilder = new KeyValueSchema.KeyValueSchemaBuilder(0);
                columnAlias = arrayKVRefs.iterator();
                while (columnAlias.hasNext()) {
                    Expression expression = (Expression)columnAlias.next();
                    keyValueSchemaBuilder.addField(expression);
                }
                KeyValueSchema kvSchema = keyValueSchemaBuilder.build();
                arrayIndexesBitSet = ValueBitSet.newInstance(kvSchema);
                KeyValueSchema.KeyValueSchemaBuilder keyValueSchemaBuilder2 = new KeyValueSchema.KeyValueSchemaBuilder(0);
                for (Expression expression : arrayKVFuncs) {
                    keyValueSchemaBuilder2.addField(expression);
                }
                arrayIndexesSchema = keyValueSchemaBuilder2.build();
            }
            selectVisitor.reset();
            ++index;
        }
        int estimatedKeySize = table.getRowKeySchema().getEstimatedValueLength();
        int estimatedByteSize = 0;
        for (Map.Entry entry : scan.getFamilyMap().entrySet()) {
            family = table.getColumnFamily((byte[])entry.getKey());
            if (entry.getValue() == null) {
                for (PColumn column : family.getColumns()) {
                    Integer maxLength = column.getMaxLength();
                    int byteSize = column.getDataType().isFixedWidth() ? (maxLength == null ? column.getDataType().getByteSize() : maxLength) : 10;
                    estimatedByteSize += 64 + estimatedKeySize + byteSize;
                }
                continue;
            }
            for (byte[] cq : (NavigableSet)entry.getValue()) {
                PColumn column = family.getColumn(cq);
                Integer maxLength = column.getMaxLength();
                int byteSize = column.getDataType().isFixedWidth() ? (maxLength == null ? column.getDataType().getByteSize() : maxLength) : 10;
                estimatedByteSize += 64 + estimatedKeySize + byteSize;
            }
        }
        boolean bl = isProjectEmptyKeyValue = (table.getType() != PTableType.VIEW || table.getViewType() != PTable.ViewType.MAPPED) && !isWildcard;
        if (isWildcard) {
            ProjectionCompiler.projectAllColumnFamilies(table, scan);
        } else {
            Iterator iterator = projectedFamilies.iterator();
            while (iterator.hasNext()) {
                family = (byte[])iterator.next();
                ProjectionCompiler.projectColumnFamily(table, scan, (byte[])family);
            }
        }
        return new RowProjector(projectedColumns, estimatedByteSize, isProjectEmptyKeyValue, resolver.hasUDFs());
    }

    private static void projectAllColumnFamilies(PTable table, Scan scan) {
        scan.getFamilyMap().clear();
        for (PColumnFamily family : table.getColumnFamilies()) {
            scan.addFamily(family.getName().getBytes());
        }
    }

    private static void serailizeArrayIndexInformationAndSetInScan(StatementContext context, List<Expression> arrayKVFuncs, List<KeyValueColumnExpression> arrayKVRefs) {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        try {
            DataOutputStream output = new DataOutputStream(stream);
            WritableUtils.writeVInt(output, arrayKVRefs.size());
            for (Expression expression : arrayKVRefs) {
                expression.write(output);
            }
            WritableUtils.writeVInt(output, arrayKVFuncs.size());
            for (Expression expression : arrayKVFuncs) {
                expression.write(output);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            try {
                stream.close();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        context.getScan().setAttribute("_SpecificArrayIndex", stream.toByteArray());
    }

    private static class SelectClauseVisitor
    extends ExpressionCompiler {
        private boolean isCaseSensitive;
        private int elementCount;
        private List<KeyValueColumnExpression> arrayKVRefs;
        private List<Expression> arrayKVFuncs;
        private SelectStatement statement;

        private SelectClauseVisitor(StatementContext context, GroupByCompiler.GroupBy groupBy, List<KeyValueColumnExpression> arrayKVRefs, List<Expression> arrayKVFuncs, SelectStatement statement) {
            super(context, groupBy);
            this.arrayKVRefs = arrayKVRefs;
            this.arrayKVFuncs = arrayKVFuncs;
            this.statement = statement;
            this.reset();
        }

        @Override
        public void reset() {
            super.reset();
            this.elementCount = 0;
            this.isCaseSensitive = true;
        }

        @Override
        protected ColumnRef resolveColumn(ColumnParseNode node) throws SQLException {
            ColumnRef ref = super.resolveColumn(node);
            this.isCaseSensitive = this.isCaseSensitive && node.isCaseSensitive();
            return ref;
        }

        @Override
        public void addElement(List<Expression> l, Expression element) {
            ++this.elementCount;
            this.isCaseSensitive &= this.elementCount == 1;
            super.addElement(l, element);
        }

        @Override
        public Expression visit(SequenceValueParseNode node) throws SQLException {
            if (this.aggregateFunction != null) {
                throw new SQLExceptionInfo.Builder(SQLExceptionCode.INVALID_USE_OF_NEXT_VALUE_FOR).setSchemaName(node.getTableName().getSchemaName()).setTableName(node.getTableName().getTableName()).build().buildException();
            }
            return this.context.getSequenceManager().newSequenceReference(node);
        }

        @Override
        public Expression visitLeave(FunctionParseNode node, List<Expression> children) throws SQLException {
            Object func = super.visitLeave(node, (List)children);
            if (!this.statement.isAggregate() && "ARRAY_ELEM".equals(node.getName())) {
                final ArrayList indexKVs = Lists.newArrayList();
                children.get(0).accept(new KeyValueExpressionVisitor(){

                    @Override
                    public Void visit(KeyValueColumnExpression expression) {
                        if (expression.getDataType().isArrayType()) {
                            indexKVs.add(expression);
                        }
                        return null;
                    }
                });
                if (!indexKVs.isEmpty()) {
                    this.arrayKVRefs.addAll(indexKVs);
                    this.arrayKVFuncs.add((Expression)func);
                    func = this.replaceArrayIndexFunction((Expression)func, this.arrayKVFuncs.size() - 1);
                    return func;
                }
            }
            return func;
        }

        public Expression replaceArrayIndexFunction(Expression func, int size) {
            return new ArrayIndexExpression(size, func.getDataType());
        }
    }

    static class ArrayIndexExpression
    extends BaseTerminalExpression {
        private final int position;
        private final PDataType type;

        public ArrayIndexExpression(int position, PDataType type) {
            this.position = position;
            this.type = type;
        }

        @Override
        public boolean evaluate(Tuple tuple, ImmutableBytesWritable ptr) {
            if (!tuple.getValue(QueryConstants.ARRAY_VALUE_COLUMN_FAMILY, QueryConstants.ARRAY_VALUE_COLUMN_QUALIFIER, ptr)) {
                return false;
            }
            int maxOffset = ptr.getOffset() + ptr.getLength();
            arrayIndexesBitSet.or(ptr);
            arrayIndexesSchema.iterator(ptr, this.position, arrayIndexesBitSet);
            Boolean hasValue = arrayIndexesSchema.next(ptr, this.position, maxOffset, arrayIndexesBitSet);
            arrayIndexesBitSet.clear();
            if (hasValue == null) {
                ptr.set(ByteUtil.EMPTY_BYTE_ARRAY);
            }
            return true;
        }

        @Override
        public PDataType getDataType() {
            return this.type;
        }

        @Override
        public <T> T accept(ExpressionVisitor<T> visitor) {
            return null;
        }
    }
}

