/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.api.protocolrecords.impl.pb;

import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.yarn.api.records.NodeLabel;
import org.apache.hadoop.yarn.api.records.impl.pb.NodeLabelPBImpl;
import org.apache.hadoop.yarn.proto.YarnProtos;
import org.apache.hadoop.yarn.proto.YarnServerResourceManagerServiceProtos;
import org.apache.hadoop.yarn.server.api.protocolrecords.AddToClusterNodeLabelsRequest;

public class AddToClusterNodeLabelsRequestPBImpl
extends AddToClusterNodeLabelsRequest {
    YarnServerResourceManagerServiceProtos.AddToClusterNodeLabelsRequestProto proto = YarnServerResourceManagerServiceProtos.AddToClusterNodeLabelsRequestProto.getDefaultInstance();
    YarnServerResourceManagerServiceProtos.AddToClusterNodeLabelsRequestProto.Builder builder = null;
    private List<NodeLabel> updatedNodeLabels;
    boolean viaProto = false;

    public AddToClusterNodeLabelsRequestPBImpl() {
        this.builder = YarnServerResourceManagerServiceProtos.AddToClusterNodeLabelsRequestProto.newBuilder();
    }

    public AddToClusterNodeLabelsRequestPBImpl(YarnServerResourceManagerServiceProtos.AddToClusterNodeLabelsRequestProto proto) {
        this.proto = proto;
        this.viaProto = true;
    }

    public YarnServerResourceManagerServiceProtos.AddToClusterNodeLabelsRequestProto getProto() {
        this.mergeLocalToProto();
        this.proto = this.viaProto ? this.proto : this.builder.build();
        this.viaProto = true;
        return this.proto;
    }

    private void mergeLocalToProto() {
        if (this.viaProto) {
            this.maybeInitBuilder();
        }
        this.mergeLocalToBuilder();
        this.proto = this.builder.build();
        this.viaProto = true;
    }

    private void mergeLocalToBuilder() {
        if (this.updatedNodeLabels != null) {
            this.addNodeLabelsToProto();
        }
    }

    private void addNodeLabelsToProto() {
        this.maybeInitBuilder();
        this.builder.clearNodeLabels();
        ArrayList<YarnProtos.NodeLabelProto> protoList = new ArrayList<YarnProtos.NodeLabelProto>();
        for (NodeLabel r : this.updatedNodeLabels) {
            protoList.add(this.convertToProtoFormat(r));
        }
        this.builder.addAllNodeLabels(protoList);
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (other.getClass().isAssignableFrom(this.getClass())) {
            return this.getProto().equals(((AddToClusterNodeLabelsRequestPBImpl)this.getClass().cast(other)).getProto());
        }
        return false;
    }

    public int hashCode() {
        assert (false) : "hashCode not designed";
        return 0;
    }

    private void maybeInitBuilder() {
        if (this.viaProto || this.builder == null) {
            this.builder = YarnServerResourceManagerServiceProtos.AddToClusterNodeLabelsRequestProto.newBuilder(this.proto);
        }
        this.viaProto = false;
    }

    @Override
    public void setNodeLabels(List<NodeLabel> updatedNodeLabels) {
        this.maybeInitBuilder();
        this.updatedNodeLabels = new ArrayList<NodeLabel>();
        if (updatedNodeLabels == null) {
            this.builder.clearNodeLabels();
            return;
        }
        this.updatedNodeLabels.addAll(updatedNodeLabels);
    }

    private void initLocalNodeLabels() {
        YarnServerResourceManagerServiceProtos.AddToClusterNodeLabelsRequestProtoOrBuilder p = this.viaProto ? this.proto : this.builder;
        List<YarnProtos.NodeLabelProto> attributesProtoList = p.getNodeLabelsList();
        this.updatedNodeLabels = new ArrayList<NodeLabel>();
        for (YarnProtos.NodeLabelProto r : attributesProtoList) {
            this.updatedNodeLabels.add(this.convertFromProtoFormat(r));
        }
    }

    @Override
    public List<NodeLabel> getNodeLabels() {
        if (this.updatedNodeLabels != null) {
            return this.updatedNodeLabels;
        }
        this.initLocalNodeLabels();
        return this.updatedNodeLabels;
    }

    private NodeLabel convertFromProtoFormat(YarnProtos.NodeLabelProto p) {
        return new NodeLabelPBImpl(p);
    }

    private YarnProtos.NodeLabelProto convertToProtoFormat(NodeLabel t) {
        return ((NodeLabelPBImpl)t).getProto();
    }

    public String toString() {
        return this.getProto().toString();
    }
}

