/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.api.records.timeline;

import com.google.common.base.Splitter;
import java.util.Iterator;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.util.Records;

@InterfaceAudience.Public
@InterfaceStability.Unstable
public abstract class TimelineEntityGroupId
implements Comparable<TimelineEntityGroupId> {
    private static final Splitter _SPLITTER = Splitter.on('_').trimResults();
    @InterfaceAudience.Public
    @InterfaceStability.Unstable
    public static final String timelineEntityGroupIdStrPrefix = "timelineEntityGroupId";

    @InterfaceAudience.Public
    @InterfaceStability.Unstable
    public static TimelineEntityGroupId newInstance(ApplicationId applicationId, String id) {
        TimelineEntityGroupId timelineEntityGroupId = Records.newRecord(TimelineEntityGroupId.class);
        timelineEntityGroupId.setApplicationId(applicationId);
        timelineEntityGroupId.setTimelineEntityGroupId(id);
        timelineEntityGroupId.build();
        return timelineEntityGroupId;
    }

    @InterfaceAudience.Public
    @InterfaceStability.Stable
    public abstract ApplicationId getApplicationId();

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    protected abstract void setApplicationId(ApplicationId var1);

    @InterfaceAudience.Public
    @InterfaceStability.Stable
    public abstract String getTimelineEntityGroupId();

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    protected abstract void setTimelineEntityGroupId(String var1);

    public int hashCode() {
        int result = this.getTimelineEntityGroupId().hashCode();
        result = 31 * result + this.getApplicationId().hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TimelineEntityGroupId other = (TimelineEntityGroupId)obj;
        if (!this.getApplicationId().equals(other.getApplicationId())) {
            return false;
        }
        return this.getTimelineEntityGroupId().equals(other.getTimelineEntityGroupId());
    }

    @Override
    public int compareTo(TimelineEntityGroupId other) {
        int compareAppIds = this.getApplicationId().compareTo(other.getApplicationId());
        if (compareAppIds == 0) {
            return this.getTimelineEntityGroupId().compareTo(other.getTimelineEntityGroupId());
        }
        return compareAppIds;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("timelineEntityGroupId_");
        ApplicationId appId = this.getApplicationId();
        sb.append(appId.getClusterTimestamp()).append("_");
        sb.append(appId.getId()).append("_");
        sb.append(this.getTimelineEntityGroupId());
        return sb.toString();
    }

    public static TimelineEntityGroupId fromString(String timelineEntityGroupIdStr) {
        Iterator<String> it = _SPLITTER.split(timelineEntityGroupIdStr).iterator();
        if (!it.next().equals(timelineEntityGroupIdStrPrefix)) {
            throw new IllegalArgumentException("Invalid CacheId prefix: " + timelineEntityGroupIdStr);
        }
        ApplicationId appId = ApplicationId.newInstance(Long.parseLong(it.next()), Integer.parseInt(it.next()));
        String id = it.next();
        while (it.hasNext()) {
            id = id + "_" + it.next();
        }
        return TimelineEntityGroupId.newInstance(appId, id);
    }

    protected abstract void build();
}

