/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.registry.client.binding;

import com.google.common.base.Preconditions;
import java.net.IDN;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.fs.PathNotFoundException;
import org.apache.hadoop.registry.client.exceptions.InvalidPathnameException;
import org.apache.zookeeper.common.PathUtils;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public class RegistryPathUtils {
    private static final Pattern PATH_ENTRY_VALIDATION_PATTERN = Pattern.compile("([a-z0-9]|[a-z0-9][a-z0-9\\-]*[a-z0-9])");

    public static String validateZKPath(String path) throws InvalidPathnameException {
        try {
            PathUtils.validatePath(path);
        }
        catch (IllegalArgumentException e) {
            throw new InvalidPathnameException(path, "Invalid Path \"" + path + "\" : " + e, e);
        }
        return path;
    }

    public static String validateElementsAsDNS(String path) throws InvalidPathnameException {
        List<String> splitpath = RegistryPathUtils.split(path);
        for (String fragment : splitpath) {
            if (PATH_ENTRY_VALIDATION_PATTERN.matcher(fragment).matches()) continue;
            throw new InvalidPathnameException(path, "Invalid Path element \"" + fragment + "\"");
        }
        return path;
    }

    public static String createFullPath(String base, String path) throws InvalidPathnameException {
        Preconditions.checkArgument(path != null, "null path");
        Preconditions.checkArgument(base != null, "null path");
        return RegistryPathUtils.validateZKPath(RegistryPathUtils.join(base, path));
    }

    public static String join(String base, String path) {
        String finalpath;
        Preconditions.checkArgument(path != null, "null path");
        Preconditions.checkArgument(base != null, "null path");
        StringBuilder fullpath = new StringBuilder();
        if (!base.startsWith("/")) {
            fullpath.append('/');
        }
        fullpath.append(base);
        if (!fullpath.toString().endsWith("/")) {
            fullpath.append("/");
        }
        if (path.startsWith("/")) {
            if (path.length() > 1) {
                fullpath.append(path.substring(1));
            }
        } else {
            fullpath.append(path);
        }
        if ((finalpath = fullpath.toString()).endsWith("/") && !"/".equals(finalpath)) {
            finalpath = finalpath.substring(0, finalpath.length() - 1);
        }
        return finalpath;
    }

    public static List<String> split(String path) {
        String[] pathelements = path.split("/");
        ArrayList<String> dirs = new ArrayList<String>(pathelements.length);
        for (String pathelement : pathelements) {
            if (pathelement.isEmpty()) continue;
            dirs.add(pathelement);
        }
        return dirs;
    }

    public static String lastPathEntry(String path) {
        List<String> splits = RegistryPathUtils.split(path);
        if (splits.isEmpty()) {
            return "";
        }
        return splits.get(splits.size() - 1);
    }

    public static String parentOf(String path) throws PathNotFoundException {
        List<String> elements = RegistryPathUtils.split(path);
        int size = elements.size();
        if (size == 0) {
            throw new PathNotFoundException("No parent of " + path);
        }
        if (size == 1) {
            return "/";
        }
        elements.remove(size - 1);
        StringBuilder parent = new StringBuilder(path.length());
        for (String element : elements) {
            parent.append("/");
            parent.append(element);
        }
        return parent.toString();
    }

    public static String encodeForRegistry(String element) {
        return IDN.toASCII(element);
    }

    public static String encodeYarnID(String yarnId) {
        return yarnId.replace("_", "-");
    }
}

