/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.jobhistory;

import com.google.common.base.Joiner;
import java.util.Collections;
import org.apache.avro.util.Utf8;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.mapreduce.JobID;
import org.apache.hadoop.mapreduce.jobhistory.EventType;
import org.apache.hadoop.mapreduce.jobhistory.HistoryEvent;
import org.apache.hadoop.mapreduce.jobhistory.JobUnsuccessfulCompletion;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class JobUnsuccessfulCompletionEvent
implements HistoryEvent {
    private static final String NODIAGS = "";
    private static final Iterable<String> NODIAGS_LIST = Collections.singletonList("");
    private JobUnsuccessfulCompletion datum = new JobUnsuccessfulCompletion();

    public JobUnsuccessfulCompletionEvent(JobID id, long finishTime, int finishedMaps, int finishedReduces, String status) {
        this(id, finishTime, finishedMaps, finishedReduces, status, NODIAGS_LIST);
    }

    public JobUnsuccessfulCompletionEvent(JobID id, long finishTime, int finishedMaps, int finishedReduces, String status, Iterable<String> diagnostics) {
        this.datum.setJobid((CharSequence)new Utf8(id.toString()));
        this.datum.setFinishTime(finishTime);
        this.datum.setFinishedMaps(finishedMaps);
        this.datum.setFinishedReduces(finishedReduces);
        this.datum.setJobStatus((CharSequence)new Utf8(status));
        if (diagnostics == null) {
            diagnostics = NODIAGS_LIST;
        }
        this.datum.setDiagnostics((CharSequence)new Utf8(Joiner.on('\n').skipNulls().join(diagnostics)));
    }

    JobUnsuccessfulCompletionEvent() {
    }

    @Override
    public Object getDatum() {
        return this.datum;
    }

    @Override
    public void setDatum(Object datum) {
        this.datum = (JobUnsuccessfulCompletion)((Object)datum);
    }

    public JobID getJobId() {
        return JobID.forName(this.datum.jobid.toString());
    }

    public long getFinishTime() {
        return this.datum.getFinishTime();
    }

    public int getFinishedMaps() {
        return this.datum.getFinishedMaps();
    }

    public int getFinishedReduces() {
        return this.datum.getFinishedReduces();
    }

    public String getStatus() {
        return this.datum.getJobStatus().toString();
    }

    @Override
    public EventType getEventType() {
        if ("FAILED".equals(this.getStatus())) {
            return EventType.JOB_FAILED;
        }
        if ("ERROR".equals(this.getStatus())) {
            return EventType.JOB_ERROR;
        }
        return EventType.JOB_KILLED;
    }

    public String getDiagnostics() {
        CharSequence diagnostics = this.datum.getDiagnostics();
        return diagnostics == null ? NODIAGS : diagnostics.toString();
    }
}

