/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.concurrent.Delayed;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.JobStatus;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.DefaultHttpClient;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class JobEndNotifier {
    private static final Log LOG = LogFactory.getLog(JobEndNotifier.class.getName());

    private static JobEndStatusInfo createNotification(JobConf conf, JobStatus status) {
        JobEndStatusInfo notification = null;
        String uri = conf.getJobEndNotificationURI();
        if (uri != null) {
            int retryAttempts = conf.getInt("mapreduce.job.end-notification.retry.attempts", 0);
            long retryInterval = conf.getInt("mapreduce.job.end-notification.retry.interval", 30000);
            int timeout = conf.getInt("mapreduce.job.end-notification.timeout", 5000);
            if (uri.contains("$jobId")) {
                uri = uri.replace("$jobId", status.getJobID().toString());
            }
            if (uri.contains("$jobStatus")) {
                String statusStr = status.getRunState() == JobStatus.SUCCEEDED ? "SUCCEEDED" : (status.getRunState() == JobStatus.FAILED ? "FAILED" : "KILLED");
                uri = uri.replace("$jobStatus", statusStr);
            }
            notification = new JobEndStatusInfo(uri, retryAttempts, retryInterval, timeout);
        }
        return notification;
    }

    private static int httpNotification(String uri, int timeout) throws IOException, URISyntaxException {
        DefaultHttpClient client = new DefaultHttpClient();
        client.getParams().setIntParameter("http.socket.timeout", timeout).setLongParameter("http.conn-manager.timeout", (long)timeout);
        HttpGet httpGet = new HttpGet(new URI(uri));
        httpGet.setHeader("Accept", "*/*");
        return client.execute((HttpUriRequest)httpGet).getStatusLine().getStatusCode();
    }

    public static void localRunnerNotification(JobConf conf, JobStatus status) {
        JobEndStatusInfo notification = JobEndNotifier.createNotification(conf, status);
        if (notification != null) {
            do {
                try {
                    int code = JobEndNotifier.httpNotification(notification.getUri(), notification.getTimeout());
                    if (code != 200) {
                        throw new IOException("Invalid response status code: " + code);
                    }
                    break;
                }
                catch (IOException ioex) {
                    LOG.error("Notification error [" + notification.getUri() + "]", ioex);
                }
                catch (Exception ex) {
                    LOG.error("Notification error [" + notification.getUri() + "]", ex);
                }
                try {
                    Thread.sleep(notification.getRetryInterval());
                }
                catch (InterruptedException iex) {
                    LOG.error("Notification retry error [" + notification + "]", iex);
                }
            } while (notification.configureForRetry());
        }
    }

    private static class JobEndStatusInfo
    implements Delayed {
        private String uri;
        private int retryAttempts;
        private long retryInterval;
        private long delayTime;
        private int timeout;

        JobEndStatusInfo(String uri, int retryAttempts, long retryInterval, int timeout) {
            this.uri = uri;
            this.retryAttempts = retryAttempts;
            this.retryInterval = retryInterval;
            this.delayTime = System.currentTimeMillis();
            this.timeout = timeout;
        }

        public String getUri() {
            return this.uri;
        }

        public int getRetryAttempts() {
            return this.retryAttempts;
        }

        public long getRetryInterval() {
            return this.retryInterval;
        }

        public int getTimeout() {
            return this.timeout;
        }

        public boolean configureForRetry() {
            boolean retry = false;
            if (this.getRetryAttempts() > 0) {
                retry = true;
                this.delayTime = System.currentTimeMillis() + this.retryInterval;
            }
            --this.retryAttempts;
            return retry;
        }

        @Override
        public long getDelay(TimeUnit unit) {
            long n = this.delayTime - System.currentTimeMillis();
            return unit.convert(n, TimeUnit.MILLISECONDS);
        }

        @Override
        public int compareTo(Delayed d) {
            return (int)(this.delayTime - ((JobEndStatusInfo)d).delayTime);
        }

        public boolean equals(Object o) {
            if (!(o instanceof JobEndStatusInfo)) {
                return false;
            }
            return this.delayTime == ((JobEndStatusInfo)o).delayTime;
        }

        public int hashCode() {
            return 629 + (int)(this.delayTime ^ this.delayTime >>> 32);
        }

        public String toString() {
            return "URL: " + this.uri + " remaining retries: " + this.retryAttempts + " interval: " + this.retryInterval;
        }
    }
}

