/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.blockmanagement;

import java.beans.ConstructorProperties;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeDescriptor;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeStorageInfo;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public class StorageTypeStats {
    private long capacityTotal = 0L;
    private long capacityUsed = 0L;
    private long capacityRemaining = 0L;
    private long blockPoolUsed = 0L;
    private int nodesInService = 0;

    @ConstructorProperties(value={"capacityTotal", "capacityUsed", "capacityRemaining", "blockPoolUsed", "nodesInService"})
    public StorageTypeStats(long capacityTotal, long capacityUsed, long capacityRemaining, long blockPoolUsed, int nodesInService) {
        this.capacityTotal = capacityTotal;
        this.capacityUsed = capacityUsed;
        this.capacityRemaining = capacityRemaining;
        this.blockPoolUsed = blockPoolUsed;
        this.nodesInService = nodesInService;
    }

    public long getCapacityTotal() {
        return this.capacityTotal;
    }

    public long getCapacityUsed() {
        return this.capacityUsed;
    }

    public long getCapacityRemaining() {
        return this.capacityRemaining;
    }

    public long getBlockPoolUsed() {
        return this.blockPoolUsed;
    }

    public int getNodesInService() {
        return this.nodesInService;
    }

    StorageTypeStats() {
    }

    StorageTypeStats(StorageTypeStats other) {
        this.capacityTotal = other.capacityTotal;
        this.capacityUsed = other.capacityUsed;
        this.capacityRemaining = other.capacityRemaining;
        this.blockPoolUsed = other.blockPoolUsed;
        this.nodesInService = other.nodesInService;
    }

    void addStorage(DatanodeStorageInfo info, DatanodeDescriptor node) {
        this.capacityUsed += info.getDfsUsed();
        this.blockPoolUsed += info.getBlockPoolUsed();
        if (!node.isDecommissionInProgress() && !node.isDecommissioned()) {
            this.capacityTotal += info.getCapacity();
            this.capacityRemaining += info.getRemaining();
        } else {
            this.capacityTotal += info.getDfsUsed();
        }
    }

    void addNode(DatanodeDescriptor node) {
        if (!node.isDecommissionInProgress() && !node.isDecommissioned()) {
            ++this.nodesInService;
        }
    }

    void subtractStorage(DatanodeStorageInfo info, DatanodeDescriptor node) {
        this.capacityUsed -= info.getDfsUsed();
        this.blockPoolUsed -= info.getBlockPoolUsed();
        if (!node.isDecommissionInProgress() && !node.isDecommissioned()) {
            this.capacityTotal -= info.getCapacity();
            this.capacityRemaining -= info.getRemaining();
        } else {
            this.capacityTotal -= info.getDfsUsed();
        }
    }

    void subtractNode(DatanodeDescriptor node) {
        if (!node.isDecommissionInProgress() && !node.isDecommissioned()) {
            --this.nodesInService;
        }
    }
}

