/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.protocolPB;

import com.google.common.collect.Lists;
import com.google.protobuf.ByteString;
import com.google.protobuf.ServiceException;
import java.io.Closeable;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.crypto.CryptoProtocolVersion;
import org.apache.hadoop.fs.BatchedRemoteIterator;
import org.apache.hadoop.fs.CacheFlag;
import org.apache.hadoop.fs.ContentSummary;
import org.apache.hadoop.fs.CreateFlag;
import org.apache.hadoop.fs.FileAlreadyExistsException;
import org.apache.hadoop.fs.FsServerDefaults;
import org.apache.hadoop.fs.Options;
import org.apache.hadoop.fs.ParentNotDirectoryException;
import org.apache.hadoop.fs.StorageType;
import org.apache.hadoop.fs.UnresolvedLinkException;
import org.apache.hadoop.fs.XAttr;
import org.apache.hadoop.fs.XAttrSetFlag;
import org.apache.hadoop.fs.permission.AclEntry;
import org.apache.hadoop.fs.permission.AclStatus;
import org.apache.hadoop.fs.permission.FsAction;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hdfs.inotify.EventBatchList;
import org.apache.hadoop.hdfs.protocol.AlreadyBeingCreatedException;
import org.apache.hadoop.hdfs.protocol.BlockStoragePolicy;
import org.apache.hadoop.hdfs.protocol.CacheDirectiveEntry;
import org.apache.hadoop.hdfs.protocol.CacheDirectiveInfo;
import org.apache.hadoop.hdfs.protocol.CachePoolEntry;
import org.apache.hadoop.hdfs.protocol.CachePoolInfo;
import org.apache.hadoop.hdfs.protocol.ClientProtocol;
import org.apache.hadoop.hdfs.protocol.CorruptFileBlocks;
import org.apache.hadoop.hdfs.protocol.DSQuotaExceededException;
import org.apache.hadoop.hdfs.protocol.DatanodeID;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.hdfs.protocol.DirectoryListing;
import org.apache.hadoop.hdfs.protocol.EncryptionZone;
import org.apache.hadoop.hdfs.protocol.ExtendedBlock;
import org.apache.hadoop.hdfs.protocol.HdfsConstants;
import org.apache.hadoop.hdfs.protocol.HdfsFileStatus;
import org.apache.hadoop.hdfs.protocol.LastBlockWithStatus;
import org.apache.hadoop.hdfs.protocol.LocatedBlock;
import org.apache.hadoop.hdfs.protocol.LocatedBlocks;
import org.apache.hadoop.hdfs.protocol.NSQuotaExceededException;
import org.apache.hadoop.hdfs.protocol.RollingUpgradeInfo;
import org.apache.hadoop.hdfs.protocol.SnapshotDiffReport;
import org.apache.hadoop.hdfs.protocol.SnapshottableDirectoryStatus;
import org.apache.hadoop.hdfs.protocol.proto.AclProtos;
import org.apache.hadoop.hdfs.protocol.proto.ClientNamenodeProtocolProtos;
import org.apache.hadoop.hdfs.protocol.proto.EncryptionZonesProtos;
import org.apache.hadoop.hdfs.protocol.proto.XAttrProtos;
import org.apache.hadoop.hdfs.protocolPB.ClientNamenodeProtocolPB;
import org.apache.hadoop.hdfs.protocolPB.PBHelper;
import org.apache.hadoop.hdfs.security.token.block.DataEncryptionKey;
import org.apache.hadoop.hdfs.security.token.delegation.DelegationTokenIdentifier;
import org.apache.hadoop.hdfs.server.namenode.NotReplicatedYetException;
import org.apache.hadoop.hdfs.server.namenode.SafeModeException;
import org.apache.hadoop.hdfs.server.protocol.DatanodeStorageReport;
import org.apache.hadoop.io.EnumSetWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.ipc.ProtobufHelper;
import org.apache.hadoop.ipc.ProtocolMetaInterface;
import org.apache.hadoop.ipc.ProtocolTranslator;
import org.apache.hadoop.ipc.RPC;
import org.apache.hadoop.ipc.RpcClientUtil;
import org.apache.hadoop.security.AccessControlException;
import org.apache.hadoop.security.proto.SecurityProtos;
import org.apache.hadoop.security.token.Token;

@InterfaceAudience.Private
@InterfaceStability.Stable
public class ClientNamenodeProtocolTranslatorPB
implements ProtocolMetaInterface,
ClientProtocol,
Closeable,
ProtocolTranslator {
    private final ClientNamenodeProtocolPB rpcProxy;
    static final ClientNamenodeProtocolProtos.GetServerDefaultsRequestProto VOID_GET_SERVER_DEFAULT_REQUEST = ClientNamenodeProtocolProtos.GetServerDefaultsRequestProto.newBuilder().build();
    private static final ClientNamenodeProtocolProtos.GetFsStatusRequestProto VOID_GET_FSSTATUS_REQUEST = ClientNamenodeProtocolProtos.GetFsStatusRequestProto.newBuilder().build();
    private static final ClientNamenodeProtocolProtos.SaveNamespaceRequestProto VOID_SAVE_NAMESPACE_REQUEST = ClientNamenodeProtocolProtos.SaveNamespaceRequestProto.newBuilder().build();
    private static final ClientNamenodeProtocolProtos.RollEditsRequestProto VOID_ROLLEDITS_REQUEST = ClientNamenodeProtocolProtos.RollEditsRequestProto.getDefaultInstance();
    private static final ClientNamenodeProtocolProtos.RefreshNodesRequestProto VOID_REFRESH_NODES_REQUEST = ClientNamenodeProtocolProtos.RefreshNodesRequestProto.newBuilder().build();
    private static final ClientNamenodeProtocolProtos.FinalizeUpgradeRequestProto VOID_FINALIZE_UPGRADE_REQUEST = ClientNamenodeProtocolProtos.FinalizeUpgradeRequestProto.newBuilder().build();
    private static final ClientNamenodeProtocolProtos.GetDataEncryptionKeyRequestProto VOID_GET_DATA_ENCRYPTIONKEY_REQUEST = ClientNamenodeProtocolProtos.GetDataEncryptionKeyRequestProto.newBuilder().build();
    private static final ClientNamenodeProtocolProtos.GetStoragePoliciesRequestProto VOID_GET_STORAGE_POLICIES_REQUEST = ClientNamenodeProtocolProtos.GetStoragePoliciesRequestProto.newBuilder().build();

    public ClientNamenodeProtocolTranslatorPB(ClientNamenodeProtocolPB proxy) {
        this.rpcProxy = proxy;
    }

    @Override
    public void close() {
        RPC.stopProxy(this.rpcProxy);
    }

    @Override
    public LocatedBlocks getBlockLocations(String src, long offset, long length) throws AccessControlException, FileNotFoundException, UnresolvedLinkException, IOException {
        ClientNamenodeProtocolProtos.GetBlockLocationsRequestProto req = ClientNamenodeProtocolProtos.GetBlockLocationsRequestProto.newBuilder().setSrc(src).setOffset(offset).setLength(length).build();
        try {
            ClientNamenodeProtocolProtos.GetBlockLocationsResponseProto resp = this.rpcProxy.getBlockLocations(null, req);
            return resp.hasLocations() ? PBHelper.convert(resp.getLocations()) : null;
        }
        catch (ServiceException e) {
            throw ProtobufHelper.getRemoteException(e);
        }
    }

    @Override
    public FsServerDefaults getServerDefaults() throws IOException {
        ClientNamenodeProtocolProtos.GetServerDefaultsRequestProto req = VOID_GET_SERVER_DEFAULT_REQUEST;
        try {
            return PBHelper.convert(this.rpcProxy.getServerDefaults(null, req).getServerDefaults());
        }
        catch (ServiceException e) {
            throw ProtobufHelper.getRemoteException(e);
        }
    }

    @Override
    public HdfsFileStatus create(String src, FsPermission masked, String clientName, EnumSetWritable<CreateFlag> flag, boolean createParent, short replication, long blockSize, CryptoProtocolVersion[] supportedVersions) throws AccessControlException, AlreadyBeingCreatedException, DSQuotaExceededException, FileAlreadyExistsException, FileNotFoundException, NSQuotaExceededException, ParentNotDirectoryException, SafeModeException, UnresolvedLinkException, IOException {
        ClientNamenodeProtocolProtos.CreateRequestProto.Builder builder = ClientNamenodeProtocolProtos.CreateRequestProto.newBuilder().setSrc(src).setMasked(PBHelper.convert(masked)).setClientName(clientName).setCreateFlag(PBHelper.convertCreateFlag(flag)).setCreateParent(createParent).setReplication(replication).setBlockSize(blockSize);
        builder.addAllCryptoProtocolVersion(PBHelper.convert(supportedVersions));
        ClientNamenodeProtocolProtos.CreateRequestProto req = builder.build();
        try {
            ClientNamenodeProtocolProtos.CreateResponseProto res = this.rpcProxy.create(null, req);
            return res.hasFs() ? PBHelper.convert(res.getFs()) : null;
        }
        catch (ServiceException e) {
            throw ProtobufHelper.getRemoteException(e);
        }
    }

    @Override
    public boolean truncate(String src, long newLength, String clientName) throws IOException, UnresolvedLinkException {
        ClientNamenodeProtocolProtos.TruncateRequestProto req = ClientNamenodeProtocolProtos.TruncateRequestProto.newBuilder().setSrc(src).setNewLength(newLength).setClientName(clientName).build();
        try {
            return this.rpcProxy.truncate(null, req).getResult();
        }
        catch (ServiceException e) {
            throw ProtobufHelper.getRemoteException(e);
        }
    }

    @Override
    public LastBlockWithStatus append(String src, String clientName, EnumSetWritable<CreateFlag> flag) throws AccessControlException, DSQuotaExceededException, FileNotFoundException, SafeModeException, UnresolvedLinkException, IOException {
        ClientNamenodeProtocolProtos.AppendRequestProto req = ClientNamenodeProtocolProtos.AppendRequestProto.newBuilder().setSrc(src).setClientName(clientName).setFlag(PBHelper.convertCreateFlag(flag)).build();
        try {
            ClientNamenodeProtocolProtos.AppendResponseProto res = this.rpcProxy.append(null, req);
            LocatedBlock lastBlock = res.hasBlock() ? PBHelper.convert(res.getBlock()) : null;
            HdfsFileStatus stat = res.hasStat() ? PBHelper.convert(res.getStat()) : null;
            return new LastBlockWithStatus(lastBlock, stat);
        }
        catch (ServiceException e) {
            throw ProtobufHelper.getRemoteException(e);
        }
    }

    @Override
    public boolean setReplication(String src, short replication) throws AccessControlException, DSQuotaExceededException, FileNotFoundException, SafeModeException, UnresolvedLinkException, IOException {
        ClientNamenodeProtocolProtos.SetReplicationRequestProto req = ClientNamenodeProtocolProtos.SetReplicationRequestProto.newBuilder().setSrc(src).setReplication(replication).build();
        try {
            return this.rpcProxy.setReplication(null, req).getResult();
        }
        catch (ServiceException e) {
            throw ProtobufHelper.getRemoteException(e);
        }
    }

    @Override
    public void setPermission(String src, FsPermission permission) throws AccessControlException, FileNotFoundException, SafeModeException, UnresolvedLinkException, IOException {
        ClientNamenodeProtocolProtos.SetPermissionRequestProto req = ClientNamenodeProtocolProtos.SetPermissionRequestProto.newBuilder().setSrc(src).setPermission(PBHelper.convert(permission)).build();
        try {
            this.rpcProxy.setPermission(null, req);
        }
        catch (ServiceException e) {
            throw ProtobufHelper.getRemoteException(e);
        }
    }

    @Override
    public void setOwner(String src, String username, String groupname) throws AccessControlException, FileNotFoundException, SafeModeException, UnresolvedLinkException, IOException {
        ClientNamenodeProtocolProtos.SetOwnerRequestProto.Builder req = ClientNamenodeProtocolProtos.SetOwnerRequestProto.newBuilder().setSrc(src);
        if (username != null) {
            req.setUsername(username);
        }
        if (groupname != null) {
            req.setGroupname(groupname);
        }
        try {
            this.rpcProxy.setOwner(null, req.build());
        }
        catch (ServiceException e) {
            throw ProtobufHelper.getRemoteException(e);
        }
    }

    @Override
    public void abandonBlock(ExtendedBlock b, long fileId, String src, String holder) throws AccessControlException, FileNotFoundException, UnresolvedLinkException, IOException {
        ClientNamenodeProtocolProtos.AbandonBlockRequestProto req = ClientNamenodeProtocolProtos.AbandonBlockRequestProto.newBuilder().setB(PBHelper.convert(b)).setSrc(src).setHolder(holder).setFileId(fileId).build();
        try {
            this.rpcProxy.abandonBlock(null, req);
        }
        catch (ServiceException e) {
            throw ProtobufHelper.getRemoteException(e);
        }
    }

    @Override
    public LocatedBlock addBlock(String src, String clientName, ExtendedBlock previous, DatanodeInfo[] excludeNodes, long fileId, String[] favoredNodes) throws AccessControlException, FileNotFoundException, NotReplicatedYetException, SafeModeException, UnresolvedLinkException, IOException {
        ClientNamenodeProtocolProtos.AddBlockRequestProto.Builder req = ClientNamenodeProtocolProtos.AddBlockRequestProto.newBuilder().setSrc(src).setClientName(clientName).setFileId(fileId);
        if (previous != null) {
            req.setPrevious(PBHelper.convert(previous));
        }
        if (excludeNodes != null) {
            req.addAllExcludeNodes(PBHelper.convert(excludeNodes));
        }
        if (favoredNodes != null) {
            req.addAllFavoredNodes(Arrays.asList(favoredNodes));
        }
        try {
            return PBHelper.convert(this.rpcProxy.addBlock(null, req.build()).getBlock());
        }
        catch (ServiceException e) {
            throw ProtobufHelper.getRemoteException(e);
        }
    }

    @Override
    public LocatedBlock getAdditionalDatanode(String src, long fileId, ExtendedBlock blk, DatanodeInfo[] existings, String[] existingStorageIDs, DatanodeInfo[] excludes, int numAdditionalNodes, String clientName) throws AccessControlException, FileNotFoundException, SafeModeException, UnresolvedLinkException, IOException {
        ClientNamenodeProtocolProtos.GetAdditionalDatanodeRequestProto req = ClientNamenodeProtocolProtos.GetAdditionalDatanodeRequestProto.newBuilder().setSrc(src).setFileId(fileId).setBlk(PBHelper.convert(blk)).addAllExistings(PBHelper.convert(existings)).addAllExistingStorageUuids(Arrays.asList(existingStorageIDs)).addAllExcludes(PBHelper.convert(excludes)).setNumAdditionalNodes(numAdditionalNodes).setClientName(clientName).build();
        try {
            return PBHelper.convert(this.rpcProxy.getAdditionalDatanode(null, req).getBlock());
        }
        catch (ServiceException e) {
            throw ProtobufHelper.getRemoteException(e);
        }
    }

    @Override
    public boolean complete(String src, String clientName, ExtendedBlock last, long fileId) throws AccessControlException, FileNotFoundException, SafeModeException, UnresolvedLinkException, IOException {
        ClientNamenodeProtocolProtos.CompleteRequestProto.Builder req = ClientNamenodeProtocolProtos.CompleteRequestProto.newBuilder().setSrc(src).setClientName(clientName).setFileId(fileId);
        if (last != null) {
            req.setLast(PBHelper.convert(last));
        }
        try {
            return this.rpcProxy.complete(null, req.build()).getResult();
        }
        catch (ServiceException e) {
            throw ProtobufHelper.getRemoteException(e);
        }
    }

    @Override
    public void reportBadBlocks(LocatedBlock[] blocks) throws IOException {
        ClientNamenodeProtocolProtos.ReportBadBlocksRequestProto req = ClientNamenodeProtocolProtos.ReportBadBlocksRequestProto.newBuilder().addAllBlocks(Arrays.asList(PBHelper.convertLocatedBlock(blocks))).build();
        try {
            this.rpcProxy.reportBadBlocks(null, req);
        }
        catch (ServiceException e) {
            throw ProtobufHelper.getRemoteException(e);
        }
    }

    @Override
    public boolean rename(String src, String dst) throws UnresolvedLinkException, IOException {
        ClientNamenodeProtocolProtos.RenameRequestProto req = ClientNamenodeProtocolProtos.RenameRequestProto.newBuilder().setSrc(src).setDst(dst).build();
        try {
            return this.rpcProxy.rename(null, req).getResult();
        }
        catch (ServiceException e) {
            throw ProtobufHelper.getRemoteException(e);
        }
    }

    @Override
    public void rename2(String src, String dst, Options.Rename ... options) throws AccessControlException, DSQuotaExceededException, FileAlreadyExistsException, FileNotFoundException, NSQuotaExceededException, ParentNotDirectoryException, SafeModeException, UnresolvedLinkException, IOException {
        boolean overwrite = false;
        if (options != null) {
            for (Options.Rename option : options) {
                if (option != Options.Rename.OVERWRITE) continue;
                overwrite = true;
            }
        }
        ClientNamenodeProtocolProtos.Rename2RequestProto req = ClientNamenodeProtocolProtos.Rename2RequestProto.newBuilder().setSrc(src).setDst(dst).setOverwriteDest(overwrite).build();
        try {
            this.rpcProxy.rename2(null, req);
        }
        catch (ServiceException e) {
            throw ProtobufHelper.getRemoteException(e);
        }
    }

    @Override
    public void concat(String trg, String[] srcs) throws IOException, UnresolvedLinkException {
        ClientNamenodeProtocolProtos.ConcatRequestProto req = ClientNamenodeProtocolProtos.ConcatRequestProto.newBuilder().setTrg(trg).addAllSrcs(Arrays.asList(srcs)).build();
        try {
            this.rpcProxy.concat(null, req);
        }
        catch (ServiceException e) {
            throw ProtobufHelper.getRemoteException(e);
        }
    }

    @Override
    public boolean delete(String src, boolean recursive) throws AccessControlException, FileNotFoundException, SafeModeException, UnresolvedLinkException, IOException {
        ClientNamenodeProtocolProtos.DeleteRequestProto req = ClientNamenodeProtocolProtos.DeleteRequestProto.newBuilder().setSrc(src).setRecursive(recursive).build();
        try {
            return this.rpcProxy.delete(null, req).getResult();
        }
        catch (ServiceException e) {
            throw ProtobufHelper.getRemoteException(e);
        }
    }

    @Override
    public boolean mkdirs(String src, FsPermission masked, boolean createParent) throws AccessControlException, FileAlreadyExistsException, FileNotFoundException, NSQuotaExceededException, ParentNotDirectoryException, SafeModeException, UnresolvedLinkException, IOException {
        ClientNamenodeProtocolProtos.MkdirsRequestProto req = ClientNamenodeProtocolProtos.MkdirsRequestProto.newBuilder().setSrc(src).setMasked(PBHelper.convert(masked)).setCreateParent(createParent).build();
        try {
            return this.rpcProxy.mkdirs(null, req).getResult();
        }
        catch (ServiceException e) {
            throw ProtobufHelper.getRemoteException(e);
        }
    }

    @Override
    public DirectoryListing getListing(String src, byte[] startAfter, boolean needLocation) throws AccessControlException, FileNotFoundException, UnresolvedLinkException, IOException {
        ClientNamenodeProtocolProtos.GetListingRequestProto req = ClientNamenodeProtocolProtos.GetListingRequestProto.newBuilder().setSrc(src).setStartAfter(ByteString.copyFrom(startAfter)).setNeedLocation(needLocation).build();
        try {
            ClientNamenodeProtocolProtos.GetListingResponseProto result = this.rpcProxy.getListing(null, req);
            if (result.hasDirList()) {
                return PBHelper.convert(result.getDirList());
            }
            return null;
        }
        catch (ServiceException e) {
            throw ProtobufHelper.getRemoteException(e);
        }
    }

    @Override
    public void renewLease(String clientName) throws AccessControlException, IOException {
        ClientNamenodeProtocolProtos.RenewLeaseRequestProto req = ClientNamenodeProtocolProtos.RenewLeaseRequestProto.newBuilder().setClientName(clientName).build();
        try {
            this.rpcProxy.renewLease(null, req);
        }
        catch (ServiceException e) {
            throw ProtobufHelper.getRemoteException(e);
        }
    }

    @Override
    public boolean recoverLease(String src, String clientName) throws IOException {
        ClientNamenodeProtocolProtos.RecoverLeaseRequestProto req = ClientNamenodeProtocolProtos.RecoverLeaseRequestProto.newBuilder().setSrc(src).setClientName(clientName).build();
        try {
            return this.rpcProxy.recoverLease(null, req).getResult();
        }
        catch (ServiceException e) {
            throw ProtobufHelper.getRemoteException(e);
        }
    }

    @Override
    public long[] getStats() throws IOException {
        try {
            return PBHelper.convert(this.rpcProxy.getFsStats(null, VOID_GET_FSSTATUS_REQUEST));
        }
        catch (ServiceException e) {
            throw ProtobufHelper.getRemoteException(e);
        }
    }

    @Override
    public DatanodeInfo[] getDatanodeReport(HdfsConstants.DatanodeReportType type) throws IOException {
        ClientNamenodeProtocolProtos.GetDatanodeReportRequestProto req = ClientNamenodeProtocolProtos.GetDatanodeReportRequestProto.newBuilder().setType(PBHelper.convert(type)).build();
        try {
            return PBHelper.convert(this.rpcProxy.getDatanodeReport(null, req).getDiList());
        }
        catch (ServiceException e) {
            throw ProtobufHelper.getRemoteException(e);
        }
    }

    @Override
    public DatanodeStorageReport[] getDatanodeStorageReport(HdfsConstants.DatanodeReportType type) throws IOException {
        ClientNamenodeProtocolProtos.GetDatanodeStorageReportRequestProto req = ClientNamenodeProtocolProtos.GetDatanodeStorageReportRequestProto.newBuilder().setType(PBHelper.convert(type)).build();
        try {
            return PBHelper.convertDatanodeStorageReports(this.rpcProxy.getDatanodeStorageReport(null, req).getDatanodeStorageReportsList());
        }
        catch (ServiceException e) {
            throw ProtobufHelper.getRemoteException(e);
        }
    }

    @Override
    public long getPreferredBlockSize(String filename) throws IOException, UnresolvedLinkException {
        ClientNamenodeProtocolProtos.GetPreferredBlockSizeRequestProto req = ClientNamenodeProtocolProtos.GetPreferredBlockSizeRequestProto.newBuilder().setFilename(filename).build();
        try {
            return this.rpcProxy.getPreferredBlockSize(null, req).getBsize();
        }
        catch (ServiceException e) {
            throw ProtobufHelper.getRemoteException(e);
        }
    }

    @Override
    public boolean setSafeMode(HdfsConstants.SafeModeAction action, boolean isChecked) throws IOException {
        ClientNamenodeProtocolProtos.SetSafeModeRequestProto req = ClientNamenodeProtocolProtos.SetSafeModeRequestProto.newBuilder().setAction(PBHelper.convert(action)).setChecked(isChecked).build();
        try {
            return this.rpcProxy.setSafeMode(null, req).getResult();
        }
        catch (ServiceException e) {
            throw ProtobufHelper.getRemoteException(e);
        }
    }

    @Override
    public void saveNamespace() throws AccessControlException, IOException {
        try {
            this.rpcProxy.saveNamespace(null, VOID_SAVE_NAMESPACE_REQUEST);
        }
        catch (ServiceException e) {
            throw ProtobufHelper.getRemoteException(e);
        }
    }

    @Override
    public long rollEdits() throws AccessControlException, IOException {
        try {
            ClientNamenodeProtocolProtos.RollEditsResponseProto resp = this.rpcProxy.rollEdits(null, VOID_ROLLEDITS_REQUEST);
            return resp.getNewSegmentTxId();
        }
        catch (ServiceException se) {
            throw ProtobufHelper.getRemoteException(se);
        }
    }

    @Override
    public boolean restoreFailedStorage(String arg) throws AccessControlException, IOException {
        ClientNamenodeProtocolProtos.RestoreFailedStorageRequestProto req = ClientNamenodeProtocolProtos.RestoreFailedStorageRequestProto.newBuilder().setArg(arg).build();
        try {
            return this.rpcProxy.restoreFailedStorage(null, req).getResult();
        }
        catch (ServiceException e) {
            throw ProtobufHelper.getRemoteException(e);
        }
    }

    @Override
    public void refreshNodes() throws IOException {
        try {
            this.rpcProxy.refreshNodes(null, VOID_REFRESH_NODES_REQUEST);
        }
        catch (ServiceException e) {
            throw ProtobufHelper.getRemoteException(e);
        }
    }

    @Override
    public void finalizeUpgrade() throws IOException {
        try {
            this.rpcProxy.finalizeUpgrade(null, VOID_FINALIZE_UPGRADE_REQUEST);
        }
        catch (ServiceException e) {
            throw ProtobufHelper.getRemoteException(e);
        }
    }

    @Override
    public RollingUpgradeInfo rollingUpgrade(HdfsConstants.RollingUpgradeAction action) throws IOException {
        ClientNamenodeProtocolProtos.RollingUpgradeRequestProto r = ClientNamenodeProtocolProtos.RollingUpgradeRequestProto.newBuilder().setAction(PBHelper.convert(action)).build();
        try {
            ClientNamenodeProtocolProtos.RollingUpgradeResponseProto proto = this.rpcProxy.rollingUpgrade(null, r);
            if (proto.hasRollingUpgradeInfo()) {
                return PBHelper.convert(proto.getRollingUpgradeInfo());
            }
            return null;
        }
        catch (ServiceException e) {
            throw ProtobufHelper.getRemoteException(e);
        }
    }

    @Override
    public CorruptFileBlocks listCorruptFileBlocks(String path, String cookie) throws IOException {
        ClientNamenodeProtocolProtos.ListCorruptFileBlocksRequestProto.Builder req = ClientNamenodeProtocolProtos.ListCorruptFileBlocksRequestProto.newBuilder().setPath(path);
        if (cookie != null) {
            req.setCookie(cookie);
        }
        try {
            return PBHelper.convert(this.rpcProxy.listCorruptFileBlocks(null, req.build()).getCorrupt());
        }
        catch (ServiceException e) {
            throw ProtobufHelper.getRemoteException(e);
        }
    }

    @Override
    public void metaSave(String filename) throws IOException {
        ClientNamenodeProtocolProtos.MetaSaveRequestProto req = ClientNamenodeProtocolProtos.MetaSaveRequestProto.newBuilder().setFilename(filename).build();
        try {
            this.rpcProxy.metaSave(null, req);
        }
        catch (ServiceException e) {
            throw ProtobufHelper.getRemoteException(e);
        }
    }

    @Override
    public HdfsFileStatus getFileInfo(String src) throws AccessControlException, FileNotFoundException, UnresolvedLinkException, IOException {
        ClientNamenodeProtocolProtos.GetFileInfoRequestProto req = ClientNamenodeProtocolProtos.GetFileInfoRequestProto.newBuilder().setSrc(src).build();
        try {
            ClientNamenodeProtocolProtos.GetFileInfoResponseProto res = this.rpcProxy.getFileInfo(null, req);
            return res.hasFs() ? PBHelper.convert(res.getFs()) : null;
        }
        catch (ServiceException e) {
            throw ProtobufHelper.getRemoteException(e);
        }
    }

    @Override
    public HdfsFileStatus getFileLinkInfo(String src) throws AccessControlException, UnresolvedLinkException, IOException {
        ClientNamenodeProtocolProtos.GetFileLinkInfoRequestProto req = ClientNamenodeProtocolProtos.GetFileLinkInfoRequestProto.newBuilder().setSrc(src).build();
        try {
            ClientNamenodeProtocolProtos.GetFileLinkInfoResponseProto result = this.rpcProxy.getFileLinkInfo(null, req);
            return result.hasFs() ? PBHelper.convert(this.rpcProxy.getFileLinkInfo(null, req).getFs()) : null;
        }
        catch (ServiceException e) {
            throw ProtobufHelper.getRemoteException(e);
        }
    }

    @Override
    public ContentSummary getContentSummary(String path) throws AccessControlException, FileNotFoundException, UnresolvedLinkException, IOException {
        ClientNamenodeProtocolProtos.GetContentSummaryRequestProto req = ClientNamenodeProtocolProtos.GetContentSummaryRequestProto.newBuilder().setPath(path).build();
        try {
            return PBHelper.convert(this.rpcProxy.getContentSummary(null, req).getSummary());
        }
        catch (ServiceException e) {
            throw ProtobufHelper.getRemoteException(e);
        }
    }

    @Override
    public void setQuota(String path, long namespaceQuota, long storagespaceQuota, StorageType type) throws AccessControlException, FileNotFoundException, UnresolvedLinkException, IOException {
        ClientNamenodeProtocolProtos.SetQuotaRequestProto.Builder builder = ClientNamenodeProtocolProtos.SetQuotaRequestProto.newBuilder().setPath(path).setNamespaceQuota(namespaceQuota).setStoragespaceQuota(storagespaceQuota);
        if (type != null) {
            builder.setStorageType(PBHelper.convertStorageType(type));
        }
        ClientNamenodeProtocolProtos.SetQuotaRequestProto req = builder.build();
        try {
            this.rpcProxy.setQuota(null, req);
        }
        catch (ServiceException e) {
            throw ProtobufHelper.getRemoteException(e);
        }
    }

    @Override
    public void fsync(String src, long fileId, String client, long lastBlockLength) throws AccessControlException, FileNotFoundException, UnresolvedLinkException, IOException {
        ClientNamenodeProtocolProtos.FsyncRequestProto req = ClientNamenodeProtocolProtos.FsyncRequestProto.newBuilder().setSrc(src).setClient(client).setLastBlockLength(lastBlockLength).setFileId(fileId).build();
        try {
            this.rpcProxy.fsync(null, req);
        }
        catch (ServiceException e) {
            throw ProtobufHelper.getRemoteException(e);
        }
    }

    @Override
    public void setTimes(String src, long mtime, long atime) throws AccessControlException, FileNotFoundException, UnresolvedLinkException, IOException {
        ClientNamenodeProtocolProtos.SetTimesRequestProto req = ClientNamenodeProtocolProtos.SetTimesRequestProto.newBuilder().setSrc(src).setMtime(mtime).setAtime(atime).build();
        try {
            this.rpcProxy.setTimes(null, req);
        }
        catch (ServiceException e) {
            throw ProtobufHelper.getRemoteException(e);
        }
    }

    @Override
    public void createSymlink(String target, String link, FsPermission dirPerm, boolean createParent) throws AccessControlException, FileAlreadyExistsException, FileNotFoundException, ParentNotDirectoryException, SafeModeException, UnresolvedLinkException, IOException {
        ClientNamenodeProtocolProtos.CreateSymlinkRequestProto req = ClientNamenodeProtocolProtos.CreateSymlinkRequestProto.newBuilder().setTarget(target).setLink(link).setDirPerm(PBHelper.convert(dirPerm)).setCreateParent(createParent).build();
        try {
            this.rpcProxy.createSymlink(null, req);
        }
        catch (ServiceException e) {
            throw ProtobufHelper.getRemoteException(e);
        }
    }

    @Override
    public String getLinkTarget(String path) throws AccessControlException, FileNotFoundException, IOException {
        ClientNamenodeProtocolProtos.GetLinkTargetRequestProto req = ClientNamenodeProtocolProtos.GetLinkTargetRequestProto.newBuilder().setPath(path).build();
        try {
            ClientNamenodeProtocolProtos.GetLinkTargetResponseProto rsp = this.rpcProxy.getLinkTarget(null, req);
            return rsp.hasTargetPath() ? rsp.getTargetPath() : null;
        }
        catch (ServiceException e) {
            throw ProtobufHelper.getRemoteException(e);
        }
    }

    @Override
    public LocatedBlock updateBlockForPipeline(ExtendedBlock block, String clientName) throws IOException {
        ClientNamenodeProtocolProtos.UpdateBlockForPipelineRequestProto req = ClientNamenodeProtocolProtos.UpdateBlockForPipelineRequestProto.newBuilder().setBlock(PBHelper.convert(block)).setClientName(clientName).build();
        try {
            return PBHelper.convert(this.rpcProxy.updateBlockForPipeline(null, req).getBlock());
        }
        catch (ServiceException e) {
            throw ProtobufHelper.getRemoteException(e);
        }
    }

    @Override
    public void updatePipeline(String clientName, ExtendedBlock oldBlock, ExtendedBlock newBlock, DatanodeID[] newNodes, String[] storageIDs) throws IOException {
        ClientNamenodeProtocolProtos.UpdatePipelineRequestProto req = ClientNamenodeProtocolProtos.UpdatePipelineRequestProto.newBuilder().setClientName(clientName).setOldBlock(PBHelper.convert(oldBlock)).setNewBlock(PBHelper.convert(newBlock)).addAllNewNodes(Arrays.asList(PBHelper.convert(newNodes))).addAllStorageIDs(storageIDs == null ? null : Arrays.asList(storageIDs)).build();
        try {
            this.rpcProxy.updatePipeline(null, req);
        }
        catch (ServiceException e) {
            throw ProtobufHelper.getRemoteException(e);
        }
    }

    @Override
    public Token<DelegationTokenIdentifier> getDelegationToken(Text renewer) throws IOException {
        SecurityProtos.GetDelegationTokenRequestProto req = SecurityProtos.GetDelegationTokenRequestProto.newBuilder().setRenewer(renewer.toString()).build();
        try {
            SecurityProtos.GetDelegationTokenResponseProto resp = this.rpcProxy.getDelegationToken(null, req);
            return resp.hasToken() ? PBHelper.convertDelegationToken(resp.getToken()) : null;
        }
        catch (ServiceException e) {
            throw ProtobufHelper.getRemoteException(e);
        }
    }

    @Override
    public long renewDelegationToken(Token<DelegationTokenIdentifier> token) throws IOException {
        SecurityProtos.RenewDelegationTokenRequestProto req = SecurityProtos.RenewDelegationTokenRequestProto.newBuilder().setToken(PBHelper.convert(token)).build();
        try {
            return this.rpcProxy.renewDelegationToken(null, req).getNewExpiryTime();
        }
        catch (ServiceException e) {
            throw ProtobufHelper.getRemoteException(e);
        }
    }

    @Override
    public void cancelDelegationToken(Token<DelegationTokenIdentifier> token) throws IOException {
        SecurityProtos.CancelDelegationTokenRequestProto req = SecurityProtos.CancelDelegationTokenRequestProto.newBuilder().setToken(PBHelper.convert(token)).build();
        try {
            this.rpcProxy.cancelDelegationToken(null, req);
        }
        catch (ServiceException e) {
            throw ProtobufHelper.getRemoteException(e);
        }
    }

    @Override
    public void setBalancerBandwidth(long bandwidth) throws IOException {
        ClientNamenodeProtocolProtos.SetBalancerBandwidthRequestProto req = ClientNamenodeProtocolProtos.SetBalancerBandwidthRequestProto.newBuilder().setBandwidth(bandwidth).build();
        try {
            this.rpcProxy.setBalancerBandwidth(null, req);
        }
        catch (ServiceException e) {
            throw ProtobufHelper.getRemoteException(e);
        }
    }

    @Override
    public boolean isMethodSupported(String methodName) throws IOException {
        return RpcClientUtil.isMethodSupported(this.rpcProxy, ClientNamenodeProtocolPB.class, RPC.RpcKind.RPC_PROTOCOL_BUFFER, RPC.getProtocolVersion(ClientNamenodeProtocolPB.class), methodName);
    }

    @Override
    public DataEncryptionKey getDataEncryptionKey() throws IOException {
        try {
            ClientNamenodeProtocolProtos.GetDataEncryptionKeyResponseProto rsp = this.rpcProxy.getDataEncryptionKey(null, VOID_GET_DATA_ENCRYPTIONKEY_REQUEST);
            return rsp.hasDataEncryptionKey() ? PBHelper.convert(rsp.getDataEncryptionKey()) : null;
        }
        catch (ServiceException e) {
            throw ProtobufHelper.getRemoteException(e);
        }
    }

    @Override
    public boolean isFileClosed(String src) throws AccessControlException, FileNotFoundException, UnresolvedLinkException, IOException {
        ClientNamenodeProtocolProtos.IsFileClosedRequestProto req = ClientNamenodeProtocolProtos.IsFileClosedRequestProto.newBuilder().setSrc(src).build();
        try {
            return this.rpcProxy.isFileClosed(null, req).getResult();
        }
        catch (ServiceException e) {
            throw ProtobufHelper.getRemoteException(e);
        }
    }

    @Override
    public Object getUnderlyingProxyObject() {
        return this.rpcProxy;
    }

    @Override
    public String createSnapshot(String snapshotRoot, String snapshotName) throws IOException {
        ClientNamenodeProtocolProtos.CreateSnapshotRequestProto.Builder builder = ClientNamenodeProtocolProtos.CreateSnapshotRequestProto.newBuilder().setSnapshotRoot(snapshotRoot);
        if (snapshotName != null) {
            builder.setSnapshotName(snapshotName);
        }
        ClientNamenodeProtocolProtos.CreateSnapshotRequestProto req = builder.build();
        try {
            return this.rpcProxy.createSnapshot(null, req).getSnapshotPath();
        }
        catch (ServiceException e) {
            throw ProtobufHelper.getRemoteException(e);
        }
    }

    @Override
    public void deleteSnapshot(String snapshotRoot, String snapshotName) throws IOException {
        ClientNamenodeProtocolProtos.DeleteSnapshotRequestProto req = ClientNamenodeProtocolProtos.DeleteSnapshotRequestProto.newBuilder().setSnapshotRoot(snapshotRoot).setSnapshotName(snapshotName).build();
        try {
            this.rpcProxy.deleteSnapshot(null, req);
        }
        catch (ServiceException e) {
            throw ProtobufHelper.getRemoteException(e);
        }
    }

    @Override
    public void allowSnapshot(String snapshotRoot) throws IOException {
        ClientNamenodeProtocolProtos.AllowSnapshotRequestProto req = ClientNamenodeProtocolProtos.AllowSnapshotRequestProto.newBuilder().setSnapshotRoot(snapshotRoot).build();
        try {
            this.rpcProxy.allowSnapshot(null, req);
        }
        catch (ServiceException e) {
            throw ProtobufHelper.getRemoteException(e);
        }
    }

    @Override
    public void disallowSnapshot(String snapshotRoot) throws IOException {
        ClientNamenodeProtocolProtos.DisallowSnapshotRequestProto req = ClientNamenodeProtocolProtos.DisallowSnapshotRequestProto.newBuilder().setSnapshotRoot(snapshotRoot).build();
        try {
            this.rpcProxy.disallowSnapshot(null, req);
        }
        catch (ServiceException e) {
            throw ProtobufHelper.getRemoteException(e);
        }
    }

    @Override
    public void renameSnapshot(String snapshotRoot, String snapshotOldName, String snapshotNewName) throws IOException {
        ClientNamenodeProtocolProtos.RenameSnapshotRequestProto req = ClientNamenodeProtocolProtos.RenameSnapshotRequestProto.newBuilder().setSnapshotRoot(snapshotRoot).setSnapshotOldName(snapshotOldName).setSnapshotNewName(snapshotNewName).build();
        try {
            this.rpcProxy.renameSnapshot(null, req);
        }
        catch (ServiceException e) {
            throw ProtobufHelper.getRemoteException(e);
        }
    }

    @Override
    public SnapshottableDirectoryStatus[] getSnapshottableDirListing() throws IOException {
        ClientNamenodeProtocolProtos.GetSnapshottableDirListingRequestProto req = ClientNamenodeProtocolProtos.GetSnapshottableDirListingRequestProto.newBuilder().build();
        try {
            ClientNamenodeProtocolProtos.GetSnapshottableDirListingResponseProto result = this.rpcProxy.getSnapshottableDirListing(null, req);
            if (result.hasSnapshottableDirList()) {
                return PBHelper.convert(result.getSnapshottableDirList());
            }
            return null;
        }
        catch (ServiceException e) {
            throw ProtobufHelper.getRemoteException(e);
        }
    }

    @Override
    public SnapshotDiffReport getSnapshotDiffReport(String snapshotRoot, String fromSnapshot, String toSnapshot) throws IOException {
        ClientNamenodeProtocolProtos.GetSnapshotDiffReportRequestProto req = ClientNamenodeProtocolProtos.GetSnapshotDiffReportRequestProto.newBuilder().setSnapshotRoot(snapshotRoot).setFromSnapshot(fromSnapshot).setToSnapshot(toSnapshot).build();
        try {
            ClientNamenodeProtocolProtos.GetSnapshotDiffReportResponseProto result = this.rpcProxy.getSnapshotDiffReport(null, req);
            return PBHelper.convert(result.getDiffReport());
        }
        catch (ServiceException e) {
            throw ProtobufHelper.getRemoteException(e);
        }
    }

    @Override
    public long addCacheDirective(CacheDirectiveInfo directive, EnumSet<CacheFlag> flags) throws IOException {
        try {
            ClientNamenodeProtocolProtos.AddCacheDirectiveRequestProto.Builder builder = ClientNamenodeProtocolProtos.AddCacheDirectiveRequestProto.newBuilder().setInfo(PBHelper.convert(directive));
            if (!flags.isEmpty()) {
                builder.setCacheFlags(PBHelper.convertCacheFlags(flags));
            }
            return this.rpcProxy.addCacheDirective(null, builder.build()).getId();
        }
        catch (ServiceException e) {
            throw ProtobufHelper.getRemoteException(e);
        }
    }

    @Override
    public void modifyCacheDirective(CacheDirectiveInfo directive, EnumSet<CacheFlag> flags) throws IOException {
        try {
            ClientNamenodeProtocolProtos.ModifyCacheDirectiveRequestProto.Builder builder = ClientNamenodeProtocolProtos.ModifyCacheDirectiveRequestProto.newBuilder().setInfo(PBHelper.convert(directive));
            if (!flags.isEmpty()) {
                builder.setCacheFlags(PBHelper.convertCacheFlags(flags));
            }
            this.rpcProxy.modifyCacheDirective(null, builder.build());
        }
        catch (ServiceException e) {
            throw ProtobufHelper.getRemoteException(e);
        }
    }

    @Override
    public void removeCacheDirective(long id) throws IOException {
        try {
            this.rpcProxy.removeCacheDirective(null, ClientNamenodeProtocolProtos.RemoveCacheDirectiveRequestProto.newBuilder().setId(id).build());
        }
        catch (ServiceException e) {
            throw ProtobufHelper.getRemoteException(e);
        }
    }

    @Override
    public BatchedRemoteIterator.BatchedEntries<CacheDirectiveEntry> listCacheDirectives(long prevId, CacheDirectiveInfo filter) throws IOException {
        if (filter == null) {
            filter = new CacheDirectiveInfo.Builder().build();
        }
        try {
            return new BatchedCacheEntries(this.rpcProxy.listCacheDirectives(null, ClientNamenodeProtocolProtos.ListCacheDirectivesRequestProto.newBuilder().setPrevId(prevId).setFilter(PBHelper.convert(filter)).build()));
        }
        catch (ServiceException e) {
            throw ProtobufHelper.getRemoteException(e);
        }
    }

    @Override
    public void addCachePool(CachePoolInfo info) throws IOException {
        ClientNamenodeProtocolProtos.AddCachePoolRequestProto.Builder builder = ClientNamenodeProtocolProtos.AddCachePoolRequestProto.newBuilder();
        builder.setInfo(PBHelper.convert(info));
        try {
            this.rpcProxy.addCachePool(null, builder.build());
        }
        catch (ServiceException e) {
            throw ProtobufHelper.getRemoteException(e);
        }
    }

    @Override
    public void modifyCachePool(CachePoolInfo req) throws IOException {
        ClientNamenodeProtocolProtos.ModifyCachePoolRequestProto.Builder builder = ClientNamenodeProtocolProtos.ModifyCachePoolRequestProto.newBuilder();
        builder.setInfo(PBHelper.convert(req));
        try {
            this.rpcProxy.modifyCachePool(null, builder.build());
        }
        catch (ServiceException e) {
            throw ProtobufHelper.getRemoteException(e);
        }
    }

    @Override
    public void removeCachePool(String cachePoolName) throws IOException {
        try {
            this.rpcProxy.removeCachePool(null, ClientNamenodeProtocolProtos.RemoveCachePoolRequestProto.newBuilder().setPoolName(cachePoolName).build());
        }
        catch (ServiceException e) {
            throw ProtobufHelper.getRemoteException(e);
        }
    }

    @Override
    public BatchedRemoteIterator.BatchedEntries<CachePoolEntry> listCachePools(String prevKey) throws IOException {
        try {
            return new BatchedCachePoolEntries(this.rpcProxy.listCachePools(null, ClientNamenodeProtocolProtos.ListCachePoolsRequestProto.newBuilder().setPrevPoolName(prevKey).build()));
        }
        catch (ServiceException e) {
            throw ProtobufHelper.getRemoteException(e);
        }
    }

    @Override
    public void modifyAclEntries(String src, List<AclEntry> aclSpec) throws IOException {
        AclProtos.ModifyAclEntriesRequestProto req = AclProtos.ModifyAclEntriesRequestProto.newBuilder().setSrc(src).addAllAclSpec(PBHelper.convertAclEntryProto(aclSpec)).build();
        try {
            this.rpcProxy.modifyAclEntries(null, req);
        }
        catch (ServiceException e) {
            throw ProtobufHelper.getRemoteException(e);
        }
    }

    @Override
    public void removeAclEntries(String src, List<AclEntry> aclSpec) throws IOException {
        AclProtos.RemoveAclEntriesRequestProto req = AclProtos.RemoveAclEntriesRequestProto.newBuilder().setSrc(src).addAllAclSpec(PBHelper.convertAclEntryProto(aclSpec)).build();
        try {
            this.rpcProxy.removeAclEntries(null, req);
        }
        catch (ServiceException e) {
            throw ProtobufHelper.getRemoteException(e);
        }
    }

    @Override
    public void removeDefaultAcl(String src) throws IOException {
        AclProtos.RemoveDefaultAclRequestProto req = AclProtos.RemoveDefaultAclRequestProto.newBuilder().setSrc(src).build();
        try {
            this.rpcProxy.removeDefaultAcl(null, req);
        }
        catch (ServiceException e) {
            throw ProtobufHelper.getRemoteException(e);
        }
    }

    @Override
    public void removeAcl(String src) throws IOException {
        AclProtos.RemoveAclRequestProto req = AclProtos.RemoveAclRequestProto.newBuilder().setSrc(src).build();
        try {
            this.rpcProxy.removeAcl(null, req);
        }
        catch (ServiceException e) {
            throw ProtobufHelper.getRemoteException(e);
        }
    }

    @Override
    public void setAcl(String src, List<AclEntry> aclSpec) throws IOException {
        AclProtos.SetAclRequestProto req = AclProtos.SetAclRequestProto.newBuilder().setSrc(src).addAllAclSpec(PBHelper.convertAclEntryProto(aclSpec)).build();
        try {
            this.rpcProxy.setAcl(null, req);
        }
        catch (ServiceException e) {
            throw ProtobufHelper.getRemoteException(e);
        }
    }

    @Override
    public AclStatus getAclStatus(String src) throws IOException {
        AclProtos.GetAclStatusRequestProto req = AclProtos.GetAclStatusRequestProto.newBuilder().setSrc(src).build();
        try {
            return PBHelper.convert(this.rpcProxy.getAclStatus(null, req));
        }
        catch (ServiceException e) {
            throw ProtobufHelper.getRemoteException(e);
        }
    }

    @Override
    public void createEncryptionZone(String src, String keyName) throws IOException {
        EncryptionZonesProtos.CreateEncryptionZoneRequestProto.Builder builder = EncryptionZonesProtos.CreateEncryptionZoneRequestProto.newBuilder();
        builder.setSrc(src);
        if (keyName != null && !keyName.isEmpty()) {
            builder.setKeyName(keyName);
        }
        EncryptionZonesProtos.CreateEncryptionZoneRequestProto req = builder.build();
        try {
            this.rpcProxy.createEncryptionZone(null, req);
        }
        catch (ServiceException e) {
            throw ProtobufHelper.getRemoteException(e);
        }
    }

    @Override
    public EncryptionZone getEZForPath(String src) throws IOException {
        EncryptionZonesProtos.GetEZForPathRequestProto.Builder builder = EncryptionZonesProtos.GetEZForPathRequestProto.newBuilder();
        builder.setSrc(src);
        EncryptionZonesProtos.GetEZForPathRequestProto req = builder.build();
        try {
            EncryptionZonesProtos.GetEZForPathResponseProto response = this.rpcProxy.getEZForPath(null, req);
            if (response.hasZone()) {
                return PBHelper.convert(response.getZone());
            }
            return null;
        }
        catch (ServiceException e) {
            throw ProtobufHelper.getRemoteException(e);
        }
    }

    @Override
    public BatchedRemoteIterator.BatchedEntries<EncryptionZone> listEncryptionZones(long id) throws IOException {
        EncryptionZonesProtos.ListEncryptionZonesRequestProto req = EncryptionZonesProtos.ListEncryptionZonesRequestProto.newBuilder().setId(id).build();
        try {
            EncryptionZonesProtos.ListEncryptionZonesResponseProto response = this.rpcProxy.listEncryptionZones(null, req);
            ArrayList<EncryptionZone> elements = Lists.newArrayListWithCapacity(response.getZonesCount());
            for (EncryptionZonesProtos.EncryptionZoneProto p : response.getZonesList()) {
                elements.add(PBHelper.convert(p));
            }
            return new BatchedRemoteIterator.BatchedListEntries<EncryptionZone>(elements, response.getHasMore());
        }
        catch (ServiceException e) {
            throw ProtobufHelper.getRemoteException(e);
        }
    }

    @Override
    public void setXAttr(String src, XAttr xAttr, EnumSet<XAttrSetFlag> flag) throws IOException {
        XAttrProtos.SetXAttrRequestProto req = XAttrProtos.SetXAttrRequestProto.newBuilder().setSrc(src).setXAttr(PBHelper.convertXAttrProto(xAttr)).setFlag(PBHelper.convert(flag)).build();
        try {
            this.rpcProxy.setXAttr(null, req);
        }
        catch (ServiceException e) {
            throw ProtobufHelper.getRemoteException(e);
        }
    }

    @Override
    public List<XAttr> getXAttrs(String src, List<XAttr> xAttrs) throws IOException {
        XAttrProtos.GetXAttrsRequestProto.Builder builder = XAttrProtos.GetXAttrsRequestProto.newBuilder();
        builder.setSrc(src);
        if (xAttrs != null) {
            builder.addAllXAttrs(PBHelper.convertXAttrProto(xAttrs));
        }
        XAttrProtos.GetXAttrsRequestProto req = builder.build();
        try {
            return PBHelper.convert(this.rpcProxy.getXAttrs(null, req));
        }
        catch (ServiceException e) {
            throw ProtobufHelper.getRemoteException(e);
        }
    }

    @Override
    public List<XAttr> listXAttrs(String src) throws IOException {
        XAttrProtos.ListXAttrsRequestProto.Builder builder = XAttrProtos.ListXAttrsRequestProto.newBuilder();
        builder.setSrc(src);
        XAttrProtos.ListXAttrsRequestProto req = builder.build();
        try {
            return PBHelper.convert(this.rpcProxy.listXAttrs(null, req));
        }
        catch (ServiceException e) {
            throw ProtobufHelper.getRemoteException(e);
        }
    }

    @Override
    public void removeXAttr(String src, XAttr xAttr) throws IOException {
        XAttrProtos.RemoveXAttrRequestProto req = XAttrProtos.RemoveXAttrRequestProto.newBuilder().setSrc(src).setXAttr(PBHelper.convertXAttrProto(xAttr)).build();
        try {
            this.rpcProxy.removeXAttr(null, req);
        }
        catch (ServiceException e) {
            throw ProtobufHelper.getRemoteException(e);
        }
    }

    @Override
    public void checkAccess(String path, FsAction mode) throws IOException {
        ClientNamenodeProtocolProtos.CheckAccessRequestProto req = ClientNamenodeProtocolProtos.CheckAccessRequestProto.newBuilder().setPath(path).setMode(PBHelper.convert(mode)).build();
        try {
            this.rpcProxy.checkAccess(null, req);
        }
        catch (ServiceException e) {
            throw ProtobufHelper.getRemoteException(e);
        }
    }

    @Override
    public void setStoragePolicy(String src, String policyName) throws IOException {
        ClientNamenodeProtocolProtos.SetStoragePolicyRequestProto req = ClientNamenodeProtocolProtos.SetStoragePolicyRequestProto.newBuilder().setSrc(src).setPolicyName(policyName).build();
        try {
            this.rpcProxy.setStoragePolicy(null, req);
        }
        catch (ServiceException e) {
            throw ProtobufHelper.getRemoteException(e);
        }
    }

    @Override
    public BlockStoragePolicy getStoragePolicy(String path) throws IOException {
        ClientNamenodeProtocolProtos.GetStoragePolicyRequestProto request = ClientNamenodeProtocolProtos.GetStoragePolicyRequestProto.newBuilder().setPath(path).build();
        try {
            return PBHelper.convert(this.rpcProxy.getStoragePolicy(null, request).getStoragePolicy());
        }
        catch (ServiceException e) {
            throw ProtobufHelper.getRemoteException(e);
        }
    }

    @Override
    public void unsetStoragePolicy(String src) throws IOException {
        ClientNamenodeProtocolProtos.UnsetStoragePolicyRequestProto req = ClientNamenodeProtocolProtos.UnsetStoragePolicyRequestProto.newBuilder().setSrc(src).build();
        try {
            this.rpcProxy.unsetStoragePolicy(null, req);
        }
        catch (ServiceException e) {
            throw ProtobufHelper.getRemoteException(e);
        }
    }

    @Override
    public BlockStoragePolicy[] getStoragePolicies() throws IOException {
        try {
            ClientNamenodeProtocolProtos.GetStoragePoliciesResponseProto response = this.rpcProxy.getStoragePolicies(null, VOID_GET_STORAGE_POLICIES_REQUEST);
            return PBHelper.convertStoragePolicies(response.getPoliciesList());
        }
        catch (ServiceException e) {
            throw ProtobufHelper.getRemoteException(e);
        }
    }

    @Override
    public long getCurrentEditLogTxid() throws IOException {
        ClientNamenodeProtocolProtos.GetCurrentEditLogTxidRequestProto req = ClientNamenodeProtocolProtos.GetCurrentEditLogTxidRequestProto.getDefaultInstance();
        try {
            return this.rpcProxy.getCurrentEditLogTxid(null, req).getTxid();
        }
        catch (ServiceException e) {
            throw ProtobufHelper.getRemoteException(e);
        }
    }

    @Override
    public EventBatchList getEditsFromTxid(long txid) throws IOException {
        ClientNamenodeProtocolProtos.GetEditsFromTxidRequestProto req = ClientNamenodeProtocolProtos.GetEditsFromTxidRequestProto.newBuilder().setTxid(txid).build();
        try {
            return PBHelper.convert(this.rpcProxy.getEditsFromTxid(null, req));
        }
        catch (ServiceException e) {
            throw ProtobufHelper.getRemoteException(e);
        }
    }

    private static class BatchedCachePoolEntries
    implements BatchedRemoteIterator.BatchedEntries<CachePoolEntry> {
        private final ClientNamenodeProtocolProtos.ListCachePoolsResponseProto proto;

        public BatchedCachePoolEntries(ClientNamenodeProtocolProtos.ListCachePoolsResponseProto proto) {
            this.proto = proto;
        }

        @Override
        public CachePoolEntry get(int i) {
            ClientNamenodeProtocolProtos.CachePoolEntryProto elem = this.proto.getEntries(i);
            return PBHelper.convert(elem);
        }

        @Override
        public int size() {
            return this.proto.getEntriesCount();
        }

        @Override
        public boolean hasMore() {
            return this.proto.getHasMore();
        }
    }

    private static class BatchedCacheEntries
    implements BatchedRemoteIterator.BatchedEntries<CacheDirectiveEntry> {
        private final ClientNamenodeProtocolProtos.ListCacheDirectivesResponseProto response;

        BatchedCacheEntries(ClientNamenodeProtocolProtos.ListCacheDirectivesResponseProto response) {
            this.response = response;
        }

        @Override
        public CacheDirectiveEntry get(int i) {
            return PBHelper.convert(this.response.getElements(i));
        }

        @Override
        public int size() {
            return this.response.getElementsCount();
        }

        @Override
        public boolean hasMore() {
            return this.response.getHasMore();
        }
    }
}

