/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.zookeeper;

import java.io.IOException;
import java.util.Properties;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.zookeeper.ZKConfig;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={SmallTests.class})
public class TestZKConfig {
    @Test
    public void testZKConfigLoading() throws Exception {
        Configuration conf = HBaseConfiguration.create();
        conf.setInt("hbase.zookeeper.property.clientPort", 2181);
        Properties props = ZKConfig.makeZKProps(conf);
        Assert.assertEquals((String)"Property client port should have been default from the HBase config", (Object)"2181", (Object)props.getProperty("clientPort"));
    }

    @Test
    public void testGetZooKeeperClusterKey() {
        Configuration conf = HBaseConfiguration.create();
        conf.set("hbase.zookeeper.quorum", "\tlocalhost\n");
        conf.set("hbase.zookeeper.property.clientPort", "3333");
        conf.set("zookeeper.znode.parent", "hbase");
        String clusterKey = ZKConfig.getZooKeeperClusterKey(conf, "test");
        Assert.assertTrue((!clusterKey.contains("\t") && !clusterKey.contains("\n") ? 1 : 0) != 0);
        Assert.assertEquals((Object)"localhost:3333:hbase,test", (Object)clusterKey);
    }

    @Test
    public void testClusterKey() throws Exception {
        this.testKey("server", 2181, "hbase");
        this.testKey("server1,server2,server3", 2181, "hbase");
        try {
            ZKConfig.validateClusterKey("2181:hbase");
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Test
    public void testClusterKeyWithMultiplePorts() throws Exception {
        this.testKey("server1:2182", 2181, "hbase", true);
        this.testKey("server1:2182,server2:2183,server3:2184", 2181, "hbase", true);
        this.testKey("server1:2182,server2,server3:2184", 2181, "hbase", true);
        this.testKey("server1:2182,server2:2183,server3", 2181, "hbase", true);
        this.testKey("server1:2182,server2,server3:2184,server4", 2181, "hbase", true);
        this.testKey("server1:2182,server1:2183,server1", 2181, "hbase", true);
        this.testKey("server1:2182,server2:2183,server1", 2181, "hbase", true);
    }

    private void testKey(String ensemble, int port, String znode) throws IOException {
        this.testKey(ensemble, port, znode, false);
    }

    private void testKey(String ensemble, int port, String znode, Boolean multiplePortSupport) throws IOException {
        Configuration conf = new Configuration();
        String key = ensemble + ":" + port + ":" + znode;
        String ensemble2 = null;
        ZKConfig.ZKClusterKey zkClusterKey = ZKConfig.transformClusterKey(key);
        if (multiplePortSupport.booleanValue()) {
            ensemble2 = ZKConfig.standardizeZKQuorumServerString(ensemble, Integer.toString(port));
            Assert.assertEquals((Object)ensemble2, (Object)zkClusterKey.getQuorumString());
        } else {
            Assert.assertEquals((Object)ensemble, (Object)zkClusterKey.getQuorumString());
        }
        Assert.assertEquals((long)port, (long)zkClusterKey.getClientPort());
        Assert.assertEquals((Object)znode, (Object)zkClusterKey.getZnodeParent());
        conf = HBaseConfiguration.createClusterConf(conf, key);
        Assert.assertEquals((Object)zkClusterKey.getQuorumString(), (Object)conf.get("hbase.zookeeper.quorum"));
        Assert.assertEquals((long)zkClusterKey.getClientPort(), (long)conf.getInt("hbase.zookeeper.property.clientPort", -1));
        Assert.assertEquals((Object)zkClusterKey.getZnodeParent(), (Object)conf.get("zookeeper.znode.parent"));
        String reconstructedKey = ZKConfig.getZooKeeperClusterKey(conf);
        if (multiplePortSupport.booleanValue()) {
            String key2 = ensemble2 + ":" + port + ":" + znode;
            Assert.assertEquals((Object)key2, (Object)reconstructedKey);
        } else {
            Assert.assertEquals((Object)key, (Object)reconstructedKey);
        }
    }
}

