/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util;

import java.io.File;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseCommonTestingUtility;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.util.ClassLoaderTestHelper;
import org.apache.hadoop.hbase.util.DynamicClassLoader;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={SmallTests.class})
public class TestDynamicClassLoader {
    private static final Log LOG = LogFactory.getLog(TestDynamicClassLoader.class);
    private static final HBaseCommonTestingUtility TEST_UTIL = new HBaseCommonTestingUtility();
    private Configuration conf;

    @Before
    public void initializeConfiguration() {
        this.conf = new Configuration(TEST_UTIL.getConfiguration());
    }

    @Test
    public void testLoadClassFromLocalPath() throws Exception {
        ClassLoader parent = TestDynamicClassLoader.class.getClassLoader();
        DynamicClassLoader classLoader = new DynamicClassLoader(this.conf, parent);
        String className = "TestLoadClassFromLocalPath";
        this.deleteClass(className);
        try {
            classLoader.loadClass(className);
            Assert.fail((String)("Should not be able to load class " + className));
        }
        catch (ClassNotFoundException cnfe) {
            // empty catch block
        }
        try {
            String folder = TEST_UTIL.getDataTestDir().toString();
            ClassLoaderTestHelper.buildJar(folder, className, null, ClassLoaderTestHelper.localDirPath(this.conf));
            classLoader.loadClass(className);
        }
        catch (ClassNotFoundException cnfe) {
            LOG.error("Should be able to load class " + className, cnfe);
            Assert.fail((String)cnfe.getMessage());
        }
    }

    @Test
    public void testLoadClassFromAnotherPath() throws Exception {
        ClassLoader parent = TestDynamicClassLoader.class.getClassLoader();
        DynamicClassLoader classLoader = new DynamicClassLoader(this.conf, parent);
        String className = "TestLoadClassFromAnotherPath";
        this.deleteClass(className);
        try {
            classLoader.loadClass(className);
            Assert.fail((String)("Should not be able to load class " + className));
        }
        catch (ClassNotFoundException cnfe) {
            // empty catch block
        }
        try {
            String folder = TEST_UTIL.getDataTestDir().toString();
            ClassLoaderTestHelper.buildJar(folder, className, null);
            classLoader.loadClass(className);
        }
        catch (ClassNotFoundException cnfe) {
            LOG.error("Should be able to load class " + className, cnfe);
            Assert.fail((String)cnfe.getMessage());
        }
    }

    @Test
    public void testLoadClassFromLocalPathWithDynamicDirOff() throws Exception {
        this.conf.setBoolean("hbase.use.dynamic.jars", false);
        ClassLoader parent = TestDynamicClassLoader.class.getClassLoader();
        DynamicClassLoader classLoader = new DynamicClassLoader(this.conf, parent);
        String className = "TestLoadClassFromLocalPath";
        this.deleteClass(className);
        try {
            String folder = TEST_UTIL.getDataTestDir().toString();
            ClassLoaderTestHelper.buildJar(folder, className, null, ClassLoaderTestHelper.localDirPath(this.conf));
            classLoader.loadClass(className);
            Assert.fail((String)("Should not be able to load class " + className));
        }
        catch (ClassNotFoundException cnfe) {
            // empty catch block
        }
    }

    private void deleteClass(String className) throws Exception {
        String jarFileName = className + ".jar";
        File file = new File(TEST_UTIL.getDataTestDir().toString(), jarFileName);
        file.delete();
        Assert.assertFalse((String)("Should be deleted: " + file.getPath()), (boolean)file.exists());
        file = new File(this.conf.get("hbase.dynamic.jars.dir"), jarFileName);
        file.delete();
        Assert.assertFalse((String)("Should be deleted: " + file.getPath()), (boolean)file.exists());
        file = new File(ClassLoaderTestHelper.localDirPath(this.conf), jarFileName);
        file.delete();
        Assert.assertFalse((String)("Should be deleted: " + file.getPath()), (boolean)file.exists());
    }

    static {
        TEST_UTIL.getConfiguration().set("hbase.dynamic.jars.dir", TEST_UTIL.getDataTestDir().toString());
    }
}

